/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       ndisdef.h
**     SYSTEM   NAME:       ndis
**     ORIGINAL AUTHOR(S):  Paul Lemmers
**     VERSION  NUMBER:     
**     CREATION DATE:       6 - may - 1990
**
** DESCRIPTION: 
**              Include file for NDIS data structures and types
**
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/

/* INCL16 */

/* MSC 32 bit features not understood!! */
/* When 32 bit features are stable and well documented, modify this file */

typedef unsigned long int     DWORD;
typedef unsigned short int    WORD;
typedef unsigned char         MBYTE;  /* watch it also defined in os2def.h */

typedef void far   *LPBUF;
typedef MBYTE far  *LPBYTE;
typedef WORD far   *LPWORD;
typedef char far   *LPCHAR;

#define NDIS_FUN   pascal far
typedef int        (pascal far *LPFUN)();


typedef struct _BlockD {
	WORD	Len;	/* Length of data block */
	LPBUF	DataPtr;/* Address of data block */
	} BlockD;

typedef struct _DatD {
	MBYTE	PtrType;	/* Type of pointer (0=Physical, 2=GDT) */
	MBYTE	ResByte;	/* Reserved byte (must be 0) */
	BlockD	Data;
	} DatD;

typedef struct _TxBufD {
	WORD	TxImmedLen;	/* Byte count for immediate data; max is 64 */
	LPBUF	TxImmedPtr;	/* Virtual address of immediate data */
	WORD	TxDataCount;	/* Count of remaining data blocks */
	DatD	TxArray[1];
	} TxBufDescr;

typedef struct _TDBufD {
	WORD	TDDataCount;	/* Count of transfer data blocks */
	DatD	TDArray[1];
	} TDBufDescr;

typedef struct _RxBufD {
	WORD	RxDataCount;	/* Count of receive data blocks */
	BlockD	RxArray[1];
	} RxBufDescr;

/* General requests */
#define InitiateDiagnostics    1
#define ReadErrorLog           2
#define SetStationAddress      3
#define OpenAdapter            4
#define CloseAdapter           5
#define ResetMAC               6
#define SetPacketFilter        7
#define AddMulticastAddress    8
#define DeleteMulticastAddress 9
#define UpdateStatistics       10
#define ClearStatistics        11
#define Interrupt              12
#define SetFunctionalAddress   13
#define SetLookahead           14

/* Status Indications */
#define RingStatus      1
#define AdapterCheck    2
#define StartReset      3
#define StatusInterrupt 4
#define EndReset        5

/* System Requests */
#define InitiateBind    1
#define Bind            2
#define InitiatePrebind 3
#define InitiateUnbind  4
#define Unbind          5

/* Protocol Manager requests */
typedef struct _ProtmanReqBlock {
	unsigned short Opcode;   /* Opcode for Protocol Manager request */
	unsigned short Status;   /* Status at completion of request */
	LPCHAR         Pointer1; /* First parameter Ring 0 GDT pointer */
	LPCHAR         Pointer2; /* Second parameter Ring 0 GDT pointer */
	unsigned short Word1;    /* Parameter word */
	} ProtmanReqBlock;
#define GetProtocolManagerInfo      1
#define RegisterModule              2
#define BindAndStart                3
#define GetProtocolManagerLinkage   4
#define GetProtocolIniPath          5
#define RegisterProtocolManagerInfo 6
#define InitAndRegister             7
#define UnbindAndStop               8
#define BindStatus                  9
#define RegisterStatus              0xA

typedef union _PARMVAL {
	long          ValL;
	unsigned char ValC[4];
	} PARMVAL;
typedef struct _PARM_E {
	unsigned short ParamType;
	unsigned short ParamLen;
	PARMVAL        Value;
	} PARM_E;
typedef struct _KEYW_E far *PKEYW_E;
typedef struct _KEYW_E {
	PKEYW_E        Next;
	PKEYW_E        Prev;
	unsigned char  Keyword[16];
	unsigned short NumParams;
	PARM_E         Parm1;
	} KEYW_E;
typedef struct _MOD_E far *PMOD_E;
typedef struct _MOD_E {
	PMOD_E        Next;
	PMOD_E        Prev;
	unsigned char ModName[16];
	KEYW_E	      KeyWord1;
	} MOD_E;
typedef struct _BINDL {
	unsigned short NumBindings;
	char	ModName1[16];
	} BINDL;
   


/* Common Characteristic table */
typedef struct _CCT _far *PCCT;
typedef struct _CCT {
	WORD          cct_size;       /* size of CCT */
	MBYTE         cct_maj_ndis;
	MBYTE         cct_min_ndis;
	WORD          cct_res1;
	MBYTE         cct_maj_mod;
	MBYTE         cct_min_mod;
	DWORD         cct_funcf;      /* Module function flags */
	MBYTE         cct_mod_name[16];
	MBYTE         cct_up_prot;    /* protocol at upper boundary */
	MBYTE         cct_up_interf;  /* interface at upper boundary */
	MBYTE         cct_lo_prot;    /* protocol at lower boundary */
	MBYTE         cct_lo_interf;  /* interface at lower boundary */
	WORD          cct_modID;
	WORD          cct_modDS;
	LPFUN         cct_SysReq;
	LPBUF         cct_SSCT;       /* Serv. Spec. Characteristics Table */
	LPBUF         cct_SSST;       /* Serv. Spec. Status Table */
	LPBUF         cct_UpDT;       /* Upper Dispatch Table */
	LPBUF         cct_LoDT;       /* Lower Dispatch Table */
	LPBUF         cct_res2;
	LPBUF         cct_res3;
	} CCT;

typedef struct _MSSC {
	WORD	mssc_size;        /* Size of _MSST */
	MBYTE	mssc_name[16];    /* Type name of MAC */
	WORD	mssc_SA_len;      /* Length of Station Address */
	MBYTE	mssc_Perm_SA[16]; /* Permanent Station Address */
	MBYTE	mssc_Cur_SA[16];  /* Current Station Address */
	DWORD   mssc_FuncAddr;    /* Current functional address */
	LPBUF	mssc_MAL;         /* Multicast Address list */
	DWORD	mssc_speed;       /* Link Speed */
	DWORD	mssc_Serv_flags;  /* Service Flags */
	WORD	mssc_maxframe;    /* Maximum frame size for Rcv & Tx */
	DWORD	mssc_TxMax;       /* Adapter Tx buffer size in bytes */
	WORD	mssc_TxSize;      /* Adapter Tx buffer granularity */
	DWORD	mssc_RcvMax;      /* Adapter Rcv buffer size in bytes */
	WORD	mssc_RcvSize;     /* Adapter Rcv buffer granularity */
	MBYTE	mssc_Vendor[3];   /* IEEE Vendor code */
	MBYTE	mssc_Adapt;       /* Vendor adapter code */
	LPBYTE	mssc_ADesc;       /* Vendor adapter descriptor */
	WORD	mssc_IRQ;         /* IRQ level used by adapter */
	WORD	mssc_TxDepth;     /* Transmit Queue depth */
	WORD	mssc_BlocksMax;   /* Max # of data blocks in descriptors */
	} MSSC;

typedef struct _MAL {
	WORD	mal_max;      /* Maximum # of Multicast addresses */
	WORD	mal_number;   /* Current # of Multicast addresses */
	MBYTE	mal_MA1[16];  /* First Multicast address */
	} MAL;

typedef struct _MSSS {
	WORD	msss_size;       /* size of Sevice Specific Status table */
	DWORD	msss_date;       /* Time/date last Diagnostics */
	DWORD	msss_status;     /* MAC status bit mask. */
	WORD	msss_filter;     /* Current Packet filter */
	LPBUF	msss_statist;    /* Ptr to media specific statistics */
	DWORD	msss_LastClear;  /* Date/time of last ClearStatistics */
	DWORD	msss_Rcv;        /* Total frames received */
	DWORD	msss_CRC;        /* Frames with CRC error */
	DWORD	msss_Rcv_bytes;  /* Total Bytes received */
	DWORD	msss_NoBuf;      /* Frames discarded - no buffer space */
	DWORD	msss_Rcv_M;      /* Multicast frames received */
	DWORD	msss_Rcv_B;      /* Broadcast frames received */
	DWORD	msss_Rcv_E;      /* Frames received with errors */
	DWORD	msss_Rcv_L;      /* Frames exceeding maximum size */
	DWORD	msss_Rcv_S;      /* Frames smaller than minimum size */
	DWORD	msss_Rcv_M_bytes;/* Multicast bytes received */
	DWORD	msss_Rcv_B_bytes;/* Broadcast bytes received */
	DWORD	msss_Rcv_hard;   /* Frames discarded hardware error */
	DWORD	msss_Tx;         /* Total frames transmitted */
	DWORD	msss_Tx_bytes;   /* Total bytes transmitted */
	DWORD	msss_Tx_M;       /* Multicast frames transmitted */
	DWORD	msss_Tx_B;       /* Broadcast frames transmitted */
	DWORD	msss_Tx_B_bytes; /* Broadcast bytes transmitted */
	DWORD	msss_Tx_M_bytes; /* Multicast bytes transmitted */
	DWORD	msss_Tx_timeout; /* Frames not transmitted - time-out */
	DWORD	msss_Tx_hard;    /* Frames not transmitted - hardw. error */
	} MSSS;

typedef struct _MUD {
	LPBUF	mud_CCT;     /* Backpointer to CCT */
	LPFUN	mud_Req;     /* Request address */
	LPFUN	mud_TxChain; /* TransmitChain address */
	LPFUN	mud_TxData;  /* TransferData address */
	LPFUN	mud_RcvRel;  /* ReceiveRelease address */
	LPFUN	mud_IndOn;   /* IndicationOn address */
	LPFUN	mud_IndOff;  /* IndicationOff address */
	} MUD;

typedef struct _NBUD {
	LPBUF	nbud_CCT;    /* Backpointer to CCT */
	LPFUN	nbud_Req;    /* Request address */
	LPFUN	nbud_NCB;    /* NetBIOS NCB handler address */
	} NBUD;

typedef struct _PLD {
	LPBUF  pld_CCT;      /* Backpointer to CCT */
	DWORD  pld_InterfF;  /* Interface flags for VECTOR */
	LPFUN  pld_ReqConf;  /* RequestConfirm Address */
	LPFUN  pld_TxConf;   /* TransmitConfirm Address */
	LPFUN  pld_RcvLook;  /* ReceiveLookahead indication Address */
	LPFUN  pld_IndCompl; /* IndicationComplete Address */
	LPFUN  pld_RcvChain; /* ReceiveChain indication Address */
	LPFUN  pld_Status;   /* Status indication Address */
	} PLD;

/* Error codes of primitives */
#define NDIS_SUCCES                       0x0000
#define NDIS_WAIT_FOR_RELEASE             0x0001
#define NDIS_REQUEST_QUEUED               0x0002
#define NDIS_FRAME_NOT_RECOGNIZED         0x0003
#define NDIS_FRAME_REJECTED               0x0004
#define NDIS_FORWARD_FRAME                0x0005
#define NDIS_OUT_OF_RESOURCE              0x0006
#define NDIS_INVALID_PARAMETER            0x0007
#define NDIS_INVALID_FUNCTION             0x0008
#define NDIS_NOT_SUPPORTED                0x0009
#define NDIS_HARDWARE_ERROR               0x000A
#define NDIS_TRANSMIT_ERROR               0x000B
#define NDIS_NO_SUCH_DESTINATION          0x000C
#define NDIS_BUFFER_TO_SMALL              0x000D
#define NDIS_ALREADY_STARTED              0x0020
#define NDIS_INCOMPLETE_BINDING           0x0021
#define NDIS_DRIVER_NOT_INITIALIZED       0x0022
#define NDIS_HARDWARE_NOT_FOUND           0x0023
#define NDIS_HARDWARE_FAILURE             0x0024
#define NDIS_CONFIGURATION_FAILURE        0x0025
#define NDIS_INTERRUPT_CONFLICT           0x0026
#define NDIS_INCOMPATIBLE_MAC             0x0027
#define NDIS_INITIALIZATION_FAILED        0x0028
#define NDIS_NO_BINDING                   0x0029
#define NDIS_NETW_NOT_CONNECTED           0x002A
#define NDIS_INCOMPATIBLE_OS_VERSION      0x002B
#define NDIS_ALREADY_REGISTERED           0x002C
#define NDIS_PATH_NOT_FOUND               0x002D
#define NDIS_INSUFFICIENT_MEMORY          0x002E
#define NDIS_INFO_NOT_FOUND               0x002F
#define NDIS_GENERAL_FAILURE              0x00FF
#define NDIS_OEM_DEFINED_ERROR            0xF000
