include ../include/gcc_os2.std

SYS     = snmp
SYSLIB  = snmp

OBJ =   $(SYS).o asn1.o 

all: obj doc

install: all $(INCDIR)/$(SYS).h $(MANDIR)/$(SYS).man $(LIBDIR)/lib$(SYSLIB).a 

$(INCDIR)/$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)/$(SYS).h

$(MANDIR)/$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)/$(SYS).man 

$(LIBDIR)/lib$(SYSLIB).a: $(OBJ) 
	$(AR) $(LIBDIR)/lib$(SYSLIB).a $(OBJ) 

obj: $(OBJ)
       
doc: $(SYS).man

clean:
	- $(RM) *.o
	- $(RM) *.a
	- $(RM) *.exe
	- $(RM) core
	- $(RM) test
	- $(RM) *.man
	- $(RM) *.err
	- $(RM) *.bak

$(SYS).man: $(SYS).c asn1.c
	$(MAN) $(SYS).c asn1.c > $(SYS).man

$(SYS).o: $(SYS).c $(SYS).h

asn1.o: asn1.c $(SYS).h


test.exe: test
	emxbind -bs test

test: test.o $(INC)
	$(LN) $(CFLAGS) -o test test.o $(LDFLAGS) -l$(SYS) -lmgmt -ldnpap 
