include ../../include/gcc_os2.std

SYS     = config
SYSLIB  = config

LDFLAGS = -L$(LIBDIR) -lsnmp -lmibdf -ldnpap


all: cfg2ini.exe ini2cfg.exe

cfg2ini.exe: cfg2ini.o funcs.o
	$(LN) $(CFLAGS) -o cfg2ini cfg2ini.o funcs.o $(LDFLAGS) -lsnmp -lmibdf -ldnpap
	emxbind -bs cfg2ini

ini2cfg.exe: ini2cfg.o funcs.o
	$(LN) $(CFLAGS) -o ini2cfg ini2cfg.o funcs.o $(LDFLAGS) -lsnmp -lmibdf -ldnpap
	emxbind -bs ini2cfg
			  
clean:
	- $(RM) *.o
	- $(RM) *.a
	- $(RM) *.exe
	- $(RM) cfg2ini
	- $(RM) ini2cfg
	- $(RM) core
	- $(RM) *.man
	- $(RM) *.err
	- $(RM) *.bak

install: $(BINDIR)\cfg2ini.exe $(BINDIR)\ini2cfg.exe

$(BINDIR)\cfg2ini.exe: cfg2ini.exe
	$(CP) cfg2ini.exe $(BINDIR)\cfg2ini.exe

$(BINDIR)\ini2cfg.exe: ini2cfg.exe
	$(CP) ini2cfg.exe $(BINDIR)\ini2cfg.exe


cfg2ini.o: cfg2ini.c hosts.h defs.h funcs.h

ini2cfg.o: ini2cfg.c defs.h funcs.h

funcs.o: funcs.c defs.h funcs.h hosts.h
