/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       gobbler.c
**     SYSTEM   NAME:                         
**     ORIGINAL AUTHOR(S):  Renata Liskova
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       1992/7/20
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************                
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header$";
#endif
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h> 
#include <stdarg.h>
#include <string.h>
#include <dnpap.h>
#include <config.h>
#include <message.h>
#include <vip.h>
#include <protocol.h>
#include "prot.h"
#include "prototyp.h"

VIPINFO *winframe=NULL;
VIPINFO *winhead, *winbutBack, *winbutnext, *winbutdata, *winpop, *winprint;
VIPINFO *winmenu, *winmenu2, *winnext[8], *winlabnext[8];
VIPINFO *winlist, *winprotocol, *winprotlabel, *winbutClose;
VIPFONT *font1, *font2, *font3;

FILE *ascii;
FILE *dumpfile;
PROT_PKT Packet;
PROT_PKT Child;
PROT_IP ProtIp;
PROT_UDP ProtUdp;
PROT_ARP ProtArp;
PROT_DNS ProtDns;
PROT_ICMP ProtIcmp;
PROT_TCP ProtTcp;
PROT_DEC ProtDec;
WORD ChildProtHis[5];
static LWORD EntryLen[4];
fpos_t pos[1000];
int selectLine=-1;
int DataFilled[20];
int DEC_FLAGS[23];
int ProtType;
int nextwin;
int next;
int NumberOfPackets;
int PacketSize;

/*****************************************************************
** NAME:        main
** SYNOPSIS:    void main(int argc, char *argv[])
** PARAMETERS:
**              used for VIP config initialization
** DESCRIPTION: - initialization of the VIP system
**              - reading of the *.dump file
**              - displaying of the main screen        
**              - creation of the ascii file representing
**              - opening of the all subwindows
**                the *.dump file
** REMARKS:     
** RETURNS:     no value
*******************************************************************/

void main(int argc, char *argv[])
{
    int tabs[]={100|VIP_TCENTER,
                360|VIP_TLEFT,
                440|VIP_TLEFT,
                540|VIP_TLEFT,
                750|VIP_TLEFT,
                830|VIP_TLEFT};
    BYTE StrLine[100];
    PROT_PKT Pkt;
    char *String;
    int flag;
    int a, l, line;

    /* Initialize Config System */
    ConfigInit(argc,argv);
    ConfigLoad();

    /* Initialize Message System, with FILE and VIP device */
    MessageInit("viptest", MSGFILE, MSGVIP, NULL);

    VipInit(argc,argv);               /* Initialize VIP system */

    winframe = VipOpenFrame  (NULL,100,100,800,800);       /* Open a frame */
    if (!winframe)
    {
        DnpapMessage(DMC_FATAL, 1, "Failed to open frame window!");
        DnpapExit(1);
    }                       
    font1=VipCreateFont(FONTFACE_HELV,10,0);
    font3=VipCreateFont(FONTFACE_HELV,7,0);
    font2=VipCreateFont(FONTFACE_COUR,10,0);

    winhead =  VipOpenText (winframe,0,950,1000,50);   /* Open a text box */
    VipSetFont(winhead, font1);

    winlist =  VipOpenList (winframe,0,0,1000,950);

    VipSetTextScrollbars (winlist,
        VipOpenVScroll(winframe,965,0,35,950),
        NULL);

    VipSetAbout(winframe, (VIP_CALLBACK)PrintWindow);
    winpop = VipOpenButton(winhead,950,0,50,1000);
    VipSetTitle(winpop, "");
    VipSetFont(winpop, font1);

    VipSetTitle    (winframe, "The Gobbler");
    VipSetTextLine (winhead,  "Frame\tTime\tID\tSize\tType\tIndex\tInfo", 0, VIP_RIGHT);
    VipSetTextTabs(winhead, 6, tabs, 0);
    VipSetTextTabs(winlist, 6, tabs, 0);

    VipSetBusy(TRUE);       /* Show busy icon */

    VipSetListCallBack(winlist, LineSelect, NULL);
    VipSetButtonCallBack(winpop, WinProt, NULL);

    VipShow(winframe);

    winprotlabel = VipOpenLabel(winframe,420,480,550,473);
    winprotocol = VipOpenText(winprotlabel,20,20,900,960);
    VipSetFont(winprotocol, font1);
    VipSetTextScrollbars (winprotocol,
        VipOpenVScroll(winprotlabel, 920,20,60,960),
        NULL);
    for (next=0;next<8;next++)
    {
        winlabnext[next] = VipOpenLabel(winframe,370-next*50,418-next*50,550,473);
        winnext[next] = VipOpenText(winlabnext[next],20,20,900,960);
        VipSetTextScrollbars (winnext[next],
            VipOpenVScroll(winlabnext[next], 920,20,60,960),
            NULL);
        VipSetBorder(winlabnext[next],1,1);
        VipSetFont(winnext[next], font1);
    }

    dumpfile = OpenFile();
    ascii = fopen("dumpfile.asc","w");
    if((protocolString = DnpapMalloc(255)) == NULL)
        DnpapMessage(DMC_FATAL, 1, "Out of memory");

    next = 0;
    InitDataFill();
    memset(DEC_FLAGS,0,22);
    winbutdata = NULL;

    VipCheck(FALSE);

    ReadFile();    

    line = 0;
    pos[line]=0;
    while(ReadPacket(&Pkt,line))
    {
        sprintf(StrLine,"%d",line+1);
        l=strlen(StrLine);
        for (flag=1; flag <= 6; flag++)
        {
            StrLine[l++]='\t';
            ConvertToString(&Pkt,&String,flag);
            a = strlen(String);
            memcpy(StrLine+l, String, a);
            l+=a;
        }
        StrLine[l]='\0';
        VipSetTextLine(winlist,StrLine,line,VIP_RIGHT);
        StrLine[l++]='\n';
        StrLine[l]='\0';
        fputs(StrLine,ascii);
        line++;
        fgetpos(ascii,&pos[line]);
        VipUpdate(winlist, 0);
        VipCheck(FALSE);  /* To update the display while reading */
    }
    NumberOfPackets = line - 1;
    fclose(ascii);
    fclose(dumpfile);

    dumpfile = OpenFile();
    ascii = fopen("dumpfile.asc","r");

    InitDataFill();

    VipSetBusy(FALSE);  /* We're not busy anymore */
    VipCheck(TRUE);
    DnpapFree(protocolString);
    fclose(dumpfile);
    fclose(ascii);
    DnpapExit(0);
}

void LineSelect(VIPINFO *wip, void *p, int line)
{
    selectLine = line;               
}

/*****************************************************************
** NAME:        WinProt
** SYNOPSIS:    void WinProt(VIPINFO *wip, VOID *p, BOOLEAN pressed)
** PARAMETERS:
**              - wip and p not used
**              - button calling WinProt is pressed
** DESCRIPTION: - opens the first (Ethernet window)
**              - opens the set of the controlling buttons
**              - sets the CallBack functions for the buttons
**              - gets the type of the first protocol        
**              - reads next protocol data
**              - displays ethernet part of the protocol
** REMARKS:     CallBack function
** RETURNS:     no value
*******************************************************************/

void WinProt(VIPINFO *wip, VOID *p, BOOLEAN pressed)
{
   char field[20];
   int Type;
   int unsigned n;
   int offset = 2;
                         
    if (pressed) return;
    if (selectLine==-1) return;
    if((Packet.Child = DnpapMalloc(sizeof(PROT_PKT))) == NULL)
        DnpapMessage(DMC_FATAL, 1,"Out of memory");
    else
    {
        VipSetButtonCallBack(winpop, Bell, NULL);
        VipSetTextLine(winprotocol,GetProtType(field),0,VIP_CENTER);
        VipShow(winprotlabel);

        winbutBack  = VipOpenButton(winframe,860,950,105,50);
        winbutClose = VipOpenButton(winframe,650,950,105,50);
        VipSetTitle(winbutBack,"Back");
        VipSetTitle(winbutClose,"Close");
        VipSetFont(winbutBack,font1);
        VipSetFont(winbutClose,font1);
        VipSetButtonCallBack(winbutBack, WinNextClose, NULL);
        VipSetButtonCallBack(winbutClose, WinClose, NULL);
        VipShow(winbutBack);
        VipShow(winbutClose);
        VipShow(winhead);

        VipSetFont(winprotocol,font1);
        Type = FillProtData(field,Packet.Child);
        VipSetBorder(winprotlabel,1,1);
        for(n = 0; n < ProtPtr[Type].StringLen; n++)
            VipSetTextLine(winprotocol,ProtPtr[Type].String[n],n+offset++,VIP_LEFT);
   }
}

/*****************************************************************
** NAME:        WinProtClose
** SYNOPSIS:    void WinProtClose(VIPINFO *wip, VOID *p, BOOLEAN pressed)
** PARAMETERS:
**              - wip and p not used
**              - button calling WinProtClose is pressed
** DESCRIPTION: - hides and clears the first (Ethernet window)
** REMARKS:     - CallBack function
** RETURNS:     no value
*******************************************************************/

void WinProtClose(VIPINFO *wip, void *p, BOOLEAN pressed)
{
     if(!pressed)
     {
        VipSetButtonCallBack(winpop, WinProt, NULL);
        VipHide(winprotlabel);
        VipClearText(winprotocol);
        DnpapFree(Packet.Child);
     }
}

/*****************************************************************
** NAME:        Bell
** SYNOPSIS:    void Bell(VIPINFO *wip, VOID *p, BOOLEAN pressed)
** PARAMETERS:
**              - wip and p not used
**              - button calling WinProtClose is pressed
** DESCRIPTION: - rings the bell
** REMARKS:     - CallBack function
** RETURNS:     no value
*******************************************************************/

void Bell(VIPINFO *wip, void *p, BOOLEAN pressed)
{
    if(!pressed)
     VipBell();
}

/*****************************************************************
** NAME:        WinClose
** SYNOPSIS:    void WinClose(VIPINFO *wip, VOID *p, BOOLEAN pressed)
** PARAMETERS:
**              - wip and p not used
**              - button calling WinProtClose is pressed
** DESCRIPTION: - hides and clears all subwindows
**              - closes the set of the controlling buttons
** REMARKS:     - CallBack function
** RETURNS:     no value
*******************************************************************/

void WinClose(VIPINFO *wip, void *p, BOOLEAN pressed)
{
    if(!pressed)
    {
        VipSetButtonCallBack(winpop, WinProt, NULL);
        VipHide(winprotlabel);
        VipClearText(winprotocol);
        DnpapFree(Packet.Child);
        next--;
        while(next >= 0)
          {
            VipHide(winlabnext[next]);
            VipClearText(winnext[next--]);
          }  
        next++;
        VipDestroy(winbutnext);
        VipDestroy(winbutBack);
        VipDestroy(winbutClose);
        if(winbutdata != NULL)
            VipDestroy(winbutdata);
        InitDataFill();
        winbutdata = NULL;
    }
}

/*****************************************************************
** NAME:        GetProtType
** SYNOPSIS:    char *GetProtType(char *field)
** PARAMETERS:
**              - string with the protocol type name
** DESCRIPTION: - gets the name of the first protocol type
**                from the ascii file
** REMARKS:
** RETURNS:     string representing name of the protocol type
*******************************************************************/

char *GetProtType(char *field)
{
      fsetpos(ascii,&pos[selectLine]);
      GetField(ascii,4,field);
      return(field);
}

/*****************************************************************
** NAME:        GetField
** SYNOPSIS:    char *GetField(FILE *ascii, int cnt, char *field)
** PARAMETERS:
**              - ascii - file pointer to the ascii file representing
**                the pktcapt.dmp file
**              - cnt - number of the required field from the line
**                in ascii file
** DESCRIPTION: - gets the required field from the line
**                in the ascii file
** REMARKS:
** RETURNS:     string representing required field
*******************************************************************/

char *GetField(FILE *ascii, int cnt, char *field)
{
    int c;
    int i=0;

    for (i=0;i<cnt;i++)
        while (((c = fgetc(ascii)) != '\t') && (c!=EOF));
    i = 0;
    while (((c = fgetc(ascii)) != '\t') && (c!=EOF) && (c!='\n'))
        field[i++] = (char) c;
    field[i] = '\0';
    return(field);
}

/*****************************************************************
** NAME:        FillProtData
** SYNOPSIS:    int FillProtData(char *field, PROT_PKT *PktChild)
** PARAMETERS:
**              - field - string with the protocol type name
**              - PktChild - structure to which the protocol data
**                will be read
** DESCRIPTION: - reads the data of the given protocol
** REMARKS:
** RETURNS:     number representing the protocol type
*******************************************************************/

int FillProtData(char *field, PROT_PKT *PktChild)
{
    int type;

    for (type=0;type<10;type++)
        if (strcmp(ProtPtr[type++].Name,field)==0)
            break;
    type--;
    if (type==9)
        DnpapMessage(DMC_ERROR, 1,"Unknown prototype type!");
    ProtType=type;
    PktChild->Child = NULL;
    ReadData(PktChild);
    return type;
}


/*****************************************************************
** NAME:        ReadData
** SYNOPSIS:    void ReadData(PROT_PKT *PktChild)
** PARAMETERS:
**              - PktChild - structure to which the protocol data
**                will be read
** DESCRIPTION: - reads the data of the given protocol
**              - displays the read data in the current window
** REMARKS:
** RETURNS:     no value
*******************************************************************/

void ReadData(PROT_PKT *PktChild)
{
   const char *String;
   int flag;
   int offset = 2;

   nextwin = 0;
    {
      GetData(&Packet,selectLine);
      Packet.DataLen = PacketSize;
      ProtPtr[ProtType].Header(&Packet);
      for(flag = 1; flag <= 3;flag++)
      {
       EtherPrintHeader (&String,flag);
       VipSetTextLine(winprotocol,String,flag+offset++,VIP_CENTER);
      }
      PktChild->ChildProt = Packet.ChildProt;
      rewind(dumpfile);
      ChildProtHis[next] = Packet.ChildProt;
      ReadNextData(PktChild);
     }
}


/*****************************************************************
** NAME:        ReadNextData
** SYNOPSIS:    void ReadNextData(PROT_PKT *PktChild)
** PARAMETERS:
**              - PktChild - structure to which the protocol data
**                will be read
** DESCRIPTION: - reads the data of the next (child) protocol
**              - sets the CallBack function for opening of the
**                next window for the next protocol and creates
**                the NEXT button
**              - fills the data structures necessary for
**                the movement among the windows
**              - if the read protocols was the last one,
**                creates the DATA button
** REMARKS:     - adjusts the DataLen item of the PROT_PKT structure
**              - the function is called from the NextWindow function
**                and from the ReadData function
** RETURNS:     no value
*******************************************************************/


void ReadNextData(PROT_PKT *PktChild)
{
 WORD ChildProtocol=0;
 static WORD HLen;

      if((ChildProtocol=PktChild->ChildProt) != PROT_PKTUNKNOWN)
      {
         switch(ProtType)
         {
          case PROT_PKTETHERNET:
                                 PktChild->Ptr = Packet.Frame->Ethernet.Data;
                                 Packet.DataLen = Packet.DataLen - 14;
                                 PktChild->DataLen = Packet.DataLen;
                                 break;
          case PROT_PKTIP:
                                 HLen = 4 * (WORD)(*(Packet.Child->Frame->Ip.HLen) & 0x0F);
                                 Packet.DataLen = Packet.DataLen - HLen;
                                 PktChild->DataLen = Packet.DataLen;
                                 PktChild->Ptr = Packet.Child->Frame->Ip.Data;
                                 break;
          case PROT_PKTTCP:
                                 PktChild->Ptr = Packet.Child->Frame->Tcp.Data;
                                 HLen = 4 * (WORD)(*(Packet.Child->Frame->Tcp.HLen) >> 4);
                                 Packet.DataLen = Packet.DataLen - HLen;
                                 break;
          case PROT_PKTUDP:
                                 PktChild->Ptr = Packet.Child->Frame->Udp.Data;
                                 Packet.DataLen = Packet.DataLen - 8;
                                 break;
          case PROT_PKTICMP:
                                 PktChild->Ptr = Packet.Child->Frame->Icmp.Data;
                                 Packet.DataLen = Packet.DataLen - 4;
                                 break;
          case PROT_PKTRARP:
          case PROT_PKTARP:
                                 PktChild->Ptr = Packet.Child->Frame->Arp.Data;
                                 HLen = 2*(*(Packet.Child->Frame->Arp.HLen)) +
                                     2*(*(Packet.Child->Frame->Arp.PLen) + 8);
                                 Packet.DataLen = Packet.DataLen - HLen;
                                 break;
         }
         DataFilled[ProtType] = 1;
         ProtType = ChildProtocol;
         ProtPtr[PktChild->ChildProt].Header(PktChild);
         switch(ChildProtocol)
         {
          case PROT_PKTIP:IpFill(PktChild->Frame->Ip);
                       break;
          case PROT_PKTUDP:UdpFill(PktChild->Frame->Udp);
                        break;
          case PROT_PKTRARP:
          case PROT_PKTARP:ArpFill(PktChild->Frame->Arp);
                        break;
          case PROT_PKTDNS:DnsFill(PktChild->Frame->Dns);
                        break;
          case PROT_PKTTCP:TcpFill(PktChild->Frame->Tcp);
                        break;
          case PROT_PKTICMP:IcmpFill(PktChild->Frame->Icmp);
                        break;
          case PROT_PKTDEC:DecFill(PktChild->Frame->Dec);
                        break;
         }
         DnpapFree(PktChild->Frame);
         Packet.ChildProt = ChildProtocol;
         ChildProtHis[next+1] = Packet.ChildProt;
         if(nextwin == 0)
         {
          winbutnext  = VipOpenButton(winframe,755,950,105,50);
          VipShow(winbutnext);
          DataFilled[0] = 1;
          VipSetFont(winbutnext,font1);
          VipSetTitle(winbutnext,"Next");
         }
         nextwin++;
         VipSetButtonCallBack(winbutnext,NextWindow,NULL);
      }
     else
      {
        if(nextwin != 0)
        {
         nextwin++;
         DataFilled[19] = 1;
         winbutdata = VipOpenButton(winframe,755,950,105,50);
         VipShow(winbutdata);
         VipSetFont(winbutdata, font1);
         VipSetTitle(winbutdata,"DATA");
         VipSetButtonCallBack(winbutdata,DisplayData,NULL);
        }
        else
        {
          winbutnext  = VipOpenButton(winframe,755,950,105,50);
          VipShow(winbutnext);
          VipSetFont(winbutnext,font1);
          VipSetTitle(winbutnext,"Next");
          VipSetButtonCallBack(winbutnext,NextWindow,NULL);
          DataFilled[0] = 1;
          nextwin++;
          DataFilled[17] = 1;
        }
      }  
}

/*****************************************************************
** NAME:        DisplayData
** SYNOPSIS:    void DisplayData(VIPINFO *wip, void *p, BOOLEAN pressed)
** PARAMETERS:
**              - wip and p not used
**              - button calling DisplayData is pressed
** DESCRIPTION: - displays the data part of the protocol
**              - by Decnet protocols displays the data segments
**                belonging to the given type of the Decnet protocol
**              - at the lower part of the window is the ascii
**                representation of the data displayed
** REMARKS:     
** RETURNS:     no value
*******************************************************************/


VOID DisplayData(VIPINFO *wip,void *p, BOOLEAN pressed)
{
  BYTE DATA[2000];
  BYTE byte[2];
  static BYTE *Str;
  LWORD LngUns;
  int i=0;
  int end = 0;
  int k = 2;
  int DataLength;
  int displayed = 0;
  int type;

  if(!pressed)
  {
    if(DataFilled[18] != 2)
    {
     VipShow(winlabnext[next]);
     VipSetFont(winnext[next], font3); /* Use fixed width font */
     VipSetTextLine(winnext[next], "DATA",0,VIP_CENTER);
     DataLength = Packet.DataLen;
     switch(Packet.ChildProt)
     {
      case PROT_PKTUDP:
                    memcpy(DATA,ProtUdp.Data,2000);
                    PROT_NETWORD(LngUns, ProtUdp.MLen)
/*                    DataLength = (int) LngUns  - 8;*/
                    break;
      case PROT_PKTRARP:
      case PROT_PKTARP:
                    memcpy(DATA,ProtArp.Data,2000);
/*                    DataLength = (int) (*ProtArp.PLen);*/
                    break;
      case PROT_PKTTCP:
                    memcpy(DATA,ProtTcp.Data,2000);
/*                    DataLength = PacketSize - 14 - 20 - ((BYTE) (*ProtIp.HLen) & 0x0f);*/
                    break;
      case PROT_PKTICMP:
                    memcpy(DATA,ProtIcmp.Data,2000);
/*                    DataLength = 0;*/
                    break;
      case PROT_PKTDNS:
                    memcpy(DATA,ProtDns.Data,2000);
                    PROT_NETWORD(LngUns,ProtUdp.MLen);
/*                    DataLength = (int) LngUns - 8;*/
                    break;
      case PROT_PKTDEC:
                    memcpy(DATA,ProtDec.NextData,2000);
                    memcpy(byte,ProtDec.Type,2);
                    k = 2;
                    if((type = byte[0])==129)
                        type = (int) byte[1];
                    switch (type)
                    {
                      case 13:
                               memcpy(byte,ProtDec.Len,2);
                               DataLength = GetDecNumber(&byte[0]);
                               DataLength = PacketSize - DataLength - 16;
                               break;
                      case 11:
                               VipSetTextLine(winnext[next],"LIST OF ROUTERS WITH STATES",0,VIP_CENTER);
                               DataLength = (int) ProtDec.Data->Dec_ERH.RSListLen;
                               PrintERHData();
                               displayed = 1;
                               break;
                      case 7:
                               VipSetTextLine(winnext[next],"SEGMENTS",0,VIP_CENTER);
                               DataLength = 0;
                               PrintLORData();
                               displayed = 1;
                               break;
                      case 38:
                               DataLength = PacketSize - 38;
                               break;
                    }
                    break;
     }
    if(!displayed)
    {
     Str = DnpapMalloc(50);
     *Str = 0;
     while(i <= DataLength - 16)
     {
      sprintf(protocolString,"%02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x",
              DATA[i],DATA[i+1],DATA[i+2],DATA[i+3],DATA[i+4],DATA[i+5],DATA[i+6],DATA[i+7],DATA[i+8],DATA[i+9],
              DATA[i+10],DATA[i+11],DATA[i+12],DATA[i+13],DATA[i+14],DATA[i+15]);                                            
      VipSetTextLine(winnext[next],protocolString,k++,VIP_CENTER);
      sprintf(protocolString,"%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",DATA[i],DATA[i+1],DATA[i+2],DATA[i+3],DATA[i+4],
                                                 DATA[i+5],DATA[i+6],DATA[i+7],DATA[i+8],DATA[i+9],DATA[i+10],DATA[i+11],DATA[i+12],DATA[i+13],DATA[i+14],
                                                 DATA[i+15]);
      VipSetTextLine(winnext[next],protocolString,k+10+DataLength/8,VIP_CENTER);
      i = i + 16;
     }
     sprintf(protocolString,"%02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x",DATA[i],DATA[i+1],DATA[i+2],DATA[i+3],DATA[i+4],
                                                 DATA[i+5],DATA[i+6],DATA[i+7],DATA[i+8],DATA[i+9],DATA[i+10],DATA[i+11],DATA[i+12],DATA[i+13],DATA[i+14],
                                                 DATA[i+15]);
     if(i != 0 && DataLength != i)
      {
       strncpy(Str,protocolString,(DataLength-i)*3 -1);
       strcpy(protocolString,Str);
       protocolString[(DataLength-i)*3 - 1] = '\0';
      }
     else
      {
       if(DataLength == i)
        DataLength = 0;
       if(DataLength  > 0)
       {
        strncpy(Str,protocolString,DataLength + DataLength/2 - 1);
        strcpy(protocolString,Str);
        protocolString[DataLength + DataLength/2 - 1] = '\0';
       }   
      }
     if(DataLength == 0)
        *protocolString = 0;
     VipSetTextLine(winnext[next],protocolString,k,VIP_CENTER);
     sprintf(protocolString,"%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",DATA[i],DATA[i+1],DATA[i+2],DATA[i+3],DATA[i+4],
                                                 DATA[i+5],DATA[i+6],DATA[i+7],DATA[i+8],DATA[i+9],DATA[i+10],DATA[i+11],DATA[i+12],DATA[i+13],DATA[i+14],
                                                 DATA[i+15]);
     if(DataLength == 0)
        *protocolString = 0;
     VipSetTextLine(winnext[next],protocolString,k+DataLength/16+4,VIP_CENTER);
    }
      next++;
      DataFilled[18] = 2;
     DnpapFree(Str);
    }
    else
     VipBell();
  }
}

/*****************************************************************
** NAME:        NextWindow
** SYNOPSIS:    void NextWindow(VIPINFO *wip, void *p, BOOLEAN pressed)
** PARAMETERS:
**              - wip and p not used
**              - button calling NextWindow is pressed
** DESCRIPTION: - shows the next window
**              - reads the next protocol
**              - displays the next protocol in the current window
**                representation of the data displayed
** REMARKS:     
** RETURNS:     no value
*******************************************************************/


VOID NextWindow(VIPINFO *wip,void *p, BOOLEAN pressed)
{
  int unsigned j,k=0;
  const char *String;        
  int offset = 2;
  int unsigned flag;
  int windowline=0;
  BYTE byte[2];
  int type;

    if(!pressed)
    {
     if(next <= nextwin)
      {
       Packet.ChildProt = ChildProtHis[next];
       if(!(Packet.ChildProt != PROT_PKTUNKNOWN && DataFilled[19] == 1))
       {
        if(Packet.ChildProt != PROT_PKTUNKNOWN)
        {
         VipShow(winlabnext[next]);
         VipSetFont(winnext[next], font1); /* Use prop. width font */
         VipSetTextLine(winnext[next],ProtPtr[Packet.ChildProt].Name,0,VIP_CENTER);

          if(Packet.ChildProt != PROT_PKTDEC)
           for(j = 0;j/2 <= ProtPtr[Packet.ChildProt].StringLen-1;j = j+2)
             VipSetTextLine(winnext[next],ProtPtr[Packet.ChildProt].String[j/2],j+offset,VIP_LEFT);
          else
           {
            k = 0;
            offset = 4;
            memcpy(byte,ProtDec.Type,2);
            type = (int) byte[0];
            if(type == 129)
                type = (int) byte[1];
             switch(type)
             {
              case 11:
                      VipSetTextLine(winnext[next],"ETHERNET ROUTER HELLO",2,VIP_CENTER);
                      break;
              case 13:
                      VipSetTextLine(winnext[next],"ETHERNET ENDNODE HELLO",2,VIP_CENTER);
                      break;
              case 7:
                      VipSetTextLine(winnext[next],"LEVEL ONE ROUTING",2,VIP_CENTER);
                      break;
              case 129:
              default:
                      VipSetTextLine(winnext[next],"LONG DATA PACKET",2,VIP_CENTER);
                      break;
             }
            for(j = 0;j/2 <= ProtPtr[Packet.ChildProt].StringLen-1;j = j+2)
            {
             if(DEC_FLAGS[j/2] == 0)
              {
               k++;
               continue;
              }
             else
               VipSetTextLine(winnext[next],ProtPtr[Packet.ChildProt].String[j/2],j - 2*k +offset,VIP_LEFT);
            }
            windowline = j - 2*k + offset;
           }
      if(Packet.ChildProt != PROT_PKTDEC)
      {
       for(flag = 1; flag <= ProtPtr[Packet.ChildProt].StringLen;flag++)
       {
        ProtFun[Packet.ChildProt].PrintHeader(&String,flag);
        VipSetTextLine(winnext[next],String,flag+offset++,VIP_CENTER);
       }
      }      
      else
      {
       offset = 4;
       k = 0;
       for(flag = 1; flag <= 22;flag++)
       {
        if(DEC_FLAGS[flag-1] == 0)
        {
          k++;
          continue;
        }
        else
        {
         ProtFun[Packet.ChildProt].PrintHeader(&String,flag);
         VipSetTextLine(winnext[next],String,flag-k+offset++,VIP_CENTER);
        }   
       }
       if(windowline)
         DisplayDecNspData(windowline);
      }
      if(DataFilled[Packet.ChildProt] == 0)
         ReadNextData(Packet.Child);
      }
         else
         {
          if(next == 0)
          {
           VipShow(winlabnext[next]);
           VipSetFont(winnext[next], font1); /* Use prop. width font */
           VipSetTextLine(winnext[next],"PROT_UNKNOWN",2,VIP_CENTER);
           VipDestroy(winbutnext);
          }
          else
          {
           winbutdata = VipOpenButton(winframe,755,950,105,50);
           VipShow(winbutdata);
           VipSetFont(winbutdata, font1);
           VipSetTitle(winbutdata,"DATA");
           VipSetButtonCallBack(winbutdata,DisplayData,NULL);
          }
         }
          next++;
       }
       else
         VipBell();
      }
    }
}

/*****************************************************************
** NAME:        DisplayDecNspData
** SYNOPSIS:    void NextWindow(int windowline)
** PARAMETERS:
**              - windowline - the line where the displaying should start
** DESCRIPTION: - shows the DEC NSP protocol
** REMARKS:     
** RETURNS:     no value
*******************************************************************/

          
void DisplayDecNspData(int windowline)
{
       memset(&DEC_FLAGS[0],0,22);
       switch(ProtDec.nsp)
       {
         case 96:
                 VipSetTextLine(winnext[next],"NSP PROTOCOL",windowline+3,VIP_RIGHT);
                 VipSetTextLine(winnext[next],"DATA SEGMENT MESSAGE",windowline+5,VIP_CENTER);
                 PrintDataSegmentMessage(windowline + 7);
                 ProtDec.NextData += 9;
                 break;
         case 48:
                 VipSetTextLine(winnext[next],"NSP PROTOCOL",windowline+3,VIP_RIGHT);
                 VipSetTextLine(winnext[next],"INTERRUPT MESSAGE",windowline+5,VIP_CENTER);
                 break;
         case 16:
                 VipSetTextLine(winnext[next],"NSP PROTOCOL",windowline+3,VIP_RIGHT);
                 VipSetTextLine(winnext[next],"LINK SERVICE MESSAGE",windowline+5,VIP_CENTER);
                 PrintDataSegmentMessage(windowline + 7);
                 ProtDec.NextData += 9;
                 break;
         case 4:
                 VipSetTextLine(winnext[next],"NSP PROTOCOL",windowline+3,VIP_RIGHT);
                 VipSetTextLine(winnext[next],"DATA ACKNOWLEDGEMENT ",windowline+5,VIP_CENTER);
                 VipSetTextLine(winnext[next],"MESSAGE",windowline+6,VIP_CENTER);
                 PrintDataAcknowledgementMessage(windowline + 8);
                 ProtDec.NextData += 9;
                 break;
         case 20:
                 VipSetTextLine(winnext[next],"NSP PROTOCOL",windowline+3,VIP_RIGHT);
                 VipSetTextLine(winnext[next],"OTHER - DATA ",windowline+5,VIP_CENTER);
                 VipSetTextLine(winnext[next],"ACKNOWLEDGEMENT MESSAGE",windowline+6,VIP_CENTER);
                 PrintOtherDataAckMessage(windowline + 8);
                 ProtDec.NextData += 7;
                 break;
         case 18:
                 VipSetTextLine(winnext[next],"NSP PROTOCOL",windowline+3,VIP_RIGHT);
                 VipSetTextLine(winnext[next],"CONNECT INITIATE MESSAGE",windowline+5,VIP_CENTER);
                 break;
         case 104:
                 VipSetTextLine(winnext[next],"NSP PROTOCOL",windowline+3,VIP_RIGHT);
                 VipSetTextLine(winnext[next],"RETRANSMITTED CONNECT INITIATE MESSAGE",windowline+5,VIP_CENTER);
                 break;
         case 40:
                 VipSetTextLine(winnext[next],"NSP PROTOCOL",windowline+3,VIP_RIGHT);
                 VipSetTextLine(winnext[next],"CONNECT CONFIRM MESSAGE",windowline+5,VIP_CENTER);
                 break;
         case 36:
                 VipSetTextLine(winnext[next],"NSP PROTOCOL",windowline+3,VIP_RIGHT);
                 VipSetTextLine(winnext[next],"CONNECT ACKNOWLEDGEMENT MESSAGE",windowline+5,VIP_CENTER);
                 break;
         case 56:
                 VipSetTextLine(winnext[next],"NSP PROTOCOL",windowline+3,VIP_RIGHT);
                 VipSetTextLine(winnext[next],"DISCONNECT INITIATE MESSAGE",windowline+5,VIP_CENTER);
                 break;
         case 67:
                 VipSetTextLine(winnext[next],"NSP PROTOCOL",windowline+3,VIP_RIGHT);
                 VipSetTextLine(winnext[next],"DISCONNECT CONFIRM MESSAGE",windowline+5,VIP_CENTER);
                 break;
         default:break;

       }
}

/*****************************************************************
** NAME:        WinNextClose
** SYNOPSIS:    void WinNextClose(VIPINFO *wip, void *p, BOOLEAN pressed)
** PARAMETERS:
**              - wip and p not used
**              - button calling WinNextClose is pressed
** DESCRIPTION: - hides the last window (BACK button)
** REMARKS:     
** RETURNS:     no value
*******************************************************************/


VOID WinNextClose(VIPINFO *wip, void *ptr, BOOLEAN pressed)
{
    if (pressed) return;
    if(next == 0)
    {
        VipSetButtonCallBack(winpop, WinProt, NULL);
       VipHide(winprotlabel);
       VipClearText(winprotocol);
       DnpapFree(Packet.Child);
       VipDestroy(winbutBack);
       if(DataFilled[0] == 1)
           VipDestroy(winbutnext);
       VipDestroy(winbutClose);
       InitDataFill();
    }
    else
    {
        VipHide(winlabnext[--next]);
        VipClearText(winnext[next]);
        if(winbutdata != NULL && DataFilled[18] != 2)
        {
            VipDestroy(winbutdata);
            winbutdata = NULL;
            DataFilled[19] = 0;
        }
        DataFilled[18] = 0;
    }
}

/*****************************************************************
** NAME:        DecFill
** SYNOPSIS:    BOOLEAN DecFill(PROT_DEC Dec)
** PARAMETERS:
**              - Dec - Decnet packet data structure
** DESCRIPTION: - fills the DEC_FLAGS, which determine
**                which fields of the Decnet protocol will be displayed
** REMARKS:     
** RETURNS:     FALSE - if allocation was not succesful
**              TRUE  - otherwise
*******************************************************************/

BOOLEAN DecFill(PROT_DEC Dec)
{
 BYTE byte[2];
 int i;
 int type;

 ProtDec.Len = Dec.Len;
 ProtDec.Type = Dec.Type;
 ProtDec.NextData = Dec.NextData;
 ProtDec.nsp = Dec.nsp;
 for(i=1;i<=23;i++)
  DEC_FLAGS[i] = 0;
 memcpy(byte,Dec.Type,2);
 if((ProtDec.Data = DnpapMalloc(1600)) == NULL)
  {
    DnpapMessage(DMC_FATAL,1,"Out of memory");
    return(FALSE);
  }
 else
 {
  ProtDec.Data = Dec.Data;
  if(byte[0] == 129)
    type = (int) byte[1];
  else
    type = (int) byte[0];
  switch(type)
   {
    case 13:  
              DEC_FLAGS[13]=DEC_FLAGS[1]=DEC_FLAGS[2]=DEC_FLAGS[3]=DEC_FLAGS[4]=
              DEC_FLAGS[5]=DEC_FLAGS[6]=DEC_FLAGS[7]=DEC_FLAGS[8]=DEC_FLAGS[9]=
              DEC_FLAGS[10]=DEC_FLAGS[11]=DEC_FLAGS[12]=1;
              return(TRUE);
     case 11:
              DEC_FLAGS[1]=DEC_FLAGS[2]=DEC_FLAGS[3]=DEC_FLAGS[4]=DEC_FLAGS[5]=
              DEC_FLAGS[6]=DEC_FLAGS[10]=DEC_FLAGS[14]=DEC_FLAGS[15]=DEC_FLAGS[16]=
              DEC_FLAGS[17]=DEC_FLAGS[17]=1;
              return(TRUE);
     case 7:
              DEC_FLAGS[4]=1;
              return(TRUE);
     case 129:
     default:
             DEC_FLAGS[19]=DEC_FLAGS[20]=DEC_FLAGS[21]=1;
             return(TRUE);
   }
 }
}

/*****************************************************************
** NAME:        IpFill
** SYNOPSIS:    BOOLEAN IpFill(PROT_IP Ip)
** PARAMETERS:
**              - Ip - IP protocol data structure
** DESCRIPTION: - fills the data in the IP protocol data structure
** REMARKS:     
** RETURNS:     TRUE
*******************************************************************/


BOOLEAN IpFill(PROT_IP Ip)
{
 ProtIp.Vers = Ip.Vers;
 ProtIp.HLen = Ip.HLen;
 ProtIp.Service = Ip.Service;
 ProtIp.TLen = Ip.TLen;
 ProtIp.ID = Ip.ID;
 ProtIp.Flags = Ip.Flags;
 ProtIp.Fragment = Ip.Fragment;
 ProtIp.Time = Ip.Time;
 ProtIp.Type = Ip.Type;
 ProtIp.ChkSum = Ip.ChkSum;
 ProtIp.IPSrc = Ip.IPSrc;
 ProtIp.IPDst = Ip.IPDst;
 ProtIp.IPOption = Ip.IPOption;
 return(TRUE);
}

/*****************************************************************
** NAME:        UdpFill
** SYNOPSIS:    BOOLEAN UdpFill(PROT_UDP Udp)
** PARAMETERS:
**              - Udp - UDP protocol data structure
** DESCRIPTION: - fills the data in the UDP protocol data structure
** REMARKS:     
** RETURNS:     TRUE
*******************************************************************/

BOOLEAN UdpFill(PROT_UDP Udp)
{
 ProtUdp.SrcPort = Udp.SrcPort;
 ProtUdp.DstPort = Udp.DstPort;
 ProtUdp.MLen = Udp.MLen;
 ProtUdp.ChkSum = Udp.ChkSum;
 ProtUdp.Data = Udp.Data;
 return(TRUE);
}

/*****************************************************************
** NAME:        ArpFill
** SYNOPSIS:    BOOLEAN ArpFill(PROT_ARP Arp)
** PARAMETERS:
**              - Arp - ARP protocol data structure
** DESCRIPTION: - fills the data in the ARP protocol data structure
** REMARKS:     
** RETURNS:     TRUE
*******************************************************************/

BOOLEAN ArpFill(PROT_ARP Arp)
{
 ProtArp.Hardw = Arp.Hardw;
 ProtArp.Type  = Arp.Type;
 ProtArp.HLen  = Arp.HLen;
 ProtArp.PLen  = Arp.PLen;
 ProtArp.Operation = Arp.Operation;
 ProtArp.HwSender = Arp.HwSender;
 ProtArp.ProtSender = Arp.ProtSender;
 ProtArp.HwTarget = Arp.HwTarget;
 ProtArp.ProtTarget = Arp.ProtTarget;
 ProtArp.Data = Arp.Data;
 return(TRUE);
}

/*****************************************************************
** NAME:        DnsFill
** SYNOPSIS:    BOOLEAN DnsFill(PROT_DNS Dns)
** PARAMETERS:
**              - Dns - DNS protocol data structure
** DESCRIPTION: - fills the data in the DNS protocol data structure
** REMARKS:     
** RETURNS:     TRUE
*******************************************************************/

BOOLEAN DnsFill(PROT_DNS Dns)
{
 ProtDns.ID = Dns.ID;
 ProtDns.Parameter = Dns.Parameter;
 ProtDns.NroQuest = Dns.NroQuest;
 ProtDns.NroAnsw = Dns.NroAnsw;
 ProtDns.NroAuth = Dns.NroAuth;
 ProtDns.NroAdd = Dns.NroAdd;
 ProtDns.Entry = Dns.Entry;
 PROT_NETWORD(EntryLen[0], Dns.NroQuest)
 PROT_NETWORD(EntryLen[1], Dns.NroAnsw)
 PROT_NETWORD(EntryLen[2], Dns.NroAuth)
 PROT_NETWORD(EntryLen[3], Dns.NroAdd)
 ProtDns.Data = Packet.Ptr + 20;
 return (TRUE);
}

/*****************************************************************
** NAME:        TcpFill
** SYNOPSIS:    BOOLEAN TcpFill(PROT_TCP Tcp)
** PARAMETERS:
**              - Tcp - TCP protocol data structure
** DESCRIPTION: - fills the data in the TCP protocol data structure
** REMARKS:     
** RETURNS:     TRUE
*******************************************************************/

BOOLEAN TcpFill(PROT_TCP Tcp)
{
 ProtTcp.SrcPort = Tcp.SrcPort;
 ProtTcp.DstPort = Tcp.DstPort;
 ProtTcp.SeqNr = Tcp.SeqNr;
 ProtTcp.AckNr = Tcp.AckNr;
 ProtTcp.HLen = Tcp.HLen;
 ProtTcp.Reserved = Tcp.Reserved;
 ProtTcp.Code = Tcp.Code;
 ProtTcp.Window = Tcp.Window;
 ProtTcp.ChkSum = Tcp.ChkSum;
 ProtTcp.UrgePtr = Tcp.UrgePtr;
 ProtTcp.Option = Tcp.Option;
 ProtTcp.Data = Packet.Ptr + 4 * (*Tcp.HLen >> 4);
 return(TRUE);
}

/*****************************************************************
** NAME:        IcmpFill
** SYNOPSIS:    BOOLEAN IcmpFill(PROT_ICMP Icmp)
** PARAMETERS:
**              - Icmp - ICMP protocol data structure
** DESCRIPTION: - fills the data in the ICMP protocol data structure
** REMARKS:     
** RETURNS:     TRUE
*******************************************************************/

BOOLEAN IcmpFill(PROT_ICMP Icmp)
{
 ProtIcmp.Type = Icmp.Type;
 ProtIcmp.Code = Icmp.Code;
 ProtIcmp.ChkSum = Icmp.ChkSum;
 ProtIcmp.Data = Icmp.Data;
 return(TRUE);
}

/*****************************************************************
** NAME:        EtherPrintHeader
** SYNOPSIS:    BOOLEAN EtherPrintHeader(BYTE **StrPtr, int flag)
** PARAMETERS:
**              - StrPtr - the string where the result string will
**                be stored
**              - flag the number of the required string
** DESCRIPTION: - gets the Ether protocol data for next printing to
**                the current window
** REMARKS:     
** RETURNS:     TRUE  - if the field was found
**              FALSE - otherwise
*******************************************************************/

BOOLEAN EtherPrintHeader(BYTE **StrPtr, int flag)
{
    LWORD LngUns;

    switch (flag)
    {
        case 1:                                 /* Dst Adr */
                sprintf(protocolString, "%02x:%02x:%02x:%02x:%02x:%02x",
                Packet.Frame->Ethernet.DstAdr[0], Packet.Frame->Ethernet.DstAdr[1],
                Packet.Frame->Ethernet.DstAdr[2], Packet.Frame->Ethernet.DstAdr[3],
                Packet.Frame->Ethernet.DstAdr[4], Packet.Frame->Ethernet.DstAdr[5]);
                *StrPtr = protocolString;
                return (TRUE);
        case 2:                                 /* Src Adr */
                sprintf(protocolString, "%02x:%02x:%02x:%02x:%02x:%02x",
                Packet.Frame->Ethernet.SrcAdr[0], Packet.Frame->Ethernet.SrcAdr[1],
                Packet.Frame->Ethernet.SrcAdr[2], Packet.Frame->Ethernet.SrcAdr[3],
                Packet.Frame->Ethernet.SrcAdr[4], Packet.Frame->Ethernet.SrcAdr[5]);
                *StrPtr = protocolString;
                return (TRUE);
        case 3:                                 /* Type */
                PROT_NETWORD(LngUns,Packet.Frame->Ethernet.Type);
                if(LngUns < 0x600)
                      LngUns = 0;
                sprintf(protocolString, "%04lx", LngUns);
                *StrPtr = protocolString;
                return (TRUE);
       default:
                return (FALSE);
     }
}

/*****************************************************************
** NAME:        EtherPrintHeader
** SYNOPSIS:    BOOLEAN TCPPrintHeader(BYTE **StrPtr, int flag)
** PARAMETERS:
**              - StrPtr - the string where the result string will
**                be stored
**              - flag the number of the required string
** DESCRIPTION: - gets the Tcp protocol data for next printing to
**                the current window
** REMARKS:     
** RETURNS:     TRUE  - if the field was found
**              FALSE - otherwise
*******************************************************************/

BOOLEAN TCPPrintHeader (BYTE **String, int flag)
{
  LWORD LngUns;
  LWORD Reserved;
  WORD Len;
  WORD Ind;
  BYTE BufChar[SNMP_SIZE_BUFCHR];
  BYTE Char[4];

        switch (flag)
        {
            case 1:                                       /* SrcPort */
                   PROT_NETWORD(LngUns, ProtTcp.SrcPort) 
                   sprintf(protocolString, "%6lu",LngUns);
                   *String = protocolString;
                   return (TRUE);
            case 2:                                       /* DstPort */
                   PROT_NETWORD(LngUns, ProtTcp.DstPort)
                   sprintf(protocolString, "%6lu", LngUns);
                   *String = protocolString;
                   return (TRUE);
            case 3:                                       /* SeqNr */
                   PROT_NETLWORD(LngUns,ProtTcp.SeqNr);
                   sprintf(protocolString, "%6lu", LngUns);
                   *String = protocolString;
                   return (TRUE);
            case 4:                                       /* AckNr */
                   PROT_NETLWORD(LngUns,ProtTcp.AckNr);
                   sprintf(protocolString, "%12lu", LngUns);
                   *String = protocolString;
                   return (TRUE);
            case 5:                                        /* HLen */
                   LngUns = (LWORD) *(ProtTcp.HLen);
                   LngUns >>= 4;
                   sprintf(protocolString, "%2lu", LngUns);
                   *String = protocolString;
                   return (TRUE);
            case 6:                                        /* Reserved */
                   LngUns = (LWORD)(*(ProtTcp.Reserved) & 0x0F);
                   LngUns <<= 2;
                   Reserved = (LWORD) (*(ProtTcp.Reserved + 1) & 0xC0);
                   Reserved >>= 6;
                   LngUns |= Reserved;
                   sprintf(protocolString, "%01lx", LngUns);   
                   *String = protocolString;
                   return (TRUE);
            case 7:                                        /* Code */
                   LngUns = (LWORD) (*(ProtTcp.Code) & 0x3F);
                   sprintf(protocolString, "%01lx", LngUns);
                   *String = protocolString;
                   return (TRUE);
            case 8:                                        /* Window */
                   PROT_NETWORD(LngUns, ProtTcp.Window);
                   sprintf(protocolString, "%6lu", LngUns);
                   *String = protocolString;
                   return (TRUE);                          
            case 9:                                        /* ChkSum */
                   PROT_NETWORD(LngUns, ProtTcp.ChkSum);
                   sprintf(protocolString, "%4lx", LngUns);
                   *String = protocolString;
                   return (TRUE);
            case 10:                                        /* UrgPtr*/
                   PROT_NETWORD(LngUns,ProtTcp.UrgePtr);
                   sprintf(protocolString, "%4lx", LngUns);
                   *String = protocolString;
                   return (TRUE);
            case 11:                                         /* Options */
                   Len = 4 * (*(ProtTcp.HLen) >> 4) - 20;
                   memcpy(BufChar, ProtTcp.Option, Len);
                   *protocolString = '\0';
                   for (Ind = 0; Ind < Len; Ind++)
                   {
                    sprintf(Char, "%02x",BufChar[Ind]);
                    strcat(protocolString, Char);
                   }
                   *String = protocolString;
                   return (TRUE);      
            case 12:                             
                   return (TRUE);
            default:
                   return (FALSE);
        }
 
}

/*****************************************************************
** NAME:        DECPrintHeader
** SYNOPSIS:    BOOLEAN DECPrintHeader(BYTE **StrPtr, int flag)
** PARAMETERS:
**              - StrPtr - the string where the result string will
**                be stored
**              - flag the number of the required string
** DESCRIPTION: - gets the Dec protocol data for next printing to
**                the current window
** REMARKS:     
** RETURNS:     TRUE  - if the field was found
**              FALSE - otherwise
*******************************************************************/

BOOLEAN DECPrintHeader (BYTE **String, int flag)
{
  BYTE EndNodeBuf[1500];
  BYTE RetStr[20];
  int type;
  int OptPad=0;

  memcpy(EndNodeBuf,ProtDec.Type,2);
  if((type = EndNodeBuf[0]) == 129)
  {
    type = (int) EndNodeBuf[1];
    OptPad=1;
  }  
  switch(type)
  {
    case 13:
            if(!OptPad)
             memcpy(EndNodeBuf,ProtDec.Data->Dec_EEH.Data,100);
            else
             memcpy(EndNodeBuf,ProtDec.Data->Dec_EEH.Data+1,100);
            switch(flag)
            {
             case 1:
                    *String = "81";
                    return(TRUE);
             case 2:
                    sprintf(protocolString,"%d",EndNodeBuf[0]);
                    *String = protocolString;
                    return(TRUE);
             case 3:
                    sprintf(protocolString,"%d",EndNodeBuf[1]);
                    *String = protocolString;
                    return(TRUE);
             case 4:
                    sprintf(protocolString,"%d",EndNodeBuf[2]);
                    *String = protocolString;
                    return(TRUE);
             case 5:
                    GetAddress(&EndNodeBuf[7],RetStr);
                    *String = RetStr;
                    return(TRUE);
             case 6:
                    sprintf(protocolString,"%d",EndNodeBuf[9]);
                    *String = protocolString;
                    return(TRUE);
             case 7:
                    sprintf(protocolString,"%d",GetDecNumber(&EndNodeBuf[10]));
                    *String = protocolString;
                    return(TRUE);
             case 8:
                    sprintf(protocolString,"%d",EndNodeBuf[12]);
                    *String = protocolString;
                    return(TRUE);
             case 9:
                    sprintf(protocolString,"%02x %02x %02x %02x %02x %02x %02x %02x",EndNodeBuf[13],
                    EndNodeBuf[14],EndNodeBuf[15],EndNodeBuf[16],
                    EndNodeBuf[17],EndNodeBuf[18],EndNodeBuf[19],EndNodeBuf[20]);
                    *String = protocolString;
                    return(TRUE);
             case 10:
                    GetAddress(&EndNodeBuf[25],RetStr);
                    *String = RetStr;
                    return(TRUE);
             case 11:
                    sprintf(protocolString,"%d",GetDecNumber(&EndNodeBuf[27]));
                    *String = protocolString;
                    return(TRUE);
             case 12:
                    sprintf(protocolString,"%d",EndNodeBuf[29]);
                    *String = protocolString;
                    return(TRUE);
             case 13:
                    sprintf(protocolString,"%d",EndNodeBuf[30]);
                    *String = protocolString;
                    return(TRUE);
            }
           break;
    case 11: if(!OptPad)
              memcpy(EndNodeBuf,ProtDec.Data->Dec_ERH.Data,100);
             else
              memcpy(EndNodeBuf,ProtDec.Data->Dec_ERH.Data+1,100);
             switch (flag)       
             {
             case 1:
                    *String = "81";
                    return(TRUE);
              case 2:                                   /* version */
                    sprintf(protocolString,"%d",EndNodeBuf[0]);
                    *String = protocolString;
                    return(TRUE);
             case 3:                                    /* eco */
                    sprintf(protocolString,"%d",EndNodeBuf[1]);
                    *String = protocolString;
                    return(TRUE);
             case 4:                                    /* user eco */
                    sprintf(protocolString,"%d",EndNodeBuf[2]);
                    *String = protocolString;
                    return(TRUE);
             case 5:                                   /* SrcNode */
                    GetAddress(&EndNodeBuf[7],RetStr);
                    *String = RetStr;
                    return(TRUE);
             case 6:                                   /* info */
                    sprintf(protocolString,"%d",EndNodeBuf[9]);
                    *String = protocolString;
                    return(TRUE);
             case 7:                                   /* blocksize */
                    sprintf(protocolString,"%d",GetDecNumber(&EndNodeBuf[10]));
                    *String = protocolString;
                    return(TRUE);
             case 15:                                   /* priority */
                    sprintf(protocolString,"%d",EndNodeBuf[12]);
                    *String = protocolString;
                    return(TRUE);
             case 11:                                   /* timer */
                    sprintf(protocolString,"%d",GetDecNumber(&EndNodeBuf[14]));
                    *String = protocolString;
                    return(TRUE);
             case 12:                                   /* MPD */
                    sprintf(protocolString,"%d",EndNodeBuf[15]);
                    *String = protocolString;
                    return(TRUE);
             case 16:                                   /* E-list length */
                    sprintf(protocolString,"%d",GetDecNumber(&EndNodeBuf[17]));
                    *String = protocolString;
                    return(TRUE);
             case 18:                                   /* Name */
                    sprintf(protocolString,"%02x %02x %02x %02x %02x %02x %02x",EndNodeBuf[18],
                    EndNodeBuf[19],EndNodeBuf[20],EndNodeBuf[21],
                    EndNodeBuf[22],EndNodeBuf[23],EndNodeBuf[24]);
                    *String = protocolString;
                    return(TRUE);
             case 17:                                    /* RS list length */
                    sprintf(protocolString,"%d",EndNodeBuf[25]);
                    *String = protocolString;
                    return(TRUE);
             }
            break;
    case 7:   if(!OptPad)
               memcpy(EndNodeBuf,ProtDec.Data->Dec_LOR.Data,1500);
              else
               memcpy(EndNodeBuf,ProtDec.Data->Dec_LOR.Data+1,1500);
              switch(flag)
              {
               case 1:
                      *String = "81";
                      return(TRUE);
               case 5:
                      GetAddress(&EndNodeBuf[0],RetStr);
                      *String = RetStr;
                      return(TRUE);
               }
              break;
    case 38:
             memcpy(EndNodeBuf,ProtDec.Data->Dec_LDP.Data,200);
             switch(flag)
             {
              case 1:
                     *String = "81";
                     return(TRUE);
              case 20:
                      GetAddress(&EndNodeBuf[7],RetStr);
                      *String = RetStr;
                      return(TRUE);
              case 21:
                      GetAddress(&EndNodeBuf[15],RetStr);
                      *String = RetStr;
                      return(TRUE);
              case 22:
                      sprintf(protocolString,"%d",(WORD) EndNodeBuf[18]/*(ProtDec.Data->Dec_LDP.VisitCount)*/);
                      *String = protocolString;
                      return(TRUE);
             }
             break;
    default:
                      sprintf(protocolString,"%d",type);
                      *String = protocolString;
                      return(TRUE);
 }
}

/*****************************************************************
** NAME:        IPPrintHeader
** SYNOPSIS:    BOOLEAN IPPrintHeader(BYTE **StrPtr, int flag)
** PARAMETERS:
**              - StrPtr - the string where the result string will
**                be stored
**              - flag the number of the required string
** DESCRIPTION: - gets the Ip protocol data for next printing to
**                the current window
** REMARKS:     
** RETURNS:     TRUE  - if the field was found
**              FALSE - otherwise
*******************************************************************/

BOOLEAN IPPrintHeader (BYTE **StrPtr, int flag)
{
    LWORD LngUns;
    BYTE t[2];
    WORD Len;
    BYTE BufChar[SNMP_SIZE_BUFCHR];
    WORD Ind;
    BYTE Char[4];

    switch (flag)
    {
        case 1:                             /* Vers */
               LngUns = (LWORD) *(ProtIp.Vers);
               LngUns >>= 4;
               sprintf(protocolString, "%d", LngUns);
               *StrPtr = protocolString;
               return (TRUE);
        case 2:                             /* HLen */
               LngUns = (LWORD) (*(ProtIp.HLen) & 0x0F);
               sprintf(protocolString, "%2lu", LngUns);
               *StrPtr = protocolString;
               return (TRUE);
        case 9:                             /* Type */
               LngUns = (LWORD) *(ProtIp.Type);
               sprintf(protocolString, "%2lu", LngUns);
               *StrPtr = protocolString;
               return (TRUE);
        case 8:                             /* Time to Live */
               LngUns = (LWORD) *(ProtIp.Time);
               sprintf(protocolString, "%4lu", LngUns);
               *StrPtr = protocolString;
               return (TRUE);
        case 3:                             /* Service */
               LngUns = (LWORD) *(ProtIp.Service);
               sprintf(protocolString, "%02lx", LngUns);
               *StrPtr = protocolString;
               return (TRUE);
        case 4:                             /* Total Len */
               PROT_NETWORD(LngUns,ProtIp.TLen);
               sprintf(protocolString, "%6lu", LngUns);
               *StrPtr = protocolString;
               return (TRUE);
        case 5:                             /* Identification */
               PROT_NETWORD(LngUns,ProtIp.ID);
               sprintf(protocolString, "%04lx", LngUns);
               *StrPtr = protocolString;
               return (TRUE);
        case 7:                             /* Fragment */
               t[0] = (BYTE) (*(ProtIp.Fragment) & 0x1F);
               t[1] = *(ProtIp.Fragment + 1);
               PROT_NETWORD(LngUns,t);
               sprintf(protocolString, "%04lx", LngUns);
               *StrPtr = protocolString;
               return (TRUE);
        case 10:                            /* Check Sum */
               PROT_NETWORD(LngUns,ProtIp.ChkSum);
               sprintf(protocolString, "%04lx", LngUns);
               *StrPtr = protocolString;
               return (TRUE);
        case 6:                             /* Flags */
               LngUns = (LWORD) *(ProtIp.Flags);
               LngUns >>= 5;
               sprintf(protocolString, "%01lx", LngUns);
               *StrPtr = protocolString;
               return (TRUE);
        case 11:                            /* IP Src */
               LngUns = *((LWORD*) ProtIp.IPSrc);
               sprintf(protocolString, "%u.%u.%u.%u",
                 ((BYTE*) &LngUns)[0],
                 ((BYTE*) &LngUns)[1],
                 ((BYTE*) &LngUns)[2],
                 ((BYTE*) &LngUns)[3]);
               *StrPtr = protocolString;
               return (TRUE);
        case 12:                            /* IP Dst */
               LngUns = *((LWORD*) ProtIp.IPDst);
               sprintf(protocolString, "%u.%u.%u.%u",
                  ((BYTE*) &LngUns)[0],
                  ((BYTE*) &LngUns)[1],
                  ((BYTE*) &LngUns)[2],
                  ((BYTE*) &LngUns)[3]);
               *StrPtr = protocolString;
               return (TRUE);
        case 13:                           /* IP Options */
               Len = 4 * (*(ProtIp.HLen) & 0x0F) - 20;
               memcpy(BufChar,ProtIp.IPOption,Len);
               *protocolString = '\0';
               for (Ind = 0; Ind < Len; Ind++)
               {
                sprintf(Char, "%02x",BufChar[Ind]);
                strcat(protocolString, Char);
               }
               *StrPtr = protocolString;
              return (TRUE);
        default:
            return (FALSE);
    }
}

/*****************************************************************
** NAME:        UDPPrintHeader
** SYNOPSIS:    BOOLEAN UDPPrintHeader(BYTE **StrPtr, int flag)
** PARAMETERS:
**              - StrPtr - the string where the result string will
**                be stored
**              - flag the number of the required string
** DESCRIPTION: - gets the Udp protocol data for next printing to
**                the current window
** REMARKS:     
** RETURNS:     TRUE  - if the field was found
**              FALSE - otherwise
*******************************************************************/

BOOLEAN UDPPrintHeader(BYTE **String,int flag)
{
    LWORD LngUns;

    switch(flag)
    {
     case 1:
            PROT_NETWORD(LngUns,ProtUdp.SrcPort);
            sprintf(protocolString, "%6lu", LngUns);
            *String = protocolString;
            return(TRUE);
     case 2:
            PROT_NETWORD(LngUns,ProtUdp.DstPort);
            sprintf(protocolString, "%6lu", LngUns);
            *String = protocolString;
            return(TRUE);
     case 3:
            PROT_NETWORD(LngUns,ProtUdp.MLen);
            sprintf(protocolString, "%6lu", LngUns);
            *String = protocolString;
            return (TRUE);
     case 4:
            PROT_NETWORD(LngUns,ProtUdp.ChkSum);
            sprintf(protocolString, "%4lx", LngUns);
            *String = protocolString;
            return(TRUE);
     default: return (FALSE);
     }
}

/*****************************************************************
** NAME:        DNSPrintHeader
** SYNOPSIS:    BOOLEAN DNSPrintHeader(BYTE **StrPtr, int flag)
** PARAMETERS:
**              - StrPtr - the string where the result string will
**                be stored
**              - flag the number of the required string
** DESCRIPTION: - gets the Dns protocol data for next printing to
**                the current window
** REMARKS:     
** RETURNS:     TRUE  - if the field was found
**              FALSE - otherwise
*******************************************************************/

BOOLEAN DNSPrintHeader(BYTE **String,int flag)
{
 LWORD LngUns;

 switch (flag)
  {
   case 1:
          PROT_NETWORD(LngUns,ProtDns.ID);
          sprintf(protocolString, "%4lx",LngUns);
          *String = protocolString;
          return(TRUE);
   case 2:
          PROT_NETWORD(LngUns,ProtDns.Parameter);
          sprintf(protocolString, "%4lx",LngUns);
          *String = protocolString;
          return(TRUE);
   case 3:
   case 4:
   case 5:
   case 6:
          LngUns = EntryLen[flag - 3];
          sprintf(protocolString, "%4lx",LngUns);
          *String = protocolString;
          return(TRUE);
   case 7:
   case 8:
   case 9:
   case 10:return(TRUE);
    }
}

/*****************************************************************
** NAME:        ICMPPrintHeader
** SYNOPSIS:    BOOLEAN ICMPPrintHeader(BYTE **StrPtr, int flag)
** PARAMETERS:
**              - StrPtr - the string where the result string will
**                be stored
**              - flag the number of the required string
** DESCRIPTION: - gets the Icmp protocol data for next printing to
**                the current window
** REMARKS:     
** RETURNS:     TRUE  - if the field was found
**              FALSE - otherwise
*******************************************************************/

BOOLEAN ICMPPrintHeader (BYTE **String, int flag)
{
 LWORD LngUns;
    
  switch (flag)
  {
   case 1:                                               /* Type */
           LngUns = (LWORD) *(ProtIcmp.Type);
           sprintf(protocolString, "%2lu", LngUns);
           *String = protocolString;
           return (TRUE);
   case 2:                                                /* Code */
           LngUns = (LWORD) *(ProtIcmp.Code);
           sprintf(protocolString, "%2lu", LngUns);
           *String = protocolString;
           return (TRUE);
   case 3:                                                 /* ChkSum */
           PROT_NETWORD(LngUns, ProtIcmp.ChkSum)
           sprintf(protocolString, "%04lx", LngUns);
           return (TRUE);
   case 4:
           return (TRUE);
   default:
           return (FALSE);
  }
}

/*****************************************************************
** NAME:        ARPPrintHeader
** SYNOPSIS:    BOOLEAN ARPPrintHeader(BYTE **StrPtr, int flag)
** PARAMETERS:
**              - StrPtr - the string where the result string will
**                be stored
**              - flag the number of the required string
** DESCRIPTION: - gets the Arp protocol data for next printing to
**                the current window
** REMARKS:     
** RETURNS:     TRUE  - if the field was found
**              FALSE - otherwise
*******************************************************************/

BOOLEAN ARPPrintHeader (BYTE **String, int flag)
{
    WORD Ind;
    BYTE Char[4];
    WORD SyntaxLen;
    LWORD LngUns;
    BYTE Buffer[SNMP_SIZE_BUFCHR];

    switch (flag)
    {
        
        case 1:                                     /* Hardw */
               PROT_NETWORD(LngUns, ProtArp.Hardw)
               sprintf(protocolString, "%4lx", LngUns);
               *String = protocolString;
               return (TRUE);
        case 5:                                     /* Operation */
               PROT_NETWORD(LngUns,ProtArp.Operation)
               sprintf(protocolString, "%4lx", LngUns);
               *String = protocolString;
               return (TRUE);
        case 2:                                     /* Protocol */
               PROT_NETWORD(LngUns,ProtArp.Type)
               sprintf(protocolString, "%04lx", LngUns);
               *String = protocolString;
               return (TRUE);
        case 3:                                     /* HLen */
               LngUns = (LWORD) *(ProtArp.HLen);
               sprintf(protocolString, "%2lu", LngUns);
               *String = protocolString;
               return (TRUE);
        case 4:                                     /* PLen */
               LngUns = (LWORD) *(ProtArp.PLen);
               sprintf(protocolString, "%2lu", LngUns);
               *String = protocolString;
               return (TRUE);
        case 6:                                     /* Hw Sender */
               SyntaxLen  = (WORD) (*(ProtArp.HLen));
               memcpy(Buffer,ProtArp.HwSender,SyntaxLen);
               *protocolString = '\0';
               for (Ind = 0; Ind < SyntaxLen; Ind++)
               {
                 sprintf(Char, "%02x", Buffer[Ind]);
                 strcat(protocolString, Char);
                 if (Ind < SyntaxLen-1)
                     strcat(protocolString, ":");
               }
               *String = protocolString;
               return (TRUE);
        case 8:                                     /* Hw Target */
               SyntaxLen  = (WORD) (*(ProtArp.HLen));
               memcpy(Buffer,ProtArp.HwTarget,SyntaxLen);
               *protocolString = '\0';
               for (Ind = 0; Ind < SyntaxLen; Ind++)
               {
                 sprintf(Char, "%02x",Buffer[Ind]);
                 strcat(protocolString, Char);
                 if (Ind < SyntaxLen-1)
                     strcat(protocolString, ":");
               }
               *String = protocolString;
               return (TRUE);
        case 7:                                     /* Prot Sender */
               SyntaxLen  = (WORD) (*(ProtArp.PLen));
               memcpy(Buffer,ProtArp.ProtSender,SyntaxLen);
               *protocolString ='\0';
               for (Ind = 0; Ind < SyntaxLen; Ind++)
               {
                 sprintf(Char, "%u", Buffer[Ind]);
                 strcat(protocolString, Char);
                 if (Ind < SyntaxLen-1)
                    strcat(protocolString, ".");
               }
               *String = protocolString;
               return (TRUE);
        case 9:                                     /* Prot Target */
               SyntaxLen  = (WORD) (*(ProtArp.PLen));
               memcpy(Buffer,ProtArp.ProtTarget,SyntaxLen);
               *protocolString ='\0';
               for (Ind = 0; Ind < SyntaxLen; Ind++)
               {
                 sprintf(Char, "%u", Buffer[Ind]);
                 strcat(protocolString, Char);
                 if (Ind < SyntaxLen-1)
                    strcat(protocolString, ".");
               }
               *String = protocolString;
               return (TRUE);
        default:
               return (FALSE);
    }
}

/*****************************************************************
** NAME:        PrintLORData
** SYNOPSIS:    void PrintLORData(void)
** PARAMETERS:  void
** DESCRIPTION: - prints the Level One Routing Protocol data
**                to the current window
** REMARKS:     
** RETURNS:     no value
*******************************************************************/

void PrintLORData(void)
{
 BYTE Data[1500];
 BYTE RetStr[10];
 int k = 2;
 int i,count,size,j=0;
 BYTE buf[2];

 memcpy(Data,ProtDec.NextData,1500);
 memcpy(&buf,ProtDec.Len,2);
 i = (int) GetDecNumber(&buf[0]);
 i = i - 14;
 size = i;

 while(i>0)
 {
  VipSetTextLine(winnext[next],"COUNT",k++,VIP_LEFT);
  sprintf(protocolString,"%d",GetDecNumber(&Data[j]));
  count = atoi(protocolString);
  VipSetTextLine(winnext[next],protocolString,k++,VIP_CENTER);
  VipSetTextLine(winnext[next],"STARTID",k++,VIP_LEFT);
  sprintf(protocolString,"%d",GetDecNumber(&Data[j+2]));
  VipSetTextLine(winnext[next],protocolString,k++,VIP_CENTER);
  i = i - 2 - count*2;
  while(count > 0)
  {
   VipSetTextLine(winnext[next],"RTGINFO",k++,VIP_LEFT);
   VipSetTextLine(winnext[next],GetHopsCost(&Data[j+4],RetStr),k++,VIP_CENTER);
   count--;
   j+= 2;
   if(j >= size)
   {
    i=0;
    break;
   }   
  }
  j = j+4;
 } 
}

/*****************************************************************
** NAME:        PrintERHData
** SYNOPSIS:    void PrintERHData(void)
** PARAMETERS:  void
** DESCRIPTION: - prints the Ether Router Hello Protocol data
**                to the current window
** REMARKS:     
** RETURNS:     no value
*******************************************************************/

void PrintERHData(void)
{
 BYTE Data[200];
 BYTE RetStr[10];
 int k = 2;
 int unsigned i;
 
 memcpy(Data,ProtDec.NextData,200);
 for(i=0; i < ProtDec.Data->Dec_ERH.RSListLen/7; i++)
 {
  VipSetTextLine(winnext[next],"ROUTER / PRISTATE",k++,VIP_LEFT);
  GetAddress(&Data[i*7 + 4],RetStr);
  VipSetTextLine(winnext[next],RetStr,k++,VIP_CENTER);
  sprintf(RetStr,"%d",Data[i*7 + 6]);
  ConverToBin(atoi(RetStr));
  VipSetTextLine(winnext[next],protocolString,k++,VIP_CENTER);
 }
}

/*****************************************************************
** NAME:        ConvertToBin
** SYNOPSIS:    void ConvertToBin(int hexnum)
** PARAMETERS:  - hexnum - hexadecimal number
** DESCRIPTION: - converts hexadecimal number to the binary one
**                and prints it to the protocolString
** REMARKS:     
** RETURNS:     no value
*******************************************************************/

void ConverToBin(int hexnum)
{
 BYTE number[8];
 int i=0;
 int j=1;

 memset(number,0,8);

 while(j)
 {
  j = hexnum/2;
  if(2*j == hexnum)
    number[i++] = 0;
  else
    number[i++] = 1;
  hexnum = hexnum/2;
 }
 sprintf(protocolString,"%d%d%d%d%d%d%d%d",number[7],number[6],number[5],number[4],
                                    number[3],number[2],number[1],number[0]);
}

/*****************************************************************
** NAME:        PrintDataSegmentMessage
** SYNOPSIS:    void PrintDataSegmentMessage(int line)
** PARAMETERS:  - line - line of the window where the displaying begins
** DESCRIPTION: - prints the Data Segment Message 
**                to the current window
** REMARKS:     
** RETURNS:     no value
*******************************************************************/

void PrintDataSegmentMessage(int line)
{
 BYTE Buffer[200];
 long address;
 static WORD Word;
 static WORD Word1;
 static WORD Word2;

 memcpy(Buffer,ProtDec.NextData,100);
 VipSetTextLine(winnext[next],"DESTINATION ADDRESS",line,VIP_LEFT);
 if((address = (int) ((int) Buffer[2]*256 + (int)Buffer[1])) < 0)
 { 
  address = (long) ((long) Buffer[2]*256 + (long)Buffer[1]);
  sprintf(protocolString,"%lu",address);
 }
 else
  sprintf(protocolString,"%d",address);
 VipSetTextLine(winnext[next],protocolString,line+1,VIP_CENTER);
 if((address = (int) ((int) Buffer[4]*256 + (int)Buffer[3])) < 0)
 { 
  address = (long) ((long) Buffer[4]*256 + (long)Buffer[3]);
  sprintf(protocolString,"%lu",address);
 }
 else
  sprintf(protocolString,"%d",address);
 VipSetTextLine(winnext[next],"SOURCE ADDRESS",line+2,VIP_LEFT);
 VipSetTextLine(winnext[next],protocolString,line+3,VIP_CENTER);
 VipSetTextLine(winnext[next],"ACKNUM",line+4,VIP_LEFT);
 Word = Buffer[5] + Buffer[6]*256;
 Word1 = Word & 16384;
 Word1 = Word1 >> 14;
 Word2 = Word >> 15;
 sprintf(protocolString,"%d %d %d",Word2,Word1,Word&16383);
 VipSetTextLine(winnext[next],protocolString,line+5,VIP_CENTER);
 VipSetTextLine(winnext[next],"SEGNUM",line+6,VIP_LEFT);
 Word = Buffer[7] + Buffer[8]*256;
 Word1 = Word & 16384;
 Word1 = Word1 >> 14;
 Word2 = Word >> 15;
 sprintf(protocolString,"%d %d %d",Word2,Word1,Word&16383);
 VipSetTextLine(winnext[next],protocolString,line+7,VIP_CENTER);
}

/*****************************************************************
** NAME:        PrintDataAcknowledgementMessage
** SYNOPSIS:    void PrintDataAcknowledgementMessage(int line)
** PARAMETERS:  - line - line of the window where the displaying begins
** DESCRIPTION: - prints the Data Acknowledgement Message 
**                to the current window
** REMARKS:     
** RETURNS:     no value
*******************************************************************/

void PrintDataAcknowledgementMessage(int line)
{
 BYTE Buffer[200];
 long address;
 static WORD Word;
 static WORD Word1;
 static WORD Word2;

 memcpy(Buffer,ProtDec.NextData,100);
 VipSetTextLine(winnext[next],"DESTINATION ADDRESS",line,VIP_LEFT);
 if((address = (int) ((int) Buffer[2]*256 + (int)Buffer[1])) < 0)
 { 
  address = (long) ((long) Buffer[2]*256 + (long)Buffer[1]);
  sprintf(protocolString,"%lu",address);
 }
 else
  sprintf(protocolString,"%d",address);
 VipSetTextLine(winnext[next],protocolString,line+1,VIP_CENTER);
 if((address = (int) ((int) Buffer[4]*256 + (int)Buffer[3])) < 0)
 { 
  address = (long) ((long) Buffer[4]*256 + (long)Buffer[3]);
  sprintf(protocolString,"%lu",address);
 }
 else
  sprintf(protocolString,"%d",address);
 VipSetTextLine(winnext[next],"SOURCE ADDRESS",line+2,VIP_LEFT);
 VipSetTextLine(winnext[next],protocolString,line+3,VIP_CENTER);
 VipSetTextLine(winnext[next],"ACKNUM",line+4,VIP_LEFT);
 Word = Buffer[5] + Buffer[6]*256;
 Word1 = Word & 16384;
 Word1 = Word1 >> 14;
 Word2 = Word >> 15;
 sprintf(protocolString,"%d %d %d",Word2,Word1,Word&16383);
 VipSetTextLine(winnext[next],protocolString,line+5,VIP_CENTER);
 VipSetTextLine(winnext[next],"ACKOTH",line+6,VIP_LEFT);
 Word = Buffer[7] + Buffer[8]*256;
 Word1 = Word & 16384;
 Word1 = Word1 >> 14;
 Word2 = Word >> 15;
 sprintf(protocolString,"%d %d %d",Word2,Word1,Word&16383);
 VipSetTextLine(winnext[next],protocolString,line+7,VIP_CENTER);
}

/*****************************************************************
** NAME:        PrintOtherDataAckMessage
** SYNOPSIS:    void PrintOtherDataAckMessage(int line)
** PARAMETERS:  - line - line of the window where the displaying begins
** DESCRIPTION: - prints the Other Data Acknowledgement Message 
**                to the current window
** REMARKS:     
** RETURNS:     no value
*******************************************************************/

void PrintOtherDataAckMessage(int line)
{
 BYTE Buffer[200];
 long address;
 static WORD Word;
 static WORD Word1;
 static WORD Word2;

 memcpy(Buffer,ProtDec.NextData,100);
 VipSetTextLine(winnext[next],"DESTINATION ADDRESS",line,VIP_LEFT);
 if((address = (int) ((int) Buffer[2]*256 + (int)Buffer[1])) < 0)
 { 
  address = (long) ((long) Buffer[2]*256 + (long)Buffer[1]);
  sprintf(protocolString,"%lu",address);
 }
 else
  sprintf(protocolString,"%d",address);
 VipSetTextLine(winnext[next],protocolString,line+1,VIP_CENTER);
 if((address = (int) ((int) Buffer[4]*256 + (int)Buffer[3])) < 0)
 { 
  address = (long) ((long) Buffer[4]*256 + (long)Buffer[3]);
  sprintf(protocolString,"%lu",address);
 }
 else
  sprintf(protocolString,"%d",address);
 VipSetTextLine(winnext[next],"SOURCE ADDRESS",line+2,VIP_LEFT);
 VipSetTextLine(winnext[next],protocolString,line+3,VIP_CENTER);
 VipSetTextLine(winnext[next],"ACKNUM",line+4,VIP_LEFT);
 Word = Buffer[5] + Buffer[6]*256;
 Word1 = Word & 16384;
 Word1 = Word1 >> 14;
 Word2 = Word >> 15;
 sprintf(protocolString,"%d %d %d",Word2,Word1,Word&16383);
 VipSetTextLine(winnext[next],protocolString,line+5,VIP_CENTER);
}

/*****************************************************************
** NAME:        InitDataFill
** SYNOPSIS:    void InitDataFill(void)
** PARAMETERS:  - void
** DESCRIPTION: - initializes the DataFilled array to the zero
** REMARKS:     
** RETURNS:     no value
*******************************************************************/

void InitDataFill(void)
{
  int i;

  for(i=0;i<20;i++)
    DataFilled[i] = 0;
}

/*****************************************************************
** NAME:        PrintWindow
** SYNOPSIS:    void PrintWindow(VIPINFO *wip, VOID *p, BOOLEAN pressed)
** PARAMETERS:  - wip and p unused
**              - pressed - the button calling this function is pressed
** DESCRIPTION: - prints the screen
** REMARKS:     CallBack function
** RETURNS:     no value
*******************************************************************/

void PrintWindow(VIPINFO *wip, VOID *p, BOOLEAN pressed)
{
    if (pressed) return;
    VipPrintWindow(winframe,TRUE);
}


