#include <dnpap.h>
#include <config.h>
#include <message.h>
#include <vip.h>

VIPINFO *frameWin;  /* Frame window is useally global, because it is used
                       in many places */

void main(int argc, char **argv)
{
    /* Initialize Config System */
    ConfigInit(argc,argv);
    ConfigLoad();

    /* Initialize Message System, with FILE and VIP device */
    MessageInit("viptest", MSGFILE, MSGVIP, NULL);

    /* Initialize the VIP System! */
    if (!VipInit(argc,argv))
        DnpapMessage(DMC_ERROR,1,"Failed to initialize VIP!");

    /* First open a toplevel window, ie without parent */
    frameWin = VipOpenSimple(NULL, 250, 250, 500, 500);

    /* Set the title of the window */
    VipSetTitle(frameWin, "Hello World!");

    /* Show it */
    VipShow(frameWin);

    /* Check the message loop, and block until exit */
    VipCheck(TRUE);

    DnpapExit(0);
}
