/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       vipmeter.c
**     SYSTEM   NAME:       VIP
**     ORIGINAL AUTHOR(S):  Alfred Kayser
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       1992/5/29
**
** DESCRIPTION: Meter Module.
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#define LIBRARY
#include "vipinc.h"

PRIVAT void MeterUpdate(VIPINFO *wip, HPS hps, BOOLEAN all);

/**************************************************************
** NAME:        VipOpenMeter                              [API]
** SYNOPSIS:    VIPINFO * VipOpenMeter(VIPINFO *parent,
**                  int x, int y, int w, int h)
** DESCRIPTION: Opens a rectangular meterwindow.
**              The meter shows a growing bar when current moves
**              from the minimum value to maximum value.
**              The title string of a meter is a 'printf' format
**              string inwhich a %ld will be replaced by the
**              current value.
** RETURNS:     void
**************************************************************/
VIPINFO *
VipOpenMeter(VIPINFO *parent, int x, int y, int w, int h)
{
    VIPINFO *wip;
    struct _dialdata *data;

    if (!(data = VipMalloc(sizeof(struct _dialdata))))
        return NULL;
    if (!(wip = VipOpenSimple(parent, x,y,w,h)))
    {
        VipFree(data);
        return wip;
    }
    
    data->lab2 = NULL;
    data->lab1 = VipOpenLabel(wip, 0,0,0,0);
    if (data->lab1)
        VipSetBorder(data->lab1,1,VIP_RISE);
    data->stripes=10;
    data->min=0;
    data->max=100;
    data->current=0;
    data->prev=0;

    wip->dialdata=data;
    wip->type=T_DIAL;
    wip->border=2;
    wip->btype=VIP_LOW;

    /* Change Update function to a dial draw function... */
    wip->update=MeterUpdate;
    return wip;
}


/**************************************************************
** NAME:        VipSetMeterCurrent                         [API]
** SYNOPSIS:    void VipSetMeterCurrent(VIPINFO *wip,
**                    LONG current)
** DESCRIPTION: Sets the current value of the meter.
**              As with all VipSet functions the corresponding
**              view is not updated until a 'VipUpdate' or
**              'VipShow' forces a redraw or refresh.
** RETURNS:     void
**************************************************************/
void
VipSetMeterCurrent(VIPINFO *wip, LONG current)
{
    TYPETEST(wip,T_DIAL,return);
    DIALDATA(wip,current)=current;
}


/**************************************************************
** NAME:        VipSetMeterRange                           [API]
** SYNOPSIS:    void VipSetMeterRange(VIPINFO *wip,
**                  LONG min, LONG max, int stripes)
** DESCRIPTION: Sets the range and stripes of the meter.
** RETURNS:     void
**************************************************************/
void 
VipSetMeterRange(VIPINFO *wip, LONG min, LONG max, int stripes)
{
    TYPETEST(wip,T_DIAL,return);
    DIALDATA(wip,min)=min;
    DIALDATA(wip,max)=max;
    DIALDATA(wip,stripes)=stripes;
}


PRIVAT void
MeterUpdate(VIPINFO *wip, HPS hps, BOOLEAN all)
{
    LONG s1, s2, t, WID, HID;
    POINTL pp;
    int i,n;
        
    WID = wip->cx - 2*wip->border-1;
    HID = wip->cy - 2*wip->border-1;

    t= DIALDATA(wip,max)-DIALDATA(wip,min);
    if (DIALDATA(wip,current)<=DIALDATA(wip,min))
        s2 = 0;
    else if (DIALDATA(wip,current)<DIALDATA(wip,max))
        s2 = (WID*DIALDATA(wip,current))/t;
    else
        s2 = WID;

    if (all)
    {
        if (wip->title)
        {
            VipBorder(wip, hps);
            if (s2)
            {
                GpiSetColor(hps, FOREGROUND(wip));
                MOVE(wip->border,wip->border);
                BLOCK(wip->border+s2, wip->border+HID);
            }
            s1=(wip->cx - DIALDATA(wip,lab1)->cx)/2,
            s2=(wip->cy - DIALDATA(wip,lab1)->cy)/2;
            VipShow(DIALDATA(wip, lab1));
            VipMoveWindow(DIALDATA(wip, lab1), s1, s2);
        }
        else
            VipHide(DIALDATA(wip, lab1));
        s1=0;
        s2=WID;
    }
    else
    {
        if (DIALDATA(wip,prev)<=DIALDATA(wip,min))
            s1 = 0;
        else if (DIALDATA(wip,prev)<DIALDATA(wip,max))
            s1 = (WID*DIALDATA(wip,prev))/t;
        else
            s1 = WID;

        if (s2>s1)  /* Growining */
        {
            GpiSetColor(hps, FOREGROUND(wip));
            MOVE(wip->border+s1,wip->border);
            BLOCK(wip->border+s2, wip->border+HID);
        }
        else if (s2<s1)
        {
            GpiSetColor(hps, BACKGROUND(wip));
            MOVE(wip->border+s2, wip->border);
            BLOCK(wip->border+s1, wip->border+HID);
            t=s1;
            s1=s2;
            s2=t;
        }
        s1-=2;
        s2+=2;
    }
    DIALDATA(wip,prev)=DIALDATA(wip,current);
    if (DIALDATA(wip,lab1) && wip->title)
    {
        char buf[80];
        DIALDATA(wip, lab1)->font = wip->font;
        sprintf(buf, wip->title, DIALDATA(wip, current));
        VipSetTitle(DIALDATA(wip, lab1), buf);
        WinSendMsg(DIALDATA(wip, lab1)->win, UM_SCALE,
            (MPARAM)TRUE, NULL);
    }
    n=(int)DIALDATA(wip,stripes);
    pp.y = wip->border-1;
    for (i=1; i<n; i++)
    {
        pp.x = wip->border+((LONG)i*WID)/n;
        if (pp.x>=s1 && pp.x<=s2)
        {
            GpiSetColor(hps, SHADOW1(wip));
            GpiMove(hps, &pp);
            pp.y = wip->cy-wip->border;
            GpiLine(hps, &pp);
            GpiSetColor(hps, SHADOW2(wip));
            pp.x ++;
            GpiMove(hps, &pp);
            pp.y = wip->border-1;
            GpiLine(hps, &pp);
        }
    }
}



