/*
DialUp - coordinate dialers
Copyright 1999, 2000 by Chuck McKinnis,  Sandia Park, NM (USA)
mckinnis@attglobal.net
*/

Trace 'N'
sub_trace = 'N'
version = '1.32'
what_r_we = 'DialUp v'||version 'Copyright 1999, 2000 by Charles H. McKinnis'

Parse Arg orgparms
parms = Translate(orgparms)

on_line = (Wordpos('ONLINE', parms) <> 0)
off_line = (Wordpos('OFFLINE', parms) <> 0)

injoy_dialer = (Wordpos('INJOY', parms) <> 0)
ibm_dialer = (Wordpos('IBM', parms) <> 0)
Select
   When injoy_dialer Then
      dialer_id = 'INJOY'
   When ibm_dialer Then
      dialer_id = 'IBM'
   Otherwise dialer_id = ''
End

If on_line | off_line Then
   Do
      Select
         When on_line Then
            Call Dialupq dialer_id, 'ONLINE'
         When off_line Then
            Call Dialupq dialer_id, 'OFFLINE'
         Otherwise
            Nop
      End
      Call Cleanup
      Return 0
   End

If Setup() Then
   Do
      Select
         When dial_up Then
            Call Dial
         When disc Then
            Call Disconnect
         When launch_appl Then
            Call Launch
         When show_status Then
            Call Showstatus
         Otherwise Call Showoptions
      End
   End
Call Cleanup
Return 0

Setup:

Parse Source . . cmd_file .
cmd_name = Filespec('N', cmd_file)
cmd_name = Left(cmd_name, Lastpos('.', cmd_name) - 1)
cmd_dir = Left(cmd_file, Lastpos('\', cmd_file) - 1)
cur_dir = Directory()
Call Directory cmd_dir

If Rxfuncquery('SysDropFuncs') Then
   Call Rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

If Rxfuncquery('WPToolsLoadFuncs') Then
   Call Rxfuncadd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'
Call WPToolsLoadFuncs

obj_view = 'DEFAULT'
obj_flag = 'TRUE'
ini_error = 'ERROR:'
null = 'null'
dialer_timeout = 60                             /* seconds to timeout */
dialer_sleep = 5                                     /* time to sleep */
dialer_tries = dialer_timeout / dialer_sleep

dial_up = (Wordpos('DIAL', parms) <> 0)
disc = (Wordpos('DISC', parms) <> 0)
show_status = (Wordpos('STATUS', parms) <> 0)
launch_appl = (Pos('<', parms) <> 0)
If parms = '' Then
   Return 1

ini_file = Stream(cmd_dir || '\dialup.ini', 'c', 'query exists')
If ini_file = '' Then
   Do
      xrc = Dialup_error('Unable to locate dialup.ini.  Please run the DialUp Utility')
      Return 0
   End

log_file = cmd_dir || '\dialup.log'

injoy_object = SysIni(ini_file, 'injoy', 'objectid')
injoy_host = SysIni(ini_file, 'injoy', 'hostid')
ibm_object = SysIni(ini_file, 'ibm', 'objectid')
If (injoy_object = ini_error) | (ibm_object = ini_error) Then
   Do
      xrc = Dialup_error('Unable to locate any dialer object(s).  Please run the DialUp Utility')
      Return 0
   End
If (injoy_host = ini_error) Then
   Do
      xrc = Dialup_error('Unable to locate InJoy Dialer default host.  Please run the DialUp Utility')
      Return 0
   End

If injoy_object <> null Then
   Do
      Parse Value Getdialerinfo(injoy_object) With info_rc injoy_path injoy_name
      If info_rc = 0 Then
         Return info_rc
   End
If ibm_object <> null Then
   Do
      Parse Value Getdialerinfo(ibm_object) With info_rc ibm_path ibm_name
      If info_rc = 0 Then
         Return info_rc
   End

If show_status Then
   Return 1

If injoy_dialer Then
   Do
      dialer_object = injoy_object
      dialer_path = injoy_path
      dialer_name = injoy_name
   End
If ibm_dialer Then
   Do
      dialer_object = ibm_object
      dialer_path = ibm_path
      dialer_name = ibm_name
   End

Return 1

Dial:
If \Check_dialer_task(dialer_id, dialer_name) Then
   Do
      Call Dialupq dialer_id, 'OFFLINE'
      If \SysOpenObject(dialer_object, obj_view, obj_flag) Then
         Do
            xrc = Dialup_error('Unable to start' dialer_name)
            Return 0
         End
      Do x = 1 To dialer_tries Until Check_dialer_task(dialer_id, dialer_name)
         Call SysSleep dialer_sleep
      End
      If x >= dialer_tries Then
         Do
            xrc = Dialup_error('Timed out waiting for' dialer_name 'to start')
            Return 0
         End
   End
Select
   When injoy_dialer Then
      dial_cmd = 'SETJOY -O:' || injoy_host '-CONNECT'
   When ibm_dialer Then
      dial_cmd = '@tcpdial -dial > nul'
   Otherwise Do
      xrc = Dialup_error('Invalid dialer')
      Return 0
   End
End
If \Dialupq(dialer_id) Then
   Do
      Call Directory dialer_path
      Address cmd dial_cmd
      Call Directory cmd_dir
      If dialer_wait Then
         Do
            Do x = 1 To dialer_tries Until Dialupq(dialer_id)
               Call SysSleep dialer_sleep
            End
            If x >= dialer_tries Then
               Do
                  xrc = Dialup_error('Timed out waiting for' dialer_name 'to connect')
                  Return 0
               End
         End
   End
Return 1

Disconnect:
If Check_dialer_task(dialer_id, dialer_name) & ,
   Dialupq(dialer_id) Then
   Do
      Select
         When injoy_dialer Then
            Do
               Call Directory dialer_path
               Address cmd 'SETJOY -O:# -D'
               Call Directory cmd_dir
            End
         When ibm_dialer Then
            Do
               Call Directory ibm_path
               Address cmd '@tcpdial -hangup > nul'
               Call Directory cmd_dir
            End
         Otherwise Nop
      End
   End
Return 0

Launch:
save_trace = Trace(sub_trace)
Parse Value('.' orgparms) With . '<' launch_object '>' .
launch_object = '<' || Strip(launch_object) || '>'
save_injoy_host = injoy_host
If injoy_dialer Then
   Do
      new_injoy_host = ''
      Parse Value('.' orgparms) With . '-H:' new_injoy_host .
      new_injoy_host = Space(new_injoy_host)
      If new_injoy_host <> '' Then
         injoy_host = new_injoy_host
   End
dialer_wait = (Wordpos('-W', parms) <> 0)
If WPToolsQueryObject(launch_object) Then
   Do
      If Dial() Then
         Do
            awake = 0
            Do Until awake
               awake = SysOpenObject(launch_object, obj_view, obj_flag)
               If \awake Then
                  Call SysSleep 3
            End
         End
      Else
         xrc = Dialup_error('Dialer failed to connect.')
   End
Else
   xrc = Dialup_error('Object' launch_object 'not found.  Please run the DialUp Utility')
injoy_host = save_injoy_host
Trace(save_trace)
Return 0

Showstatus:
save_trace = Trace(sub_trace)
Say what_r_we
Say 'DialUp Status'
If injoy_object <> null Then
   Do
      Say '   The object name for the InJoy dialer is -' injoy_object
      Say '   The path to the InJoy dialer is -' injoy_path
      Say '   The default host for InJoy sessions is -' injoy_host
      Say '   The task name for the InJoy session is -' injoy_name
      If Check_dialer_task('INJOY', injoy_name) Then
         Do
            Say '   The InJoy dialer is active'
            If Dialupq('INJOY') Then
               dialer_stat = 'connected'
            Else
               dialer_stat = 'disconnected'
            Say '      The current status of the InJoy dialer session is -' dialer_stat
         End
      Else
         Say '   The InJoy dialer is not active'
      Say ''
   End
If ibm_object <> null Then
   Do
      Say '   The object name for the AT&T dialer is -' ibm_object
      Say '   The path to the AT&T dialer is -' ibm_path
      Say '   The task name for the AT&T session is -' ibm_name
      If Check_dialer_task('IBM', ibm_name) Then
         Do
            Say '   The AT&T dialer is active'
            If Dialupq('IBM') Then
               dialer_stat = 'connected'
            Else
               dialer_stat = 'disconnected'
            Say '      The current status of the AT&T dialer session is -' dialer_stat
         End
      Else
         Say '   The AT&T dialer is not active'
   End
Say ''
Say '   The current DialUp configuration file is -' ini_file
Say '   The current DialUp LOG file is -' log_file
Trace(save_trace)
Return

Showoptions:
save_trace = Trace(sub_trace)
Say what_r_we
Say 'The following options are valid for the DialUp command:'
Say '   IBM or INJOY - dialer to use'
Say '   DIAL - dial the host (start the dialer if necessary)'
Say '   DISC - hang up (if connected)'
Say '   ONLINE - set dialer status to connected (normally done by the dialer)'
Say '   OFFLINE - set dialer status to disconnected (normally done by the dialer)'
Say '   STATUS - display all the parameters'
Say '   Object launch parameters'
Say '      IBM or INJOY - dialer to use'
Say '      "<object_id>" - connect and launch object_id'
Say '         (the object_id must be enclosed in double quotes)'
Say '      -H:injoy_host - name of the InJoy host for this connection'
Say '      -W - wait for the dialer to connect before launching'
Say '      -NW - do not wait for the dialer to connect before launching'
Trace(save_trace)
Return

Cleanup:
Call Directory cur_dir
Return 0

Getdialerinfo: Procedure Expose sub_trace
save_trace = Trace(sub_trace)
Parse Arg object
If WPToolsQueryObject(object, 'szClass', 'szTitle', 'szSetupString') Then
   Do
      Parse Var szsetupstring program 'EXENAME=' path ';' .
      path = Strip(path)
      If Pos(':', path) = 0 Then
         path = SysSearchPath('path', path)
      If path = '' Then
         Do
            xrc = Dialup_error('Unable to determine path for' object || '.  Please run the DialUp Utility')
            Return 0
         End
      path = Left(path, Lastpos('\', path) - 1)
      title = Space(Translate(sztitle, , D2c(94) || D2c(13) || D2c(10) || '^', ' ',))
   End
Else
   Do
      xrc = Dialup_error('Unable to locate object' object || '.  Please run the DialUp Utility')
      Return 0
   End
Trace(save_trace)
Return Space(1 path title)

Check_dialer_task: Procedure Expose sub_trace
save_trace = Trace(sub_trace)
Parse Arg dialer_id, dialer_name
rc_dialer = 0
Select
   When dialer_id = 'INJOY' Then
      Do
         Call SysQuerySwitchList 'tasks.'
         Do i = 1 To tasks.0 Until rc_dialer
            task_title = Space(Translate(tasks.i, , D2c(94) || D2c(13) || D2c(10) || '^', ' ',))
            If Pos(dialer_name, task_title) > 0 Then
               rc_dialer = 1
         End
      End
   When dialer_id = 'IBM' Then
      Do
         Call Directory ibm_path
         Address cmd '@tcpdial -status > nul'
         rc_tcpdial = rc
         Call Directory cmd_dir
         rc_dialer = (rc_tcpdial = 0) | (rc_tcpdial = 20)
         If rc_tcpdial = 0 & \Dialupq('IBM') Then
            Call Dialupq 'IBM', 'ONLINE'
         If rc_tcpdial = 20 & Dialupq('IBM') Then
            Call Dialupq 'IBM', 'OFFLINE'
      End
   Otherwise Nop
End
If \rc_dialer & Dialupq(dialer_id) Then
   Call Dialupq dialer_id, 'OFFLINE'
Trace(save_trace)
Return rc_dialer

Dialupq: Procedure
trace_save = Trace('N')
Parse Upper Arg dialer_id, action
dialer_list = 'INJOY IBM'
dialer_queues = 'DIALUP_INJOY DIALUP_IBM'
dialup_queue = Word(dialer_queues, Wordpos(dialer_id, dialer_list))
new_queue = Rxqueue('create', dialup_queue)
/* delete new queue if the one wanted already exists */
If new_queue <> dialup_queue Then
   Call Rxqueue 'delete', new_queue
old_queue = Rxqueue('Set', dialup_queue)
Select
   When action = 'ONLINE' Then
      Do
         If Queued() = 0 Then
            Queue dialup_queue
         dialed = 1
      End
   When action = 'OFFLINE' Then
      Do
         Do Queued()
            Parse Pull .
         End
         dialed = 0
      End
   Otherwise Do
      dialed = (Queued() > 0)
   End
End
Call Rxqueue 'Set', old_queue
Trace (trace_save)
Return dialed

Dialup_error: Procedure Expose sub_trace
save_trace = Trace(sub_trace)
Parse Arg dialer_error_text
xrc = RxMessageBox('Dial Up error', dialer_error_text, 'OK', 'ERROR')
Return xrc

Log_out: Procedure Expose log_file sub_trace
save_trace = Trace(sub_trace)
Parse Arg log_info
Call Lineout log_file, log_info
Call Stream log_file, 'c', 'close'
Trace(save_trace)
Return
