/*
Install - DialUp - coordinate InJoy dialer
Copyright 1999 - 2000 by Chuck McKinnis,  Sandia Park, NM (USA)
mckinnis@attglobal.net
*/

Trace 'N'
version = '1.32'
what_r_we = 'DialUp v'||version 'Copyright 1999, 2000 by Charles H. McKinnis'

Parse Source . . cmd_file .
cmd_name = Filespec('N', cmd_file)
cmd_name = Left(cmd_name, Lastpos('.', cmd_name) - 1)
cmd_dir = Left(cmd_file, Lastpos('\', cmd_file) - 1)
cur_dir = Directory()
Call Directory cmd_dir

vbox = Infobox('Install DialUp? Y/n')
Parse Upper Pull ans .
If Abbrev(ans, 'N') Then
   Do
      Parse Var Version whole '.' decimal
      Address cmd '@E.EXE' cmd_dir || '\dialup' || whole || decimal || '.doc'
      Signal Cleanup
   End

If Rxfuncquery('SysDropFuncs') Then
   Call Rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

If RxSearchLibpath('wptools.dll') = '' Then
   Do
      vbox = Infobox('Unzipping wptools.zip')
      Address cmd '@unzip -jo' cmd_dir || '\wptools.zip'
   End
If Stream(cmd_dir || '\wptools.zip', 'c', 'query exists') <> '' Then
   Call SysFileDelete cmd_dir || '\wptools.zip'

If Rxfuncquery('WPToolsLoadFuncs') Then
   Call Rxfuncadd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'
Call WPToolsLoadFuncs

If SysSearchPath('path', 'vrexx.exe') = '' Then
   Do
      vbox = Infobox('Unable to locate vrexx.exe, unzipping from vrexx.zip')
      Address cmd '@unzip -joC' cmd_dir || '\vrexx.zip vrexx.exe'
   End
If RxSearchLibpath('vrexx.dll') = '' Then
   Do
      vbox = Infobox('Unable to locate vrexx.dll, unzipping from vrexx.zip')
      Address cmd '@unzip -joC' cmd_dir || '\vrexx.zip vrexx.dll'
   End
If RxSearchLibpath('devbase.dll') = '' Then
   Do
      vbox = Infobox('Unable to locate devbase.dll, unzipping from vrexx.zip')
      Address cmd '@unzip -joC' cmd_dir || '\vrexx.zip devbase.dll'
   End
If Stream(cmd_dir '\vrexx.zip', 'c', 'query exists') <> '' Then
   Call SysFileDelete cmd_dir || '\vrexx.zip'

If SysSearchPath('path', 'killpid.exe') = '' Then
   Do
      vbox = Infobox('Unable to locate killpid.exe, unzipping killpid.zip')
      Address cmd '@unzip -jo' cmd_dir || '\killpid.zip'
   End
If Stream(cmd_dir '\killpid.zip', 'c', 'query exists') <> '' Then
   Call SysFileDelete cmd_dir || '\killpid.zip'

Signal On Failure Name cleanup
Signal On Halt Name cleanup
Signal On Syntax Name cleanup

Say what_r_we

obj_view = 'DEFAULT'
obj_flag = 'TRUE'
nl = D2c(94)                                              /* new line */
vbox = 0

class = 'WPFolder'
location = '<WP_DESKTOP>'
title = 'DialUp'
setup = 'OBJECTID=<WP_DIALUP>;'
If SysCreateObject(class, title, location, setup, 'U') Then
   vbox = Infobox(title 'folder created or updated')
Else
   vbox = Errorbox('Unable to create or update' title)
If vbox Then
   Signal Cleanup

class = 'WPFolder'
location = '<WP_DIALUP>'
title = 'DialUp Launch Objects'
setup = 'OBJECTID=<WP_DIALUP_LAUNCH>;'
If SysCreateObject(class, title, location, setup, 'U') Then
   vbox = Infobox(title 'folder created or updated')
Else
   vbox = Errorbox('Unable to create or update' title)
If vbox Then
   Signal Cleanup

class = 'WPFolder'
location = '<WP_DIALUP>'
title = 'DialUp Target Objects'
setup = 'OBJECTID=<WP_DIALUP_TARGETS>;'
If SysCreateObject(class, title, location, setup, 'U') Then
   vbox = Infobox(title 'folder created or updated')
Else
   vbox = Errorbox('Unable to create or update' title)
If vbox Then
   Signal Cleanup

class = 'WPProgram'
location = '<WP_DIALUP>'
title = 'DialUp' || nl || 'Utility'
obj = 'OBJECTID=<WP_DIALUP_UTILITY>;'
exec_name = Stream('dialupu.exe', 'c', 'query exists')
If exec_name = '' Then
   exec_name = Stream('dialupu.cmd', 'c', 'query exists')
exec = 'EXENAME=' || exec_name || ';'
iconfile = 'ICONFILE=' || cmd_dir || '\dialup.ico;'
parm = 'MINIMIZED=YES;NOAUTOCLOSE=NO;'
setup = obj || exec || iconfile || parm
If SysCreateObject(class, title, location, setup, 'U') Then
   vbox = Infobox(title 'created or updated')
Else
   vbox = Errorbox('Unable to create or update' title)
If vbox Then
   Signal Cleanup

vbox = Infobox('The DialUp Utility will now be started')
awake = SysOpenObject('<WP_DIALUP_UTILITY>', obj_view, obj_flag)
If \awake Then
   vbox = Errorbox('Unable to start DialUp Utility')


Cleanup:
Call Directory cur_dir
Return 0

Errorbox:
Procedure
Parse Arg message
vtitle = 'Error Message -'
Say vtitle message
Return 1

Infobox:
Procedure
Parse Arg message
Say message
Return 0

/* RxSearchLibpath
   search the current libpath for a module
   returns the fully qualified path if found or null if not found
   Copyright 2000 by Chuck McKinnis,  Sandia Park, NM (USA) 04 Feb 2000
   mckinnis@attglobal.net */
Rxsearchlibpath: Procedure
Trace('N')
Parse Arg dll
boot_drive = SysBootDrive()
config_sys = boot_drive || '\config.sys'
xrc = SysFileSearch('libpath', config_sys, 'lib_path.')
If xrc = 0 & lib_path.0 <> 0 Then
   Do i = 1 To lib_path.0
      lib_test = Space(Translate(lib_path.i))
      If Abbrev(lib_test, 'REM') Then
         Iterate i
      If \Abbrev(lib_test, 'LIBPATH') Then
         Iterate i
      lib_equal = Space(Substr(lib_test, 8))
      If \Abbrev(lib_equal, '=') Then
         Iterate i
      Parse Var lib_test . '=' lib_path
   End
lib_path = Space(lib_path)
our_path = SysTempFileName('lib????')
old_value = Value(our_path, lib_path, 'os2environment')
dll_path = SysSearchPath(our_path, dll)
old_value = Value(our_path, old_value, 'os2environment')
Return dll_path
