/* Rexx utility to get connection times from TCPOS2.INI file
 * These are the connection times recorded by the IBM Dial-Up for TCP/IP
 * program,  SLIPPM.
 *
 * syntax:  IAKTIMES
 *
 * output:  a summary of the connection times as stored by SLIPPM listed
 *          by connection identifier and totaled.
 *
 * Written by: Dan Douglas
 *             dandoug@scruznet.com 
 *
 * Feel free to use, distribute or modify as you see fit.  If you find it
 * helpful, send me a postcard.
 */

/* Save command name for use in messages */
Parse upper source . . src '.CMD'
src = substr(src, lastpos('\',src)+1)
msghdr = '>>'src'>>'

/* Set field widths and NLS strings for formatting */
al  = 10 /* application name length */
sl  = 10 /* max digits in seconds string */
hl  = 4  /* max digits in connect hours */
dl  = 2  /* max ditits in connect days */
day = 'day, ' /* singular day label */
dys = 'days,' /* plural days label */
ll  = al + sl + hl + dl + length(dys) + 21

err = 'ERROR:'
all = 'ALL:'
tck = 'TOTAL_CONNECT'  /* key for total connect seconds */
etc = 'ETC'            /* ennvironment variable with path */
fn  = 'TCPOS2.INI'     /* ini file name */
env = 'OS2ENVIRONMENT' /* environment for OS/2 variables */

ts     = 'total'
msgs.1 = 'OS/2 environment variable 'etc' must be set to 'fn' path.'
msgs.2 = 'Error reading 'fn' applications.'
msgs.3 = 'No applications with non-zero 'tck' time found.'

/* Get value of ETC environment variable and use it to build
   full name TCPOS2.INI file */
path = VALUE(etc,,env)
if path = '' then do
   say msghdr msgs.1
   exit -1
end  /* Do */
ini_file = path"\"fn

/* Load utility function to read INI file*/
call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'

/* Read all the applications in the INI file */
if SysIni(ini_file,all,'Apps.') = err then do
   say msghdr msgs.2
   exit -2
end  /* Do */

/* Find all the applications with a TOTAL_CONNECT key that has
   a non-blank, non-zero value */
total = 0
Do i = 1 to Apps.0
  l_ct = SysIni(ini_file,Apps.i,tck)
  parse value l_ct with l_ct '00'x 
  if l_ct \= err & l_ct \= '' & l_ct \= 0 then do
    say left(Apps.i,al) right(l_ct,sl) hms(l_ct)
    total = total + l_ct
  end
end

/* Put out summary lines */
if total = 0 then do /* did we find what we wanted?*/
  say msghdr msgs.3
  exit -3
 end
else do
   say copies('-',ll)
   say left(ts,al) right(total,sl) hms(total)
end  /* Do */

exit 0

/* Subroutine to compute hours, minutes, seconds from seconds */
HMS: procedure expose hl dl day dys
 p_s = ARG(1)        /* single argument, number of seconds */

 hh  = p_s %  3600   /* number of whole hours */
 m_s = p_s // 3600   /* leftover seconds from whole hours */
 mm  = m_s %  60     /* number of whole minutes */
 ss  = m_s // 60     /* leftover seconds from whole minutes */

 dd  = hh  %  24     /* whole days */
 dh  = hh  // 24     /* leftover hours from whole days */

 ms  = right(mm,2,'0')':'right(ss,2,'0')  /* min/sec part of display */

 hs = right(hh,hl)':'ms  /* hourly result */

 if dd > 1 then  /* more than one day? */
  ds = '('right(dd,dl)' 'dys' 'right(dh,2,0)':'ms')'
 else if dd = 1 then /* only one day, leave off 's' in display */
  ds = '('right(dd,dl)' 'day' 'right(dh,2,0)':'ms')'
 else /* just hours...left day part blank */
  ds = '('copies(' ',dl+2+length(dys))right(dh,2,0)':'ms')'

return hs ds
