/**************************************************************************/
/*                                                                        */
/* INETTIME.cmd - Procedure to summarize by month all connect time to the */
/*                Internet using the IPDIALER.LOG as input data.          */
/*                                                                        */
/* Version:       2.0                                                     */
/* Last Update:   January 28, 1998                                        */
/*                                                                        */
/* Copyright (c) D.A.Ritari-KNIGHT RESEARCH - 1995 - ALL RIGHTS RESERVED  */
/*                                                                        */
/* FREELY DISTRIBUTABLE FOR ANY USE OR PURPOSE.                           */
/* NO WARRANTY OF MERCHANTABILITY OR FITNESS FOR ANY PURPOSE IMPLIED.     */
/*                                                                        */
/*                                                                        */
/* CONTACT:   Constructive comments and tips to:                          */
/*                Internet:    dritari@ibm.net                            */
/*                                                                        */
/* FOR:       Warp Internet Users who want to know how much 'connect'     */
/*            time they've used this month on IBM's Advantis Network.     */
/*            (NOT for ALTERNATE-DIALER Users).                           */
/*                                                                        */
/* PURPOSE:   This small REXX program searches for the Internet connect   */
/*            log on all available drives, and reads thru all the         */
/*            entries in the log (in the file \mptn\etc\IPDIALER.LOG)     */
/*            and SUMMARIZES the 'connect' time by month...quickly letting*/
/*            you know how much time you've used this month. (I haven't   */
/*            found a similar function with the Warp Internet bonus       */
/*            pack apps). Assumptions are that you are using the SLIP     */
/*            standard 'Dialer' app, that you have logging turned on,     */
/*            and that the log file is set big enough to record more than */
/*            a few connects. As this is a REXX application, you must     */
/*            have REXX installed on your PC to run the program, and      */
/*            if you prefer a PM-style application, it can be also run    */
/*            using PMREXX. Testing of this app was minimal...if you      */
/*            find that it doesn't run on your system, let me know or     */
/*            modify it to your hearts content.                           */
/*                                                                        */
/*                                                                        */
/* TO RUN:    At the 'C>' prompt:   INETTIME   (no parms needed)          */
/*            At the 'C>' prompt:   INETTIME C:\mydir\IPDIALER.LOG        */
/*            or for PMREXX usage:  PMREXX INETTIME.CMD                   */
/*                                                                        */
/*                                                                        */
/* UPDATES:   Version 1.0 - Original Release - January 25, 1995           */
/*            Version 1.1 - Inadvertently left off last entry in log.     */
/*                          This corrected original error.                */
/*            Version 1.2 - Variety of fixes for 'connect.log' files      */
/*                          which have missing carriage returns, spliced  */
/*                          lines, broken lines etc., which caused the    */
/*                          calculations to abend. Also, added better     */
/*                          lookup of where connect.log exists by using   */
/*                          the environment 'ETC' parm if it exists.      */
/*            Version 1.3 - Added new YEAR information added to log       */
/*                          entries available with DIALER version 1.45.   */
/*                          Also, Dialer-1.45 LOCKS the CONNECT.LOG file  */
/*                          and keeps it locked, even after you hangup.   */
/*                          An error message was added advising you to    */
/*                          close the Dialer app before running INETTIME. */
/*            Version 2.0 - Changed default name of logfile for the newer */
/*            JAN/1998      IBM Dialer - 1.69 or greater...IPDIALER.LOG   */
/*                          (was CONNECT.LOG). Changed search directory   */
/*                          to \mptn\etc from \tcpip\etc directory. Fixed */
/*                          date error in December...always showed the    */
/*                          new year instead of the old year (Thanks      */
/*                          Tom for the error report). IF you are still   */
/*                          using the old dialer, either rename the log   */
/*                          in the dialer setup to IPDIALER.LOG or change */
/*                          the source code at the start of the program   */
/*                          in the LOGNAME entry...remarked statement     */
/*                          already provided, or override the name of the */
/*                          log by running INETTIME with the fulle path...*/
/*                              INETTIME C:\mptn\etc\connect.log          */
/*                                                                        */
/* PROBLEMS:  Do not use this program if you ONLY use the Alternate       */
/*            Dialer (AD). The AD does NOT produce a IPDIALER.LOG to      */
/*            summarize (INETTIME won't be able to find the log).         */
/*                                                                        */
/*            If INETTIME reports that it can't find your IPDIALER.LOG    */
/*            file OR you have MULTIPLE ipdialer.log files and you don't  */
/*            want a report on the first one it finds, specify the name   */
/*            of the log on the command line when you run the program...  */
/*                INETTIME   R:\example\other\backup\IPDIALER.LOG         */
/*            for example (or whereever you keep you IPDIALER.LOG file).  */
/*                                                                        */
/*            If the INETTIME report has a month with '???' in it, your   */
/*            IPDIALER.log file is corrupted on one or more entries.      */
/*            A normal log entries looks like the following line:         */
/*                                                                        */
/*    12/11 17:22:37 Disconnected after 01:14:01  0 errors  0 discards    */
/*                                                                        */
/*            A corrupted line might look like the following:             */
/*                                                                        */
/*    xxxxx 17:22:37 Disconnected af                                      */
/*    ter 01:14:01  0 errors  0 discards                                  */
/*                                                                        */
/*            As you can see, the log entry has (somehow) gotten split    */
/*            into two lines...INETTIME will find the 'Disconnected'      */
/*            line BUT there is no time to report and the date field      */
/*            contains X's...the program will not abend...will attempt    */
/*            to summarize the data on a '???' month and continues.       */
/*            If you can edit the ipdialer.log file and straight out      */
/*            the entries, future reports will summarize correctly.       */
/*            (See caution below on editing the log).                     */
/*                                                                        */
/* LOG SIZE:  In the Dialer, I strongly suggest that you set IPDIALER.LOG */
/*            size to an amount LARGER THAN 10K...I suggest at least      */
/*            50K for 6 months of log activity. Also, I edit the log      */
/*            occasionally to remove old month's activities (instead of   */
/*            just letting the dialer arbitrarily 'trim' back your log).  */
/*            (See caution below on editing the log).                     */
/*                                                                        */
/* CAUTIONS:  Do not edit your IPDIALER.LOG file with an ASCII editor     */
/*            which puts an END-OF-FILE (EOF) mark at the end of the      */
/*            file! The IBM dialer program will write log entries AFTER   */
/*            this mark and you will not be able to see new log entries   */
/*            using INETTIME or other ASCII-based programs (or just       */
/*            'TYPE ipdialer.log') in the future. Either remove the EOF   */
/*            character or erase the log and let the dialer build you     */
/*            a new one for future use...A remove-end-of-file-mark        */
/*            program has been included for this purpose...See REMOVEOF.  */
/*                                                                        */
/**************************************************************************/

PARSE ARG connect_log_in

 /*** IF YOU ARE USING IBM's DIALER PROGRAM 1.69 or greater *******************/
     LOGNAME = "IPDIALER.LOG"          /* IBM's Dialer 1.69 or greater        */
 /*** IF YOU ARE USING AN OLDER VERSION OF IBM's DIALER PROGRAM < 1.69        */
     /*** LOGNAME = "CONNECT.LOG" ***/ /* Dialer BEFORE 1.69 used this name   */


 if connect_log_in \== "" then do  /* User specified log name on cmd line */
     logfile = connect_log_in
     if "" == stream(logfile, 'c', 'query exists') then do
         say " "
         say "Can't find file: " logfile
         say "Procedure Canceled."
         say " "
         exit 1
         END
     END
 else do
     call P_FindConnectLog         /* Search for the ipdialer.log file */
     END

 call P_InitMonthTable
 call P_InitMonthNames
 call P_DisplayHeading


 /*------------------- Loop through all records in Log file. -------------*/

 PMonth = 0
 PYear  = 0
 year_hold = 0
 do while LINES(logfile) > 0
     currline = LINEIN(logfile)
     parse VAR   currline first     currline2
     parse VAR   currline2 second   currline2
     parse VAR   currline2 third    currline2
     parse VAR   currline2 fourth   currline2
     parse VAR   currline2 fifth    currline2
     if third == "Disconnected" then do         /* Use only DISCONNECT lines */
         /* Validate first argument before using - added in version 1.2 */
         first_length = LENGTH(first);


         /* Possible YYYY/MM/DD format added in Dialer version 1.45 */
         /* If possible YYYY, get YEAR - added in version 1.3       */
         if first_length > 5 then do
             month_hold = RIGHT(first, 5, '0');
             year_hold  = substr(first, 1, 4);
             first = month_hold;
             if DATATYPE(year_hold, 'N') \== 1 then year_hold = 0;
             END
         month = substr(first, 1, 2)
         month = STRIP(month,'L',0)
         /* verify that 'month' is NUMERIC - added in version 1.2 */
         if DATATYPE(month, 'N') \== 1 then month = 13;

         if  month \== PMonth then do
             if PMonth \== 0 then do
                 call P_DisplayDetail           /* Month break - summarize */
                 call P_InitMonthTable
                 PMonth = month
                 Pyear  = year_hold
                 end
             else do
                 PMonth = month
                 Pyear  = year_hold
                 end
             end

         connects.month = connects.month + 1
         parse VALUE fifth WITH hours ':' minutes ':' seconds
         /* Validate hours, minutes, seconds before using - added in 1.2 */
         if DATATYPE(hours, 'N') \== 1 then hours = 0;
         if DATATYPE(minutes, 'N') \== 1 then minutes = 0;
         if DATATYPE(seconds, 'N') \== 1 then seconds = 0;

         if seconds > 0 then do
             seconds = 0
             minutes = minutes + 1
             if minutes > 59 then do
                 minutes = 0
                 hours = hours + 1
                 end
             end
         totalhours.month   = totalhours.month + hours
         totalminutes.month = totalminutes.month + minutes
         end
     end

 ok = stream(logfile, 'C', 'CLOSE')

 call P_DisplayDetail                           /* Display final month */
 say ' '

 exit 0

/***************************************************************************
Procedure Name: P_DisplayHeading
****************************************************************************/
P_DisplayHeading:

 head = "Log:" logfile
 headlen = LENGTH(head)
 if headlen < 52 then headlen = 52;
 if headlen > 78 then headlen = 78;

 say " "
 say "+--" || CENTER("", headlen, '-') || "--+"
 say "+"  CENTER("IBM Global Network - Internet Connection Summary", headlen) "  +"
 say "+"  CENTER("INETTIME - Version: 2.0", headlen) "  +"
 temp1 = date('U') time()
 say "+"  CENTER(temp1, headlen) "  +"
 say "+"  CENTER(head, headlen) "  +"
 say "+--" || CENTER("", headlen, '-') || "--+"
 say " "
 return

/***************************************************************************
Procedure Name: P_DisplayDetail
****************************************************************************/
P_DisplayDetail:
 do while totalminutes.PMonth > 59
     totalhours.PMonth = totalhours.PMonth + 1
     totalminutes.PMonth = totalminutes.PMonth - 60
     end
 if totalhours.PMonth \== 0 | totalminutes.PMonth \== 0 then do
     if PYear == 0 then do
         say  '    ' ||,
              COPIES(' ', ((headlen - 52) % 2)),
              monthname.PMonth ,
              FORMAT(totalhours.PMonth, 3),
              'Hrs.',
              FORMAT(totalminutes.PMonth,2),
              'Min. -',
              FORMAT(connects.PMonth, 3),
              'Sessions -' ||,
              FORMAT((((totalhours.PMonth * 60) + totalminutes.PMonth) / connects.PMonth),4,0),
              'Min. Avg.'
         end
     else do
         say  PYear ||,
              COPIES(' ', ((headlen - 52) % 2)),
              monthname.PMonth ,
              FORMAT(totalhours.PMonth, 3),
              'Hrs.',
              FORMAT(totalminutes.PMonth,2),
              'Min. -',
              FORMAT(connects.PMonth, 3),
              'Sessions -' ||,
              FORMAT((((totalhours.PMonth * 60) + totalminutes.PMonth) / connects.PMonth),4,0),
              'Min. Avg.'
         end
     end
 return

/***************************************************************************
Procedure Name: P_InitMonthTable
****************************************************************************/
P_InitMonthTable:

 temp = 13
 do while temp >= 0
     totalhours.temp   = 0
     totalminutes.temp = 0
     connects.temp     = 0
     temp = temp - 1
     end
 return


/***************************************************************************
Procedure Name: P_InitMonthNames
****************************************************************************/
P_InitMonthNames:

 monthname.0  = '???:'
 monthname.1  = 'JAN:'
 monthname.2  = 'FEB:'
 monthname.3  = 'MAR:'
 monthname.4  = 'APR:'
 monthname.5  = 'MAY:'
 monthname.6  = 'JUN:'
 monthname.7  = 'JUL:'
 monthname.8  = 'AUG:'
 monthname.9  = 'SEP:'
 monthname.10 = 'OCT:'
 monthname.11 = 'NOV:'
 monthname.12 = 'DEC:'
 monthname.13 = '???:'
 return


/***************************************************************************
Procedure Name: P_FindConnectLog
****************************************************************************/
P_FindConnectLog:

 /*** Try finding IPDIALER.LOG first using the ETC environment variable   ***/
 LogPath = value(ETC,,OS2ENVIRONMENT);
 temp_path = REVERSE(LogPath);
 if '\' == substr(temp_path, 1, 1) then
     logfile = LogPath || LOGNAME;
 else
     logfile = LogPath || '\' || LOGNAME;

 if "" == stream(logfile, 'c', 'query exists') then do
     /*** Find where the IPDIALER.LOG file is (check C,D,E,F...Z drives)  ***/
     LogPath = ':\mptn\etc\' || LOGNAME;
     DO i = 67 to 90 BY 1      /* Drive C --> Drive Z */
         if "" \== stream(D2C(i) || LogPath,'c','query exists') then DO
             logfile = D2C(i) || LogPath;
             LEAVE;
             END
         END
     END

 if "" == stream(logfile, 'c', 'query exists') then do
     say " "
     say "'ETC' variable doesn't point to IPDIALER.LOG in the environment!"
     say "Can't find \mptn\etc\IPDIALER.LOG on Drives C thru Z!"
     say "No filename argument passed for the IPDIALER.LOG location!"
     say "(This program does not summarize time for the Alternate-Dialer)."
     say "Procedure Canceled."
     say " "
     EXIT 1
     END

 if "READY:" \== stream(logfile, 'c', 'open read') then do
     say " "
     say "INETTIME - Version: 2.0 - ERROR opening IPDIALER.LOG!"
     say "  The IPDIALER.LOG file is probably LOCKED! Please exit the DIALER"
     say "  application to unlock the file...then rerun INETTIME."
     say " "
     EXIT 2
     END


 return
