/*
 *      INSTALL.CMD - ISDNPM V3.0x by C.Langanke 2001, 2002
 *
 *      Syntax: INSTALL
 *
 *      This program creates a WPS folder for ISDNPM V3.0.
 */

 SIGNAL ON HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 Title     = CmdName Info

 env          = 'OS2ENVIRONMENT';
 TRUE         = (1 = 1);
 FALSE        = (0 = 1);
 Redirection  = '> NUL 2>&1';
 '@ECHO OFF'

 /* OS/2 Errorcodes */
 ERROR.NO_ERROR           =  0;
 ERROR.INVALID_FUNCTION   =  1;
 ERROR.FILE_NOT_FOUND     =  2;
 ERROR.PATH_NOT_FOUND     =  3;
 ERROR.ACCESS_DENIED      =  5;
 ERROR.NOT_ENOUGH_MEMORY  =  8;
 ERROR.INVALID_FORMAT     = 11;
 ERROR.INVALID_DATA       = 13;
 ERROR.NO_MORE_FILES      = 18;
 ERROR.WRITE_FAULT        = 29;
 ERROR.READ_FAULT         = 30;
 ERROR.GEN_FAILURE        = 31;
 ERROR.INVALID_PARAMETER  = 87;

 GlobalVars = 'Title CmdName env TRUE FALSE Redirection ERROR.';
 call RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs

 /* show help */
 ARG Parm .
 IF (POS('?', Parm) > 0) THEN
 DO
    rc = ShowHelp();
    EXIT(ERROR.INVALID_PARAMETER);
 END;

 /* Defaults */
 GlobalVars   = GlobalVars 'MessageFile';
 rc           = 0;
 BootDrive    = GetInstDrive();

 IniAppName   = 'ISDNPM30'
 IniKeyDir    = 'INSTALLDIR';

 CallDir      = GetCallDir();
 ObjectIdBase = IniAppName;

 HaltMessage  = 'Interrupted by user.';
 ErrorTag     = CmdName': error:';

 ValidLanguageChars = '0'XRANGE('A', 'Z');

 DO UNTIL (1)
 /*
    trace ?i
 */
    /* determine language */
    SyslevelFile = BootDrive'\OS2\INSTALL\SYSLEVEL.OS2';
    Language = CHARIN( SyslevelFile, X2D(37), 1);
    rcx = STREAM( SyslevelFile, 'C', 'CLOSE');
    IF (POS( Language, ValidLanguageChars) = 0) THEN
       Language = '0';

    /* take english as default ! */
    MessageFile    = CallDir'\install\inst'Language'.txt';
    IF (\FileExist( MessageFile)) THEN
       Language = '0';

    /* determine data and message file */
    MessageFile    = CallDir'\install\inst'Language'.txt';
    ObjectListFile = CallDir'\install\inst'Language'.lst';
    IF (\FileExist( MessageFile)) THEN
    DO
       SAY ErrorTag 'messagefile' MessageFile 'not found.';
       rc = ERROR.FILE_NOT_FOUND;
       LEAVE;
    END;
    HaltMessage = GetMessage( 'INST_HALT');
    ErrorTag    = CmdName':' GetMessage( 'INST_ERRORTAG')':';

    /* say who we are */
    SAY;
    SAY GetMessage( 'INST_TITLE');
    SAY;

    /* check for object list file */
    IF (\FileExist( ObjectListFile)) THEN
    DO
       SAY ErrorTag GetMessage('INST_NO_OBJECT_LISTFILE');
       rc = ERROR.FILE_NOT_FOUND;
       LEAVE;
    END;

    /* get some literals being used on creating objects */
    Msg._Create      = GetMessage( 'INST_CREATE');
    Msg._Update      = GetMessage( 'INST_UPDATE');
    Msg._ResultOk    = GetMessage( 'INST_RESULTOK');
    Msg._ResultError = GetMessage( 'INST_RESULTERROR');

    /* setup some values */
    rcx = VALUE('CALLDIR', CallDir, env);
    rcx = VALUE('OBJECTIDBASE', ObjectIdBase, env);

    /* create isdn.cfg if not exist */
    SourceFile = CallDir'\isdn_'Language'.cf0';
    TargetFile = CallDir'\isdn.cfg';
    IF (\FileExist( TargetFile)) THEN
       'copy ' SourceFile TargetFile; 

    /* create all objects */
    DO WHILE (LINES( ObjectListFile) > 0)
       ThisLine = ParseLine( STRIP( LINEIN( ObjectListFile)));

       PARSE VAR ThisLine '"'ThisClass'"' '"'ThisTitle'"' '"'ThisLocation'"' '"'ThisSetup'"'
       IF (ThisSetup = '') THEN ITERATE;

       PARSE VAR ThisSetup 'OBJECTID='ThisObjectId';'.
       IF ((ThisObjectId = '') | (\SysSetObjectData( ThisObjectId, ';'))) THEN
          Action = Msg._Create;
       ELSE
          Action = Msg._Update;
       CALL CHAROUT, Action '"'ThisTitle'" ... ';
       rcx = SysCreateObject( ThisClass, ThisTitle, ThisLocation, ThisSetup, 'U');
       IF (rcx = 1) THEN
          SAY Msg._ResultOk;
       ELSE
          SAY Msg._ResultError;
    END;
    rcx = STREAM( ObjectListFile, 'C', 'CLOSE');

    /* enter installation directory into OS2.INI */
    rcx = SysIni(, IniAppName, IniKeyDir, CallDir);

    /* create syslevel copy */
    SyslevelSource = CallDir'\install\sl'Language'.ipm';
    'COPY' SyslevelSource 'syslevel.*' Redirection;

    /* open folder for viewing */
    FolderId = '<'ObjectIdBase'_FOLDER>';
    rcx = SysOpenObject( FolderId, 'DEFAULT', TRUE);
    rcx = SysOpenObject( FolderId, 'DEFAULT', TRUE);

 END; /* DO UNTIL (1) */

 /* cleanup */

 EXIT(rc)

/* ------------------------------------------------------------------------- */
HALT:
SYNTAX:
 SAY 'Interrupted by user.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE (GlobalVars)

 SAY;
 SAY Title;
 SAY;

 PARSE SOURCE . . ThisFile

 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 ThisLine = LINEIN(Thisfile);
 DO WHILE (ThisLine \= ' */')
    SAY SUBSTR(ThisLine, 7);
    ThisLine = LINEIN(Thisfile);
 END;

 rc = LINEOUT(Thisfile);

 RETURN('');

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 PARSE ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ------------------------------------------------------------------------- */
GetInstDrive: PROCEDURE EXPOSE env
 ARG DirName, EnvVarName

 /* Default: get OS2 directory: this is also the boot drive */
 IF (DirName = '') THEN DirName = '\OS2';

 /* Default: search in PATH  */
 IF (EnvVarName = '') THEN EnvVarName = 'PATH';
 PathValue = VALUE(EnvVarName,,env);

 /* search entry and return drive letter */
 DirName = ':'DirName';';
 EntryPos = POS(DirName, PathValue) - 1;
 IF (EntryPos = -1) THEN
    RETURN('');
 InstDrive = SUBSTR(PathValue, EntryPos, 2);
 RETURN(InstDrive);

/* ------------------------------------------------------------------------- */
GetDrivePath: PROCEDURE
 PARSE ARG FileName

 FullPath = FILESPEC('D', FileName)||FILESPEC('P', FileName);
 IF (FullPath \= '') THEN
    RETURN(LEFT(FullPath, LENGTH(FullPath) - 1));
 ELSE
    RETURN('');

/* ------------------------------------------------------------------------- */
ParseLine: PROCEDURE EXPOSE env
 PARSE ARG ThisLine

 Delimiter = '%';

 ThisLineCopy = '';
 CurrentPos   = 1;

 /* search var */
 VarStart = POS(Delimiter, ThisLine);
 DO WHILE (VarStart > 0)

    VarEnd       = Pos(Delimiter, ThisLine, VarStart + 1);
    ThisVar      = SUBSTR(ThisLine, VarStart + 1, VarEnd - VarStart - 1);
    ThisVarValue = VALUE(ThisVar,,env);

    /* extend copy with value */
    ThisLineCopy = ThisLineCopy||,
                   SUBSTR(ThisLine, CurrentPos, VarStart - CurrentPos)||,
                   ThisVarValue;
    CurrentPos   = VarEnd + 1;

    /* search next occurrence of var */
    VarStart = POS(Delimiter, ThisLine, CurrentPos);
 END;

 /* take also rest of line */
 ThisLineCopy = ThisLineCopy||SUBSTR(ThisLine, CurrentPos);

 RETURN(ThisLineCopy);

/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ========================================================================= */
GetMessage: PROCEDURE EXPOSE MessageFile
 PARSE ARG ID;
 rcx = SysFileSearch( '<'ID'>: ', MessageFile, 'Line.');
 IF ((rcx \= 0) | (Line.0 = 0)) THEN
    RETURN( 'Error: *** Could not retrieve message' ID'***');
 ELSE
 DO
    PARSE VAR Line.1 .'>: 'Message;
    RETURN( Message);
 END;

