/*
   Quick and (somewhat) Dirty Installation Script for StofaSwitch/2

   (C) Mads Orbesen Troest & SIRIUS Cybernetics 1999

   Contact author at <mads@troest.dk>
*/

PARSE SOURCE . . InstallPath
InstallPath = DELSTR( InstallPath, LASTPOS( '\', InstallPath ) + 1 )

CALL RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
CALL SysLoadFuncs

CALL SysCls
SAY
SAY "StofaSwitch Installation Script V0.01 - (C) Mads Orbesen Troest [SCC] '99"
SAY ""
SAY "OK... If you continue, this script will configure the Stofa Switcher and"
SAY "install/update customised program objects on your desktop. Also, two"
SAY "simple SignOn.CMD and SignOff.CMD scripts are generated for commandline"
SAY "usage of the switcher."
SAY ""
SAY "The script assumes that the files /already/ reside in the directory in"
SAY "which you want them. If not, abort the script, move the files to the"
SAY "right place, and re-run this script... Notice that you may run this"
SAY "script at any time, if you need to reconfigure the switcher!"
SAY ""
SAY "It looks like I am installing program objects for files residing in:"
SAY InstallPath
SAY ""
SAY "Are you ready to continue the installation script? (Y/N)"
PULL Response
IF Response \= "Y" & Response \= "YES" THEN DO
 SAY "OK, then; aborting script..."
 EXIT
END

Switches = ""

SignOnIcon = "Icons\UserOn.ICO"
SignOffIcon = "Icons\UserOff.ICO"

SAY ""
SAY "OK, I need to know your User ID at the cable ISP:"
PARSE PULL User
SAY "Fine, and then your Password at the ISP:"
PARSE PULL Password
SAY "Right... Now, does the ISP NAT reside at IP 192.168.30.2, Port 259 ?"
PULL Response
IF Response \= "Y" & Response \= "YES" THEN DO
 SAY "Aha. Then please tell me the NAT IP:"
 PULL NatIP
 Switches = Switches || " -NATIP:" || NatIP
 SAY "And also the Port of the NAT:"
 PULL NatPort
 Switches = Switches || " -NATPORT:" || NatPort
END
SAY "Finally, should I make informative sign-on/off and panic sounds (recommended!)?"
PULL Response
IF Response \= "Y" & Response \= "YES" THEN DO
 Switches = Switches || " -SHUTUP"
 SAY "OK, feedback noises are disabled; /not/ recommended though!"
END
SAY "Oh, wait! Do you want to see the alternative icons available?"
PULL Response
IF Response \= "N" & Response \= "NO" THEN DO
 SAY "OK, I am opening the folder now..."
 CALL SysSetObjectData InstallPath"Icons", "OPEN=ICON;"
 SAY "The traditional icon-set consists of the 'man-in-chair' icons."
 SAY "Do you want the 'traffic-light' icons instead?"
 PULL Response
 IF Response \= "N" & Response \= "NO" THEN DO
  SAY "OK! Well, I prefer the traditional ones... ;-)"
  SignOnIcon = "Icons\TrafficGreen.ICO"
  SignOffIcon = "Icons\TrafficRed.ICO"
 END
 ELSE DO
  SAY "Yeah! My choice too! :-)"
 END
END
SAY "Press any key to move on the final part of the setup!"
PULL KNALL

CALL SysCls
SAY "* Calling ""StofaNet.EXE ENCRYPT "Password""" to obtain encrypted version..."
DO WHILE QUEUED() > 0 /* Empty queue... */
 KNALL = LINEIN( "QUEUE:" )
END
Encrypted = ""
"@ECHO "Password"|StofaNet.EXE Encrypt|RXQUEUE"
DO WHILE QUEUED() > 0 /* Examine queue... */
 qLine = LINEIN( "QUEUE:" )
 P = POS( "Encrypted version of '"||Password||"' is '", qLine )
 IF P > 0 THEN PARSE VAR qLine "'"."'" "'"Encrypted"'"
END
IF Encrypted \= "" THEN DO
 SAY "* Obtained encrypted password '"||Encrypted||"'..."
 Switches = Switches || " -ENCRYPTED"
 Password = Encrypted
END
ELSE DO
 SAY "* PANIC : Encryption failed, encryption NOT enabled!"
END

'@IF NOT EXIST 'InstallPath'Scripts MD 'InstallPath'Scripts >NUL'
RC = SysCreateObject( 'WPProgram',,
                      'StofaNet SignOn',,
                      '<WP_DESKTOP>',,
                      'EXENAME=' || InstallPath ||'StofaNet.EXE;'||'ICONFILE='InstallPath||SignOnIcon';MINIMIZED=YES;NOAUTOCLOSE=NO;PROGTYPE=WINDOWABLEVIO;',
                      'FULLSCREEN;PARAMETERS=SignOn 'User' 'Password' 'Switches';',,
                      'REPLACE' )
IF( RC <> 1 ) THEN SAY '* PANIC : Unable to create Sign-On object! :-('
'@ECHO @'InstallPath'StofaNet.EXE SignOn 'User' 'Password' 'Switches' > Scripts\SignOn.CMD'

RC = SysCreateObject( 'WPProgram',,
                      'StofaNet SignOff',,
                      '<WP_DESKTOP>',,
                      'EXENAME=' || InstallPath ||'StofaNet.EXE;'||'ICONFILE='InstallPath||SignOffIcon';MINIMIZED=YES;NOAUTOCLOSE=NO;PROGTYPE=WINDOWABLEVIO;',
                      ';PARAMETERS=SignOff 'User' 'Password' 'Switches';',,
                      'REPLACE' )
IF( RC <> 1 ) THEN SAY '* PANIC : Unable to create Sign-Off object! :-('
'@ECHO @'InstallPath'StofaNet.EXE SignOff 'User' 'Password' 'Switches' > Scripts\SignOff.CMD'

SAY ""
SAY "StofaSwitch Objects should now be installed on your desktop! :-)"
SAY "And heeey: SignOn/Off scripts should also be generated in:"
SAY InstallPath'Scripts'
SAY "(If not, well uh-uh; try writing me at <mads@troest.dk> ;-)"

