/* Install of VoiceDialer/2 */

call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
call SysLoadFuncs

CALL SysCls

say 'Rexx Installer for Vdial/2'
say '--------------------------------------------'
say
say '   Installation...'
say
say '   copies files to destination directory'
say '   creates folder and objects on desktop'
say

/* Ask Directory */

say 'Enter target directory (e.g.: C:\VDIAL):'
say '(<return> = current directory, object creation only, no copy operation)'
PARSE PULL InstDir
InstDir = STRIP(InstDir, 'T', '\')

IF InstDir="" THEN
 DO
   InstDir=directory()
   SIGNAL MakeIcons
 END

/* Create Directory */
say
say '--------------------------------------------'
say 'creating directories'
say '--------------------------------------------'

if InstDir <> "." then
   DO
     call SysFileTree InstDir, "SearchDir", "D"
     if SearchDir.0 = 0 then do
         rc = SysMkDir(InstDir)
            if rc <> 0 then do
                 say "Error: Cannot create directory!" InstDir
                 exit
            end
     end
end

/* Copy files */
say
say '--------------------------------------------'
say 'copying files'
say '--------------------------------------------'

'@Copy Vdialer2.exe 'InstDir'\Vdialer2.exe'
'@Copy VDIALGER.INF 'InstDir'\VDIALGER.INF'
'@Copy VDIALENG.INF 'InstDir'\VDIALENG.INF'
'@Copy VDIALFOLD1.ICO 'InstDir'\VDIALFOLD1.ICO'
'@Copy VDIALFOLD2.ICO 'InstDir'\VDIALFOLD2.ICO'

MakeIcons:
/* Make icons */
say
say '--------------------------------------------'
say 'creating icons on your desktop'
say '--------------------------------------------'

mydir=Directory()

classname = 'WPFolder'
title     = 'Voice^Dial'
location  = '<WP_DESKTOP>'
icon1     = mydir||'\VDIALFOLD1.ico'
icon2     = mydir||'\VDIALFOLD2.ico'
icon      = 'ICONFILE='icon1||';ICONNFILE=1,'||icon2
folderid  = '<VDIAL2_FOLDER>'
setup     = 'OBJECTID='||folderid||';'||icon||':ICONVIEW=FLOWED'
rc        = SysCreateObject(classname, title, location ,setup,'U')

classname = 'WPProgram'
title     = 'ENGLISH INFORMATION'
location  = '<VDIAL2_FOLDER>'
INFNAME   = InstDir||'\VDIALENG.INF'  
WorkDir   = InstDir
setup     = 'OBJECTID=<VDIALENG>;EXENAME=VIEW.EXE;PARAMETERS='||INFNAME||';STARTUPDIR='||Workdir
rc        = SysCreateObject(classname, title, location ,setup,'U')

classname = 'WPProgram'
title     = 'GERMAN INFORMATION'
location  = '<VDIAL2_FOLDER>'
INFNAME   = InstDir||'\VDIALGER.INF' 
WorkDir   = InstDir
setup     = 'OBJECTID=<VDIALGER>;EXENAME=VIEW.EXE;PARAMETERS='||INFNAME||';STARTUPDIR='||Workdir
rc        = SysCreateObject(classname, title, location ,setup,'U')

classname = 'WPProgram'
title     = 'VoiceDial/2'
location  = '<VDIAL2_FOLDER>'
exename   = 'EXENAME='||InstDir||'\vdialer2.exe'
WorkDir   = InstDir
setup     = 'OBJECTID=<VDIAL2_PROGRAM>; STARTUPDIR='||InstDir||';STARTUPDIR='||Workdir||';'||exename
rc        = SysCreateObject(classname, title, location, setup, 'U')

say
say 'Ready.'
