/****************************************************************/
/*             Creation of Zeupd desktop folder                */
/*    Based on a script supplied by Antonio Manara Rossini      */
/*    and Peter Moylan                                                      */
/****************************************************************/

/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
zversion = '0.9'
zv = '09'

Say 'Zeupd for OS/2 - Installation Script.'
Say
Say 'Create Zeupd for OS/2 folder and icons.'
Say
Say 'NOTE: This program needs to be executed from the installation directory'
Say '      of your working Zeupd setup.'
Say
CreateCollision = 'Replace'

Call CreateObjects
Exit

CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    Say 'Creating ['Title']'
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say ' > failed to create ['Title' | 'Class'] at location ['Location']'
    return rc

CreateShadow: procedure
    Parse Arg Original, Location
    Say 'Creating Shadow of 'Original
    rc = SysCreateShadow( Original, Location )
    If rc <> 1 Then
        Say ' > failed to create shadow of 'Original' at location ['Location']'
    return rc

CreateObjects:

current_dir = directory()

/***************/
/* MAIN FOLDER */
/***************/

rc = CreateObject( 'WPFolder',,
    'Zone Edit Update',,
    '<WP_DESKTOP>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,NORMAL;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='||current_dir||'\Zefold1.ico;'||,
        'ICONNFILE=1,'||current_dir||'\Zefold2.ico;'||,
        'OBJECTID=<Zeupd_folder>',,
    CreateCollision )

/***************************/
/*  OBJECTS IN MAIN FOLDER */
/***************************/

  rc = CreateShadow(current_dir||'\ZEUPD.DOC', '<Zeupd_folder>')

  rc = CreateObject( 'WPProgram',,
      'Zeupd Ini Editor',,
      '<Zeupd_folder>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||current_dir||'\ZEUPDINI'||zv||'.EXE;'||,
          'STARTUPDIR='||current_dir||';'||,
          'MINIMIZED=NO;'||,
          'ICONFILE='||current_dir||'\Zeupdini.ico;'||,
          'OBJECTID=<ZeupdIni_Editor>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Zeupd v'||zversion,,
      '<Zeupd_folder>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||current_dir||'\zeupd'||zv||'.EXE;'||,
          'STARTUPDIR='||current_dir||';'||,
          'ICONFILE='||current_dir||'\Zeupd.ico;'||,
          'OBJECTID=<Zeupd>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Zeupd Shutdown',,
      '<Zeupd_folder>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||current_dir||'\shutdown_zeupd.EXE;'||,
          'STARTUPDIR='||current_dir||';'||,
          'ICONFILE='||current_dir||'\shutdown_zeupd.ico;'||,
          'MINIMIZED=NO;'||,
          'OBJECTID=<Zeupd_Shutdown>',,
      CreateCollision )


return

