/*---------------------------------------------------------------------------*\
|   Check all logon assignments whether corresponding aliases exists          |
|   if aliases does not exist ask for deletion of logon assignment            |
|       (C) Alain Rykaert IBM Belgium & Hermann Pauli IBM Germany SEP95-MAY96 |
|                                                                 FEB2000     |
\*---------------------------------------------------------------------------*/

    Parse Arg Option

    Call INIT                     /* Initalisation of DLL's and other stuff*/
    Call CHKOPT                          /* Check Options & display Welcome*/
    Call CHKPWS                               /* Check the PWS & Admin name*/
    Call MAIN                                            /* do the main job*/
    Call QUIT                                                       /* Quit*/

 MAIN:/* ------------------------------------------------------ MAIN: -------*/

    Call Time('R')

    /* Get list of all aliases definend on server */
    RC = NetEnumerate(NETALIAS, 'ALIAS' , '\\'SRVNAME)
    if RC = 0
     then nop
     else do
             Call LOGIT 'NetEnum. Alias' ,'Server \\' || SRVNAME , RC
             call Quit
          end

    /* build list with all existing aliases */
    ALIASOK. = 0
    do i = 1 to ALIAS.0
       AliasN = ALIAS.i
       ALIASOK.AliasN = 1
    end

    /* get all defined userids */
 /* RC = NetEnumerate(NETUSER, 'USERID', '\\'SRVNAME) */
    RC = WfrxUserEnum('\\'SrvName,'UserID')
    if RC = 0
     then nop
     else do
             Call LOGIT 'NetEnum. User' , 'Server \\' || SRVNAME , RC
             call Quit
          end

    call RxStemSort 'USERID'

    ErrorNr     = 0                              /* number of found incons.*/
    ToDel.0     = 0

    do i = 1 to USERID.0
       if trace
        then say '0909'x i ':' USERID.i
        else do
                say  '0909'x 'Total Users =' i
                if \MUTE
                 then do
                         Call SysCurState OFF
                         parse value SysCurPos() with row col
                         row = row - 1
                         Call SysCurPos row,0
                      end
                 else Nop
             end

       RC = NetGetInfo(NETLOGONASN, 'LASSINFO', '\\'SRVNAME, USERID.i)
       if RC = 0
        then do j = 1 to LASSINFO.count
                AliasN = LASSINFO.j.Alias
                if \ALIASOK.AliasN
                 then do
                         ErrorNr = ErrorNr + 1

                         call Logit 'pay attention',,
                                  Left(AliasN,8,' ') '<-->' USERID.I,,
                                  'inconsistency found'

                         if DELETE
                          then do
                                  ToDel.0 = ErrorNr
                                  ToDel.ErrorNr.Alias = AliasN
                                  ToDel.ErrorNr.User  = USERID.I
                               end
                          else nop
                      end
                 else nop
             end
        else if left(strip(RC),1) <> 3
              then do
                      call LOGIT 'NetGetInfo LA' , USERID.i , RC
                      call Quit
                   end
              else nop                      /* no assignments for this user*/
    end

    if ToDel.0 > 0
     then call DelIncon
     else nop


    say ; say '0909'x 'Total Time  =' Trunc(Time('E'),2)

    Return


 DelIncon:/* -------------------------------------------------- DelIncon: ---*/

    /* get path for IBMLAN$ to be used for dummy Alias */
    NetName = 'IBMLAN$'

    RC = NetGetInfo(NETSHARE, 'shareInfo', '\\'SrvName, NetName)

    if RC = '0'
     then nop
     else do
             call Logit 'NetGetInfo Share' , '\\'SRVNAME NetName , RC
             call Quit
             return
          end

    /* info for dummy alias to delete the assignment */
    AliasInfo.remark   = 'Temporary alias'
    AliasInfo.server   = '\\'SRVNAME
    AliasInfo.location = 'Within Domain'
    AliasInfo.mode     = 'At Requester use'
    AliasInfo.type     = 'Files'

    /* find dummy path for temporary Alias */
    AliasInfo.path     = '\\'SRVNAME'\IBMLAN$\DUMMY???'
    AliasInfo.path     = SysTempFileName(AliasInfo.path)

    parse var AliasInfo.path . 'IBMLAN$' AliasInfo.path

    AliasInfo.path     = shareInfo.path || AliasInfo.path

    DelNr = 0
    do i = 1 to ToDel.0
       /* add dummy alias to delete the assignment */
       AliasInfo.name     = ToDel.i.Alias
       RC = NetAdd(NETALIAS, 'AliasInfo', '\\'SRVNAME)
    end

    do i = 1 to ToDel.0
       /* delete the assignment                    */
       RC = NetDelete(NETLOGONASN, '\\'SRVNAME, ToDel.i.User,ToDel.i.Alias)
       if RC = 0
        then do
                call Logit 'Delete Incons.',,
                Left(ToDel.i.Alias,8,' ') '<-->' ToDel.i.User , ''
                DelNr = DelNr + 1
             end
        else do
                call Logit 'NetDelete LA' ,,
                           '\\'SRVNAME ToDel.i.User ToDel.i.Alias ':' RC
                call Quit
             end
    end

    do i = 1 to ToDel.0
       /* delete the dummy alias                   */
       RC = NetDelete(NETALIAS, '\\'SRVNAME, ToDel.i.Alias)
    end

    Return

 CHKOPT:/* ---------------------------------------------------- CHKOPT: -----*/

    SRVNAME = ''; LOGF = 'LSMT.LOG'; PIPE = ''
    TRACE = 0 ; MUTE = 0 ; DELETE = 0
    OPTION = Translate(OPTION)
    do while OPTION <> ''
       Parse value OPTION with ARGUMENT ' ' OPTION
       select
        when Left(ARGUMENT,5) = '/SRV:' then SRVNAME = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/INP:' then INPF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/LOG:' then LOGF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/CHK:' then CHKF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/PIP:' then PIPE    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,2) = '/D'    then DELETE  = 1
        when Left(ARGUMENT,5) = '/M'    then MUTE    = 1
        when Left(ARGUMENT,2) = '/T'    then TRACE   = 1
        otherwise Nop
       end
    end

    if SRVNAME = '' then signal GETHELP
    if \MUTE
     then do
              Topic1='CHKASSGNWELCOME'
              Topic_String.Topic1.1=SRVNAME;
              Topic_String.Topic1.2=LOGF;
              If DELETE
              Then Topic_String.Topic1.3='Yes';
              Else Topic_String.Topic1.3='No';
              Topic_List='WELCOMELOGO' Topic1;
              Call GETANS
              Parse VALUE SysCurPos() With Old_R Old_C; '@pause'
              Call SysCurPos Old_R, Old_C; say ESC'[K'
          end
     else do
             say 'ServerName =' SRVNAME
             say 'LogFile    =' LOGF
             if Delete then say 'Delete     = yes'
            'pause'
          end
    Return

 CHKPWS:/* ---------------------------------------------------- CHKPWS: -----*/

    RC = NetGetInfo(350, 'WKSTAINFO','')
    if RC = 0
     then do
             ADMNAME = WKSTAINFO.UserName
             PWSNAME = WKSTAINFO.ComputerName
          end
     else do
            Call LOGIT 'Get PWS Info', ,RC
            Call Quit
          end
    Return

 INIT:/* ------------------------------------------------------ INIT: -------*/

    Call RgUtil   '/m'                                    /* Rexx Utilities*/
    Call RgUtils  '/m'                                    /* Rexx Utilities*/
    Call RgLSRXUT '/m'                             /* Lan Server Rexx Utils*/

    Parse Upper Source . . P_NAME
    PRGN = Filespec('N', Left(P_NAME, Length(P_NAME) -4))

   '@echo off'
    ESC     = '1B'x
    REDIR   = '>NUL 2>NUL'

    NETLOGONASN = 52                                 /* code for LSREXX API*/
    NETSHARE    = 190
    NETUSER     = 280
    NETALIAS    = 20
    NETWKSTA    = 350

    Resource_File = 'LSMT.RSC'
    Call CHKFILE Resource_File

    Return

 GETANS:/* ---------------------------------------------------- GETANS: -----*/

    Vars_List =Ansi_Say(Resource_File Topic_List);
    Parse VALUE SysCurPos() With Old_R Old_C;
    Do While Vars_List <> '';
       Parse VALUE Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List;
       Call SysCurPos Row, Column;
       Say x2c(Color) || Topic_String.Topic_Id.Var_Id || '1B'x || '[0m';
       End;
    Call SysCurPos Old_R, Old_C;

    Return

 GETHELP:/* --------------------------------------------------- GETHELP: ----*/

    if \MUTE
     then do
             Topic1='CHKASSGNHELP'
             Topic_String.Topic1.1=PRGN;
             Topic_List=Topic1;
             Call GETANS
          end
     else say 'Incorrect options.'
    Call QUIT

    Return

 CHKFILE:/* --------------------------------------------------- CHKFILE: ----*/

    Parse Arg FILE
    RC = Stream(FILE, 'C', 'QUERY EXIST')
    if RC = ''
     then do
             say ' File' FILE 'not found.'
             Call QUIT
          end
     else Nop
    Call Stream FILE, 'C', 'CLOSE'

    Return

 LOGIT:/* ----------------------------------------------------- LOGIT: ------*/

    FUNC = ARG(1); INFO = ARG(2); RCOD = ARG(3)
    RC = LLOGIT(LOGF, PIPE, ADMNAME, PRGN, FUNC, INFO, RCOD)

    Return

 QUIT:/* ------------------------------------------------------ QUIT: -------*/

    Call LineOut 'LSMT.END', PRGN, 1
    Call Stream  'LSMT.END', 'C', 'CLOSE'
    Call Stream COLF, 'C', 'CLOSE'
    Call Stream LOGF, 'C', 'CLOSE'
    Exit

 /*--------------------------------------------------------------------------*/
