/*---------------------------------------------------------------------------*\
|   GETDOM  all details from all LAN Servers into the Domain                  |
|                  Version 2.12 - (C) Alain Rykaert IBM Belgium - JUN96-AUG96 |
\*---------------------------------------------------------------------------*/

 /*==========================================================================*/

     COL_Name.0  =  11        ; COL_Len.0 = COL_Name.0

     COL_Name.1  = 'NAME'     ; COL_Len.1 = 9
     COL_Name.2  = 'OS2'      ; COL_Len.2 = 8
     COL_Name.3  = 'BUILD'    ; COL_Len.3 = 6
     COL_Name.4  = 'MPTS'     ; COL_Len.4 = 8
     COL_Name.5  = 'LSR'      ; COL_Len.5 = 8
     COL_Name.6  = 'CM2'      ; COL_Len.6 = 8
     COL_Name.7  = 'TCPIP'    ; COL_Len.7 = 8
     COL_Name.8  = 'COMMENT'  ; COL_Len.8 = 35
     COL_Name.9  = 'ROLE'     ; COL_Len.9 = 11
     COL_Name.10 = 'DISC'     ; COL_Len.10 = 5
     COL_Name.11 = 'HIDDEN'   ; COL_Len.11 = 8

 /*==========================================================================*/

    Parse Arg Option

    Call Init                    /* Initialisation of DLL's and other stuff */
    Call Chkopt                          /* Check Options & display Welcome */
    Call Main                                            /* do the main job */
    Call Quit                                                       /* Quit */

 MAIN:/* ----------------------------------------------------- MAIN: -------*/

 /* Check if this is the Primary DC */

    Call ChkServer DCName

 /* Get the Domain name from the DC-PR */

    Call SysFileSearch 'DOMAIN =', '\\'DCName'\ibmlan$\ibmlan.ini', 'FILE.'
    if FILE.0 = 1
     then Parse Value FILE.1 with . '=' DomainName .
     else do
             say ESC'[0;1;31m Unable to determine the Domains name from',
                 'the Primary Domain Controller' DCName ESC'[0m'
             Pull
             Exit
          end

    say
    say '09'x ESC'[0;1;35m The Domains name is' DomainName ESC'[0m'

 /* Check if a directory exist for this domain. If needed, create it */

    Call ChkDir Directory()'\'DomainName

    OutputFile = Directory()'\'DomainName'\'OutputFile

    if TXT
     then do
            'if exist' OutputFile 'del' OutputFile
             Call GetBanner
          end
     else Nop

    RC = NetGetInfo(340, 'SrvName', '\\'DCName, 'SERVERS')
    if RC = 0
     then do
             Call RxStemSort 'SrvName'
             if TXT then Call LineOut OutputFile, Banner
             do i = 1 to SrvName.0
                Call ChkDir Directory()'\'DomainName'\'SrvName.i
                if TXT & i // 20 = 0 then Call LineOut OutputFile, Banner

                say
                say '09'x ESC'[0;1;36m Server =' i'/'SrvName.0 '-' SrvName.i ESC'[0m'
                Parse value SysCurPos() with ROW COL
                Call SysCurPos ROW -1, Length(SrvName.i) + 26

                RC = NetGetInfo(160, 'SrvNameInfo', '\\'SrvName.i)
                if RC = 0
                 then do
                         say ESC'[0;1;32m OK' ESC'[0m'
                         Call GetInfo SrvName.i
                      end
                 else do
                         Call Beep 100,50
                         say ESC'[0;1;33m Not found' ESC'[0m'
                         ServerInfo = ' ;'Left(SrvName.i, 9, ' ')';'
                         Call LineOut OutputFile, ServerInfo
                         Call Stream OutputFile, 'C', 'CLOSE'
                      end
             end
          end
     else do
             Call Beep 100,50
             say ESC'[0;1;33m Can not get NetGetInfo from \\'DCName ESC'[0m'
          end

    Call Stream Directory()'\'OutputFile, 'C', 'CLOSE'
    Call SysSetObjectData Directory()'\'OutputFile, 'ICONFILE='Directory()'\Domain.Ico'

    Return

 GETINFO:/* --------------------------------------------------- GETINFO: ----*/

    Parse Arg Server_Name

    CSD_LSR  = ''
    CSD_MPTS = ''
    CSD_OS2  = ''
    BLD_OS2  = ''
    CSD_CM2  = ''
    CSD_TCP  = ''

   'net admin \\'Server_Name '/c set >' TempFile

 /* determine the Boot Drive */

    do while Lines(TempFile)
       LLINE = Translate(LineIn(TempFile))
       Parse Value LLINE with Begin '=' Rest
       if Begin = 'COMSPEC'
        then Boot_UNC = Left(Rest,1)
        else Nop
    end

 /* say '09'x ESC'[0;1;36m Boot Drive =' Boot_UNC':' ESC'[0m' */

 /* read & interpret the PATH line from the CONFIG.SYS */

    Call SysFileSearch 'SET PATH=', '\\'Server_Name'\'Boot_UNC'$\CONFIG.SYS', 'PATH.'

    Parse Value PATH.1 with DUMMY '=' LLINE

    do while LLINE <> ''
       Parse Value LLINE with Path ';' LLINE
       Path = Translate(Strip(Path))

       Select

        when SubStr(Path,3) = '\OS2'                            /* OS/2 Base */
         then do
                 OS2_UNC = '\\'Server_Name'\'Left(Path,1)'$'
                 CSD_OS2  = RxSysLevel(OS2_UNC'\OS2\INSTALL\SYSLEVEL.OS2', 'LEVEL')
              end

        when SubStr(Path,3) = '\IBMCOM'          /* MPTS */
         then do
                 MPTS_UNC = '\\'Server_Name'\'Left(Path,1)'$'
                 CSD_MPTS = RxSysLevel(MPTS_UNC'\IBMCOM\SYSLEVEL.TRP','LEVEL')
              end

        when SubStr(Path,3) = '\IBMLAN\NETPROG'  /* Lan Server */
         then do
                 LSR_UNC = '\\'Server_Name'\'Left(Path,1)'$'
                 CSD_LSR  = RxSysLevel(LSR_UNC'\IBMLAN\SYSLEVEL.SRV','LEVEL')
              end

        when SubStr(Path,3) = '\CMLIB'           /* CM/2 */
         then do
                 CM2_UNC = '\\'Server_Name'\'Left(Path,1)'$'
                 CSD_CM2  = RxSysLevel(CM2_UNC'\CMLIB\SYSLEVEL.ACS', 'LEVEL')
              end

        when SubStr(Path,3) = '\TCPIP\BIN'       /* TCP/IP */
         then do
                 TCP_UNC = '\\'Server_Name'\'Left(Path,1)'$'
                 CSD_TCP  = RxSysLevel(TCP_UNC'\TCPIP\BIN\SYSLEVEL.TCP', 'LEVEL')
              end

        otherwise Nop

       end
    end

 /* Determine the BUILD level from OS/2 */

    Call Stream TempFile, 'C', 'CLOSE'

   'net admin \\'Server_Name '/c ver /r >' TempFile

    Do 3
        LLINE = LineIn(TempFile)
    end

    Parse Value LLINE with . BLD_OS2 .

 /* Get Role of this server */

    RC = NetGetInfo(370, 'SrvNameModalInfo', '\\'Server_Name)
    Parse Value SrvNameModalInfo.Role with ServerRole .

 /* Collect all together */

    ServerInfo = ' ;'                                                 ||,
                 Left(SrvNameInfo.Name,   COL_Len.1 ,' ')';'          ||,
                 Left(CSD_OS2,            COL_Len.2 ,' ')';'          ||,
                 Left(BLD_OS2,            COL_Len.3 ,' ')';'          ||,
                 Left(CSD_MPTS,           COL_Len.4 ,' ')';'          ||,
                 Left(CSD_LSR,            COL_Len.5 ,' ')';'          ||,
                 Left(CSD_CM2,            COL_Len.6 ,' ')';'          ||,
                 Left(CSD_TCP,            COL_Len.7 ,' ')';'          ||,
                 Left(SrvNameInfo.Comment,COL_Len.8 ,' ')';'          ||,
                 Left(ServerRole,         COL_Len.9 ,' ')';'          ||,
                 Left(SrvNameInfo.Disc,   COL_Len.10,' ')';'          ||,
                 Left(SrvNameInfo.Hidden, COL_Len.11,' ')';'

 /* If '/TXT' specified write the default file 'Domain.CSV' */

    if TXT
     then do
             say '09'x ESC'[0;1;36m "'SrvNameInfo.Comment'"' ESC'[0m'
             Call LineOut OutputFile, ServerInfo
             Call Stream OutputFile, 'C', 'CLOSE'
          end
     else Nop

 /* if '/OBJ' specified create a folder with pointers to CONFIG.SYS,
    IBMLAN.INI, PROTOCOL.INI etc... */

    if OBJ
     then Call MakeObjects
     else Nop

 /* Close the temporary file & delete it */

    Call Stream TempFile, 'C', 'CLOSE'
   'if exist' TempFile 'del' TempFile

    Return

 GETBANNER:/* ------------------------------------------------- GETBANNER: --*/

    Banner = ' ;'

    do i = 1 to COL_Name.0
       Banner = Banner || Left(COL_Name.i, COL_Len.i, ' ') || ';'
    end

    Return

 CHKOPT:/* ---------------------------------------------------- CHKOPT: -----*/

    DCName = ''
    OutputFile = 'Domain.CSV'
    LOGFile = 'LSMT.LOG'
    OBJ = 0
    TXT = 0

    Option = Translate(Option)
    do while Option <> ''
       Parse Value Option with Argument ' ' Option
       Select
        when Left(Argument,5) = '/SRV:' then DCName     = Substr(Argument,6)
        when Left(Argument,5) = '/OUT:' then OutputFile = Substr(Argument,6)
        when Left(Argument,5) = '/LOG:' then LOGFile    = Substr(Argument,6)
        when Left(Argument,4) = '/OBJ'  then OBJ = 1
        when Left(Argument,4) = '/TXT'  then TXT = 1
        otherwise Nop
       end
    end

    if DCName = '' | (OBJ + TXT = 0) then signal GetHelp

    Return

 INIT:/* ------------------------------------------------------ INIT: -------*/

    Call RgUtil   '/M'                                     /* Rexx Utilities */
    Call RgUtils  '/M'                                     /* Rexx Utilities */
    Call RgLSRXUT '/M'                              /* Lan Server Rexx Utils */

    Parse Upper Source . . P_NAME
    PRGN = Filespec('N', Left(P_NAME, Length(P_NAME) -4))

   '@echo off'
    ESC   = '1B'x
    REDIR = '>NUL 2>NUL'
    TempFile = 'TEMP.TMP'        /* Temporary file used in the program */

    Resource_File = 'LSMT.RSC'   /* Ansi Topics Resource File */
    Call Chkfile Resource_File

    Return

 GETANS: /*---------------------------------------------------- GETANS: -----*/

    Vars_List = Ansi_Say(Resource_File Topic_List)
    Parse VALUE SysCurPos() With Old_R Old_C
    Do While Vars_List <> ''
       Parse VALUE Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List
       Call SysCurPos Row, Column
       Say x2c(Color) || Topic_String.Topic_Id.Var_Id || '1B'x || '[0m'
       End
    Call SysCurPos Old_R, Old_C

    Return

 GETHELP:/* --------------------------------------------------- GETHELP: ----*/

    Topic1 = 'GETDOM'
    Topic_String.Topic1.1 = PRGN
    Topic_List = Topic1

    Call GETANS

    Call QUIT

 CHKFILE: /*--------------------------------------------------- CHKFILE: ----*/

    Parse Arg FILE
    RC = Stream(FILE, 'C', 'QUERY EXIST')
    if RC = ''
     then do
             say ' File' FILE 'not found.'
             Call QUIT
          end
     else Nop
    Call Stream FILE, 'C', 'CLOSE'

    Return

 CHKSERVER: /*------------------------------------------------- CHKSERVER: --*/

    Parse Arg Server

    say
    say ESC'[0;1;33m Check if' Server 'is a Primary Domain Controller ...' ESC'[0m'

    Parse value SysCurPos() with ROW COL
    Call SysCurPos ROW -1, 55

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'Server)

    if RC = 0 & ServerModalInfo.Role = 'Primary server in the domain'
     then say ESC'[0;1;42m OK' ESC'[0m'
     else do
             say ESC'[0;1;41m Not OK' ESC'[0m'
            'start popup "This is not a Primary DC" "LSMT Message"'
             Call Quit
          end

    Return

 MAKEOBJECTS: /*----------------------------------------------- MAKEOBJECTS */

    say '09'x ESC'[0;1;36m "'SrvNameInfo.Comment'"' ESC'[0m'

    Class    = 'WPFolder'
    Title    =  DomainName
    Location = '<LSMT_SERVERS>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'>;'             ||,
               'ICONVIEW=FLOWED;'                                  ||,
               'ICONVIEWPOS=40,20,55,65;'                          ||,
               'ICONFONT=10.System VIO;'                           ||,
               'ICONFILE='Directory()'\1001.ico;'                  ||,
               'ALWAYSSORT=YES'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPFolder'
    Title    =  Server_Name || '^' || SrvNameInfo.Comment
    Location = '<LSMT_SERVERS_'DomainName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'Server_Name'>;'            ||,
               'ICONVIEW=FLOWED;'                                  ||,
               'ICONVIEWPOS=40,20,55,65;'                          ||,
               'ICONFONT=10.System VIO;'                           ||,
               'ICONFILE='Directory()'\os2res63.ico;'              ||,
               'ALWAYSSORT=YES'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = 'CONFIG.SYS'
    Location = '<LSMT_SERVERS_'Server_Name'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'Server_Name'_CONFIG>;'     ||,
               'ICONFILE='Directory()'\1000.ico;'                  ||,
               'PROGTYPE=PM;'                                      ||,
               'EXENAME=e.exe;'                                    ||,
               'PARAMETERS='OS2_UNC'\config.sys'
    Update   = 'Update'
    Call CreateObj

    Call CCompare OS2_UNC'\config.sys',
                  Directory()'\'DomainName'\'Server_Name'\config.sys'

    Class    = 'WPProgram'
    Title    = 'PROTOCOL.INI'
    Location = '<LSMT_SERVERS_'Server_Name'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'Server_Name'_PROTOCOL>;'   ||,
               'ICONFILE='Directory()'\1018.ico;'                  ||,
               'PROGTYPE=PM;'                                      ||,
               'EXENAME=e.exe;'                                    ||,
               'PARAMETERS='MPTS_UNC'\ibmcom\protocol.ini'
    Update   = 'Update'
    Call CreateObj

    Call CCompare MPTS_UNC'\ibmcom\protocol.ini',
                  Directory()'\'DomainName'\'Server_Name'\protocol.ini'

    Class    = 'WPProgram'
    Title    = 'LANTRAN.LOG'
    Location = '<LSMT_SERVERS_'Server_Name'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'Server_Name'_LANTRAN>;'    ||,
               'ICONFILE='Directory()'\netinfo.ico;'               ||,
               'PROGTYPE=PM;'                                      ||,
               'EXENAME=e.exe;'                                    ||,
               'PARAMETERS='MPTS_UNC'\ibmcom\lantran.log'
    Update   = 'Update'
    Call CreateObj

    Call CCompare MPTS_UNC'\ibmcom\lantran.log',
                  Directory()'\'DomainName'\'Server_Name'\lantran.log'

    Class    = 'WPProgram'
    Title    = 'IBMLAN.INI'
    Location = '<LSMT_SERVERS_'Server_Name'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'Server_Name'_IBMLAN>;'     ||,
               'ICONFILE='Directory()'\1055.ico;'                  ||,
               'PROGTYPE=PM;'                                      ||,
               'EXENAME=e.exe;'                                    ||,
               'PARAMETERS='LSR_UNC'\ibmlan\ibmlan.ini'
    Update   = 'Update'
    Call CreateObj

    Call CCompare LSR_UNC'\ibmlan\ibmlan.ini',
                  Directory()'\'DomainName'\'Server_Name'\ibmlan.ini'

    if Stream(OS2_UNC'\IBM386FS\HPFS386.INI', 'C', 'QUERY EXIST') = ''
     then nop
     else do
             Class    = 'WPProgram'
             Title    = 'HPFS386.INI'
             Location = '<LSMT_SERVERS_'Server_Name'>'
             Setup    = 'OBJECTID=<LSMT_SERVERS_'Server_Name'_HPFS386>;'    ||,
                        'ICONFILE='Directory()'\perfmon.ico;'               ||,
                        'PROGTYPE=PM;'                                      ||,
                        'EXENAME=e.exe;'                                    ||,
                        'PARAMETERS='OS2_UNC'\ibm386fs\hpfs386.ini'
             Update   = 'Update'
             Call CreateObj
             Call CCompare OS2_UNC'\ibm386fs\hpfs386.ini',
                           Directory()'\'DomainName'\'Server_Name'\hpfs386.ini'
          end

    if CSD_CM2 = ''
     then nop
     else do
             Call SysFileSearch 'CMDefaultCFG', CM2_UNC'\CMLIB\CM.INI', 'FILE.'
             if FILE.0 = 1
              then do
                      Parse Value FILE.1 with '=' NDF_File

                      Class    = 'WPProgram'
                      Title    = NDF_File'.NDF'
                      Location = '<LSMT_SERVERS_'Server_Name'>'
                      Setup    = 'OBJECTID=<LSMT_SERVERS_'Server_Name'_NDF>;' ||,
                                 'ICONFILE='Directory()'\cm2.ico;'            ||,
                                 'PROGTYPE=PM;'                               ||,
                                 'EXENAME=e.exe;'                             ||,
                                 'PARAMETERS='CM2_UNC'\cmlib\'NDF_File'.NDF'
                      Update   = 'Update'
                      Call CreateObj
                      Call CCompare CM2_UNC'\cmlib\'NDF_File'.ndf',
                                    Directory()'\'DomainName'\'Server_Name'\'NDF_File'.ndf'
                   end
              else Nop
          end

    if CSD_TCP = ''
     then nop
     else do
             Call SysFileSearch 'SET ETC=', OS2_UNC'\CONFIG.SYS', 'FILE.'
             if FILE.0 = 1
              then do
                      Parse Value FILE.1 with '=' ETC_Location
                      i = 0
                      do while ETC_Location <> ''
                         i = i + 1
                         Parse Value ETC_Location with Path.i '\' ETC_Location
                      end
                      ETC_UNC = '\\fs2\'Left(Path.1,1)'$\'Path.2'\BIN'

                      Class    = 'WPProgram'
                      Title    = 'TCP/IP^Setup.CMD'
                      Location = '<LSMT_SERVERS_'Server_Name'>'
                      Setup    = 'OBJECTID=<LSMT_SERVERS_'Server_Name'_SETUP>;'      ||,
                                 'ICONFILE='Directory()'\1065.ico;'                  ||,
                                 'PROGTYPE=PM;'                                      ||,
                                 'EXENAME=e.exe;'                                    ||,
                                 'PARAMETERS='ETC_UNC'\setup.cmd'
                      Update   = 'Update'
                      Call CreateObj
                      Call CCompare ETC_UNC'\setup.cmd',
                                    Directory()'\'DomainName'\'Server_Name'\setup.cmd'
                   end
              else Nop
          end

    Class    = 'WPProgram'
    Title    = 'System Info'
    Location = '<LSMT_SERVERS_'Server_Name'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'Server_Name'_QSYSTEM>;'    ||,
               'ICONFILE='Directory()'\sysinfo.ico;'               ||,
               'PROGTYPE=windowablevio;'                           ||,
               'EXENAME='Directory()'\q_system.cmd;'               ||,
               'PARAMETERS='Server_Name
    Update   = 'Update'
    Call CreateObj

    Call CCompare '\\'Server_Name'\ibmlan$\netprog\qsystem.out',
                  Directory()'\'DomainName'\'Server_Name'\qsystem.out'

    Class    = 'WPProgram'
    Title    = 'Lan Server Errors^[GET]'
    Location = '<LSMT_SERVERS_'Server_Name'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'Server_Name'_GETERROR>;'   ||,
               'ICONFILE='Directory()'\notedoc.ico;'               ||,
               'PROGTYPE=windowablevio;'                           ||,
               'EXENAME='Directory()'\q_errors.cmd;'               ||,
               'PARAMETERS='Server_Name
    Update   = 'Update'
    Call CreateObj

    Call CCompare '\\'Server_Name'\ibmlan$\netprog\neterr.out',
                  Directory()'\'DomainName'\'Server_Name'\neterr.out'

    Class    = 'WPProgram'
    Title    = 'Lan Server Errors^[RESET]'
    Location = '<LSMT_SERVERS_'Server_Name'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'Server_Name'_RESERROR>;'   ||,
               'ICONFILE='Directory()'\notedoc1.ico;'              ||,
               'PROGTYPE=windowablevio;'                           ||,
               'EXENAME='Directory()'\r_errors.cmd;'               ||,
               'PARAMETERS='Server_Name
    Update   = 'Update'
    Call CreateObj

    Return

 CREATEOBJ: /*------------------------------------------------- CREATEOBJ: --*/

    RC = SysCreateObject(Class, Title, Location, Setup, Update)
    if RC <> 1
       then say ESC'[0;1;41m ErrorCode' RC Title ESC'[0m'
       else Nop

    Return

 CHKDIR:/* ---------------------------------------------------- CHKDIR: ---*/

    Parse Arg Dir_Name

    RCode = 0                                      /* Reset the Return Code*/

    if Stream(Dir_Name, 'C', 'QUERY EXIST') <> ''       /* is this a file ?*/
     then RCode = 1    /* Bad RC, there already exist a file with this name*/
     else do
             Call SysFileTree Dir_Name, 'DIREXIST', 'DO'/* does this DIR exist ?*/
             if DIREXIST.0 = 0
              then do
                      RC = SysMKDir(Dir_Name)
                      if RC <> 0
                       then RCode = 1
                       else Nop
                   end
              else Nop
          end

    if RCode = 1
     then do
             Call Beep 1000,100
             say 'Error while creating' Dir_Name
             Pull
             Exit
          end
     else Nop

    Return

 CCOMPARE:/* ------------------------------------------------- CCOMPARE: ----*/

    Parse Arg Source Target

    if Source = '' | Source = '\' | Target = ''
     then Return
     else Nop

    Q = Stream(Source, 'C', 'QUERY EXIST')
    if Q <> ''
     then do
             Q1 = Stream(Source, 'C', 'QUERY DATETIME')
             Q2 = Stream(Target, 'C', 'QUERY DATETIME')
             if Q1 <> Q2
              then do
                      say '09'x ESC'[0;1;36m Copy' Source ESC'[0m'
                     'copy' Source Target Redir
                      if RC <> 0
                       then do
                               Call Beep 1000,100
                               say 'BAD COPY'
                               Exit
                            end
                       else Nop
                   end
              else Nop
          end
     else Nop

    Return

 QUIT:/* ------------------------------------------------------ QUIT: -------*/

    Exit

 /*--------------------------------------------------------------------------*/
