/*---------------------------------------------------------------------------*\
|  Browse or change Alias Name & Assignments  (C) Alain Rykaert - NOV97-FEB98 |
\*---------------------------------------------------------------------------*/
    Version = '1.04'
    Say '* LSALIAS Version' Version

    Parse Upper Arg DCName OldAliasName NewAliasName

    Call Init                                   /* load DLL's & other stuff*/

    LogFileName = 'LSALIAS.LOG'                     /* name of the log file*/

    If DCName = '' | OldAliasName = ''
      Then Do
             Say '*'
             Say '* Browse or Change an Alias name & logon assignments'
             Say '*'
             Say '* Browse: LSALIAS {PrimaryDomainController} {AliasName}'
             Say '* Sample: LSALIAS \\DC01 ALIAS1'
             Say '*'
             Say '* Change: LSALIAS {PrimaryDomainController} {OldAliasName} {NewAliasName}'
             Say '* Sample: LSALIAS \\DC01 ALIAS1 ALIAS01'
             Say '*'
             Exit
           End
      Else Nop

    DCName = Strip(DCName,'L','\')

    Say '* Check if \\'DCName 'is a Primary Domain Controller'
    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole)
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Call ChkError '! Error:' DCName 'not a Primary DC'
                    End
           End
      Else Call ChkError '!' DCName RC

    Say '* Get information from the (old) Alias' OldAliasName
    RC = NetGetInfo(20, 'AliasInfo', '\\'DCName, OldAliasName)
    If RC = 0
      Then Do
             Call Logit 'Name       :' AliasInfo.Name
             Call Logit 'Remark     :' AliasInfo.Remark
             Call Logit 'Server     :' AliasInfo.Server
             Call Logit 'NetName    :' AliasInfo.Netname
             Call Logit 'Location   :' AliasInfo.Location
             Call Logit 'Mode       :' AliasInfo.Mode
             Call Logit 'Max uses   :' AliasInfo.Maxuses
             Call Logit 'Type       :' AliasInfo.Type
             Call Logit 'Queue      :' AliasInfo.Queue
             Call Logit 'Path       :' AliasInfo.Path
             Call Logit 'Priority   :' AliasInfo.Priority
             Call Logit 'Device pool:' AliasInfo.Device_pool
           End
      Else Call ChkError '! Error: Alias info' OldAliasName RC

    Say '* Get all users from \\'DCName
 /* RC = NetEnumerate(280, 'UserID', '\\'DCName) */
    RC = WfrxUserEnum('\\'DCNAME,'USERID')
    If RC = 0
      Then Do
             Say '* Total number of users:' UserID.0
             If RXUtils                         /* if RXutils DLL available*/
               Then Call RxStemSort 'UserID'
               Else Nop

             Say '* Get all users with a logon assignment to the Alias' OldAliasName
             k = 0
             Do i = 1 to UserID.0
               Counter = '('Right(i,Length(UserID.0))'/'Right(UserID.0,Length(UserID.0))')'
               Call NetGetInfo 52, 'LogonAsnInfo', '\\'DCName, UseriD.i
               If LogonAsnInfo.0 > 0
                 Then Do j = 1 to LogonAsnInfo.0
                        If LogonAsnInfo.j.Alias = OldAliasName
                          Then Do
                                 k = k + 1
                                 FoundUserID.k = UserID.i
                                 FoundDevice.k = LogonAsnInfo.j.Device
                                 Text = Counter Left(UserID.i,8) LogonAsnInfo.j.Device
                                 Call Logit Text
                               End
                          Else Nop
                        LogonAsnInfo.j.Alias = ''
                      End
                 Else Nop
             End
             FoundUserID.0 = k
           End
      Else Call ChkError '! Error: User info' OldAliasName RC

    If NewAliasName = ''   /* if no new alias specified, exit the procedure*/
     Then Signal Quit
     Else Nop

    Say '* Check if the new alias' NewAliasName 'already exist'
    RC = NetGetInfo(20, 'AliasInfo', '\\'DCName, NewAliasName)
    If RC = 0
      Then Call ChkError '! Error: Alias' NewAliasName 'already exist'
      Else Nop

    Say '* Add new Alias definitions' NewAliasName
    AliasInfo.Name = NewAliasName
    RC = NetAdd(20, 'AliasInfo', '\\'DCName)
    If RC = 0
      Then Call Logit 'Alias' NewAliasName 'added'
      Else Call ChkError '! Error: Add alias' NewAliasName RC

    Say '* Delete old Alias definitions' OldAliasName
    RC = NetDelete(20, '\\'DCName, OldAliasName)
    If RC = 0
      Then Call Logit 'Alias' OldAliasName 'deleted'
      Else Call ChkError '! Error: Delete alias' OldAliasName RC

    Say '* Update logon assignments'
    Do i = 1 to FoundUserID.0
      Counter = '('Right(i,Length(FoundUserID.0))'/'Right(FoundUserID.0,Length(FoundUserID.0))')'
      Say ' ' Counter Left(FoundUserID.i,8) FoundDevice.i
      RC = NetDelete(52, '\\'DCName, FoundUserID.i, OldAliasName)
      If RC = 0
        Then Nop
        Else Call ChkError '! Error: Delete logonassignment' FoundUserID.i FoundDevice.i RC
      RC = NetAdd(52, '\\'DCName, NewAliasName, FoundDevice.i, FoundUserID.i)
      If RC = 0
        Then Nop
        Else Call ChkError '! Error: Add logonassignment' FoundUserID.i FoundDevice.i RC
    End
 /*
    Say '* Check the share status for' OldAliasName 'on \\'AliasInfo.Server
    RC = NetGetInfo(190, 'ShareInfo', '\\'AliasInfo.Server, AliasInfo.NetName)
    If RC = 0
      Then Do
             Call Logit 'Netname       :' ShareInfo.NetName
             Call Logit 'Type          :' ShareInfo.Type
             Call Logit 'Remark        :' ShareInfo.Remark
             Call Logit 'Max uses      :' ShareInfo.Max_Uses
             Call Logit 'Current uses  :' ShareInfo.Current_Uses
             Call Logit 'Path          :' ShareInfo.Path
             If ShareInfo.Current_Uses = 0       /* if share in use, log it*/
               Then Nop
               Else Do
                      Call Logit '! Warning: Share in use ('ShareInfo.Current_Uses') on \\'AliasInfo.Server AliasInfo.NetName
                      Say '* Press any key to continue' '07'x
                      Pull
                    End
             RC = NetDelete(190, '\\'AliasInfo.Server, AliasInfo.NetName)
             If RC = 0
               Then Do
                      ShareInfo.NetName = NewAliasName
                      RC = NetAdd(190, 'ShareInfo', '\\'AliasInfo.Server)
                      If RC = 0
                        Then Nop
                        Else Call ChkError '! Error: Add share on \\'AliasInfo.Server AliasInfo.NetName RC
                    End
               Else Call ChkError '! Error: Delete share on \\'AliasInfo.Server AliasInfo.NetName RC
           End
      Else Call ChkError '! Error: Share info' AliasInfo.NetName 'on' AliasInfo.Server RC
   */
 QUIT:

    Say '* Log File' LogFileName 'created'

    Exit

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'
    BootDrive = Left(Value('COMSPEC',,'OS2ENVIRONMENT'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = Left(SysSearchPath('PATH', 'NET.EXE'), 2)    /* IBMLAN Drive*/
    If LSRDrive <> ''
      Then Nop
      Else Do
             Say '! Could not determine the Lan Requester path' '07'x
             Exit X2D('1604')
           End

    If Stream(LSRDrive'\ibmlan\netlib\lsrxut.dll', 'C', 'Query Exists') <> ''
      Then Do
             If RxFuncQuery('LoadLSRXUTFuncs')
               Then Do
                      Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
                      Call LoadLsRxutFuncs
                    End
               Else Nop
          /* Say '* LSRXUT.DLL Version' LSRXUTVER() */
           End
      Else Do
             Say '* Could not find' LSRDrive'\IBMLAN\NETLIB\LSRXUT.DLL' '07'x
             Exit
           End

    If Stream(LSRDrive'\ibmlan\netlib\wfrxutil.dll', 'C', 'Query Exists') <> ''
      Then Do
             Call RxFuncAdd 'WfrxLoadFuncs', 'WfrxUtil', 'WfrxLoadFuncs'
             Call WfrxLoadFuncs
           End
      Else Do
             Say '! Could not find' LSRDrive'\IBMLAN\NETLIB\WFRXUTIL.DLL' '07'x
             Exit X2D('0800')
           End

    If Stream(BootDrive'\os2\dll\rxutils.dll', 'C', 'Query Exists') <> ''
      Then Do
             If RxFuncQuery('RxLoadFuncs')
               Then Do
                      Call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
                      Call RxLoadFuncs
                    End
               Else Nop
          /* Say '* RXUTILS.DLL Version' RXUtilsVer() */
             RXUtils = 1
           End
      Else Do
             Say '! Could not find' BootDrive'\os2\dll\rxutils.dll'
             RXUtils = 0
           End

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg ErrorInformation

    Say '07'x
    Call Logit ErrorInformation

    Exit

 LOGIT:/* -------------------------------------------------------------------*/

    Parse Arg LogText

    If Left(LogText, 1) = '!'
      Then Nop
      Else LogText = '-' LogText

    Say LogText
    LogText = Date('E') Time() LogText

    If LineOut(LogFileName, LogText) = 0
      Then Nop
      Else Say '! Error while writing to the log file' '07'x
    Call Stream LogFileName, 'C', 'Close'

    Return

