/*---------------------------------------------------------------------------*\
|  Check HomeDirectories for proper ACL's     (C) Alain Rykaert - MAR96-FEB00 |
\*---------------------------------------------------------------------------*/
    Version = '4.04a (C) AR - FEB2000'
    Say '* LSHOME Version' Version

    Signal On Halt Name Quit

 /*=============================*/
    LogFileName = 'LSHOME.LOG'                             /* LOG File name*/
    DefaultACP = 'RWCXDAP'               /* default ACP for homedirectories*/
 /*=============================*/

    Call Init                                                 /* init dll's*/

    Parse Upper Arg DCName Option              /* option can only be '/FIX'*/
    Parse Var Option '/U:' UserID .
    Parse Var Option '/F' Fix .

    If DCName = ''
      Then Do
             Say '*'
             Say '* Check Home Directories for proper ACLS`s'
             Say '*'
             Say '* Usage: LSHOME DCName {/U:UserID} {/FIX}'
             Say '*'
             Say '* Sample: LSHOME \\DC01'
             Say '*'
             Exit X2D('1600')
           End
      Else Nop

    If Fix = 'IX'                   /* check if the fix option is specified*/
      Then Fix = 1
      Else Fix = 0

    DCName = Strip(DCName,'L','\')

    Say '* Server Name:' '\\'DCName
    Say '* UserID:' UserID
    Say '* FIX:' Fix

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole) > 0     /* check server role*/
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Exit X2D('1600')
                    End
           End
      Else Call ChkError RC

    Counter = ''                                       /* Reset the Counter*/

    If UserID = ''                  /* If no user specified, scan all users*/
      Then Do
             RC = NetEnumerate(280, 'UserID', '\\'DCName)  /* get all users*/
             RC = WfrxUserEnum('\\'DCNAME,'USERID')
             If RC = 0
               Then Do
                      Call RxStemSort 'UserID'            /* sort all users*/
                      Say '* Total Users:' UserID.0
                      Do i = 1 to UserID.0
                        Counter = '('Right(i,Length(UserID.0))'/'Right(UserID.0,Length(UserID.0))')'
                        Call ChkUser UserID.i Counter
                      End
                    End
               Else Call ChkError RC
           End
      Else Do                                        /* If a user specified*/
             RC = NetGetInfo(280, 'UserInfo', '\\'DCName, UserID)
             If RC = 0
               Then Call ChkUser UserID Counter
               Else Call ChkError RC
           End

    If Fix Then Say '* Done, look at the Log File' LogFilename

    Exit X2D('FE00')

 CHKUSER:/* -----------------------------------------------------------------*/

    Parse Arg UserID Counter

    Call NetGetInfo 280, 'UserInfo', '\\'DCName, UserID
    If UserInfo.Home_Dir = '-none-'
      Then Say ' ' Counter Left(UserID,15)                      /* '-none-'*/
      Else Do
             If Left(UserInfo.Home_Dir,2) = '\\'
               Then Do
                      Resource = UserInfo.Home_Dir
                      Drive = '*:'
                    End
               Else Do
                      Parse Var UserInfo.Home_Dir Drive '\' HSName '\' Resource
                      HSName = Strip(HSName,'L','\')
                      Resource = '\\'HSName'\'Resource
                    End
             Say ' ' Counter Left(UserID, 15) Drive '->' Resource

          /* check if dir exist*/
             Call SysFileTree Resource, 'DirExist', 'DO'
             If DirExist.0 = 0
               Then Do
                      Say '! Error: no DIR on' Resource
                      If Fix = 1
                        Then Do
                               CheckDir = Resource
                               Parse Var CheckDir UNCPath '$\' Rest
                               DirPath = UNCPath'$'
                               Do While Rest <> ''
                                 Parse Var Rest Temp '\' Rest
                                 DirPath = DirPath'\'Temp
                                 Call SysFileTree DirPath, 'DirCheck', 'DO'
                                 If DirCheck.0 = 0
                                   Then Do
                                          Text = 'Make Directory' DirPath
                                          Say '09'x Text
                                          If SysMKDir(DirPath) = 0
                                            Then Call Logit Text
                                            Else Do
                                                   Say '! Error:' Text
                                                   Call Logit '! Error:' Text
                                                 End
                                        End
                                   Else Nop
                               End
                             End
                        Else Nop
                    End
               Else Nop

          /* check for proper acl */
             If NetGetInfo(10, 'Access', '\\'HSName, Resource) = 0
               Then Do
                      If Access.Count > 1
                        Then Do
                               Say '! Error: Multiple ACP on' Resource
                               Do j = 1 to Access.Count
                                 Say '09'x Access.j.UgName || ':' || Access.j.Access
                               End
                               If Fix = 1
                                 Then Do
                                        Say '09'x 'Delete & Create a default ACP ? (Y/N)'
                                        If Translate(SysGetKey('NoEcho')) = 'Y'
                                          Then Do
                                                 Call Logit 'Del multiple ACP' Resource
                                                 Call SetHome UserID HSName Resource
                                               End
                                          Else Nop
                                      End
                                 Else Nop
                             End
                        Else Do
                               If Access.1.Access = DefaultACP &,
                                  Access.1.UgName = UserID
                                 Then Nop
                                 Else Do
                                        Say '! Error: mismatch ACP on' Resource Access.1.UgName || ':' || Access.1.Access
                                        If Fix = 1
                                          Then Do
                                                 Call Logit 'Del matcherror ACP' Resource Access.1.UgName || ':' || Access.1.Access
                                                 Call SetHome UserID HSName Resource
                                               End
                                          Else Nop
                                      End
                             End
                    End
               Else Do
                      Say '! Error: no ACP on' Resource
                      If Fix = 1
                        Then Call SetHome UserID HSName Resource
                        Else Nop
                    End
           End
    Return

 SETHOME:/* -----------------------------------------------------------------*/

    Parse Arg UserID ServerName UNCSource

 /* server presence check*/
    RC = NetGetInfo(370, 'ServerModalInfo', '\\'ServerName)
    If RC = 0
      Then Do
          /* Delete */
             LogText = 'Del ACL on' UNCSource
             Say '09'x LogText
             RC = NetDelete(10, '\\'ServerName, UNCSource)
             Call Logit LogText RC

          /* Set */
             ACL.Count    = 1
             ACL.1.Ugname = UserID
             ACL.1.Access = DefaultACP
             LogText = 'Set ACL on' UNCSource ACL.1.UgName || ':' || ACL.1.Access
             Say '09'x LogText
             RC = NetAdd(10, 'ACL', '\\'ServerName, UNCSource)
             If RC = 0
               Then Do
                      Call Logit LogText
                   /* Apply */
                      LogText = 'Apply ACL on' UNCSource
                      Say '09'x LogText
                      RC = NetMisc(520, 'ApplyInfo', '\\'ServerName, UNCSource)
                      If RC = 0
                        Then Call Logit LogText
                        Else Do
                               LogText = '! Error: Apply' ApplyInfo.Error_Buf ApplyInfo.Error_Code
                               Say '!' LogText
                               Call Logit LogText
                             End
                    End
               Else Do
                      Say '!' LogText
                      Call Logit '! Error:' LogText
                    End

           End
      Else Do
             LogText = '! Server not found:' ServerName
             Say LogText '07'x
             Call Logit LogText
           End

    Return

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'
    BootDrive = Left(Value('ComSpec',,'OS2Environment'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = Left(SysSearchPath('PATH', 'NET.EXE'), 2)    /* IBMLAN Drive*/
    If LSRDrive <> ''
      Then Nop
      Else Do
             Say '! Could not determine the Lan Requester path' '07'x
             Exit X2D('1604')
           End

    If Stream(LSRDrive'\ibmlan\netlib\lsrxut.dll', 'C', 'Query Exists') <> ''
      Then Do
             If RxFuncQuery('LoadLSRXUTFuncs')
               Then Do
                      Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
                      Call LoadLsRxutFuncs
                    End
               Else Nop
           End
      Else Do
             Say '! Could not find' LSRDrive'\IBMLAN\NETLIB\LSRXUT.DLL' '07'x
             Exit X2D('0800')
           End

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
             Call RxLoadFuncs
           End
      Else Nop

    If Stream(LSRDrive'\ibmlan\netlib\wfrxutil.dll', 'C', 'Query Exists') <> ''
      Then Do
             Call RxFuncAdd 'WfrxLoadFuncs', 'WfrxUtil', 'WfrxLoadFuncs'
             Call WfrxLoadFuncs
           End
      Else Do
             Say '! Could not find' LSRDrive'\IBMLAN\NETLIB\WFRXUTIL.DLL' '07'x
             Exit X2D('0800')
           End

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg RCode

    Say '! Error:' RCode '07'x
    Exit X2D('1604')

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check '07'x
             Exit X2D('0800')
           End
      Else Nop

    Return

 LOGIT:/* ------------------------------------------------------------------*/

    Parse Arg Log_Text

    Log_Text = Date('E') Time() Log_Text

    Call LineOut LogFileName, Log_Text
    Call Stream LogFileName, 'C', 'Close'

    Return

 QUIT:/* --------------------------------------------------------------------*/

    Say '...Interupted by User...'

    Exit X2D('1604')

