/*---------------------------------------------------------------------------*\
|   Check LAN Server Netlogon Service         (C) Alain Rykaert - APR98-JUN99 |
\*---------------------------------------------------------------------------*/
    Version = '1.02'
    Say '* LSNLCHCK Version' Version

    Signal On Halt Name Quit

    Call Init                                 /* Init dll's and other stuff*/

    LogFileName = 'LSNLCHK.LOG'                          /* Output filename*/
    Say '* Log Filename:' LogFileName

    TempFile = LSRDrive'\ibmlan\lsnlchk.tmp'              /* Temporary file*/

    Parse Upper Arg DCName UserID Option

    If DCName = '' | UserID = ''
      Then Do
             Say '*'
             Say '* LAN Server Netlogon Check'
             Say '*'
             Say '* Usage: LSNLCHK DCName UserID {/PWD}'
             Say '*'
             Say '* Sample: LSNLCHK \\BEDDC01 USER001 /pwd'
             Say '*'
             Exit
           End
      Else Nop

    If Option = '/PWD'              /* check if the fix option is specified*/
      Then PWD = 1
      Else PWD = 0

    DCName = Strip(DCName,'L','\')

    Say '* Server Name:' '\\'DCName
    Say '* UserID:' UserID

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)  /* Get server role*/
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole) > 0
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Exit
                    End
           End
      Else Call ChkError RC

    If PWD = 1              /* if passwordcheck, get the password on the DC*/
      Then Do
            'if not exist \\'DCName'\ibmlan$\netprog\pwdexp.exe copy pwdexp.exe \\'DCName'\ibmlan$\netprog\pwdexp.exe'
            'net admin \\'DCName '/c pwdexp' UserID '>' TempFile
             DCPassword = LineIn(TempFile)
             Call Stream TempFile, 'C', 'Close'
             If Left(DCPassword,6) = 'Error:'
               Then Do
                      Say '!' DCPassword '07'x
                      Exit
                    End
               Else Nop
           End
      Else Nop

    RC = NetGetInfo(340, 'Server', '\\'DCName, 'Servers')/* get all servers*/
    If RC = 0
      Then Do
             Call RxStemSort 'Server'
             Say '* Total defined servers:' Server.0
             Say '* Scanning active servers...'
             Call SysCurState Off
             Parse Value SysCurPos() With Row Col
             j = 0
             Do i = 1 to Server.0           /* get only the 'alive' servers*/
               Call SysCurPos Row -1, 28
               Say ESC'[K' i Server.i
           /*  If Stream('\\'Server.i'\ibmlan$\ibmlan.ini', 'C','Query Exists') <> '' */
               If NetGetInfo(370, 'ServerModalInfo', '\\'Server.i) = 0
                 Then Do
                        j = j + 1
                        ServerName.j = Server.i
                      End
                 Else Nop
             End
           End
      Else Call ChkError RC

    ServerName.0 = j                             /* total of active servers*/

    Do i = 1 to ServerName.0                   /* Reset all status counters*/
      Status.i = ''
    End

    OutText = '* Total active servers:' ServerName.0
    Say OutText
    Call Logit OutText


    Call Time('R')                                       /* reset the timer*/
    UserFound = 0
    PasswordFound = 0
    Loop = 1

    Do While UserFound <> ServerName.0     /* if all servers ok, then leave*/
      Call SysCls
      Say Left('*', 40, '-') 'Loop:' Loop
      Do i = 1 to ServerName.0
        If Status.i = ''
          Then Do
                 If PWD = 1                               /* password check*/
                   Then Do
                         'if not exist \\'ServerName.i'\ibmlan$\netprog\pwdexp.exe copy pwdexp.exe \\'ServerName.i'\ibmlan$\netprog\pwdexp.exe'
                         'net admin \\'ServerName.i '/c pwdexp' UserID '>' TempFile
                          ServerPassword = LineIn(TempFile)
                          Call Stream TempFile, 'C', 'Close'
                          If DCPassword = ServerPassword
                            Then Check = 1
                            Else Check = 0
                        End
                   Else Do                                    /* user check*/
                          If NetGetInfo(280, 'UserInfo', '\\'ServerName.i, UserID) = 0
                            Then Check = 1
                            Else Check = 0
                        End

                 If Check = 1
                   Then Do
                          Status.i = 'OK'
                          UserFound = UserFound + 1
                          Call Beep 2000,50
                          Call Logit Time() Left(ServerName.i,8) Trunc(Time('E'),2)
                        End
                   Else Nop

                 Say '* ServerName:' i Left(ServerName.i,9) Status.i
               End
          Else Nop
      End
      Loop = Loop + 1
      Call SysSleep 1
    End

    Say
    Say '* Total Time:' Trunc(Time('E'),2)

    Exit

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'

    ESC = '1B'x

    BootDrive = Left(Value('Comspec',,'OS2Environment'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = Left(SysSearchPath('PATH', 'NET.EXE'), 2)    /* IBMLAN Drive*/
    If LSRDrive <> ''
      Then Nop
      Else Do
             Say '! Could not determine the Lan Requester path' '07'x
             Exit
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
             Call RxLoadFuncs
           End
      Else Nop

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg RCode

    Say '* Error:' RCode
    Exit

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check
             Exit
           End
      Else Nop

    Return

 LOGIT:/* ------------------------------------------------------------------*/

    Parse Arg Log_Text

    If LineOut(LogFileName, Log_Text) = 0
      Then Call Stream LogFileName, 'C', 'Close'
      Else Say '! Error while writing:' LogFileName '07'x

    Return

 QUIT:/* --------------------------------------------------------------------*/

    Say '...Interupted by User...'

    Exit

