/*---------------------------------------------------------------------------*\
|  Check HomeDirectories for proper ACL's     (C) Alain Rykaert - MAR96-FEB00 |
\*---------------------------------------------------------------------------*/
    Version = '2.02'
    Say '* LSUSERS Version' Version

 /*=============================*/
    MaxLines = 30
 /*=============================*/

    Call Init                                                 /* init dll's*/

    Parse Upper Arg DCName OutFileName

    If DCName = '' | OutFileName = ''
      Then Do
             Say '*'
             Say '* Get LAN Server Users inventory'
             Say '*'
             Say '* Usage: LSUSERS {DCName} {OutputFileName}'
             Say '*'
             Say '* Sample: LSUSERS \\BEDDC01 LSUSERS.TXT'
             Say '*'
             Exit
           End
      Else Nop

    DCName = Strip(DCName,'L','\')

    Say '* Server Name:' '\\'DCName

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole) > 0     /* check server role*/
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Exit
                    End
           End
      Else Call ChkError RC

    Say '* Getting all users from: \\'DCName
 /* RC = NetEnumerate(280, 'UserID', '\\'DCName) */        /* get all users*/
    RC = WfrxUserEnum('\\'DCName,'UserID')
    If RC = 0
      Then Do
            'if exist' OutFileName 'del' OutFileName
             OutText = '***' Date('E') Time() '*** LSUSERS Version:' Version
             Call Logit OutFileName OutText
             Call Logit OutFileName ' '

             Say '* Total defined users:' UserID.0
             Counter = Left('COUNTER', (Length(UserID.0) * 2)+3)
             Banner = Counter            ';',
                      Left('USERID',8)   ';',
                      Left('COMMENT',30) ';',
                      Left('NUM',3)      ';',
                      Left('LOGON',8)    ';',
                      Left('LOGOFF',8)   ';'
             Call Logit OutFileName Banner

             Call RxStemSort 'UserID'                     /* sort all users*/
             Do i = 1 to UserID.0
               Counter = '('Right(i,Length(UserID.0))'/'Right(UserID.0,Length(UserID.0))')'
               If i // MaxLines = 0
                 Then Call Logit OutFileName Banner
                 Else Nop

               Call NetGetInfo 280, 'UserInfo', '\\'DCName, UserID.i

               If UserInfo.Comment = '-none-'
                 Then UserComment = ''
                 Else UserComment = UserInfo.Comment
               If UserInfo.Num_Logons = 'Unknown'
                 Then NumLogons = ''
                 Else NumLogons = UserInfo.Num_Logons
               If UserInfo.Last_Logon = 'Unknown'
                 Then LastLogon = ''
                 Else Do
                        Call GetDate UserInfo.Last_Logon
                        LastLogon = NewDate
                      End
               If UserInfo.Last_Logoff = 'Unknown'
                 Then LastLogoff = ''
                 Else Do
                        Call GetDate UserInfo.Last_Logoff
                        LastLogoff = NewDate
                      End

               OutText = Counter ';',
                         Left(UserID.i, 8)    ';',
                         Left(UserComment,30) ';',
                         Right(NumLogons,3)   ';',
                         Left(LastLogon,8)    ';',
                         Left(LastLogoff,8)   ';'
               Call Logit OutFileName OutText
               Say Counter UserID.i
             End
           End
      Else Call ChkError RC

    Exit

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'
    BootDrive = Left(Value('ComSpec',,'OS2Environment'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = Left(SysSearchPath('PATH', 'NET.EXE'), 2)    /* IBMLAN Drive*/
    If LSRDrive <> ''
      Then Nop
      Else Do
             Say '! Could not determine the Lan Requester path' '07'x
             Exit X2D('1604')
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
             Call RxLoadFuncs
           End
      Else Nop

    If Stream(LSRDrive'\ibmlan\netlib\wfrxutil.dll', 'C', 'Query Exists') <> ''
      Then Do
             Call RxFuncAdd 'WfrxLoadFuncs', 'WfrxUtil', 'WfrxLoadFuncs'
             Call WfrxLoadFuncs
           End
      Else Do
             Say '! Could not find' LSRDrive'\IBMLAN\NETLIB\WFRXUTIL.DLL' '07'x
             Exit X2D('0800')
           End

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg RCode

    Say '! Error:' RCode '07'x
    Exit

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check '07'x
             Exit
           End
      Else Nop

    Return

 LOGIT:/* ------------------------------------------------------------------*/

    Parse Arg Log_File Log_Text

    If LineOut(Log_File, Log_Text) = 0
      Then Call Stream Log_File, 'C', 'Close'
      Else Say '! Error while writing:' Log_File '07'x

    Return

 GETDATE:/* -----------------------------------------------------------------*/

    Parse Arg DateFormat

    DateFormat = Strip(DateFormat,,'0A'x)

    Parse Upper Value DateFormat With WeekDay Month Day Hour Year .

    Select
      When Month = 'JAN'
        Then Month = '01'
      When Month = 'FEB'
        Then Month = '02'
      When Month = 'MAR'
        Then Month = '03'
      When Month = 'APR'
        Then Month = '04'
      When Month = 'MAY'
        Then Month = '05'
      When Month = 'JUN'
        Then Month = '06'
      When Month = 'JUL'
        Then Month = '07'
      When Month = 'AUG'
        Then Month = '08'
      When Month = 'SEP'
        Then Month = '09'
      When Month = 'OCT'
        Then Month = '10'
      When Month = 'NOV'
        Then Month = '11'
      When Month = 'DEC'
        Then Month = '12'
      Otherwise Nop
    End

    NewDate = Year || Month || Right(Day,2,'0')

    Return

