/*---------------------------------------------------------------------------*\
|  Query Printers Settings                    (C) Alain Rykaert - MAR96-DEC97 |
\*---------------------------------------------------------------------------*/
    Version = '1.11'
    Say '* QPRINT Version' Version

 /*========================================================================*/
    ColName.0  = 13                    ; ColLength.0  = ColName.0
    ColName.1  = 'COL'                 ; ColLength.1  = 3
    ColName.2  = 'TITLE'               ; ColLength.2  = 10
    ColName.3  = 'LOCATION'            ; ColLength.3  = 19
    ColName.4  = 'OBJECTID'            ; ColLength.4  = 15
    ColName.5  = 'QUEUENAME'           ; ColLength.5  = 10
    ColName.6  = 'PORTNAME'            ; ColLength.6  = 20
    ColName.7  = 'PRINTDRIVER'         ; ColLength.7  = 35
    ColName.8  = 'SEPARATORFILE'       ; ColLength.8  = 25
    ColName.9  = 'OUTPUTTOFILE'        ; ColLength.9  = 12
    ColName.10 = 'DEFAULTVIEW'         ; ColLength.10 = 11
    ColName.11 = 'JODIALOBEFOREPRINT'  ; ColLength.11 = 18
    ColName.12 = 'QUEUEDRIVER'         ; ColLength.12 = 11
    ColName.13 = 'PRINTWHILESPOOLING'  ; ColLength.13 = 18

    PrinterFolderObject = '<WP_PRINTERSFOLDER>'
    PrintwhileSpooling  = 'YES'                     /* specify your default*/
 /*========================================================================*/

    Call Init                                 /* init DLL's and other stuff*/

    Parse Upper Arg ServerName

    If ServerName = ''
      Then Do
             Say '*'
             Say '* Usage: QPRINT {*} {ServerName}'
             Say '*'
             Say '* Sample: QPRINT \\BEDDC2'
             Say '*'
             Exit X2D('1600')
           End
      Else Nop

    If ServerName = '*'
      Then Do
             RC = NetGetInfo(350, 'WKSTAINFO','')
             If RC = 0
               Then ServerName = WkstaInfo.ComputerName
               Else Call ChkError RC
           End
      Else ServerName = ServerName

    ServerName = Strip(ServerName,'L','\')

    Say '* Server Name:' '\\'ServerName

    Say '* Getting all queues on \\'ServerName

    Title = ''                                           /* Building banner*/
    Do i = 1 to ColName.0
      Title = Title || Left(ColName.i, ColLength.i) || ';'
    End
    Say Title

    RC = RxSplEnumQueue('\\'ServerName, Queues)   /* get queues from server*/
    If RC = 0
      Then Nop
      Else Call ChkError RC

    If Queues.Count > 0                        /* if a queue exist continue*/
     Then Do i = 1 to Queues.Count
            Queues.i.Name = Translate(Queues.i.Name)
            Call RxSplQueryDevice '\\'ServerName, Details, Queues.i.Printers

            If Pos(',', Details.Drivers) > 0  /* check for multiple drivers*/
              Then Do
                     PrintDrivers = Details.Drivers
                     j = 0
                     Do While PrintDrivers <> ''
                       j = j + 1
                       Parse Value PrintDrivers With PrintDriver.j ',' PrintDrivers
                     End
                     PrintDriver.0 = j
                   End
              Else Do
                     PrintDriver.0 = 1
                     PrintDriver.1 = Strip(Details.Drivers)
                   End

            If Queues.i.Sepfile = 'No separator file'
              Then Queues.i.Sepfile = ''       /* check for empty separator*/
              Else Nop

            Say Left('',                       ColLength.1)  || ';' ||,
                Left(Queues.i.Name,            ColLength.2)  || ';' ||,
                Left(PrinterFolderObject,      ColLength.3)  || ';' ||,
                Left('<WPPO_'Queues.i.Name'>', ColLength.4)  || ';' ||,
                Left(Queues.i.Name,            ColLength.5)  || ';' ||,
                Left(Details.LogAddr,          ColLength.6)  || ';' ||,
                Left(PrintDriver.1,            ColLength.7)  || ';' ||,
                Left(Queues.i.SepFile,         ColLength.8)  || ';' ||,
                Left('NO',                     ColLength.9)  || ';' ||,
                Left('ICON',                   ColLength.10) || ';' ||,
                Left('NO',                     ColLength.11) || ';' ||,
                Left('PMPRINT',                ColLength.12) || ';' ||,
                Left(PrintwhileSpooling,       ColLength.13)

                If PrintDriver.0 > 0       /* if multiple drivers installed*/
                  Then Do j = 2 to PrintDriver.0
                         Say Left('*', ColLength.1) || ';',
                             Left('', 2+ColLength.2+ColLength.3+ColLength.4+ColLength.5+ColLength.6),
                             ';' || PrintDriver.j
                       End
                  Else Nop

          End
      Else Say '  -none-'

    Exit X2D('FE00')

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'
    ESC = '1B'x
    BootDrive = Left(Value('COMSPEC',,'OS2ENVIRONMENT'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    PPath = Value('PATH',,'OS2ENVIRONMENT')
    Do While PPath <> ''
      Parse Upper Value PPath With Begin ';' PPath
      If SubStr(Begin,4) = 'IBMLAN\NETPROG'
        Then LSRDrive = Left(Begin,2)
        Else Nop
    End

    If Stream(LSRDrive'\ibmlan\netlib\lsrxut.dll', 'C', 'Query Exists') <> ''
      Then Do
             If RxFuncQuery('LoadLSRXUTFuncs')
               Then Do
                      Call RxFuncAdd LoadLsRxutFuncs, LSRxut, LoadLsRxutFuncs
                      Call LoadLsRxutFuncs
                    End
               Else Nop
           End
      Else Do
             Say '* Could not find:' LSRDrive'\IBMLAN\NETLIB\LSRXUT.DLL' '07'x
             Exit X2D('0800')
           End

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg RCode

    Say '* Error:' RCode
    Exit X2D('1600')

    Return

