/*---------------------------------------------------------------------------*\
|   Query Server info from all LAN Servers into the Domain                    |
|                                             (C) Alain Rykaert - JUN96-AUG99 |
\*---------------------------------------------------------------------------*/
    Version = '4.06'
    Say '* QSRVRS Version:' Version

    Parse Upper Arg DCName

    Call Init                    /* Initialisation of DLL's and other stuff*/

    TempFile = LSRDrive'\ibmlan\qsrvrs.tmp'               /* Temporary file*/

    If DCName = ''
      Then Do
             Say '*'
             Say '* Query all servers'
             Say '*'
             Say '* Usage: QSRVRS {ServerName}'
             Say '*'
             Say '* Sample: QSRVRS \\DC01'
             Say '*'
             Exit
           End
      Else Nop

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'DCName)
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole) > 0     /* check server role*/
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Exit
                    End
           End
      Else Call ChkError RC

 /* Get the Domain name from the DC-PR */
    Call SysFileSearch 'DOMAIN =', '\\'DCName'\ibmlan$\ibmlan.ini', 'File.'
    If File.0 > 0
      Then Do i = 1 to File.0
             If Pos(';', File.i) > 0
               Then Nop
               Else Parse Upper Value File.i With . '=' DomainName .
           End
       Else Do
              Say '! Unable to determine the Domain name' '07'x
              Say '! from the Primary Domain Controller' DCName
              Say '  (or not logon as an Administrator)'
              Say '* Press any key to Exit'
              Pull
              Exit
           End
    Say '> The name of the Domain is:' DomainName

   'if not exist' Directory()'\'DomainName 'md' Directory()'\'DomainName
    Call MakeObjects                         /* make a folder of the domain*/

    Say '* Done. Press any key to Exit'
    Pull

    Exit

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'

    BootDrive = Left(Value('Comspec',,'OS2Environment'),2)

    Redir = '>nul'

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = Left(SysSearchPath('PATH', 'NET.EXE'), 2)    /* IBMLAN Drive*/
    If LSRDrive <> ''
      Then Nop
      Else Do
             Say '! Could not determine the Lan Requester path' '07'x
             Exit X2D('1604')
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
             Call LoadLsRxutFuncs
           End
      Else Nop

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File

    If Stream(File, 'C', 'Query Exists') = ''
    Then Do
           Say '! File not found:' File '07'x
           Say '* Press any key to Exit'
           Exit
        End
    Else Nop

    Return

 MAKEOBJECTS:/* -------------------------------------------------------------*/

    Class    = 'WPFolder'
    Title    =  DomainName
    Location = '<LSMT_SERVERS>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'>;' ||,
               'ICONVIEW=FLOWED;'                      ||,
               'ICONVIEWPOS=40,20,55,65;'              ||,
               'ICONFONT=10.System VIO;'               ||,
               'ICONFILE='Directory()'\domain.ico;'    ||,
               'ALWAYSSORT=Yes'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '#Refresh all^ Server folders'
    Location = '<LSMT_SERVERS_'DomainName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_'ServerName'_REFRESH>;' ||,
               'ICONFILE='Directory()'\tsadmin.ico;'                        ||,
               'PROGTYPE=vio;'                                              ||,
               'EXENAME='Directory()'\refresh.cmd;'                         ||,
               'PARAMETERS=[Enter the name of a PR-DC]'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '*Hardware^ Get'
    Location = '<LSMT_SERVERS_'DomainName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_GET_LSGETHW>;' ||,
               'ICONFILE='Directory()'\qsystem.ico;'               ||,
               'EXENAME='Directory()'\lsgethw.cmd;'                ||,
               'PARAMETERS=[Enter the name of a PR-DC]' Directory()'\'DomainName'\lsgethw.csv'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '*Hardware^ Edit'
    Location = '<LSMT_SERVERS_'DomainName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_EDIT_LSGETHW>;' ||,
               'ICONFILE='Directory()'\qsystem.ico;'                ||,
               'PROGTYPE=pm.exe;'                                   ||,
               'EXENAME=e.exe;'                                     ||,
               'PARAMETERS='Directory()'\'DomainName'\lsgethw.csv'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '*Syslevel^ Get'
    Location = '<LSMT_SERVERS_'DomainName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_GET_LSSYSLVL>;' ||,
               'ICONFILE='Directory()'\ddnsscfo.ico;'               ||,
               'PROGTYPE=windowablevio;'                            ||,
               'EXENAME='Directory()'\lssyslvl.cmd;'                ||,
               'PARAMETERS=[Enter the name of a PR-DC]' Directory()'\'DomainName'\lssyslvl.csv'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '*Syslevel^ Edit'
    Location = '<LSMT_SERVERS_'DomainName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_EDIT_LSSYSLVL>;' ||,
               'ICONFILE='Directory()'\ddnsscfo.ico;'                ||,
               'PROGTYPE=pm.exe;'                                    ||,
               'EXENAME=e.exe;'                                      ||,
               'PARAMETERS='Directory()'\'DomainName'\lssyslvl.csv'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '*LS Parameters^ Get'
    Location = '<LSMT_SERVERS_'DomainName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_GET_LSBROWSE>;' ||,
               'ICONFILE='Directory()'\svcreq.ico;'                 ||,
               'PROGTYPE=windowablevio;'                            ||,
               'EXENAME='Directory()'\lsbrowse.cmd;'                ||,
               'PARAMETERS=[Enter the name of a PR-DC]' Directory()'\'DomainName'\lsbrowse.csv'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '*LS Parameters^ Edit'
    Location = '<LSMT_SERVERS_'DomainName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_EDIT_LSBROWSE>;' ||,
               'ICONFILE='Directory()'\svcreq.ico;'                  ||,
               'PROGTYPE=pm.exe;'                                    ||,
               'EXENAME=e.exe;'                                      ||,
               'PARAMETERS='Directory()'\'DomainName'\lsbrowse.csv'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '*Configuration^ Get'
    Location = '<LSMT_SERVERS_'DomainName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_GET_LSCONFIG>;' ||,
               'ICONFILE='Directory()'\compsys.ico;'                ||,
               'PROGTYPE=windowablevio;'                            ||,
               'EXENAME='Directory()'\lsconfig.cmd;'                ||,
               'PARAMETERS=[Enter the name of a PR-DC]' Directory()'\'DomainName'\lsconfig.csv'
    Update   = 'Update'
    Call CreateObj

    Class    = 'WPProgram'
    Title    = '*Configuration^ Edit'
    Location = '<LSMT_SERVERS_'DomainName'>'
    Setup    = 'OBJECTID=<LSMT_SERVERS_'DomainName'_EDIT_LSCONFIG>;' ||,
               'ICONFILE='Directory()'\compsys.ico;'                 ||,
               'PROGTYPE=pm.exe;'                                    ||,
               'EXENAME=e.exe;'                                      ||,
               'PARAMETERS='Directory()'\'DomainName'\lsconfig.csv'
    Update   = 'Update'
    Call CreateObj

    Return

 CREATEOBJ:/* ---------------------------------------------------------------*/

    Say '> Creating Object:' Title

    If SysCreateObject(Class, Title, Location, Setup, Update) = 1
      Then Nop
      Else Say '! Error: while creating Object' Title '07'x

    Parse Value Setup With 'OBJECTID=' ObjectID ';' .
    Call SysSetObjectData ObjectID, 'Title='Title

    Return

