/*---------------------------------------------------------------------------*\
|  Register all the LSRXUT.DLL Functions      (C) Alain Rykaert - DEC95-OCT96 |
|                                                                 FEB2000     |
\*---------------------------------------------------------------------------*/

    Parse Upper Arg Option .

    Call ChkDll                                    /* Check for correct DLL*/

    If Strip(Translate(Option)) = '/M'
      Then Mute = 1
      Else Mute = 0

    Result_Query = RxFuncQuery('LoadLSRXUTFuncs')
    If Result_Query = 0
      Then Do
             If \Mute Then Say '*** OK, LSRXUT was registered. ***'
           End
      Else Do
             Result_Add = RxFuncAdd('LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs')
             If Result_Add = 0
               Then Do
                      If \MUTE Then Say '*** OK, LSRXUT is registered. ***'
                      Signal On Syntax Name Load_Check
                      Call LoadLsRxutFuncs
                      Load_Check:        /* RC of 43 means LSRXUT not found*/
                      If RC = 43
                        Then Do
                               Say '*** ERROR: Not able to load the LSRXUT. '
                               Say '    Perhaps REXX not installed'
                               say '    or LSRXUT.DLL not found in a LIBPATH drive/directory.'
                              '@Pause'
                             End
                        Else Nop
                      Signal Off Syntax
                    End
               Else Do
                      Say '*** ERROR: LSRXUT registration has failed. ***'
                     '@Pause'
                    End
           End

    Call RxFuncAdd 'WfrxLoadFuncs', 'WfrxUtil', 'WfrxLoadFuncs'
    Call WfrxLoadFuncs

    If \Mute Then Say '0A0D'X ' LSRXUT.DLL Version' LsRxUtVer()

    Exit

 CHKDLL:/* ------------------------------------------------------------------*/

    LsrDrive = Left(SysSearchPath('PATH', 'NET.EXE'), 2)    /* IBMLAN Drive*/

    If LsrDrive = ''
      Then Do
             Say ' Unable to determine the OS/2 Boot Drive'
             Say ' or the OS/2 Lan Requester Drive.'
             Exit
           End

    REQ_CSD = SubStr(LineIn(LsrDrive'\ibmlan\syslevel.req'),48,1)
    Call Stream lsrdrive'\ibmlan\syslevel.req', 'C', 'Close'

    If REQ_CSD = '7'
      Then Call Compit 'lsrxut.30' LsrDrive'\ibmlan\netlib\lsrxut.dll'
      Else Call Compit 'lsrxut.40' LsrDrive'\ibmlan\netlib\lsrxut.dll'

    Call Compit 'wfrxutil.dll' LsrDrive'\ibmlan\netlib\wfrxutil.dll'

    Return

 COMPIT:/* ------------------------------------------------------------------*/

    Parse Arg Source Target

    If Source = '' | Target = ''
      Then Do
             Call Beep 500,200
             Return
           End

    Q1 = Stream(Source, 'C', 'Query Exists')
    If Q1 <> ''
      Then Do
             Q1 = Stream(Source, 'C', 'Query DateTime')
             Q2 = Stream(Target, 'C', 'Query DateTime')
             If Q1 \= Q2
               Then Do
                     '@copy' Source Target
                      If RC <> 0
                        Then Do
                               Call Beep 500,200
                               Say ' Copy Error :' RC
                               Exit
                             End
                        Else Nop
                    End
               Else Nop
          End
      Else Nop

    Return

