/*---------------------------------------------------------------------------*\
|   SET all Logon Assignments to a LAN Server 3.0 and higher                  |
|   from an ASCII file                                                        |
|       (C) Alain Rykaert IBM Belgium & Hermann Pauli IBM Germany SEP95-MAY96 |
\*---------------------------------------------------------------------------*/

    Parse Arg Option

    Call INIT                     /* Initalisation of DLL's and other stuff*/
    Call CHKOPT                          /* Check Options & display Welcome*/
    Call CHKPWS                               /* Check the PWS & Admin name*/
    Call MAIN                                            /* do the main job*/
    Call QUIT                                                       /* Quit*/

 MAIN:/* ------------------------------------------------------ MAIN: -------*/

    Call Time('R')
   'if exist' CHKF 'del' CHKF
    EC = 0
    ExitCode = X2D('FE00')                          /* Good CID Return code*/

    do while Lines(INPF)
       LLINE = TRANSLATE(LineIN(INPF))
       OLINE = LLINE
       LLINE = Strip(LLINE)

       parse value LLINE with OPT ';' LLINE
       select
        when OPT = '' | LLINE = ''    then Iterate
        when Left(OPT,1)      = '*'   then Iterate
        when Translate(OPT)   = 'OPT' then Call COLUMNS
        when Translate(OPT)   = 'D'   then Call DELASS
        when Translate(OPT)   = 'U'   |,
             Translate(OPT)   = 'A'   then Call UPDASS
        otherwise
         do
            call ToCheck
            call Logit 'Main','wrong input allowed options only U and D.',,
                              'Invalid option' OPT
         end
       end
       if EC
        then do
                call ToCheck
                EC = 0
                ExitCode = X2D('1604')               /* Bad CID return code*/
             end
        else Nop
    end

    say ;say '0909'x 'Total Time  =' Trunc(Time('E'),2)

    Return

 UPDASS:/* ---------------------------------------------------- UPDASS: -----*/

    EC = 0

    /*   get the users new logon assignment values */
    parse value LLINE with UserId ';' LLINE
    UserId = Strip(UserId)

    i = 0

    /* scan through input line to retrieve new device assignments         */
    AssNum = 0

    Assign_Set. = 0
    do while LLine <> ''
       i = i+1
       AliasName = AliasByCol.i
       parse value LLINE with ActDevice ';' LLINE
       ActDevice = strip(ActDevice)
       if ActDevice <> ''
       then do    /* there is an assignment */
               AssNum = AssNum + 1
               Assign.AssNum.Alias  = AliasName
               Assign.AssNum.Device = ActDevice
               Assign_Set.AliasName = 1
            end
       else nop
    end

    Assign.0 = AssNum

    /* Check for multiple entries for the same device */
    do i = 1 to Assign.0
       do j = i+1 to Assign.0
          if Assign.i.device = Assign.j.device
          then do
                  EC = 1
                  Call LOGIT 'Update LA' , 'wrong input',,
                             'may use' Assign.i.device 'only once'
                return
               end
          else nop
       end
    end



    say '0909'x 'Updating User ...' UserId

    /*   get the users old logon assignment values */
    O_Device. = ''

    RC = NetGetInfo(NETLOGONASN, 'OldAssgn', '\\'SRVNAME, UserID)
    if RC = 0
     then do
             do i = 1 to OldAssgn.count
                AliasName = OldAssgn.i.Alias
                O_Device.AliasName =Strip(OldAssgn.i.Device)
             end
          end

     else if left(strip(RC),1) = 3
           then OldAssgn.count = 0      /* no previous assignments */
           else do
                   EC = 1
                   Call LOGIT 'NetGetInfo LA' , UserID , RC
                   return
                end

    /*  del all existing assignments                */
    if OldAssgn.count >0
     then do
             RC = NetDelete(NETLOGONASN, '\\'SRVNAME, UserID)
             if RC = 0
              then nop
              else do
                      EC = 1
                      Call LOGIT 'NetDelete LA' , UserID , RC
                     return
                   end
          end
      else nop

    /*  log deleted assignments                   */
    do i = 1 to OldAssgn.count
       AliasName = OldAssgn.i.alias
       if Assign_Set.AliasName
        then iterate
        else do
                Call LOGIT 'Delete LA' ,,
                           UserID AliasName '-' O_Device.AliasName ,''
             end
    end


    /*  add all assignments                       */
    do i = 1 to Assign.0
       AliasName = Assign.i.Alias
       RC = NetAdd(NETLOGONASN, '\\'SRVNAME, AliasName, Assign.i.device,,
                   UserID)
       if RC = 0
          then do
                  RC = 'OK'

                  if O_Device.AliasName = ''
                   then Call LOGIT 'Add LA' ,,
                             UserID AliasName '-' Assign.i.device , ''
                   else if Assign.i.device <> O_Device.AliasName
                         then Call LOGIT 'Update LA' ,,
                              UserID AliasName '-' Assign.i.device , ''
                         else nop
               end
          else do
                  EC = 1
                  Call LOGIT 'NetAdd LA' , UserID ||'/'|| AliasName , RC
                  return
               end
    end
    Return

 ToCheck: /*--------------------------------------------------- ToCheck: ----*/

    CHKLines = CHKLines + 1
    if CHKLines = 1 | CHKLines // 20 = 0
     then call LineOut CHKF, ALIASLst
     else nop
    Call LineOut CHKF, OLINE
    return

 DELASS: /*---------------------------------------------------- UPDASS: -----*/

    EC = 0
    i  = 0

    parse value LLINE with UserId ';' LLINE
    UserId = Strip(UserId)

    say '0909'x 'Updating User ...' UserId

    /*  del all logon assignments                   */
    RC = NetDelete(NETLOGONASN, '\\'SRVNAME, UserID)

    if RC = 0
       then do
               RC = 'OK'
               Call LOGIT 'Delete LA' , UserID '- all' , ''
            end
       else do
               EC = 1
               Call LOGIT 'NetDelete LA' , UserID , RC
               return
            end

    Return

 COLUMNS: /*--------------------------------------------------- COLUMNS: ----*/

    ALIASLst = OPT || ';' || LLINE
    parse value LLINE with UserId ';' LLINE

    i = 0
    do while LLine <> ''
       i = i+1
       parse value LLINE with AliasByCol.i ';' LLINE
       AliasByCol.i = strip(AliasByCol.i)
    end
    AliasByCol.0 = i /* AliasByCol.: Alias-Name retrieveable via col number */

    Return


 CHKOPT: /*---------------------------------------------------- CHKOPT: -----*/

    SRVNAME = '';
    INPF    = 'ASSGN.CSV';
    LOGF    = 'LSMT.LOG';
    CHKF    = 'ASSGN.CHK';
    PIPE    = '';
    TRACE   = 0;
    MUTE    = 0;

    OPTION = Translate(OPTION)
    do while OPTION <> ''
       Parse value OPTION with ARGUMENT ' ' OPTION
       select
        when Left(ARGUMENT,5) = '/SRV:' then SRVNAME = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/INP:' then INPF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/LOG:' then LOGF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/CHK:' then CHKF    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/PIP:' then PIPE    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,2) = '/M'    then MUTE    = 1
        when Left(ARGUMENT,2) = '/T'    then TRACE   = 1
        otherwise Nop
       end
    end

    if SRVNAME = '' then signal GETHELP

    if \MUTE
     then do
             Topic1='SETWELCOME'
             Topic_String.Topic1.1=SRVNAME;
             Topic_String.Topic1.2=INPF;
             Topic_String.Topic1.3=LOGF;
             Topic_String.Topic1.4=CHKF;
             Topic_String.Topic1.5=PIPE' ';
             Topic_List='WELCOMELOGO' Topic1 'SETASSGN';
             Call GETANS
             Parse VALUE SysCurPos() With Old_R Old_C; '@pause'
             Call SysCurPos Old_R, Old_C; say ESC'[K'
          end
     else do
             say 'ServerName =' SRVNAME
             say 'InputFile  =' INPF
             say 'LogFile    =' LOGF
             say 'CheckFile  =' CHKF
          end

    Return

 CHKPWS: /*---------------------------------------------------- CHKPWS: -----*/

    RC = NetGetInfo(350, 'WKSTAINFO','')
    if RC = 0
     then do
             ADMNAME = WKSTAINFO.UserName
             PWSNAME = WKSTAINFO.ComputerName
          end
     else do
            Call LOGIT 'Get PWS Info', ,RC
            Call Quit
          end
    Return

 INIT: /*------------------------------------------------------ INIT: -------*/

    Call RgUtil   '/m' /* Rexx Utilities        */
    Call RgUtils  '/m' /* Rexx Utilities        */
    Call RgLSRXUT '/m' /* Lan Server Rexx Utils */

    Parse Upper Source . . P_NAME
    PRGN = Filespec('N', Left(P_NAME, Length(P_NAME) -4))

   '@echo off'
    ESC   = '1B'x
    REDIR = '>NUL 2>NUL'

    NETLOGONASN = 52
    NETALIAS    = 20
    EC  = 0
    CHKLines = 0

    COLF  = 'USERS.INI'          /* Column description file */
    Call CHKFILE COLF

    Resource_File = 'LSMT.RSC'
    Call CHKFILE Resource_File

    Return

 GETANS: /*---------------------------------------------------- GETANS: -----*/

    Vars_List =Ansi_Say(Resource_File Topic_List);
    Parse VALUE SysCurPos() With Old_R Old_C;
    Do While Vars_List <> '';
       Parse VALUE Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List;
       Call SysCurPos Row, Column;
       Say x2c(Color) || Topic_String.Topic_Id.Var_Id || '1B'x || '[0m';
       End;
    Call SysCurPos Old_R, Old_C;

    Return

 GETHELP: /*--------------------------------------------------- GETHELP: ----*/

    if \MUTE
     then do
             Topic1='SETHELP'
             Topic_String.Topic1.1=PRGN;
             Topic_List=Topic1;
             Call GETANS
          end
     else say 'Incorrect options.'

    Call QUIT

    Return

 CHKFILE: /*--------------------------------------------------- CHKFILE: ----*/

    Parse Arg FILE
    RC = Stream(FILE, 'C', 'QUERY EXIST')
    if RC = ''
     then do
             say ' File' FILE 'not found.'
             Call QUIT
          end
     else Nop
    Call Stream FILE, 'C', 'CLOSE'

    Return

 LOGIT: /*----------------------------------------------------- LOGIT: ------*/

    FUNC = ARG(1); INFO = ARG(2); RCOD = ARG(3)
    RC = LLOGIT(LOGF, PIPE, ADMNAME, PRGN, FUNC, INFO, RCOD)

    Return

 QUIT: /*------------------------------------------------------ QUIT: -------*/

    Call LineOut 'LSMT.END', PRGN, 1
    Call Stream  'LSMT.END', 'C', 'CLOSE'
    Call Stream   INPF,      'C', 'CLOSE'
    Call Stream   LOGF,      'C', 'CLOSE'
    Call Stream   CHKF,      'C', 'CLOSE'
    Exit ExitCode

 /*--------------------------------------------------------------------------*/
