/*---------------------------------------------------------------------------*\
|   SET all or some changes back to the Domain Controller by Drag & Drop      |
|                                                                             |
|                                               (C) Alain Rykaert MAY96-AUG98 |
\*---------------------------------------------------------------------------*/
    Version = '1.03'

    Parse Upper Arg Mute ServerName InputName

    Say '* GetCMD Version' Version
    Say '* ServerName:' ServerName
    Say '* InputName:' InputName

    Call Init                    /* Initialisation of DLL's and other stuff*/

    Call ChkFile Directory()'\popup.exe'   /* Check for Message Box program*/

    Select
      When ServerName = ''
        Then Do
              'Start Popup "You must enter a ComputerName of a DC" "LSMT Message"'
               Exit
             End
      When InputName = ''
        Then Do
              'Start Popup "Just Drag & Drop an Output file on me" "LSMT Message"'
               Exit
             End
      Otherwise Nop
    End

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'ServerName)
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             Say '* Role:' ServerRole
             If WordPos('Primary', ServerRole) > 0     /* check server role*/
               Then Do
                      Call SysFileSearch 'DOMAIN =', '\\'ServerName'\ibmlan$\ibmlan.ini', 'FILE.'
                      If File.0 > 0
                        Then Do j = 1 to File.0
                               Parse Value File.j with Begin '=' Rest .
                               If Left(Begin,1) = ';'
                                 Then Nop
                                 Else DomainName = Rest
                             End
                        Else Do
                               Say '! Error: Unable to determine the Domains name'
                               Say'          from the Primary Domain Controller' ServerName
                              'Start popup "Could not find the domain name" "LSMT Message"'
                               Call Quit
                             End
                    End
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                     'Start popup "This is not a Primary Domain Controller" "LSMT Message"'
                      Call Quit
                    End
           End
      Else Do
             Say '! Error:' RC '07'x
            'Start popup "Error:' RC 'from Server' ServerName'" "LSMT Message"'
             Call Quit
           End

    Call Main                                          /* Do the main thing*/

    Call Quit                                         /* Quit the procedure*/

 MAIN:/* --------------------------------------------------------------------*/

    InputName = Translate(InputName)

 /* Determine the Filename.Extension */

    TempName = InputName

    x = LastPos('\', InputName) + 1
    FileName = SubStr(InputName, x)

 /* Select & start the associated program */

    Select

     When FileName = 'SERVERS.CSV'
       Then Do
              Say '* Setting all Servers to' ServerName
             'Call SetSrvs /m /srv:'ServerName '/inp:'InputName '/log:'CurDir'\lsmt.log'
            End

     When FileName = 'USERS.CSV'
       Then Do
              Say '* Setting all Users to' ServerName
             'Call SetUsers /m /srv:'ServerName '/inp:'InputName '/log:'CurDir'\lsmt.log /HOM:'CurDir'\HomeACL.CSV'
              Call MakeShadow CurDir'\HOMEACL.CSV' '<LSMT_DCDB_'DomainName'>'
            End

     When FileName = 'GROUPS1.CSV'
       Then Do
              Say '* Setting all Groups to' ServerName
             'Call SetGrps1 /m /srv:'ServerName '/inp:'InputName '/log:'CurDir'\lsmt.log'
            End

     When FileName = 'GROUPS2.CSV'
       Then Do
              Say '* Setting all Groups & Memebers to' ServerName
             'Call SetGrps2 /m /srv:'ServerName '/inp:'InputName '/log:'CurDir'\lsmt.log'
            End

     When FileName = 'ALIAS.CSV'
       Then Do
              Say '* Setting all Aliases to' ServerName
             'Call SetAlias /m /srv:'ServerName '/inp:'InputName '/log:'CurDir'\lsmt.log'
            End

     When FileName = 'ACL.CSV'
       Then Do
              Say '* Setting all Access Control List to' ServerName
             'Call SetAcl /m /srv:'ServerName '/inp:'InputName '/log:'CurDir'\lsmt.log'
            End

     When FileName = 'ASSGN.CSV'
       Then Do
              Say '* Setting all Logon Assignments to' ServerName
             'Call SetAssgn /m /srv:'ServerName '/inp:'InputName '/log:'CurDir'\lsmt.log'
            End

     When FileName = 'APPL.CSV'
       Then Do
              Say '* Setting all Applications to' ServerName
             'Call SetAppl /m /srv:'ServerName '/inp:'InputName '/log:'CurDir'\lsmt.log'
            End

     When FileName = 'SELECTOR.CSV'
       Then Do
              Say '* Setting all Application Selectors to' ServerName
             'Call SetSel /m /srv:'ServerName '/inp:'InputName '/log:'CurDir'\lsmt.log'
            End

     When FileName = 'USERS.PWD'
       Then Do
              Say '* Setting all Users Passwords to' ServerName
             'Call SetPwd /m /srv:'ServerName '/inp:'InputName '/log:'CurDir'\lsmt.log'
            End

     When FileName = 'HOMEACL.CSV'
       Then Do
              Say '* Setting all needed ACP'
             'Call SetHome /m /srv:'ServerName '/inp:'InputName '/log:'CurDir'\lsmt.log'
            End

     Otherwise Say '* Nothing To Do'

    End

    Return

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'

    CurDir = Directory()                 /* Determine the current directory*/

    If Stream('RGUTIL.CMD', 'C', 'Query Exists') = ''
      Then 'cd..'
      Else Nop

    Call RgUtil   '/M'                                    /* Rexx Utilities*/
    Call RgLSRXUT '/M'                             /* Lan Server Rexx Utils*/

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg FileName

    If Stream(FileName, 'C', 'Query Exist') = 0
      Then Do
             Say ' File' FileName 'not found.'
             Exit
           End
      Else Nop

    Return

 MAKESHADOW:/* --------------------------------------------------------------*/

    Parse Arg InputFile Location

    RC = Stream(InputFile, 'C', 'Query Exists')
    If RC = ''
      Then Nop
      Else Do
             Class    = 'WPSHADOW'
             Title    = 'HOMEACL.CSV'
             Location =  Location
             Setup    = 'SHADOWID='InputFile
             Update   = 'Update'
             Call CreateOBJ
           End

    Return

 CREATEOBJ:/* ---------------------------------------------------------------*/

    If SysCreateObject(Class, Title, Location, Setup, Update) = 1
      Then Nop
      Else Say '! Error: while making a shadow' RC Title '07'x

    Return

 QUIT:/* --------------------------------------------------------------------*/

    Say
    Say '* Done. Press the [Enter] key to leave'

    Pull

    Exit

