#define  INCL_DOSMODULEMGR
#include "config.h"
#include <conio.h>
#include "syshead.h"
#include "buffer.h"
#include "error.h"
#include "mtu.h"
#include "sig.h"
#include "memdbg.h"

int
os2_signal_get (void)
{
  int ret = 0;
  int code = 0;

  if (siginfo_static.signal_received)
    {
      ret = siginfo_static.signal_received;
    }
  else
    {
     if ( kbhit() )
        {
        printf ( "Get signal\n");
        code = getch();
	  switch (code )
	    {
	    case 0x3B: /* F1 -> USR1 */
	    case 0x31: /* 1 -> USR1 */
	      ret = SIGUSR1;
	      break;
	    case 0x3C: /* F2 -> USR2 */
	    case 0x32: /* 2 -> USR2 */
	      ret = SIGUSR2;
	      break;
	    case 0x3D: /* F3 -> HUP */
	    case 0x33: /* 3 -> HUP */
	      ret = SIGHUP;
	      break;
	    case 0x3E: /* F4 -> TERM */
	    case 0x34: /* 4 -> TERM */
	      ret = SIGTERM;
	      break;
           default:
             printf("Unknown keyboard code %x\n",code);
	    }
	}
      if (ret)
	{
	  siginfo_static.signal_received = ret;
	  siginfo_static.hard = true;
	}
    }
  return ret;
}

PFN  GetProcAddress (HMODULE module, const char *symbol)
{
APIRET rc;
PFN   FunAddr;

  rc = DosQueryProcAddr ( module, strlen(symbol), symbol, &FunAddr);
  if ( rc )
      return NULL;
  else
      return FunAddr;
}
HMODULE LoadLibrary (const char *symbol)
{
APIRET rc;
HMODULE Mod;
UCHAR   LoadError[256];

   rc = DosLoadModule ( LoadError, sizeof(LoadError),symbol,&Mod);
   if ( rc )
      return NULL;
   else
      return Mod;
}
ULONG FreeLibrary (HMODULE mod)
{
APIRET rc;

   rc = DosFreeModule ( mod );

return rc;
}
/* get password from console */

char *
getpass (const char *prompt)
{
/*
  static char line[256];
  if (get_console_input_win32 (prompt, false, line, sizeof (line)))
    return line;
  else
*/
    return NULL;
}
