/* REXX */

/*
 *  File    :  TS_STATUS
 *  Purpose :  Display the Tunnel Slave status
 *
 *
 *  Modification History:
 *
 *  --Date--- --By-- --Reason------------------------------------------------
 *  1997.06.12     TAB   Created script
 *
 */


/* */

PARSE ARG stanza item value
PARSE UPPER VAR stanza stanza
PARSE UPPER VAR item   item
app = 'TS_SET'

/* settings */

item.0  = 16
item.1  = 'MODEM   PHONE_NO'

item.2  = 'DNS     HOSTNAME'
item.3  = 'DNS     ADDRESS'
item.4  = 'DNS     DOMAIN'

item.5  = 'TM      HOSTNAME'
item.6  = 'TM      ADDRESS'
item.7  = 'TM      INTERFACE'
item.8  = 'TM      NETMASK'
item.9  = 'TM      PASSWORD'

item.10 = 'TS      HOSTNAME'
item.11 = 'TS      ADDRESS'
item.12 = 'TS      NETMASK'
item.13 = 'TS      CLOSE_DELAY'

item.14 = 'LAN     HOSTNAME'
item.15 = 'LAN     ADDRESS'
item.16 = 'LAN     NETMASK'


/* load the REXX utility package */

CALL RXFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
CALL SysLoadfuncs


/* see if we know where the TS code is */

profile = SysIni('USER', 'TS', 'PROFILE')
IF profile = 'ERROR:' THEN DO
   rc = status(app, 'ERROR', 'Tunnel configuration not found')
   EXIT 2
END
rc = status(app, 'INFO', 'TS profile =' profile)


/* look at the profile */

IF \ exist(profile) THEN rc = status(app, 'ERROR', 'Tunnel profile ('||profile||') not found')


/* display the values */

cstanza = ''
citem   = ''
DO loop = 1 TO item.0

   /* add a space between stanzas */

   IF LENGTH(stanza) = 0 & cstanza \ = WORD(item.loop, 1) THEN SAY


   /* fetch the current stanza and item */

   cstanza = WORD(item.loop, 1)
   citem   = WORD(item.loop, 2)


   /* display the value */

   IF LENGTH(stanza)   = 0 | cstanza = stanza THEN DO
      IF LENGTH(item) = 0 | citem   = item   THEN DO
         IF LENGTH(value) > 0 THEN rc = SysIni(profile, cstanza, citem, value)
         rc = status(app, 'INFO', SUBSTR(cstanza, 1, 14)||' -> '||SUBSTR(citem, 1, 14)||' = '||SysIni(profile, cstanza, citem))
      END
   END

END


RETURN 0
