/* REXX                                                              */
/* Allgemeine Installationsroutine                                   */
/* --- angepat an URLCOPY.EXE ---                                   */
/* Lothar Sns, 2000                                                 */
/* ----------------------------------------------------------------- */
/* Funktionen:                                                       */
/* - prfen, ob notwendige Dateien vorhanden                         */
/* - WPS-Programmsymbol erzeugen                                     */
/* Voraussetzung:                                                    */
/* - Dateien befinden sich im aktuellen Verzeichnis                  */
/* ----------------------------------------------------------------- */


/* RexxUtil-Funktionen laden                                         */
call RxFuncAdd 'SysLoadFuncs' , RexxUtil, 'SysLoadFuncs'
call SysLoadFuncs

/* Konstanten fr diese Installation (anpassen)                      */
Objid        = '<LSOE_URLCOPY_EN>'                        /* Pflicht */
ProgramTitle = 'URLCopy for OS/2'                         /* Pflicht */
ExeFile      = 'urlcopy.exe'                              /* Pflicht */
HelpFile     = 'urlcopy.hlp'                              /* Kann    */
AddFile1     = ''                                         /* Kann    */
Applicn      = 'URLCopy'                                  /* Kann    */
InstallDir   = Directory()        /* Default = aktuelles Verzeichnis */

/* Weitere Optionen fr das Objekt                                   */
/* Parm = '%'   heit keine Parameter                                */
Parm         = ''
/* Zuordnungs-Angaben, mit Kommata trennen                           */
DateiTyp     = ''
DateiEndung  = ''


/* Optionen concatenieren (anpassen)                                 */
OptionString =  'OBJECTID='objid,
                ';EXENAME='InstallDir'\'ExeFile,
                ';STARTUPDIR='InstallDir,
                ';PARAMETERS='Parm,
/* +++++        ';ASSOCTYPE='DateiTyp,       +++++ */
/* +++++        ';ASSOCFILTER='DateiEndung,  +++++ */
                ''

/* Was soll passieren, wenn das Objekt schon existiert?              */
Action       = Update


/* ----------------------------------------------------------------- */
/* Jetzt geht's los                                                  */
/* ----------------------------------------------------------------- */
call SysCls

say ' Ŀ'
say '                   REXX installation routine                    '
say ' '
say
say 'A program object will be created on the WPS desktop, named:'
say '    >>>' ProgramTitle '<<<'
say 'Subsequently, you might move it into any folder you like.'
say
say 'Installation directory:'
say '   ' InstallDir
say

/* Exe-File vorhanden?                                               */
say 'Search for file:' ExeFile || '......'
if Stream(ExeFile,'C','Query Exists') = '' then do
        say 'File' ExeFile 'not found in' InstallDir
        say ExeFile 'must reside in this directory for the installation.'
        say 'Cancelled ...'
        exit
   end
say '... detected.'

/* AddFile  vorhanden?                                               */
if AddFile1 <> '' then do
   say 'Suche die Datei:' AddFile1 || '......'
   if Stream(AddFile1,'C','Query Exists') = '' then do
        say 'File' AddFile1 'not found in' InstallDir
        say AddFile1 'must reside in this directory for the installation.'
        say 'Cancelled ...'
        exit
        end
   say '... detected.'
   end

/* HelpFile vorhanden?                                                */
if HelpFile <> '%' then do
   say 'Search for file:' HelpFile || '......'
   if Stream(HelpFile,'C','Query Exists') = '' then do
        say 'File' HelpFile 'not found in' InstallDir
        say HelpFile 'must reside in this directory for the installation.'
        say 'Cancelled ...'
        exit
        end
   say '... detected.'
   end


/* WPS-Objekt erzeugen (auf dem Desktop)                             */
say
say 'Create the program object ......'
rc = SysCreateObject('WPProgram',,
                     ProgramTitle,,
                     '<WP_DESKTOP>',,
                     OptionString,,
                     Action)

/* erfolgreich?                                                       */
if rc = 0 then do
        say '... failed !!!'
        end
else do
        say '... successfully installed.'
        if DateiTyp    \= '' then do
                say
                say 'The following file types are associated to the program:'
                say DateiTyp
                say 'Double clicking such a file will open this program.'
                end
        if DateiEndung \= '' then do
                say
                say 'The following file extensions are associated to the program:'
                say DateiEndung
                say 'Double clicking such a file will open this program.'
                end
        end

/* Voreinstellungen initialisieren bzw. lschen */
ret = SysIni('USER',Applicn,'DELETE:')

say
say 'REXX installation routine ended.'




