/* Creates WebWilly for OS/2 bookmarks for "http://" URLs,
in the current directory, from the command line */

parse arg args
parse var args . '"' title '"' . '"' url '"' date time
if date='' then date=insert("/",insert("/",date("S"),4),7)
if time='' then do
   time=time('C')
   if length(time)=6 then time=0||time
end
if url='' | length(time)<>7 | length(date)<>10 | pos('/',date)<>5 | lastpos('/',date)<>8 | pos(':',time)<>3 | pos(":/",url)>0 then do
   say ""
   say "Arguments:"
   say "----------"
   say "1.  The page's title, in quotation marks"
   say "2.  The URL, in quotation marks, without 'http://' at the front"
   say "3.  The date, ten characters long, as in 1996/09/23"
   say "4.  The time, seven characters long, as in 01:00am"
   say "If date and time are omitted, computer's clock will be used."
   exit
end

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
signal on syntax name NoREXX
call SysLoadFuncs
signal on syntax name Syntax
'@ECHO OFF'

url="http://"||url
string='17'x||title||'09'x||url||'09'x||date||'09'x||time||'09'x||'20'x||'09'x||'09'x
filename=GetPopName(directory(),'URL')
if filename='error' then exit
filename=filename'.URL'
call lineout filename

if SysPutEA(filename,'URLFILEBUFFER',string)=0 then say "Created bookmark" filename
else say "Unsuccessful!"
if stream(filename)<>"UNKNOWN" then call lineout filename

exit

Syntax:
  say 'Error' rc 'in line' sigl':' errortext(rc)
  say sigl':' sourceline(sigl)
  exit
return

NoREXX:
   say 'Unable to load the REXXUtil functions.  Either the REXXUTIL.DLL file'
   say 'is not on the LIBPATH or REXX support is not installed on this system.'
   exit
return

/* Copyright (c)1996 Kari Jackson for InnoVal Systems Solutions, Inc. */
/* Subroutine to produce a *.POP-style filename */
/* Returns 8-character name or "error" */
GetPopName:procedure
parse arg directory,extension
characters='0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'
parse value date("O") with . 2 year "/" month "/" day
parse value time() with hour ":" minute ":" second
month=substr(characters,month+1,1)
day=substr(characters,day+1,1)
hour=substr(characters,hour+1,1)
fifth=minute%36
sixth=substr(characters,minute//36+1,1)
test=second//36
string=year||month||day||hour||fifth||sixth
do j=1 to 36
   test2=(test+j)//36
   if test2=0 then seventh=substr(characters,36,1)
   else seventh=substr(characters,test2,1)
   do i=1 to 36
      tryit=string||seventh||substr(characters,i,1)
      filename=directory||"\"||tryit||'.'||extension
      if stream(filename,'c','query exists')='' then return tryit
   end
end
say "There have already been 1296 files created in this directory during"
say "this minute.  Please wait until the clock changes and try again."
return 'error'
