/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
        call VROptions 'NoEchoQuit'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         __VXREXX____APPENDS__
*/
__VXREXX____APPENDS__:
/*
*/
return
/*:VRX         CalculateSpace
*/
CalculateSpace: 
  ok = VRSet( "MainWin", "Pointer", "Wait" )
  qname="DVDBURNQ"
  call RXQueue 'Create',qname
  oldq1=RXQUEUE('Set',qname)
  /* Clean queue */
  DO WHILE QUEUED()\=0
    PULL str
  END
  'RXQUEUE 'qname' /CLEAR'

  hinttext = VRGet( "MainWin", "HintText" )
  ok = VRSet( "DT_Text_MBAll2", "Visible", 1 )
  ok = VRSet( "DT_MB_All2", "Visible", 1 )
  ok = VRSet( "DT_Text_MBF2", "Visible", 1 )
  ok = VRSet( "DT_Text_MBF1", "Visible", 1 )
  count = VRGet( "LB_MPGFiles", "Count" )

  MBComplete = 0
  Filearray.0 = count
  do n = 1 to count
    filename = VRMethod( "LB_MPGFiles", "GetString", n )
    filename = SpaceCheck(filename)
/*  jetzt immer ermitteln */
/*  if pos(filename,FileArray.n) = 0 then do */
      FileSize = GetFileSize(filename)

      launch=ffmpegpath ' -i ' filename||' 2>&1 |RXQUEUE '||qname||' /FIFO & ECHO DONEACTION 2>&1 |RXQUEUE '||qname||' /FIFO'
      launch='"'launch'"'
      '@start "Get source bitrate" /C /B /MIN 'launch
      call ParseOutput 'Bitrate', FileSize
      if FileSize > 0 then do
        FileSizeSaved = FileSize * Factor
        FileArray.n = filename"|"FileSizeSaved
      end
/*  end
    else
      FileSizeSaved = substr(FileArray.n,pos("|",FileArray.n)+1)
*/
    if FileSize > 0 then
      MBComplete = MBComplete + FileSizeSaved
  end  /* do */

  /* Clean queue */
  DO WHILE QUEUED()\=0
    PULL str
  END
  'RXQUEUE 'qname' /CLEAR'
  oldq=RXQUEUE('Set',oldq1)  
  ok = VRSet( "MainWin", "HintText", hinttext )
  ok = VRSet( "MainWin", "Pointer", "<default>" )
return
/*:VRX         CB_2PassEncode_Click
*/
CB_2PassEncode_Click: 
  set = VRGet( "CB_2PassEncode", "Set" )
  if set=1 then do
    ok = VRSet( "EF_ffmpegPar2", "Visible", 1 )
    ok = VRSet( "DT_14", "Visible", 1 )
  end
  else
  do
    ok = VRSet( "EF_ffmpegPar2", "Visible", 0 )
    ok = VRSet( "DT_14", "Visible", 0 )
  end
return

/*:VRX         CB_BurnISO_Click
*/
CB_BurnISO_Click: 
  call CheckChecked
return

/*:VRX         CB_CreateISO_Click
*/
CB_CreateISO_Click: 
  call CheckChecked
return

/*:VRX         CB_CreateStructure_Click
*/
CB_CreateStructure_Click: 
  call CheckChecked
return

/*:VRX         CB_Pipe_Click
*/
CB_Pipe_Click: 
  pipecheck = VRGet( "CB_Pipe", "Set" )
  ok= VRSetIni("DVDVIDEO", "pipecheck", pipecheck, ActDir"\DVDBURN.INI" )
  if pipecheck = 1 then do
   ok=VRSet( "CB_Split", "Set", 0 )
   ok= VRSetIni("DVDVIDEO", "splitcheck", 0, ActDir"\DVDBURN.INI" )
  end
return

/*:VRX         CB_Split_Click
*/
CB_Split_Click: 
  splitcheck = VRGet( "CB_Split", "Set" )
  ok= VRSetIni("DVDVIDEO", "splitcheck", splitcheck, ActDir"\DVDBURN.INI" )
  if splitcheck = 1 then do
   ok=VRSet( "CB_Pipe", "Set", 0 )
   ok= VRSetIni("DVDVIDEO", "pipecheck", 0, ActDir"\DVDBURN.INI" )
  end
return

/*:VRX         CB_Transcode_Click
*/
CB_Transcode_Click: 
  call CheckChecked
return

/*:VRX         CheckChecked
*/
CheckChecked: 
  setTrans = VRGet( "CB_Transcode", "Set" )
  setStru = VRGet( "CB_CreateStructure", "Set" )
  setCrISO = VRGet( "CB_CreateISO", "Set" )
  setBrISO = VRGet( "CB_BurnISO", "Set" )
  if (setTrans=0) & (setStru=0) & (setCrISO=0) & (setBrISO=0) then
    ok = VRSet( "PB_Start", "Enabled", 0 )
  else do
    if (setTrans=1) then do
      if (VRGet( "LB_MPGFiles", "Count" )>0) then
        ok = VRSet( "PB_Start", "Enabled", 1 )
      else
        ok = VRSet( "PB_Start", "Enabled", 0 )
    end
    else
      ok = VRSet( "PB_Start", "Enabled", 1 )
  end
  if (setStru=1) | (setCrISO=1) | (setBrISO=1) then
    if (VRGet( "Combo_Name", "Value" )='') then
      ok = VRSet( "PB_Start", "Enabled", 0 )
  ok = VRSet( "CB_Split", "Enabled", setCrISO )
  ok = VRSet( "CB_Pipe", "Enabled", setBrISO & setCrIso )
  if setBrIso = 0 then ok = VRSet( "CB_Pipe", "Set", 0 )
return

/*:VRX         CheckParameters
*/
CheckParameters: 
  /* structpath msut be filled */
  if (structpath = '') then
    structOK = 0
  else
    structOK = VRIsDir( structpath )
  /* encodepath may be empty, check only if filled */  
  if (encodepath = '') then
    encodeOK = 2
  else
    encodeOK = VRIsDir( encodepath )
  ffmpegOK = VRFileExists( ffmpegpath )
  dvdauthorOK = VRFileExists( dvdauthorpath )
  dvddaoOK = VRFileExists( dvddaopath )
  mkisofs2OK = VRFileExists( mkisofs2path )
  if (structOK <> 1) | (ffmpegOK <> 1) | (dvdauthorOK <> 1) | (dvddaoOK <> 1) | (mkisofs2OK <> 1) | (dvddevice = '') then
  DO
    ok = VRSet( "MainWin", "HintText", SetupVar("Hint configure") )
    ok = VRSet( "Combo_Name", "Enabled", 0 )
    ok = VRSet( "PB_Add", "Enabled", 0 )
    ok = VRSet( "PB_Remove", "Enabled", 0 )
    ok = VRSet( "PB_Refresh", "Enabled", 0 )
    ok = VRSet( "PB_Media", "Enabled", 0 )
  END
  ELSE
  DO
    ok = VRSet( "MainWin", "HintText", OriginalHint )
    ok = VRSet( "Combo_Name", "Enabled", 1 )
    ok = VRSet( "PB_Add", "Enabled", 1 )
    ok = VRSet( "PB_Remove", "Enabled", 1 )
    ok = VRSet( "PB_Refresh", "Enabled", 1 )
    ok = VRSet( "PB_Media", "Enabled", 1 )
  END
  if (ffmpegrate = '') then ffmpegrate = '5500'
  if (ffmpegaurate = '') then ffmpegaurate = '384'
  if (dvdspeed = '') then dvdspeed = 0
  if (structOK = 1) then
  DO
    /* check for ending backslash */
    structlength  = Length( structpath )
    structsubstr  = SubStr( structpath, structlength, 1 )
    if structsubstr <> '\' then structpath = structpath || '\'
    /* check for root */
    structlength  = Length( structpath )
    if (structlength < 4) then
        id = VRMessage( VRWindow(), "Setting the root of a drive as video folder will produce logfiles and folders for every DVD and mpg files there!", "Root selected", "Information", , ,  )
  END
  if (encodeOK = 1) then
  DO
    /* check for ending backslash */
    encodelength  = Length( encodepath )
    encodesubstr  = SubStr( encodepath, encodelength, 1 )
    if encodesubstr <> '\' then encodepath = encodepath || '\'
    /* check for root */
    encodelength  = Length( encodepath )
    if (encodelength < 4) then
        id = VRMessage( VRWindow(), "Setting the root of a drive as encode path will produce mpg files for every sourcefile there!", "Root selected", "Information", , ,  )
  END
    
return

/*:VRX         Combo_Name_Change
*/
Combo_Name_Change: 
  call CheckChecked
  DVDName = VRGet( "Combo_Name", Value )
  logfile=structpath||DVDName||'_log.txt'
  ok = VRSet( "PB_logshow", "Enabled", VRFileExists(logfile) )
return

/*:VRX         CreateXML
*/
CreateXML: 
  parse arg aXMLFile
  ok = VRDeleteFile( aXMLFile )
  call LINEOUT aXMLFile, "<dvdauthor>"
  call LINEOUT aXMLFile, "    <vmgm />"
  call LINEOUT aXMLFile, "    <titleset>"
  call LINEOUT aXMLFile, "        <titles>"

  if (dvdauthorsys <> "auto") & (dvdauthoraspect <> "auto") then
    call LINEOUT aXMLFile, '            <video format="'||dvdauthorsys||'" aspect="'||dvdauthoraspect||'" />'
  else
    if (dvdauthorsys <> "auto") then
      call LINEOUT aXMLFile, '            <video format="'||dvdauthorsys||'" />'
    else
      if (dvdauthoraspect <> "auto") then
        call LINEOUT aXMLFile, '            <video aspect="'||dvdauthoraspect||'" />'

  call LINEOUT aXMLFile, "            <pgc>"
  do n = 1 to count
    filename = FileList.n
    if substr(filename,1,1) <> '"' then
      filename = '"'filename'"'
    if n=1 then
      call LINEOUT aXMLFile, '             <vob file='||filename||' chapters="0" />'
    else
      call LINEOUT aXMLFile, '             <vob file='||filename||' />'
  end
  call LINEOUT aXMLFile, "            </pgc>"
  call LINEOUT aXMLFile, "        </titles>"
  call LINEOUT aXMLFile, "    </titleset>"
  call LINEOUT aXMLFile, "</dvdauthor>"
  call stream aXMLFile, 'c', 'close'
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         GetFileInfo
*/
GetFileInfo: 
  ok = VRSet( "MainWin", "Pointer", "Wait" )
  qname="DVDBURNQ"
  call RXQueue 'Create',qname
  oldq1=RXQUEUE('Set',qname)
  /* Clean queue */
  DO WHILE QUEUED()\=0
    PULL str
  END
  'RXQUEUE 'qname' /CLEAR'

  if menu_key = "T" then
    filename = VRGet( "LB_TARGETFILES", "SelectedString" )
  else
    filename = VRGet( "LB_MPGFiles", "SelectedString" )
  filename = SpaceCheck(filename)

  ok = VRFileExists( filename )
  
  if ok = 1 then do
    FileSize = GetFileSize(filename)
    listfiles_info.0 = 1
    listfiles_info.1 = filename
    launch=ffmpegpath ' -i ' filename||' 2>&1 |RXQUEUE '||qname||' /FIFO & ECHO DONEACTION 2>&1 |RXQUEUE '||qname||' /FIFO'
    launch='"'launch'"'
    '@start "Get fileinfo" /C /B /MIN 'launch
    call ParseOutput 'Fileinfo'
  end
  else do
    listfiles_info.0 = 1
    listfiles_info.1 = "N/A"
  end
  ok1 = VRMethod( "LB_FILEINFO", "Clear" )
  ok1 = VRMethod( "LB_FILEINFO", "AddStringList", "listfiles_info.", 1 )

  /* Clean queue */
  DO WHILE QUEUED()\=0
    PULL str
  END
  'RXQUEUE 'qname' /CLEAR'
  oldq=RXQUEUE('Set',oldq1)

  
  ok = VRSet( "MainWin", "Pointer", "<default>" )
return

/*:VRX         GetFileSize
*/
GetFileSize: 
  nF=1
  checkfile = ''
  CheckSize = 0
  do ARG()
    checkfile = checkfile||ARG(nF)
    nF = nF+1
  end
  if pos('"',checkfile) <> 0 then
    checkname = substr(checkfile,2,length(checkfile)-2)
  else
    checkname = checkfile
  checkname = Translate(VRParseFileName( checkname, "NE" ))

  'dir '||checkfile||' > '||tmppath'\dirout.lst'
  do while lines(tmppath'\dirout.lst') <> 0
    RLine = Translate(LINEIN(tmppath'\dirout.lst'))
    if (pos(':\',RLine) = 0) & (pos(checkname,RLine) <> 0) THEN do
      CheckSize = SPACE(TRANSLATE(WORD(RLine,3),'','.'),0)
      CheckSize = SPACE(TRANSLATE(CheckSize,'','.'),0)
      CheckSize = SPACE(TRANSLATE(CheckSize,'',','),0)
      CheckSize = SPACE(TRANSLATE(CheckSize,'',','),0)
      CheckSize = SPACE(TRANSLATE(CheckSize,'',"'"),0)
      CheckSize = SPACE(TRANSLATE(CheckSize,'',"'"),0)
      CheckSize = SPACE(TRANSLATE(CheckSize,'',''),0)
      CheckSize = SPACE(TRANSLATE(CheckSize,'',''),0)
      if WORD(RLine,4) = 'K' then
        CheckSize = CheckSize / 1024
      else      
        CheckSize = CheckSize / 1048576
    end
  end
  ok=stream(tmppath'\dirout.lst','c','close')
  'del '||tmppath'\dirout.lst'
return CheckSize
/*:VRX         GetFreeDiskSize
*/
GetFreeDiskSize: 
ARG LW
if LW = '' then LW = left(directory(),2)
driveinfo = SysDriveInfo(LW)
freesize = word(driveinfo,2) / 1048576
return freesize

/*:VRX         GetProcess
*/
GetProcess: 
  program = Arg(1)
  progid = 0
  pslist. = ''
  if PRProcessList(pslist) <> "ERROR" then do
    nP = 0
    do pslist.0
      nP = nP +1
      if pos(program,pslist.nP.name) <> 0 then do
        progid = pslist.nP.pid
        leave
      end
    end
  end
return progid
/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         InErrIgnoreList
*/
InErrIgnoreList: 
  retvalue = 1
  sText = ARG(1)
  sListe = errorignore
  counter = 0
  posend = pos('0d0a'x,sListe)      /* crlf */
  do while (posend > 0)             /* parse the ignore list */
    counter = counter + 1
    stemText.counter = substr(sListe,1,posend-1)
    sliste = delstr(sListe,1,posend+1)
    posend = pos('0d0a'x,sListe)
  end
  if length(sListe) > 0 then do     /* last line has no crlf at the end */
    counter = counter + 1
    stemText.counter = sListe
  end
  stemText.0 = counter
  counter = 0
  do stemText.0                     /* check occurence in output line of dvddao */
    counter = counter + 1
    if pos(stemText.counter,sText) <> 0 then do
      retValue = 0
      leave
    end
  end 
return retValue
/*:VRX         Init
*/
Init:
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         LB_MPGFiles_Click
*/
LB_MPGFiles_Click: 
  selected = VRGet( "LB_MPGFiles", "Selected" )
  ok = VRSet( "LB_TARGETFILES", "Selected", selected )
return

/*:VRX         LB_MPGFiles_ContextMenu
*/
LB_MPGFiles_ContextMenu: 
  menu_key = "S"  
  call VRMethod "mnu_mpg_context", "Popup"  
return

/*:VRX         LB_MPGFiles_DoubleClick
*/
LB_MPGFiles_DoubleClick:
    ok = VRRedirectStdIO( "Off" ) 
    ok = VRSet( "DT_Text_MB", "Caption", "MB" )
    filename = VRGet( "LB_MPGFiles", "SelectedString" )
    actdrive = VRCurrDrive()
    actdir = VRCurrDir( actdrive )
    filedrive = VRParseFileName( videoplayerpath, "D" )
    filepath = VRParseFileName( videoplayerpath, "DP" )
    ok = VRChDrive( filedrive )
    ok = VRChDir( filepath )
    videoplayerpath filename
    ok = VRChDrive( actdrive )
    ok = VRChDir( actdir )
    ok = VRRedirectStdIO( "On" )
return

/*:VRX         LB_TARGETFILES_ContextMenu
*/
LB_TARGETFILES_ContextMenu: 
  menu_key = "T"  
  call VRMethod "mnu_mpg_context", "Popup"  
return

/*:VRX         LB_TARGETFILES_DoubleClick
*/
LB_TARGETFILES_DoubleClick: 
    ok = VRRedirectStdIO( "Off" ) 
    ok = VRSet( "DT_Text_MB", "Caption", "MB" )
    filename = VRGet( "LB_TARGETFILES", "SelectedString" )
    actdrive = VRCurrDrive()
    actdir = VRCurrDir( actdrive )
    filedrive = VRParseFileName( videoplayerpath, "D" )
    filepath = VRParseFileName( videoplayerpath, "DP" )
    ok = VRChDrive( filedrive )
    ok = VRChDir( filepath )
    videoplayerpath filename
    ok = VRChDrive( actdrive )
    ok = VRChDir( actdir )
    ok = VRRedirectStdIO( "On" )
return

/*:VRX         Logshow_Close
*/
Logshow_Close: 
  font = VRGet( "LB_logshow", "Font" )  
  if font <> fontlogwin then do
    ok = VRSetIni( "DVDVIDEO", "fontlogwin", font, ActDir"\DVDBURN.INI" )
    fontwin = font
  end
  call Logshow_Fini
return

/*:VRX         Logshow_Create
*/
Logshow_Create: 
  call Logshow_Init
  fontlogwin = VRGetIni( "DVDVIDEO", "fontlogwin", ActDir"\DVDBURN.INI", "NoClose" )
  if fontlogwin <> '' then
    ok = VRSet( "LB_logshow", "Font", fontlogwin )
  LLine = linein(logfile,1,0)
  do until lines(logfile) = 0
    LLine = linein(logfile)
    position = VRMethod( "LB_logshow", "AddString", LLine,  )
  end
  ok = lineout(logfile)
  call stream logfile "c" "Close"
return

/*:VRX         Logshow_Fini
*/
Logshow_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Logshow_Init
*/
Logshow_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         MainWin_Close
*/
MainWin_Close:
  font = VRGet( "LB_Output", "Font" )
  if font <> fontshortlog then 
    ok = VRSetIni( "DVDVIDEO", "fontshortlog", font, ActDir"\DVDBURN.INI", "NoClose" )
  font = VRGet( "LB_MPGFiles", "Font" )  
  if font <> fontfilelist then 
    ok  = VRSetIni( "DVDVIDEO", "fontfilelist", font, ActDir"\DVDBURN.INI", "NoClose" )
  ok= VRSetIni("DVDVIDEO", "initialpath", initialpath, ActDir"\DVDBURN.INI" )
  call Quit
return

/*:VRX         MainWin_Create
*/
MainWin_Create: 
  call rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
  call RxFuncAdd 'PRLoadFuncs', 'PR1UTIL', 'PRLoadFuncs'
  call PRLoadFuncs
  ok = VRRedirectStdIO( "On" )
  tmppath = value( 'TMP', , 'OS2ENVIRONMENT')
  ActDir= VRCurrDrive()||VRCurrDir(VRCurrDrive())
  OriginalHint = VRGet( "MainWin", "HintText" )

/* read ini settings */
  ffmpegpath= VRGetIni("DVDVIDEO", "ffmpegpath", ActDir"\DVDBURN.INI", "NoClose" )
  encodepath= VRGetIni("DVDVIDEO", "encodepath", ActDir"\DVDBURN.INI", "NoClose" )
  ffmpegpar1= VRGetIni("DVDVIDEO", "ffmpegpar1", ActDir"\DVDBURN.INI", "NoClose" )
  ffmpegpar2= VRGetIni("DVDVIDEO", "ffmpegpar2", ActDir"\DVDBURN.INI", "NoClose" )
  ffmpegrate= VRGetIni("DVDVIDEO", "ffmpegrate", ActDir"\DVDBURN.INI", "NoClose" )
  ffmpegaurate= VRGetIni("DVDVIDEO", "ffmpegaurate", ActDir"\DVDBURN.INI", "NoClose" )
  ffmpeginterlace= VRGetIni("DVDVIDEO", "ffmpeginterlace", ActDir"\DVDBURN.INI", "NoClose" )
  ffmpegdeinterlace= VRGetIni("DVDVIDEO", "ffmpegdeinterlace", ActDir"\DVDBURN.INI", "NoClose" )
  ffmpeg2pass= VRGetIni("DVDVIDEO", "ffmpeg2pass", ActDir"\DVDBURN.INI", "NoClose" )
  ffmpegsys= VRGetIni("DVDVIDEO", "ffmpegsys", ActDir"\DVDBURN.INI", "NoClose" )
  if (ffmpegsys <> "auto") & (ffmpegsys <> "pal") & (ffmpegsys <> "ntsc") & (ffmpegsys <> "film") then ffmpegsys = "auto"
  ffmpegMVignore= VRGetIni("DVDVIDEO", "ffmpegMVignore", ActDir"\DVDBURN.INI", "NoClose" )
  dvdauthorpath= VRGetIni("DVDVIDEO", "dvdauthorpath", ActDir"\DVDBURN.INI", "NoClose" )
  dvdauthorparVOB= VRGetIni("DVDVIDEO", "dvdauthorparVOB", ActDir"\DVDBURN.INI", "NoClose" )
  dvdauthorparTOC= VRGetIni("DVDVIDEO", "dvdauthorparTOC", ActDir"\DVDBURN.INI", "NoClose" )
  dvdauthorsys= VRGetIni("DVDVIDEO", "dvdauthorsys", ActDir"\DVDBURN.INI", "NoClose" )
  if (dvdauthorsys <> "auto") & (dvdauthorsys <> "pal") & (dvdauthorsys <> "ntsc") then dvdauthorsys = "auto"
  dvdauthoraspect= VRGetIni("DVDVIDEO", "dvdauthoraspect", ActDir"\DVDBURN.INI", "NoClose" )
  if (dvdauthoraspect <> "auto") & (dvdauthoraspect <> "16:9") & (dvdauthoraspect <> "4:3") then dvdauthoraspect = "auto"
  mkisofs2path= VRGetIni("DVDVIDEO", "mkisofs2path", ActDir"\DVDBURN.INI", "NoClose" )
  mkisofs2par= VRGetIni("DVDVIDEO", "mkisofs2par", ActDir"\DVDBURN.INI", "NoClose" )
  dvddaopath= VRGetIni("DVDVIDEO", "dvddaopath", ActDir"\DVDBURN.INI", "NoClose" )
  dvddaopar= VRGetIni("DVDVIDEO", "dvddaopar", ActDir"\DVDBURN.INI", "NoClose" )
  dvddevice= VRGetIni("DVDVIDEO", "dvddevice", ActDir"\DVDBURN.INI", "NoClose" )
  dvdspeed= VRGetIni("DVDVIDEO", "dvdspeed", ActDir"\DVDBURN.INI", "NoClose" )
  errorignore= VRGetIni("DVDVIDEO", "errorignore", ActDir"\DVDBURN.INI", "NoClose" )
  if pos("Buffer underrun",errorignore) = 0 then
    if length(errorignore) = 0 then
      errorignore="Buffer underrun"
    else  
      errorignore=errorignore||"0d0a"x||"Buffer underrun"
  if pos("MEDIUM MAY HAVE CHANGED",errorignore) = 0 then
    errorignore=errorignore||"0d0a"x||"MEDIUM MAY HAVE CHANGED"
  if pos("Cant read enough data",errorignore) = 0 then
    errorignore=errorignore||"0d0a"x||"Cant read enough data"
  if pos("INVALID FIELD IN CDB",errorignore) = 0 then
    errorignore=errorignore||"0d0a"x||"INVALID FIELD IN CDB"
  structpath= VRGetIni("DVDVIDEO", "structpath", ActDir"\DVDBURN.INI", "NoClose" )
  splitcheck=VRGetIni("DVDVIDEO", "splitcheck", ActDir"\DVDBURN.INI", "NoClose" )
  pipecheck=VRGetIni("DVDVIDEO", "pipecheck", ActDir"\DVDBURN.INI", "NoClose" )
  delmpgfiles=VRGetIni("DVDVIDEO", "delmpgfiles", ActDir"\DVDBURN.INI", "NoClose" )
  deldvdfolder=VRGetIni("DVDVIDEO", "deldvdfolder", ActDir"\DVDBURN.INI", "NoClose" )
  delimage=VRGetIni("DVDVIDEO", "delimage", ActDir"\DVDBURN.INI", "NoClose" )
  dellogfile=VRGetIni("DVDVIDEO", "dellogfile", ActDir"\DVDBURN.INI", "NoClose" )
  setBlank=VRGetIni("DVDVIDEO", "setBlank", ActDir"\DVDBURN.INI", "NoClose" )
  setFormat=VRGetIni("DVDVIDEO", "setFormat", ActDir"\DVDBURN.INI", "NoClose" )
  initialpath=VRGetIni("DVDVIDEO", "initialpath", ActDir"\DVDBURN.INI", "NoClose" )
  postCommand=VRGetIni("DVDVIDEO", "postCommand", ActDir"\DVDBURN.INI", "NoClose" )
  videoplayerpath=VRGetIni("DVDVIDEO", "videoplayerpath", ActDir"\DVDBURN.INI", "NoClose" )
  videoplayerpar=VRGetIni("DVDVIDEO", "videoplayerpar", ActDir"\DVDBURN.INI", "NoClose" )
  language = VRGetIni( "DVDVIDEO", "language", ActDir"\DVDBURN.INI", "NoClose" )
  if language = '' then
    language = 'lang_en.txt'
  fontshortlog = VRGetIni( "DVDVIDEO", "fontshortlog", ActDir"\DVDBURN.INI", "NoClose" )
  if fontshortlog <> '' then
    ok = VRSet( "LB_Output", "Font", fontshortlog )
  fontfilelist = VRGetIni( "DVDVIDEO", "fontfilelist", ActDir"\DVDBURN.INI" )
  if fontfilelist <> '' then
    ok = VRSet( "LB_MPGFiles", "Font", fontfilelist )  
  ok = VRSet( "CB_Split", "Set", splitcheck )
  ok = VRSet( "CB_Pipe", "Set", pipecheck )
  mainTitle = 'Burn DVD video for eCs and OS/2'
  call SetLanguage
  call CheckParameters
  call ReadFolders
  call CheckChecked
return
/*:VRX         mnu_fileinfo_Click
*/
mnu_fileinfo_Click: 
    call GetFileinfo
return

/*:VRX         ParseOutDvddao
*/
ParseOutDvddao: 
  parse arg aOutType 
  call SysSleep 1
  DO forever
    call SysSleep 0.2
    RLine=''
    IF QUEUED()\=0 THEN Do
      RLine = LINEIN("QUEUE:")      
      IF RLine='' THEN RLine=' '
    END
    if (pos("Info : Unlocking media...",RLine) \= 0) then do
      leave
    end
    if (pos("DONEACTION",RLine) \= 0) then do
      leave
    end

    if (aOutType = 'Format') then do
      if (pos("Error :",RLine) <> 0) & (InErrIgnoreList(RLine) <> 0) then do
        error = 1
        leave        
      end
    end

    if (aOutType = 'Blank') then do
      if (pos("Error :",RLine) <> 0) & (InErrIgnoreList(RLine) <> 0) then do
        error = 1
        leave        
      end
    end

  end

return

/*:VRX         ParseOutput
*/
ParseOutput:
  parse arg aOutType, aMBComplete 
  if (aOutType \= 'Fileinfo') & (aOutType \= 'Bitrate') then do
    ok = VRSet( "MainWin", "HintText", SetupVar("Hint working") )
  end
  ok = VRSet( "DT_MBReady", "Caption", "" )
  ok = VRSet( "DT_MBAll", "Caption", "" )

  breaked=0
  /* Initialize variables */
  forcount=0
  Factor = 1
  noVOBUCount = 0

  call SysSleep 1
  DO forever
    call SysSleep 0.1
    RLine=''
    IF QUEUED()\=0 THEN Do
      RLine = LINEIN("QUEUE:")      
      IF RLine='' THEN RLine=' '
      else forcount = 0
    END

    if (pos("DONEACTION",RLine) \= 0) then do
      leave
    end

    if (aOutType \= 'Fileinfo') & (aOutType \= 'Bitrate') then do
      if Rline <> ' ' then call LINEOUT logfile, RLine
    end

    if (aOutType = 'Fileinfo') then do
      if (pos("Video:",RLine) \= 0) then do
        posinf = pos("Video:",RLine)
        vidinf = substr(RLine,posinf)
      end
      if (pos("Audio:",RLine) \= 0) then do
        posinf = pos("Audio:",RLine)
        audinf = substr(RLine,posinf)
      end
      if (pos("bitrate:",RLine) \= 0) then do
        posstart = pos("bitrate:",RLine)
        posend = pos("bitrate:",RLine)+14
        temprate = substr(RLine,posstart,posend-posstart)
        bitrate = word(temprate,2)
      end
      if (bitrate = "N/A") & (pos("Stream #0.0",RLine) \= 0) then do
        posbitrate = pos("kb/s",RLine)
        if (posbitrate = 0) then do
          bitrate = 10000
        end
        else do
          temprate = substr(RLine,posbitrate-12,12)
          poscomma = pos(",",temprate)
	  tempstr = substr(temprate,poscomma+1,11)
	  bitrate = word(tempstr,1)
        end        
      end
      listfiles_info.0 = 4
      listfiles_info.2 = vidinf
      listfiles_info.3 = "bitrate: "||bitrate||"k"
      listfiles_info.4 = audinf
    end

    if (aOutType = 'Bitrate') then do
      if (pos("bitrate:",RLine) \= 0) then do
        posstart = pos("bitrate:",RLine)
        posend = pos("bitrate:",RLine)+14
        temprate = substr(RLine,posstart,posend-posstart)
        bitrate = word(temprate,2)
        if bitrate <> "N/A" then
          Factor = ffmpegrate / bitrate * 1.1
      end
      if (bitrate = "N/A") & (pos("Stream #0.0",RLine) \= 0) then do
        posbitrate = pos("kb/s",RLine)
        if (posbitrate = 0) then do
          bitrate = 10000
        end
        else do
          temprate = substr(RLine,posbitrate-12,12)
          poscomma = pos(",",temprate)
	  tempstr = substr(temprate,poscomma+1,11)
	  bitrate = word(tempstr,1)
        end        
        Factor = ffmpegrate / bitrate * 1.1
      end
    end

    if (aOutType = 'Trans') then do
      ok = VRSet( "DT_MBAll", "Visible", 0 )
      if (pos("MV errors",RLine) <> 0) then do
        ok  = Beep( "200", "250" )
	position = VRMethod( "LB_Output", "AddString", RLine  )
        if ffmpegMVignore = 0 then
          error = 1
      end
      if (pos("frame=",RLine) \= 0) then do
        posstart = pos('size=',RLine)+6
        posend = posstart+7
        kBready = strip(substr(RLine,posstart,posend-posstart),'L')
        if ffmpeg2pass = 1 then
          kBready = kBReady / 2
        kBDisplay = kBCum + kBready
        MBDisplay = Format((kBDisplay / 1024),,2)
        if (MBDisplay > 0) & (MBComplete > 0) then do
          Percent = Format(((MBDisplay / aMBComplete) * 100),,0)
        end
        ok = VRSet( "DT_MBReady", "Caption", MBDisplay )
        ok = VRSet( "SL_Progress", "Percentile", Percent )
        ok = VRSet( "DT_Percent", "Caption", Percent||'%' )
        ok = VRSet( "MainWin", "Caption", Percent||'% - '||mainTitle )
        ok = VRSet( "DT_MBAll", "Caption", Format(aMBComplete,,2) )
      end
    end
    else
      ok = VRSet( "DT_MBAll", "Visible", 1 )
  
    if (aOutType = 'VTS') then do
      ok = VRSet( "DT_MBAll", "Caption", Format(aMBComplete,,2) )
      if (pos("WARN: Skipping sector, waiting for first VOBU...",RLine) <> 0) then do
        noVOBUCount = noVOBUCount +1
        if noVOBUCount > 150 then do
          ok  = Beep( "200", "250" )
          position = VRMethod( "LB_Output", "AddString", SetupVar("Log not encoded"),  )
          error = 1
          leave
        end        
      end
      if (pos("STAT:",RLine) <> 0) & (pos("VOBU",RLine) <> 0) & (pos("fixed",RLine) = 0) then do
        posstart = pos('at',RLine)+3
        posend = pos('MB', RLine)+1
        MBready = substr(RLine,posstart,posend-posstart-1)
        pospercent = pos("%",RLine)
        if (pospercent <> 0) & (pos("100%",RLine) = 0) then do
          opcaption = VRGet( "DT_Operation", "Caption" )
          if opcaption <> "Fix VOBUS at" then call VRSet "DT_Operation", "Caption", SetupVar("Operation Fix VOBUS")
          tempstr = substr(RLine,pospercent-3,3)
          posstart= pos(" ",tempstr)
          Percent = substr(tempstr,posstart,3)
          Percent = Percent / 2 + 50
        end
        else do
          if opcaption <> "Check VOBUS" then do
            call VRSet "DT_Operation", "Caption", SetupVar("Operation Check VOBUS")
            if (MBReady > 0) & (MBComplete > 0) then
              Percent = Format(MBReady / MBComplete * 100 / 2,,0)
          end
        end
        ok = VRSet( "DT_MBReady", "Caption", MBReady )
        ok = VRSet( "SL_Progress", "Percentile", Percent )
        ok = VRSet( "DT_Percent", "Caption", Percent||'%' )
        ok = VRSet( "MainWin", "Caption", Percent||'% - '||mainTitle )
      end
    end

    if (aOutType = 'TOC') then do
      /* nothing to parse */
    end

    if (aOutType = 'MakeImg') then do
      if (pos("Unable to make a DVD-Video image",RLine) <> 0) | (pos("cannot fwrite",RLine) <> 0) then do
        ok  = Beep( "200", "250" )
        error = 1
        leave        
      end
      if (pos("estimate finish",RLine) <> 0) then do
        Percent = substr(RLine,2,2)
        ok = VRSet( "SL_Progress", "Percentile", Percent )
        ok = VRSet( "DT_Percent", "Caption", Percent||'%' )
        ok = VRSet( "MainWin", "Caption", Percent||'% - '||mainTitle )
      end
    end

    if (aOutType = 'Pipe') then do
      if (pos("Error :",RLine) <> 0) & (InErrIgnoreList(RLine) <> 0) then do
        ok  = Beep( "200", "250" )
        error = 1
        leave        
      end
      if (pos("Info : Writing:",RLine) <> 0) then do
        posstart = pos("Writing:",RLine)+9
        posend = pos("MB at",RLine)
        if posend = 0 then posend = pos("MB done", RLine)
        if (posstart > 0) & (posend > posstart) then
          MBready = substr(RLine,posstart,posend-posstart-1)
        else
          MBReady = "?"
        ok = VRSet( "DT_MBReady", "Caption", MBReady )
      end
    end

    if (aOutType = 'Burn') then do
      if (pos("Error :",RLine) <> 0) & (InErrIgnoreList(RLine) <> 0) then do
        ok  = Beep( "200", "250" )
        error = 1
        leave        
      end
      if (pos("Info : Writing:",RLine) <> 0) then do
        posstart = pos("Writing:",RLine)+9
        posend = pos("MB of",RLine)
        if (posstart > 0) & (posend > posstart) then        
            MBready = substr(RLine,posstart,posend-posstart-1)
        else
            MBReady = "?"
        posstart = pos('MB of',RLine)+6
        posend = pos('MB (',RLine)
        if (posstart > 0) & (posend > posstart) then
            MBAll = substr(RLine,posstart,posend-posstart-1)
        else
            MBAll = "?"
        pospercent = pos("%",RLine)
        if (pospercent > 0) then do
            tempstr = substr(RLine,pospercent-3,3)
            posstart= pos("(",tempstr)
            Percent = substr(tempstr,posstart+1,3)
            ok = VRSet( "SL_Progress", "Percentile", Percent )
            ok = VRSet( "DT_Percent", "Caption", Percent||'%' )
            ok = VRSet( "MainWin", "Caption", Percent||'% - '||mainTitle )
        end
        ok = VRSet( "DT_MBReady", "Caption", MBReady )
        ok = VRSet( "DT_MBAll", "Caption", MBAll )
      end
    end

    if (queued() = 0) then do
       forcount=forcount+1
       call SysSleep(1)
    end
    if (forcount > 5) then do
      if GetProcess( progstarted ) = 0 then do
        breaked=1
        leave
      end
      else
        forcount = 0
    end
    if (aOutType = 'Trans') & ( length(encodepath) > 0 ) then
      checkdrive = substr(encodepath,1,2)
    else
      checkdrive = substr(structpath,1,2)
    MBFree = GetFreeDiskSize(checkdrive)
    if \(MBFree > 0) then MBFree = 0
    MBFree = Format(MBFree,,2)
    ok = VRSet( "DT_FREE_1", "Caption", SetupVar("Free space")||" "||checkdrive )
    ok = VRSet( "DT_FREE_1MB", "Caption", MBFree )

  end
  if error = 1 then
    call LINEOUT logfile, RLine
  call stream logfile, 'c', 'close'

return
/*:VRX         PB_1_Click
*/
PB_1_Click: 
  call logshow_close
return

/*:VRX         PB_Add_Click
*/
PB_Add_Click: 
  if length(encodepath) > 0 then do
    nPosLastBS = lastpos('\',encodepath )
    length  = Length( encodepath )
    if length != nPosLastBS then
      encodepathused = encodepath||'\'
    else
      encodepathused = encodepath
  end
  else
    encodepathused = structpath

  ok = VRFileDialog( VRWindow(), "Choose MPEG file", "Open", initialpath, "", , , "files." )
  i=0
  do files.0 
    i=i+1
    bExists = VRFileExists( files.i )
    if bExists==1 then
    position = VRMethod( "LB_MPGFiles", "AddString", files.i,  )
    newfile = (VRParseFileName( files.i, "N" ))||'.MPG'
    encodefile = SpaceCheck(encodepathused||newfile)
    postarget = VRMethod( "LB_TARGETFILES", "AddString", encodefile,  )
  end
  call CheckChecked
  if i > 0 then initialpath = VRParseFileName(files.1, "D") || ":" || VRParseFileName(files.1, "P") || "\"
return

/*:VRX         PB_dvdauthorpathsel_Click
*/
PB_dvdauthorpathsel_Click: 
  sFile = VRGet( "EF_dvdauthorpath", "Value" )
  sInitialPath = VRParseFilePath( sFile, "DP" )||"\"
  sFile = VRFileDialog( VRWindow(), SetupVar("Choose DVDAuthor path"), "Open", sInitialPath, "", ,  )
  bExists = VRFileExists( sFile )
  if bExists==1 then
    ok = VRSet( "EF_dvdauthorpath", "Value", sFile )
return

/*:VRX         PB_dvddaopathsel_Click
*/
PB_dvddaopathsel_Click: 
  sFile = VRGet( "EF_dvddaopath", "Value" )
  sInitialPath = VRParseFilePath( sFile, "DP" )||"\"
  sFile = VRFileDialog( VRWindow(), SetupVar("Choose dvddao path"), "Open", sInitialPath, "", ,  )
  bExists = VRFileExists( sFile )
  if bExists==1 then
    ok = VRSet( "EF_dvddaopath", "Value", sFile )
return

/*:VRX         PB_encodepathsel_Click
*/
PB_encodepathsel_Click: 
  sFile = VRGet( "EF_encodepath", "Value" )
  sInitialPath = VRParseFilePath( sFile, "DP" )||"\"
  sFile = DirDialg( VRWindow(), SetupVar("Choose encodepath"), sInitialPath )
  if length( sFile ) > 0 then ok = VRSet( "EF_encodepath", "Value", sFile )
return

/*:VRX         PB_ffmpegpathsel_Click
*/
PB_ffmpegpathsel_Click: 
  sFile = VRGet( "EF_ffmpegpath", "Value" )
  sInitialPath = VRParseFilePath( sFile, "DP" )||"\"
  sFile = VRFileDialog( VRWindow(), SetupVar("Choose ffmpeg"), "Open", sInitialPath, "", ,  )
  bExists = VRFileExists( sFile )
  if bExists==1 then
    ok = VRSet( "EF_ffmpegpath", "Value", sFile )
return

/*:VRX         PB_logclear_Click
*/
PB_logclear_Click: 
  ok = VRMethod( "LB_Output", "Clear" )
return

/*:VRX         PB_logshow_Click
*/
PB_logshow_Click: 
  ok= VRLoadSecondary( "LOGSHOW" )
  ok= VRMethod( "LOGSHOW", "Activate" ) 
return

/*:VRX         PB_MClose_Click
*/
PB_MClose_Click: 
   call SW_Media_Close
return

/*:VRX         PB_Media_Click
*/
PB_Media_Click: 
    ok= VRLoadSecondary( "SW_Media" )
    ok= VRMethod( "SW_Media", "Activate" )
return

/*:VRX         PB_mkisofs2pathsel_Click
*/
PB_mkisofs2pathsel_Click: 
  sFile = VRGet( "EF_mkisofs2path", "Value" )
  sInitialPath = VRParseFilePath( sFile, "DP" )||"\"
  sFile = VRFileDialog( VRWindow(), SetupVar("Choose mkisofs2 path"), "Open", sInitialPath, "", ,  )
  bExists = VRFileExists( sFile )
  if bExists==1 then
    ok = VRSet( "EF_mkisofs2path", "Value", sFile )
return

/*:VRX         PB_MStart_Click
*/
PB_MStart_Click: 
  setBlank = VRGet( "RB_Blank", "Set" )
  setFormat = VRGet( "RB_Format", "Set" )
  ok = VRSet( "PB_MStart", "Enabled", 0 )
  ok = VRSet( "PB_MClose", "Enabled", 0 )
  error=0
  qname="DVDDAOQ"
  call RXQueue 'Create',qname
  oldq=RXQUEUE('Set',qname)
  /* Clean queue */
  DO WHILE QUEUED()\=0
	PULL str
  END
  'RXQUEUE 'qname' /CLEAR'

  if setBlank = 1 then do
    ok = VRSet( "SW_Media", "HintText", SetupVar("blanking") )
    launch=dvddaopath '--device '||dvddevice||' --blank fast 2>&1 |RXQUEUE '||qname||' /FIFO & ECHO DONEACTION 2>&1 |RXQUEUE '||qname||' /FIFO'
    launch='"'launch'"'
    echo launch '>> '|| logfile
    '@start "Blank DVD-RW with dvddao" /C /B /MIN 'launch
    call ParseOutDvddao 'Blank'
  end
  else
  do
    if setFormat = 1 then do
      ok = VRSet( "SW_Media", "HintText", SetupVar("formatting") )
      launch=dvddaopath '--device '||dvddevice||' --format dvd+rw 2>&1 |RXQUEUE '||qname||' /FIFO & ECHO DONEACTION 2>&1 |RXQUEUE '||qname||' /FIFO'
      launch='"'launch'"'
      echo launch '>> '|| logfile
      '@start "Quickformat DVD+RW with dvddao" /C /B /MIN 'launch
      call ParseOutDvddao 'Format'
    end
  end

  /* Clean queue */
  DO WHILE QUEUED()\=0
    PULL str
  END
  'RXQUEUE 'qname' /CLEAR'
  oldq=RXQUEUE('Set',oldq) 

  if error = 1 then do
    ok  = Beep( "200", "250" )
    if setBlank = 1 then    
      ok = VRSet( "SW_Media", "HintText", SetupVar("error-") )
    else
      ok = VRSet( "SW_Media", "HintText", SetupVar("error+") )
  end  
  else
    ok = VRSet( "SW_Media", "HintText", SetupVar("ready") )
  ok = VRSet( "PB_MStart", "Enabled", 1 )
  ok = VRSet( "PB_MClose", "Enabled", 1 )
  
return

/*:VRX         PB_POSTCOMMSEL_Click
*/
PB_POSTCOMMSEL_Click: 
  selfile = VRFileDialog( VRWindow(), SetupVar("Choose post program"), "Open", "*.*" )
  ok = VRSet( "EF_POSTCOMMAND", "Value", selfile )
return

/*:VRX         PB_Refresh_Click
*/
PB_Refresh_Click: 
  call CalculateSpace
  filecount = VRGet( "LB_MPGFiles", "Count" )
  if filecount <> 0 then do
    ok = VRSet( "DT_MB_All2", "Caption", Format(MBComplete,,2) )
  end
  else
    ok = VRSet( "DT_MB_All2", "Caption", '0' )
return

/*:VRX         PB_Remove_Click
*/
PB_Remove_Click: 
  selected = VRGet( "LB_MPGFiles", "Selected" )
  ok = VRMethod( "LB_MPGFiles", "Delete", selected )
  ok = VRMethod( "LB_TARGETFILES", "Delete", selected )
  call CheckChecked
return

/*:VRX         PB_Settings_Click
*/
PB_Settings_Click: 
    ok= VRLoadSecondary( "SETTINGS" )
    ok= VRMethod( "SETTINGS", "Activate" ) 
return

/*:VRX         PB_SettingsCancel_Click
*/
PB_SettingsCancel_Click: 
  call SETTINGS_Fini
return

/*:VRX         PB_SettingsOK_Click
*/
PB_SettingsOK_Click: 
    ffmpegpath= VRGet( "EF_ffmpegpath", "Value" )
    encodepath= VRGet( "EF_encodepath", "Value" )
    ffmpegpar1= VRGet( "EF_ffmpegPar1", "Value" )
    ffmpegpar2= VRGet( "EF_ffmpegPar2", "Value" )
    ffmpegrate= VRGet( "EF_bitrate", "Value" )
    ffmpegaurate= VRGet( "EF_aurate", "Value" )
    ffmpeginterlace= VRGet( "CB_Interlace", "Set" ) 
    ffmpegdeinterlace= VRGet( "CB_Deinterlace", "Set" )
    ffmpeg2pass= VRGet( "CB_2PassEncode", "Set" )
    ffmpegsys= VRGet( "DDCB_SYS", "Value" )
    ffmpegMVignore = VRGet( "CB_MVIgnore", "Set" )
    dvdauthorpath= VRGet( "EF_dvdauthorpath", "Value" )
    dvdauthorparVOB= VRGet( "EF_dvdauthorParVOB", "Value" )
    dvdauthorparTOC= VRGet( "EF_dvdauthorParTOC", "Value" )
    dvdauthorsys= VRGet( "DDCB_AUTHSYS", "Value" )
    dvdauthoraspect= VRGet( "DDCB_AUTHASPECT", "Value" )
    mkisofs2path= VRGet( "EF_mkisofs2path", "Value" )
    mkisofs2par= VRGet( "EF_mkisofs2Par", "Value" )
    dvddaopath= VRGet( "EF_dvddaopath", "Value" )    
    dvddaopar= VRGet( "EF_dvddaoPar", "Value" )
    dvddevice= VRGet( "EF_dvddevice", "Value" )
    dvdspeed= VRGet( "EF_dvdspeed", "Value" )
    errorignore = VRGet( "MLE_ignoreErr", "Value" )
    structpath= VRGet( "EF_structurepath", "Value" )
    delmpgfiles = VRGet( "CB_delmpgfiles", "Set" )
    deldvdfolder = VRGet( "CB_deldvdfolder", "Set" )
    delimage = VRGet( "CB_delimage", "Set" )
    dellogfile = VRGet( "CB_dellogfile", "Set" )
    postCommand = VRGet( "EF_POSTCOMMAND", Value )
    videoplayerpath= VRGet( "EF_VIDEOPLAYERPATH", "Value" )
    videoplayerpar= VRGet( "EF_VIDEOPLAYERPAR", "Value" )
    language = VRGet( "DDCB_LANGUAGE", "Value" )
    
    ok= VRSetIni("DVDVIDEO", "ffmpegpath", ffmpegpath, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "encodepath", encodepath, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "ffmpegpar1", ffmpegpar1, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "ffmpegpar2", ffmpegpar2, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "ffmpegrate", ffmpegrate, ActDir"\DVDBURN.INI", "NoClose" )    
    ok= VRSetIni("DVDVIDEO", "ffmpegaurate", ffmpegaurate, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "ffmpeginterlace", ffmpeginterlace, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "ffmpegdeinterlace", ffmpegdeinterlace, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "ffmpeg2pass", ffmpeg2pass, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "ffmpegsys", ffmpegsys, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "ffmpegMVignore", ffmpegMVignore, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "dvdauthorpath", dvdauthorpath, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "dvdauthorparVOB", dvdauthorparVOB, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "dvdauthorparTOC", dvdauthorparTOC, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "dvdauthorsys", dvdauthorsys, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "dvdauthoraspect", dvdauthoraspect, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "mkisofs2path", mkisofs2path, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "mkisofs2par", mkisofs2par, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "dvddaopath", dvddaopath, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "dvddaopar", dvddaopar, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "dvddevice", dvddevice, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "dvdspeed", dvdspeed, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "structpath", structpath, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "errorignore", errorignore, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "delmpgfiles", delmpgfiles, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "deldvdfolder", deldvdfolder, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "delimage", delimage, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "dellogfile", dellogfile, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "postCommand", postCommand, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "videoplayerpath", videoplayerpath, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "videoplayerpar", videplayerpar, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "language", language, ActDir"\DVDBURN.INI" )

    call SetLanguage
    call CheckParameters
    call ReadFolders
    call SETTINGS_Fini
return

/*:VRX         PB_Start_Click
*/
PB_Start_Click:
error=0
breaked=0
qname="DVDBURNQ"
call RXQueue 'Create',qname
oldq=RXQUEUE('Set',qname)
/* Clean queue */
DO WHILE QUEUED()\=0
  PULL str
END
'RXQUEUE 'qname' /CLEAR'

ok = VRSet( "PB_Start", "Enabled", 0 )
ok = VRSet( "PB_Settings", "Enabled", 0 )
ok = VRSet( "PB_Media", "Enabled", 0 )
ok = VRSet( "PB_Add", "Enabled", 0 )
ok = VRSet( "PB_Remove", "Enabled", 0 )
ok = VRSet( "DT_Operation", "Caption", "" )
ok = VRSet( "SL_Progress", "Percentile", '0' )
ok = VRSet( "DT_Percent", "Caption", '0'||'%' )
ok = VRSet( "PB_logshow", "Enabled", 0 )
ok = VRSet( "PB_logclear", "Enabled", 0 )
ok = VRSet( "DT_FREE_1", "Visible", 1 )
ok = VRSet( "DT_FREE_1MB", "Visible", 1 )
ok = VRSet( "DT_Text_MBF2", "Visible", 1 )

call PB_Refresh_Click
count = VRGet( "LB_MPGFiles", "Count" )      

DVDName = VRGet( "Combo_Name", Value )
/* replace spaces with underscore */
DVDName = translate(DVDName, '_', ' ')
position = VRMethod( "LB_Output", "AddString", SetupVar("Log operation starts"),  )
ffmpegfolder = VRParseFilePath( ffmpegpath, "DP" )
dvdauthorfolder = VRParseFilePath( dvdauthorpath, "DP" )

nPosLastBS = lastpos('\',structpath )
length  = Length( structpath )
if length != nPosLastBS then
  structpath = structpath||'\'

if length(encodepath) > 0 then do
  nPosLastBS = lastpos('\',encodepath )
  length  = Length( encodepath )
  if length != nPosLastBS then
    encodepathused = encodepath||'\'
  else
    encodepathused = encodepath
end
else
  encodepathused = structpath

imagepath = structpath||DVDName

logfile=structpath||DVDName||'_log.txt'
position = VRMethod( "LB_Output", "AddString", SetupVar("Log Logfile is")||" "||logfile,  )
call SysMkDir structpath||DVDName

MBComplete = 0
kBReady=0
kBCum = 0

echo 'log for creating '||DVDName||' > ' ||logfile
setTranscode = VRGet( "CB_Transcode", "Set" )
if setTranscode = 1 then do
  progstarted = translate(VRParseFileName( ffmpegpath, "NE" ))
  call CalculateSpace
  ok = VRSet( "CB_Transcode", "Enabled", 0 )
  ok = VRSet( "DT_Operation", "Caption", SetupVar("Operation Written") )
  ok = VRSet( "DT_Text_MB", "Visible", 1 )

  do n = 1 to count
    ok = VRSet( "DT_Text_MB", "Caption", "MB" )
    string = VRMethod( "LB_MPGFiles", "GetString", n )
    filename = VRParseFileName( string, "NE" )
    newfile = (VRParseFileName( string, "N" ))||'.MPG'
    string = SpaceCheck(string)
    ok = VRSet( "DT_Operation", "Caption", SetupVar("Operation Transcoded") )
    neudir = directory(ffmpegfolder)
    if ffmpegsys = "auto" then
      launch=ffmpegpath ' -i ' string ' -y -target dvd'
    else
      launch=ffmpegpath ' -i ' string ' -y -target '||ffmpegsys||'-dvd'
    if ffmpeg2pass = 1 then do
      position = VRMethod( "LB_Output", "AddString", SetupVar("Log Transcoding")||" "||filename||" pass 1",  )
      launch = launch ' -pass 1'   
    end
    else
      position = VRMethod( "LB_Output", "AddString", SetupVar("Log Transcoding")||" "||filename,  )
    if ffmpeginterlace = 1 then
      launch = launch ' -ilme'
    if ffmpegdeintlace = 1 then
      launch = launch ' -deinterlace'
    encodefile = SpaceCheck(encodepathused||newfile)
    launch = launch ' -b ' ffmpegrate||'k -ab ' ffmpegaurate||'k ' ffmpegpar1 ' ' encodefile||' 2>&1 |RXQUEUE '||qname||' /FIFO & ECHO DONEACTION 2>&1 |RXQUEUE '||qname||' /FIFO'
    launch='"'launch'"'
    echo launch '>> '|| logfile
    '@start "Transcode file p1" /C /B /MIN 'launch
    call ParseOutput 'Trans', MBComplete
    kBCum = kBCum + kBReady

    if (breaked=1) | (error = 1) then do
      call PB_Start_End
      return
    end

    if ffmpeg2pass = 1 then do                  /* second pass */
      position = VRMethod( "LB_Output", "AddString", SetupVar("Log Transcoding")||" "||filename||" pass 2",  )
      ok = VRSet( "DT_Operation", "Caption", SetupVar("Operation Transcoded") )
      launch=ffmpegpath ' -i ' string ' -y -target dvd -pass 2'
      if ffmpeginterlace = 1 then
        launch = launch ' -ilme'
      if ffmpegdeintlace = 1 then
        launch = launch ' -deinterlace'
      encodefile = SpaceCheck(encodepathused||newfile)
      launch = launch ' -b ' ffmpegrate||'k -ab ' ffmpegaurate||'k ' ffmpegpar2 ' ' encodefile||' 2>&1 |RXQUEUE '||qname||' /FIFO & ECHO DONEACTION 2>&1 |RXQUEUE '||qname||' /FIFO'
      launch='"'launch'"'
      echo launch '>> '|| logfile
      '@start "Transcode MPEG file p2" /C /B /MIN 'launch
      call ParseOutput 'Trans', MBComplete
      kBCum = kBCum + kBReady

      if (breaked=1) | (error =1) then do
        call PB_Start_End
        return
      end

    end
  end
  ok = VRSet( "MainWin", "Caption", mainTitle )
  ok = VRSet( "DT_Percent", "Caption", '100%' )
  ok = VRSet( "SL_Progress", "Percentile", 100 )
end
setStructure = VRGet( "CB_CreateStructure", "Set" )
ok = VRSet( "DT_MB_All2", "Visible", 0 )
ok = VRSet( "DT_Text_MBALL2", "Visible", 0 )
ok = VRSet( "DT_Text_MBF2", "Visible", 0 )
if setStructure = 1 then do 
  progstarted = translate(VRParseFileName( dvdauthorpath, "NE" ))
  MBComplete = 0  
  ok = VRRedirectStdIO( "Off" )
  do n = 1 to count
    string = VRMethod( "LB_MPGFiles", "GetString", n )
    file = (VRParseFileName( string, "N" ))||'.MPG'      
    ext = VRParseFileName( string, "E" )
    filename = SpaceCheck(encodepathused||file)
    FileSize = 0
    FileSize = GetFileSize(filename)
    if FileSize = 0 then do
      if (Translate(ext) = 'MPG') | (Translate(ext) = 'MPEG') then do
        filename = string
        FileSize = GetFileSize(filename)
      end
      else do 
        ok  = Beep( "200", "250" )
        position = VRMethod( "LB_Output", "AddString", SetupVar("Log File not found")||" "||filename  )
        position = VRMethod( "LB_Output", "AddString", SetupVar("Log must encode")  )
        error = 1
        call PB_Start_End
        return
      end
    end
    FileList.n = filename
    MBComplete = MBComplete + FileSize
  end
  FileList.0 = count
  ok = VRRedirectStdIO( "On" )
  ok = VRSet( "CB_Transcode", "Enabled", 0 )
  ok = VRSet( "CB_CreateStructure", "Enabled", 0 )
  ok = VRSet( "DT_Text_MB", "Visible", 1 )
  ok = VRSet( "DT_Text_MB", "Caption", SetupVar("Operation MB of") )
  neudir = directory(dvdauthorfolder)
  if count > 0 then do

    /* all additional options must be set in XML file !!! */
    launch=dvdauthorpath
    position = VRMethod( "LB_Output", "AddString", SetupVar("Log Creating VOB")  )
    XMLfile = structpath||DVDName||'.XML'
    call CreateXML XMLfile
    launch=launch||' -o ' structpath||DVDName||' -x '||XMLFile||' '||dvdauthorparVOB||' 2>&1 |RXQUEUE '||qname||' /FIFO & ECHO DONEACTION 2>&1 |RXQUEUE '||qname||' /FIFO'
    launch='"'launch'"'
    echo launch '>> '|| logfile
    '@start "Create VOBs with dvdauthor" /C /B /MIN 'launch
    call ParseOutput 'VTS', MBComplete

    if breaked=1 then do
      call PB_Start_End
      return
    end

    if error=1 then do
      call PB_Start_End
      return
    end

  end
  position = VRMethod( "LB_Output", "AddString", SetupVar("Log Creating DVD"),  )
  ok = VRSet( "DT_Text_MB", "Visible", 0 )
  launch = dvdauthorpath ' -T -o '||dvdauthorparTOC||' '||structpath||DVDName||' 2>&1 |RXQUEUE '||qname||' /FIFO & ECHO DONEACTION 2>&1 |RXQUEUE '||qname||' /FIFO'
  launch='"'launch'"'
  echo launch '>> '|| logfile
  '@start "Create TOC with dvdauthor" /C /B /MIN 'launch
  call ParseOutput 'TOC'
  ok = VRSet( "MainWin", "Caption", mainTitle )  
  ok = VRSet( "DT_Percent", "Caption", '100%' )
  ok = VRSet( "SL_Progress", "Percentile", 100 )
end
setISO = VRGet( "CB_CreateISO", "Set" )
setSplit = VRGet( "CB_Split", "Set" ) 
setPipe = VRGet( "CB_Pipe", "Set" ) 
ok = VRSet( "CB_Split", "Enabled", 0 )
ok = VRSet( "CB_Pipe", "Enabled", 0 )
ok = VRSet( "DT_Text_MB", "Visible", 0 )
if dvdspeed > 0 then speedpar = "--speed "||dvdspeed
else speedpar = ""
if setISO = 1 then do
  progstarted = translate(VRParseFileName( mkisofs2path, "NE" ))
  neudir = directory(structpath||DVDName||"\VIDEO_TS")
  ok = VRFileExists( structpath||DVDName||"\VIDEO_TS\VIDEO_TS.IFO" )
  if ok = 0 then do
    ok  = Beep( "200", "250" )
    position = VRMethod( "LB_Output", "AddString", SetupVar("Log Error DVD no VIDEO_TS.IFO"),  )
    error=1
    call PB_Start_End
    return
  end
  ok = VRFileExists( structpath||DVDName||"\VIDEO_TS\VTS_01_1.VOB" )
  if ok = 0 then do
    ok  = Beep( "200", "250" )
    position = VRMethod( "LB_Output", "AddString", SetupVar("Log Error DVD no VOB"),  )
    error=1
    call PB_Start_End
    return
  end
  ok = VRSet( "CB_Transcode", "Enabled", 0 )
  ok = VRSet( "CB_CreateStructure", "Enabled", 0 )
  ok = VRSet( "CB_CreateISO", "Enabled", 0 )
  ok = VRSet( "DT_Operation", "Caption", SetupVar("Operation Writing image") )
  neudir = directory(imagepath)
  if setPipe = 1 then
    position = VRMethod( "LB_Output", "AddString", SetupVar("Log Piping"),  )
  else
    position = VRMethod( "LB_Output", "AddString", SetupVar("Log Creating ISO"),  )
  if setSplit = 1 then
    launch=mkisofs2path '-dvd-video -o dvdimage '||mkisofs2par||' -v -split-output -r . 2>&1 |RXQUEUE '||qname||' /FIFO & ECHO DONEACTION 2>&1 |RXQUEUE '||qname||' /FIFO'
  else
  ok = VRDeleteFile( structpath||DVDName||"\dvdimage." )  
  if setPipe = 1 then
    launch=mkisofs2path '2>nul -quiet -dvd-video '||mkisofs2par||' -v -r . |'||dvddaopath '--device '||dvddevice||' --eject '||dvddaopar||' '||speedpar||' - 2>&1 |RXQUEUE '||qname||' /FIFO & ECHO DONEACTION 2>&1 |RXQUEUE '||qname||' /FIFO'
  else
    launch=mkisofs2path '-dvd-video -o dvdimage '||mkisofs2par||' -v -r . 2>&1 |RXQUEUE '||qname||' /FIFO & ECHO DONEACTION 2>&1 |RXQUEUE '||qname||' /FIFO'
  launch='"'launch'"'
  echo launch '>> '|| logfile
  if setPipe =1 then do
    ok = VRSet( "MainWin", "Caption", mainTitle )
    ok = VRSet( "DT_Text_MB", "Visible", 1 )
    ok = VRSet( "DT_Text_MB", "Caption", SetupVar("Operation MB done") )
    ok = VRSet( "SL_Progress", "Visible", 0 )
    ok = VRSet( "DT_Percent", "Visible", 0 )
    ok = VRSet( "CB_BurnISO", "Enabled", 0 )
    '@start "Piping image direct to dvddao" /C /B /MIN 'launch
    call ParseOutput 'Pipe'
  end
  else do
    ok = VRSet( "SL_Progress", "Visible", 1 )
    ok = VRSet( "DT_Percent", "Visible", 1 )
    ok = VRSet( "DT_Text_MB", "Visible", 0 )
    '@start "Create image with mkisofs2" /C /B /MIN 'launch
    call ParseOutput 'MakeImg'
  end

  if (breaked=1) | (error=1) then do
    call PB_Start_End
    return
  end
  ok = VRSet( "MainWin", "Caption", mainTitle )
  ok = VRSet( "DT_Percent", "Caption", '100%' )
  ok = VRSet( "SL_Progress", "Percentile", 100 )
end
setBurn = VRGet( "CB_BurnISO", "Set" )
setPipe = VRGet( "CB_Pipe", "Set" )
ok = VRSet( "DT_Text_MBF2", "Visible", 0 )
if setISO = 0 then setPipe = 0 
if (setBurn = 1) & (setPipe = 0) then do
  progstarted = translate(VRParseFileName( dvddaopath, "NE" ))
  ok = VRSet( "CB_Transcode", "Enabled", 0 )
  ok = VRSet( "CB_CreateStructure", "Enabled", 0 )
  ok = VRSet( "CB_CreateISO", "Enabled", 0 )
  ok = VRSet( "CB_BurnISO", "Enabled", 0 )
  ok = VRSet( "CB_Pipe", "Enabled", 0 )
  ok = VRSet( "DT_Operation", "Caption", SetupVar("Operation Written DVD") )
  neudir = directory(imagepath)
  if setSplit = 1 then do
    position = VRMethod( "LB_Output", "AddString", SetupVar("Log Burning ISO files"),  )
    fc=0
    do while VRFileExists( "dvdimage_0"||fc ) = 1
      if fc=0 then
        imglist = "dvdimage_0"||fc
      else
        imglist = imglist" dvdimage_0"||fc
      fc = fc+1
    end
    if fc=1 then do
      error=1
      ok  = Beep( "200", "250" )
      position = VRMethod( "LB_Output", "AddString", SetupVar("Log no Image"),  )
    end  
    ok = VRSet( "DT_Text_MB", "Visible", 1 )
    ok = VRSet( "DT_Text_MB", "Caption", "MB of" )
    launch=dvddaopath '--device '||dvddevice||' '||speedpar||' --eject '||dvddaopar||' '||imglist||' 2>&1 |RXQUEUE '||qname||' /FIFO & ECHO DONEACTION 2>&1 |RXQUEUE '||qname||' /FIFO'
    launch='"'launch'"'
    echo launch '>> '|| logfile
    '@start "Burn DVD with dvddao" /C /B /MIN 'launch
    call ParseOutput 'Burn'

    if (breaked=1) | (error=1) then do
      call PB_Start_End
      return
    end

  end
  else do
    position = VRMethod( "LB_Output", "AddString", SetupVar("Log Burning ISO file"),  )
    if VRFileExists( "dvdimage" ) = 1 then do
      ok = VRSet( "DT_Text_MB", "Visible", 1 )
      ok = VRSet( "DT_Text_MB", "Caption", "MB of" )
      ok = VRSet( "DT_Operation", "Caption", "Written to DVD:" )
      launch=dvddaopath '--device '||dvddevice||' '||speedpar||' --eject '||dvddaopar||' '||dvdimage||' 2>&1 |RXQUEUE '||qname||' /FIFO & ECHO DONEACTION 2>&1 |RXQUEUE '||qname||' /FIFO'
      launch='"'launch'"'
      echo launch '>> '|| logfile
      '@start "Burn DVD with dvddao" /C /B /MIN 'launch
      call ParseOutput 'Burn'

      if (breaked=1) | (error=1) then do
        call PB_Start_End
        return
      end

    end
    else do
      ok  = Beep( "200", "250" )
      position = VRMethod( "LB_Output", "AddString", SetupVar("Log Image not found"),  )
      error = 1
    end
  end
  ok = VRSet( "MainWin", "Caption", mainTitle )
  ok = VRSet( "DT_Percent", "Caption", '100%' )
  ok = VRSet( "SL_Progress", "Percentile", 100 )
end
call PB_Start_End
return

PB_Start_End:
/* Clean queue */
DO WHILE QUEUED()\=0
  PULL str
END
'RXQUEUE 'qname' /CLEAR'
oldq=RXQUEUE('Set',oldq)  

setStructure = 1
setISO = 1
setBurn = 1

ok = VRChDir(structpath)         /* necessary for deleting dvd folder */ 
if (breaked = 0) & (error = 0) then do
  if (setStructure = 1) | (setISO = 1) | (setBurn = 1) then do
    if (delmpgfiles = 1) then do
      position = VRMethod( "LB_Output", "AddString", SetupVar("Log Delete encoded files"),  )      
      count = VRGet( "LB_MPGFiles", "Count" )      
      do n = 1 to count
        string = VRMethod( "LB_MPGFiles", "GetString", n )
        newfile = (VRParseFileName( string, "N" ))||'.MPG'
        encodefile = encodepathused||newfile        
        if VRFileExists( encodefile ) = 1 then do
          ok = VRDeleteFile( encodefile )
        end
      end
    end
  end
  if (setBurn = 1) & (setPipe = 0) then do
    if (delimage = 1) & (VRFileExists(structpath||DVDName||"\dvdimage.")) then do
      position = VRMethod( "LB_Output", "AddString", SetupVar("Log Delete images files"),  )      
      ok = VRDeleteFile( structpath||DVDName||"\dvdimage." )
    end
  end
  if (setISO = 1) | (setBurn = 1) then do
    if (deldvdfolder = 1) then do
      position = VRMethod( "LB_Output", "AddString", SetupVar("Log Delete structure"),  )      
      ok = VRDeleteFile( structpath||DVDName||"\VIDEO_TS\*.*" )
      ok = VRRMDir( structpath||DVDName||"\AUDIO_TS" )
      ok = VRRMDir( structpath||DVDName||"\VIDEO_TS" )
      ok = VRDeleteFile( structpath||DVDName||'.xml' )  
      ok = VRRMDir( structpath||DVDName )
    end
  end
  if (dellogfile = 1) then do
    call stream logfile, 'c', 'close'
    call SysSleep(0.5)
    position = VRMethod( "LB_Output", "AddString", SetupVar("Log Delete log"),  )      
    ok = VRDeleteFile( logfile )
  end
end

if breaked=1 then do
  ok  = Beep( "200", "100" )
  position = VRMethod( "LB_Output", "AddString", SetupVar("Log Operations canceled"), )
end
else do
  if error=0 then do
    position = VRMethod( "LB_Output", "AddString", SetupVar("Log Finished"),  )
    setPost = VRGet( "CB_POSTCOMMAND", "Set" )
    if (setPost = 1) & ((length(postCommand)) <> 0) then
      '@start "Run post command" /C 'postCommand
  end
  else do
    position = VRMethod( "LB_Output", "AddString", SetupVar("Log Errors"),  )
  end
end

ok = VRSet( "MainWin", "Caption", mainTitle )
hinttext = VRGet( "MainWin", "HintText" )
ok = VRSet( "MainWin", "HintText", SetupVar("Hint finished") )

ok = VRSet( "PB_Start", "Enabled", 1 )
ok = VRSet( "PB_Settings", "Enabled", 1 )
ok = VRSet( "PB_Media", "Enabled", 1 )
ok = VRSet( "PB_Add", "Enabled", 1 )
ok = VRSet( "PB_Remove", "Enabled", 1 )
ok = VRSet( "CB_Transcode", "Enabled", 1 )
ok = VRSet( "CB_CreateStructure", "Enabled", 1 )
ok = VRSet( "CB_CreateISO", "Enabled", 1 )
ok = VRSet( "CB_BurnISO", "Enabled", 1 )
ok = VRSet( "CB_Split", "Enabled", 1 )
ok = VRSet( "CB_Pipe", "Enabled", 1 )
ok = VRSet( "PB_logshow", "Enabled", VRFileExists(logfile) )
ok = VRSet( "PB_logclear", "Enabled", 1 )
call CheckChecked
return
/*:VRX         PB_structurepathsel_Click
*/
PB_structurepathsel_Click: 
  sFile = VRGet( "EF_structurepath", "Value" )
  sInitialPath = VRParseFilePath( sFile, "DP" )||"\"
  sFile = DirDialg( VRWindow(), SetupVar("Choose DVD path"), sInitialPath )
  if length( sFile ) > 0 then ok = VRSet( "EF_structurepath", "Value", sFile )
return

/*:VRX         PB_VIDEOPLAYERSEL_Click
*/
PB_VIDEOPLAYERSEL_Click: 
  sVFile = VRGet( "EF_VIDEOPLAYERPATH", "Value" )
  sVInitialPath = VRParseFilePath( sVFile, "DP" )||"\"
  sVFile = VRFileDialog( VRWindow(), SetupVar("Choose videoplayer"), "Open", sVInitialPath, "", ,  )
  bExists = VRFileExists( sVFile )
  if bExists==1 then
    ok = VRSet( "EF_VIDEOPLAYERPATH", "Value", sVFile )

return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         ReadFolders
*/
ReadFolders: 
  ok = VRMethod( "Combo_Name", "Clear" )
  rc = SysFileTree(structpath'*', folders, 'DO') 
  i=1
  do folders.0
    lbs = lastpos("\",folders.i)
    folders.i = strip(substr(folders.i,lbs+1,25))
    i=i+1
  end
  status = VRMethod( "Combo_Name", "AddStringList", "folders." )
return

/*:VRX         ReadSetup
*/
ReadSetup: 
 SetupDatei = ARG(1)
 i = 0
 do while lines(SetupDatei) <> 0
  i = i+1
  Zeile = linein(SetupDatei)
  j = pos('=',Zeile)
  if j <> 0 then do
   SetupKeys.i = strip(substr(Zeile,1,j-1),'B')
   SetupStrings.i = strip(substr(Zeile,j+1),'B')
  end
  else do
   SetupKeys.i = strip(Zeile,'B')
   SetupStrings.i = ''
  end
 end
 ok = lineout(SetupDatei)
 SetupKeys.0 = i
 SetupStrings.0 = i

return

/*:VRX         SetLangMain
*/
SetLangMain:
    /* main window captions */
    ok = VRSet( "DT_7", "Caption", SetupVar("DVD name") )
    ok = VRSet( "DT_1", "Caption", SetupVar("Source files") )
    ok = VRSet( "DT_22", "Caption", SetupVar("Target files") )
    ok = VRSet( "GB_1", "Caption", SetupVar("Operations") )
    ok = VRSet( "DT_23", "Caption", SetupVar("Fileinfo") )
    ok = VRSet( "DT_8", "Caption", SetupVar("Short log") )
    ok = VRSet( "CB_Transcode", "Caption", SetupVar("Transcode files") )
    ok = VRSet( "CB_CreateStructure", "Caption", SetupVar("Create DVD structure") )
    ok = VRSet( "CB_CreateISO", "Caption", SetupVar("Create ISO image") )
    ok = VRSet( "CB_Split", "Caption", SetupVar("split") )
    ok = VRSet( "CB_BurnISO", "Caption", SetupVar("Burn ISO image") )
    ok = VRSet( "CB_pipe", "Caption", SetupVar("pipe") )
    ok = VRSet( "PB_Refresh", "Caption", SetupVar("Calc size") )
    ok = VRSet( "PB_Start", "Caption", SetupVar("Start") )
    ok = VRSet( "PB_Settings", "Caption", SetupVar("Settings") )
    ok = VRSet( "PB_media", "Caption", SetupVar("Blank Media") )
    ok = VRSet( "CB_POSTCOMMAND", "Caption", SetupVar("Post command") )
    ok = VRSet( "PB_logclear", "Caption", SetupVar("Clear Short log") )
    ok = VRSet( "PB_logshow", "Caption", SetupVar("Show logfile") )
    ok = VRSet( "DT_TEXT_MBAll2", "Caption", SetupVar("Estimated space") )
    ok = VRSet( "mnu_fileinfo", "Caption", SetupVar("Menu Get fileinfo") )

    /* main window hints */
    ok = VRSet( "DT_7", "HintText", SetupVar("Hint DVD name") )
    ok = VRSet( "Combo_Name", "HintText", SetupVar("Hint DVD name") )
    ok = VRSet( "CB_Transcode", "HintText", SetupVar("Hint Transcode") )
    ok = VRSet( "CB_CreateStructure", "HintText", SetupVar("Hint DVD structure") )
    ok = VRSet( "CB_CreateISO", "HintText", SetupVar("Hint ISO image") )
    ok = VRSet( "CB_Split", "HintText", SetupVar("Hint split") )
    ok = VRSet( "CB_BurnISO", "HintText", SetupVar("Hint Burn ISO image") )
    ok = VRSet( "CB_pipe", "HintText", SetupVar("Hint pipe") )
    ok = VRSet( "DT_1", "HintText", SetupVar("Source files") )
    ok = VRSet( "LB_MPGFiles", "HintText", SetupVar("Source files") )
    ok = VRSet( "DT_22", "HintText", SetupVar("Target files") )
    ok = VRSet( "LB_TARGETFILES", "HintText", SetupVar("Target files") )
    ok = VRSet( "PB_Add", "HintText", SetupVar("Hint plus") )
    ok = VRSet( "PB_Remove", "HintText", SetupVar("Hint minus") )
    ok = VRSet( "PB_Refresh", "HintText", SetupVar("Hint calc") )
    ok = VRSet( "PB_Start", "HintText", SetupVar("Hint start") )
    ok = VRSet( "PB_Settings", "HintText", SetupVar("Hint settings") )
    ok = VRSet( "PB_Media", "HintText", SetupVar("Hint blank") )
    ok = VRSet( "CB_PostCommand", "HintText", SetupVar("Hint post command") )
    ok = VRSet( "SL_Progress", "HintText", SetupVar("Hint Progress") )
    ok = VRSet( "DT_8", "HintText", SetupVar("Hint shortlog") )
    ok = VRSet( "LB_Output", "HintText", SetupVar("Hint shortlog") )
    ok = VRSet( "PB_logclear", "HintText", SetupVar("Hint clear") )
    ok = VRSet( "PB_logshow", "HintText", SetupVar("Hint logfile") )
    ok = VRSet( "DT_23", "HintText", SetupVar("Hint Fileinfo") )
    ok = VRSet( "LB_FILEINFO", "HintText", SetupVar("Hint Fileinfo") )
return

/*:VRX         SetLangSettings
*/
SetLangSettings: 
    /* settings window captions */
    ok = VRSet( "Settings", "Caption", SetupVar("Settings") )
    ok = VRSet( "DT_9", "Caption", SetupVar("Red settings") )
    ok = VRSet( "PB_SettingsOK", "Caption", SetupVar("OK") )
    ok = VRSet( "PB_SettingsCancel", "Caption", SetupVar("Cancel") )
    ok = VRMethod( "NB_1", "SetTabText", "1", SetupVar("Common") )
return

/*:VRX         SetLangSettings_P0
*/
SetLangSettings_P0: 
    ok = VRSet( "DT_6", "Caption", SetupVar("DVD path") )
    ok = VRSet( "CB_delmpgfiles", "Caption", SetupVar("Delete MPG") )
    ok = VRSet( "CB_deldvdfolder", "Caption", SetupVar("Delete DVD") )
    ok = VRSet( "CB_delimage", "Caption", SetupVar("Delete image") )
    ok = VRSet( "CB_dellogfile", "Caption", SetupVar("Delete logfile") )
    ok = VRSet( "DT_15", "Caption", SetupVar("Program language") )
    ok = VRSet( "DT_5", "Caption", SetupVar("Post command setting") )
    ok = VRSet( "DT_13", "Caption", SetupVar("Videoplayer command") )
    ok = VRSet( "DT_19", "Caption", SetupVar("Videoplayer parameter") )
return

/*:VRX         SetLangSettings_P1
*/
SetLangSettings_P1: 
    ok = VRSet( "DT_2", "Caption", SetupVar("ffmpeg path") )
    ok = VRSet( "DT_16", "Caption", SetupVar("ffmpeg parameter 1") )
    ok = VRSet( "DT_Encodepath", "Caption", SetupVar("encodepath") )
    ok = VRSet( "DT_14", "Caption", SetupVar("ffmpeg parameter 2") )
    ok = VRSet( "CB_2PassEncode", "Caption", SetupVar("2-pass encoding") )
    ok = VRSet( "CB_Deinterlace", "Caption", SetupVar("Deinterlace") )
    ok = VRSet( "DT_12", "Caption", SetupVar("TV standard") )
    ok = VRSet( "CB_MVIgnore", "Caption", SetupVar("MV error ignore") )
    ok = VRSet( "DT_10", "Caption", SetupVar("Video bitrate (kBit/s)") )
    ok = VRSet( "DT_11", "Caption", SetupVar("Audio bitrate (kBit/s)") )
return

/*:VRX         SetLangSettings_P2
*/
SetLangSettings_P2: 
    ok = VRSet( "DT_3", "Caption", SetupVar("DVDAuthor path") )
    ok = VRSet( "DT_17", "Caption", SetupVar("VOB parameter") )
    ok = VRSet( "DT_13a", "Caption", SetupVar("TOC parameter") )
    ok = VRSet( "DT_20", "Caption", SetupVar("TV standard") )
    ok = VRSet( "DT_21", "Caption", SetupVar("aspect") )
return

/*:VRX         SetLangSettings_P3
*/
SetLangSettings_P3: 
    ok = VRSet( "DT_4", "Caption", SetupVar("mkisofs2 path") )
    ok = VRSet( "DT_18", "Caption", SetupVar("mkisofs2 parameter") )
return

/*:VRX         SetLangSettings_P4
*/
SetLangSettings_P4: 
    ok = VRSet( "DT_dvddaopath", "Caption", SetupVar("dvddao path") )
    ok = VRSet( "DT_dvddaopar", "Caption", SetupVar("dvddao parameter") )
    ok = VRSet( "DT_device", "Caption", SetupVar("Device ID") )
    ok = VRSet( "DT_Speed", "Caption", SetupVar("speed") )
    ok = VRSet( "DT_ignorelist", "Caption", SetupVar("error ignore list") )
return

/*:VRX         SetLanguage
*/
SetLanguage: 
  workingdirectory = VRGet( "Application", "WorkingDirectory" )
  fnr = 1
  langlistpos = 0
  langfiles.fnr = VRDir( workingdirectory"\lang_*.txt", "N", )
  if langfiles.fnr = language then langlistpos = fnr
  do while langfiles.fnr <> ""
    fnr = fnr+1
    langfiles.fnr = VRDir( , "N" )
    if langfiles.fnr = language then langlistpos = fnr
  end
  langfiles.0 = fnr-1
  if langlistpos > -1 then do
    call ReadSetup language
    call SetLangMain
  end
return

/*:VRX         Settings_Close
*/
Settings_Close: 
    call Settings_Fini
return

/*:VRX         Settings_Create
*/
Settings_Create: 
    call Settings_Init
    call SetLangSettings
return

/*:VRX         Settings_Fini
*/
Settings_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         Settings_Init
*/
Settings_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SetupVar
*/
SetupVar: 
 Key = ARG(1)
 Inhalt = ARG(2)
 gef = 0
 j = 0
 do i = 1 to SetupKeys.0
  if gef <> 1 then do
   if pos(translate(Key), translate(SetupKeys.i)) == 1 then do
    if Inhalt <> '' then do
     if translate(Inhalt) = '/L' then do
      SetupStrings.i = ''
      SetupKeys.i = '--/L--'
      j = j+1
     end
     else SetupStrings.i = Inhalt
    end
    gef = 1
    Ergebnis = strip( SetupStrings.i, 'B' )
   end
  end
 end
 Anzahl = SetupKeys.0+1-j
 SetupKeys.0 = Anzahl
 SetupStrings.0 = Anzahl
 if gef == 0 then do
  SetupKeys.Anzahl = Key
  SetupStrings.Anzahl = Inhalt
  Ergebnis = strip( SetupStrings.Anzahl, 'B' )
 end

return Ergebnis
/*:VRX         SpaceCheck
*/
SpaceCheck: 
  parse arg checkfolder
  nPosSpace = pos(' ',checkfolder)
  if (nPosSpace <> 0) & (substr(checkfolder,1,1) <> '"') then
    checkfolder = '"'||checkfolder||'"'
return checkfolder
/*:VRX         SW_Media_Activate
*/
SW_Media_Activate: 
    ok = VRSet( "SW_Media", "Caption", SetupVar("blank media") )
    ok = VRSet( "RB_Blank", "Caption", SetupVar("blank DVD-RW") )
    ok = VRSet( "RB_Format", "Caption", SetupVar("format DVD+RW") )
    ok = VRSet( "PB_MStart", "Caption", SetupVar("Start") )
    ok = VRSet( "PB_MClose", "Caption", SetupVar("close") )
return

/*:VRX         SW_Media_Close
*/
SW_Media_Close: 
    setBlank = VRGet( "RB_Blank", "Set" )
    setFormat = VRGet( "RB_Format", "Set" )
    ok= VRSetIni("DVDVIDEO", "setBlank", setBlank, ActDir"\DVDBURN.INI", "NoClose" )
    ok= VRSetIni("DVDVIDEO", "setFormat", setFormat, ActDir"\DVDBURN.INI" )
    call SW_Media_Fini
return

/*:VRX         SW_Media_Create
*/
SW_Media_Create: 
    call SW_Media_Init
    ok = VRSet( "RB_Blank", "Set", setBlank )
    ok = VRSet( "RB_Format", "Set", setFormat )
return

/*:VRX         SW_Media_Fini
*/
SW_Media_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_Media_Init
*/
SW_Media_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_P0_Close
*/
SW_P0_Close: 
    call SW_P0_Fini
return

/*:VRX         SW_P0_Create
*/
SW_P0_Create: 
    call SW_P0_Init
    ok = VRSet( "EF_structurepath", "Value", structpath )
    ok = VRSet( "CB_delmpgfiles", "Set", delmpgfiles )
    ok = VRSet( "CB_deldvdfolder", "Set", deldvdfolder )
    ok = VRSet( "CB_delimage", "Set", delimage )
    ok = VRSet( "CB_dellogfile", "Set", dellogfile )
    ok = VRSet( "EF_POSTCOMMAND", "Value", postCommand )
    ok = VRSet( "EF_VIDEOPLAYERPATH", "Value", videoplayerpath )
    ok = VRMethod( "DDCB_LANGUAGE", "AddStringList", "langfiles.",  )
    ok = VRSet( "DDCB_LANGUAGE", "Selected", langlistpos )
    call SetLangSettings_P0
return

/*:VRX         SW_P0_Fini
*/
SW_P0_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_P0_Init
*/
SW_P0_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_P1_Close
*/
SW_P1_Close: 
    call SW_P1_Fini
return

/*:VRX         SW_P1_Create
*/
SW_P1_Create: 
    call SW_P1_Init
    ok = VRSet( "EF_ffmpegpath", "Value", ffmpegpath )
    ok = VRSet( "EF_encodepath", "Value", encodepath )
    ok = VRSet( "EF_ffmpegPar1", "Value", ffmpegpar1 )
    ok = VRSet( "EF_ffmpegPar2", "Value", ffmpegpar2 )
    ok = VRSet( "EF_bitrate", Value, ffmpegrate )
    ok = VRSet( "EF_aurate", Value, ffmpegaurate )
/*  ok = VRSet( "CB_Interlace", "Set", ffmpeginterlace ) */
    ok = VRSet( "CB_DeInterlace", "Set", ffmpegdeinterlace )
    ok = VRSet( "CB_2PassEncode", "Set", ffmpeg2pass )
    ok = VRSet( "DDCB_SYS", "Value", ffmpegsys )
    ok = VRSet( "CB_MVignore", "Set", ffmpegMVignore )
    call CB_2PassEncode_Click
    call SetLangSettings_P1
return

/*:VRX         SW_P1_Fini
*/
SW_P1_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_P1_Init
*/
SW_P1_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_P2_Close
*/
SW_P2_Close: 
    call SW_P2_Fini
return

/*:VRX         SW_P2_Create
*/
SW_P2_Create: 
    call SW_P2_Init
    ok = VRSet( "EF_dvdauthorpath", "Value", dvdauthorpath )
    ok = VRSet( "EF_dvdauthorParVOB", "Value", dvdauthorparVOB )
    ok = VRSet( "EF_dvdauthorParTOC", "Value", dvdauthorparTOC )
    ok = VRSet( "DDCB_AUTHSYS", "Value", dvdauthorsys )
    ok = VRSet( "DDCB_AUTHASPECT", "Value", dvdauthoraspect )
    call SetLangSettings_P2
return
/*:VRX         SW_P2_Fini
*/
SW_P2_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_P2_Init
*/
SW_P2_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_P3_Close
*/
SW_P3_Close: 
    call SW_P3_Fini
return

/*:VRX         SW_P3_Create
*/
SW_P3_Create: 
    call SW_P3_Init
    ok = VRSet( "EF_mkisofs2path", "Value", mkisofs2path )
    ok = VRSet( "EF_mkisofs2Par", "Value", mkisofs2par )
    call SetLangSettings_P3
return

/*:VRX         SW_P3_Fini
*/
SW_P3_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_P3_Init
*/
SW_P3_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_P4_Close
*/
SW_P4_Close: 
    call SW_P4_Fini
return

/*:VRX         SW_P4_Create
*/
SW_P4_Create: 
    call SW_P4_Init
    ok = VRSet( "EF_dvddaopath", "Value", dvddaopath )
    ok = VRSet( "EF_dvddaoPar", "Value", dvddaopar )
    ok = VRSet( "EF_dvddevice", "Value", dvddevice )
    ok = VRSet( "EF_dvdspeed", "Value", dvdspeed )
    if length(errorignore) > 0 then
       ok = VRSet( "MLE_ignoreErr", "Value", errorignore )
    call SetLangSettings_P4
return

/*:VRX         SW_P4_Fini
*/
SW_P4_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_P4_Init
*/
SW_P4_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

