#ifndef _CDRDAO_H
#define _CDRDAO_H

/* cdrdao commands */
enum Command { UNKNOWN, SHOW_TOC, SHOW_DATA, READ_TEST, SIMULATE, WRITE,
               READ_TOC, DISK_INFO, READ_CD, TOC_INFO, TOC_SIZE, BLANK,
               SCAN_BUS, UNLOCK, COPY_CD, READ_CDDB, MSINFO, SETSPEED, DRIVE_INFO, DISCID };

/* cdrdao options. See docu for details */
struct daooptions {
       Command COMMAND;
       char *DRIVER_ID;
       char *SOURCE_DRIVER_ID;
       char *DRIVER_OPT;
       char *SOURCE_DRIVER_OPT;
       char *SCSI_DEVICE;
       char *SOURCE_SCSI_DEVICE;
       char *DATA_FILENAME;
       char *CDDB_SERVER_LIST;
       char *CDDB_LOCAL_DB_DIR;
       char *BLANKING_MODE;
       char *READ_SUBCHAN_MODE;
       char *TMP_FILE_DIR;
       int READING_SPEED;
       int WRITING_SPEED;
       int EJECT;
       int SWAP;
       int MULTI_SESSION;
       int VERBOSE;
       int SESSION;
       int FAST_TOC;
       int PAUSE;
       int READ_RAW;
       int MODE2_MIXED;
       int RELOAD;
       int FORCE;
       int PARANOIA_MODE;
       int ON_THE_FLY;
       int WRITE_SIMULATE;
       int USER_CAPACITY;
       int FULL_BURN;
       int CDDB_TIMEOUT;
       int WITH_CDDB;
       int TAO_SOURCE;
       int TAO_SOURCE_ADJUST;
       int KEEPIMAGE;
       int OVERBURN;
       int BUFFER_UNDER_RUN_PROTECTION;
       int WRITE_SPEED_CONTROL;
       int KEEP;
       int PRINT_QUERY;
       long SKIPBLOCK;
       int NON_ZERO_PAD;
       int NOTITLE;
       int PRIORITYCLASS;
       int PRIORITYDELTA;
       char * LOCK; /* the arrays of drive letter to lock */
       int FIFO_BUFFERS;
       int MAXRETRYS;
       int ERRORCONTROL;
};

/*
 Tha main dao function.

 tocfilename - toc filename just for error messages
 toccontent - pointer to pointer to toc file content ;) 
 abortsem - when this senaphore is posted, the writing process will be aborted.
 messagefunc - printf-like callback for messaging.
 os2titlefunc - callback for changing switchentry, if you need ;) 
*/
int _Optlink daomain(const char * tocfilename, char ** toccontent, struct daooptions * OPT, HEV abortSem, 
		void (_Optlink *messagefunc)(int level, const char *fmt), void (_Optlink *os2titlefunc)(int op, const char *message));

#include "cdtextout.h"
/*
  returns CD TEXT info from toc file.
*/
int _Optlink extractcdtext(const char * tocfilename, char ** toccontent, struct cdtextout ** out, int * num);

#endif /* _CDRDAO_H */