/* UPSMONS.CMD - External shutdown script for UPS Monitor for OS/2 */

/* CAUTION: As shipped, this file will not do anything. You must first
            select and unremark one of the listed shutdown scripts.
            Please read the comments carefully. Some of these samples
            will not shutdown OS/2 without prompts.

   DO NOT use SETBOOT because SETBOOT will restart your system after a shutdown.
   UPS may be armed for a timed turn-off and kill the power as you computer reboots.
   See the UPS Monitor Help for more details on disabling of the UPS turn-off.

   RECOMMENDATION: Use external shutdown only if you are 110% sure what you are doing.
*/


/* The SIMPLEST way
   If you only run PM applications, 'start SHUTDOWN' will work.
   Problem: Any DOS or OS/2 windowed or full screen sessions
   including Win-OS2 sessions, this will NOT work
   as you will be prompted to close these sessions. */
/*
'start SHUTDOWN'
*/

/* Warp 4 FP6 and later only.
You can use TSHUTDWN which is supplied on the last fixpack disk. You have to
unpack it manually, it is NOT installed automatically when you apply the fixpack.
TSHUTDWN is said to shutdown without prompting, however in some cases it will not work.
I could not shutdown an OS/2 full-screen sessions without getting prompted for it.
According to the fixpack README.1ST file, using TSHUTDWN /N will shutdown without prompting,
but again it did not work for me. Try TSHUTDWN first before you use it in this script.
*/

/*
'start TSHUTDWN'
*/


/* The UPSPMSD.DLL way
These commands below issue a DOSShutdown API call and secures the file system
such that the computer is ready to be turned off. It leaves the Presentation
Manager displayed but no user input is possible. Because the UPS is armed to turn
itself off, DO NOT reboot your computer. Rather, turn the UPS off, then on again.
That will reset the internal UPS turn-off timer.

DOSShutdown will secure the file system even if an irate thread is tying up your
system and would prevent a regular shutdown.

This is the command that gets executed when the external shutdown is disabled.
*/


/*

/* Load the UPSPMSD.DLL (supplied with UPS Monitor) */
call RxFuncAdd 'UPSLoadFuncs', 'UPSPMSD', 'UPSLoadFuncs'
call UPSLoadFuncs

SAY 'UPS Monitor is shutting system down. Please wait...'
rc = DosShutd('0')  /* perform the shutdown */

IF rc = 0 THEN
  DO
    SAY 'Shutdown has completed. The UPS has been armed and will'
    SAY 'turn off your computer after the set turn-off delay.'
    SAY 'Do NOT use Ctrl-Alt-Del to restart.'
    SAY 'To restart the system now, turn the UPS off'
    SAY 'manually and then restart.'
  END
ELSE
  SAY 'DosShutdown failed, rc = ' || rc

*/

SAY 'UPSMONS.CMD - External shutdown script for UPS Monitor for OS/2'
SAY ''
SAY 'CAUTION: As shipped, this file will not do anything.'
SAY 'You must first select and unremark one of the listed'
SAY 'shutdown scripts inside this file'.

EXIT

