# include <stdio.h>
# include <sys/types.h>

# ifndef lint
static char *rcs_id =
	"@(#) $Header: mp_main.c,v 2.5 89/05/25 10:42:35 mark Exp $";
# endif

# include "mp_head.h"

/*
 * mpage:	a program to reduce pages of print so that several pages
 * 	  	of output appear on one printed page.
 *
 * Written by:
 *   ...!uunet!\                       Mark Hahn, Sr Systems Engineer
 *              >pyrdc!mark            Pyramid Technology Corporation
 * ...!pyramid!/                       Vienna, Va    (703)848-2050
 *
 *
 * Copyright (c) 1988 Mark P. Hahn, Herndon, Virginia
 *  
 *     Permission is granted to anyone to make or distribute verbatim
 *     copies of this document as received, in any medium, provided
 *     that this copyright notice notice is preserved, and that the
 *     distributor grants the recipient permission for further
 *     redistribution as permitted by this notice.
 *
 */

/* $Log:	mp_main.c,v $
 * Revision 2.5  89/05/25  10:42:35  mark
 * changes to print a page count on stderr after the print job is queued.
 * 
 * Revision 2.4  89/05/25  08:58:25  mark
 * rearranged the rcs header keywords for better readability.
 * 
 * Revision 2.3  89/05/22  14:40:28  mark
 * Fixed the type-o in the rcs identification string
 * 
 * Revision 2.2  89/05/22  14:37:30  mark
 * Added rcs identification usable with the "what" program
 * 
 * Revision 2.1  89/05/22  14:31:15  mark
 * New Major Revision
 * 
 * Revision 1.1  89/05/22  14:19:56  mark
 * Initial revision
 *  */

main(argc,argv)
 int argc;
 char **argv;
{
	FILE *outfd;
	int currarg;
	struct sheet *thelist;
	struct sheet *thesheet;

	/*
	 * examine the environment for PRINTER and MPAGE environment variables
	 */
	if (do_env() == 0) {
		fprintf(stderr, usage, MPAGE);
		exit(1);
	}
		
	currarg = do_args(argc, argv, 0);
	if (currarg < 0) {
		fprintf(stderr, usage, MPAGE);
		exit(1);
	}

	/*
	 * if a printer was specified then create a lpr command using
	 * the specified printer, else output goes to standard out
	 */
	if (*printer) {
		(void)sprintf(outcommand, "ucb /usr/ucb/lpr -P%s", printer);
		if ((outfd = popen(outcommand, "w")) == NULL) {
			fprintf(stderr, "%s: cannot create pipe for '%s'\n",
				outcommand);
			perror(MPAGE);
		}
	} else {
		outfd = stdout;
	}

	/*
	 * pick the array of sheet lists based upon the specified option
	 */
	if (sheetorder == UPDOWN) {
		sheetlist = up_down;
	} else {
		sheetlist = left_right;
	}

	/*
	 * from the array of sheet lists pick the proper sheet list for
	 * the given sheetaspect, then select the proper sheet format
	 * for the given number of redueced pages per output page
	 */
	thelist = sheetlist[sheetaspect];
	thesheet = &(thelist[sheetindex]);

	/*
	 * if either lines or columns were specified as options, over
	 * the default sheets idea of the number of line or cloumns
	 * per reduced page
	 */
	if (opt_lines > 0) {
		thesheet->sh_plength = opt_lines;
	}
	if (opt_width > 0) {
		thesheet->sh_cwidth = opt_width;
	}

	/*
	 * if there are arguments left over after processing options, then
	 * these are names of files to process, else process the standard
	 * input
	 */
	if (currarg < argc) {
		ps_title(argv[currarg], outfd);
		for ( ;currarg < argc; currarg++) {
			do_file(argv[currarg], thesheet, outfd);
		}
	} else {
		ps_title("<stdin>", outfd);
		do_stdin(thesheet, outfd);
	}
	/*
	 * having processed all input, print out a PS trailer
	 * (timeing stuff stolen from old adobe troff stuff)
	 */
	fprintf(outfd, "%%%%Trailer\n");
	fprintf(outfd, "statusdict begin jobname print flush");
	fprintf(outfd, " (: Job finished:\\n) print\n");
	fprintf(outfd, "(\\tmpage time (s) = ) print flush usertime ");
	fprintf(outfd, "mp_stm sub 1000 div ==\n(\\tmpage pages = ) print ");
	fprintf(outfd, "flush pagecount mp_pgc sub ==\nend flush\n");
	fprintf(outfd, "%%%%Pages: %d\n", ps_pagenum);
	if (opt_verbose) {
		fprintf(stderr, "[%s: %d pages, ", MPAGE, ps_pagenum);
		if (*printer == 0) {
			fprintf(stderr, "on <stdout>]\n");
		} else {
			fprintf(stderr, "printer %s]\n", printer);
		}
	}
	/*
	 * proper clean up to make sure the pipe is flushed
	 */
	if (*printer) {
		(void)pclose(outfd);
	}
	return 0;
}

/*
 * ps_title prints a post script header suitable for PS processors
 */
ps_title(name, outfd)
 char *name;
 FILE *outfd;
{
	time_t curr_time;
	char *time_str;

	fprintf(outfd, "%%!PS-Adobe-1.0\n");
	fprintf(outfd, "%%%%DocumentFonts: Courier\n");
	fprintf(outfd, "%%%%Title: %s (mpage)\n", name, MPAGE);
	fprintf(outfd, "%%%%Creator: %s\n", MPAGE);
	(void)time(&curr_time);
	time_str = ctime(&curr_time);
	fprintf(outfd, "%%%%CreationDate: %s",time_str);
	fprintf(outfd, "%%%%Pages: (atend)\n");
	fprintf(outfd, "%%%%BoundingBox: 20 20 596 776\n");
	fprintf(outfd, "%%%%EndComments\n\n");
	fprintf(outfd, "/mp_stm usertime def\n");
	fprintf(outfd, "/mp_pgc statusdict begin pagecount end def\n");
	fprintf(outfd, "statusdict begin /jobname (%s) def end\n", name);
}

