/*
 * font.c - manipulating font informations
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "nup.h"

/*
 * use as buffer for Font List
 */

static  PFONTMETRICS    bufFntMet = NULL ;
static  int             numFntMet = 0    ;

/*
 * fontList - listup font metrics
 */

static  PFONTMETRICS    fontList(int *nFonts)
{
    HPS             hps ;
    PFONTMETRICS    pfm ;
    ULONG           nReq, nCnt, nRem ;
    
    /*
     * already listed, use them
     */

    if (bufFntMet != NULL) {
        *nFonts = numFntMet ;
	return bufFntMet ;
    }

    /*
     * listup fonts, query screen fonts, but PUBLIC (also used for print)
     */

    hps = WinGetPS(HWND_DESKTOP) ;
    
    nReq = 0 ;
    nCnt = GpiQueryFonts(hps, QF_PUBLIC,
                NULL, &nReq, sizeof(FONTMETRICS), NULL) ;

    if ((pfm = (PFONTMETRICS) malloc(sizeof(FONTMETRICS) * nCnt)) == NULL) {
        return NULL ;
    }
    
    nRem = GpiQueryFonts(hps, QF_PUBLIC,
                NULL, &nCnt, sizeof(FONTMETRICS), pfm) ;

    bufFntMet = pfm  ;
    numFntMet = nCnt ;
    
    *nFonts = numFntMet ;
    return bufFntMet ;
}

/*
 * fontFill - fill list box with font names
 */
 
void            fontFill(HWND hwndLbox)
{
    PFONTMETRICS    base, pfm ;
    int             nfnts, i  ;
    
    if ((base = fontList(&nfnts)) == NULL) {
        return ;
    }

    WinSendMsg(hwndLbox, LM_DELETEALL, NULL, NULL) ;

    for (i = 0, pfm = base ; i < nfnts ; i++, pfm++) {
        if ((pfm->fsDefn & FM_DEFN_GENERIC) == 0) {
	    continue ;
	}
	if ((pfm->fsDefn & FM_DEFN_OUTLINE) == 0) {
	    continue ;
	}
	if ((pfm->fsType & FM_TYPE_FIXED) == 0) {
	    continue ;
	}
	if ((pfm->fsType & FM_TYPE_MBCS) == 0) {
	    continue ;
	}
	WinSendMsg(hwndLbox, LM_INSERTITEM,
	    MPFROM2SHORT(LIT_SORTASCENDING, 0), MPFROMP(pfm->szFacename)) ;
    }
}

/*
 * fontSelect - mark selection on font list
 */

void            fontSelect(HWND hwndLbox, PSZ name)
{
    LONG    idx ;
    
    idx = (LONG) WinSendMsg(hwndLbox, LM_SEARCHSTRING,
                MPFROM2SHORT(0, LIT_FIRST), MPFROMP(name)) ;
    if (idx != LIT_NONE) {
        WinSendMsg(hwndLbox, LM_SELECTITEM,
	        MPFROMLONG(idx), MPFROMSHORT(TRUE)) ;
    }
}

/*
 * fontRefer - refer to font metrics of named font
 */

PFONTMETRICS    fontRefer(PSZ name)
{
    PFONTMETRICS    base, pfm ;
    int             nfnts, i  ;
    
    if ((base = fontList(&nfnts)) == NULL) {
        return NULL ;
    }

    for (i = 0, pfm = base ; i < nfnts ; i++, pfm++) {
        if (stricmp(pfm->szFacename, name) == 0) {
	    return pfm ;
	}
    }
    return NULL ;
}

