/****************************************************************************

PSNUP.CMD -- REXX version of psnup
Clark Gaylord
Blacksburg, Va
cgaylord@vt.edu

Version 1.1.OS2 -- 25 February 1995
     Fixed help, enabled -? and -h.  
     Allow stdin.
Version 1.0.OS2 -- 29 January 1995
     Initial OS/2 release.

*** MAN PAGE ***
NAME
     psnup - print n-up PostScript pages

SYNOPSIS
     psnup [-n 2|4|8|16] [-r] [-s #] [-f file] [-o outfile]

DESCRIPTION
     psnup takes an arbitrary PostScript file (or standard input)
     and filters it to give n-up printing.

OPTIONS
     -n value
          Select the number of page images that will  be  printed
          per sheet of paper. Allowed values are 2, 4, 8, and 16,
          and the default is 2.

     -r   Reverse the order in which page images are laid out  on
          the page. By default, page images are printed from left
          to right, top to bottom.  The -r flag prints the  pages
          from  right to left, bottom to top.  This can be useful
          when using psnup with print  spoolers  (such  as  Tran-
          Script)  that automatically reverse the pages being fed
          to the PostScript printer.

     -s   Select the spot for the first image to be printed.  The
          range of spots is from 0 to (nup - 1), where nup is the
          number of images per page.  The default is spot 0 (nor-
          mally the top left of the page).
 
     -f   File to be processed.  Filename may not contain spaces.
          Default is stdin.

     -o   Output file.  Default is stdout.

REQUIREMENTS
     This shell script uses the getopt(1) command, a  version  of
     which   is  in  the  public  domain  and  available  in  the
     comp.sources.unix archives.

OS/2 VERSION ALSO REQUIRES
     nup.pro  and  nup.epi  in  current   directory  or   %PSNUP%
     directory

SEE ALSO
     enscript(1), postscript(7)

AUTHOR
     The OS/2 REXX version is by Clark Gaylord (cgaylord@vt.edu).
     OS/2 version introduced -f and -o options.

     psnup is a shell script written by Roy Smith (phri!roy) that
     uses PostScript scripts written by Ned Batchelder at U. Penn
     (ned@UPenn.CSNet).  The manual page was contributed  by  Mic
     Kaczmarczik (mic@emx.utexas.edu).

****************************************************************************/

NupDir = Value( 'PSNUP', ,'OS2ENVIRONMENT' )
IF (NupDir = '') THEN
    NupDir = '.'

ProName = Stream( NupDir'\nup.pro', 'c', 'query exists' )
EpiName = Stream( NupDir'\nup.epi', 'c', 'query exists' )
IF ((ProName = '') | (EpiName = '')) THEN
    SIGNAL Help

NumUp = 2
Reverse = 'false'
Spot = 0
InFile = 'StdIn'
OutFile = 'StdOut'

/* Parse args */
PARSE UPPER ARG Args
IF ((Pos('-H', Args) > 0) | (Pos('-?', Args) > 0)) THEN
    SIGNAL Help
IF (Pos('-N', Args) > 0) THEN
    PARSE Value(Args) With '-N' NumUp .
IF (Pos('-R', Args) > 0) THEN
    Reverse = 'true'
IF (Pos('-S', Args) > 0) THEN
    PARSE Value(Args) With '-S' Spot .
IF (Pos('-F', Args) > 0) THEN
    PARSE Value(Args) With '-F' InFile .
IF (Pos('-O', Args) > 0) THEN
    PARSE Value(Args) With '-O' OutFile .

CALL Open ProName
CALL Open EpiName
IF (InFile \= 'StdIn') THEN
    CALL Open InFile

DO WHILE (Lines(ProName) > 0)
    Line = LineIn( ProName )
    SELECT
        WHEN (Line = '@#@Pages@#@') THEN
            Line = NumUp
        WHEN (Line = '@#@Rev@#@') THEN
            Line = Reverse
        WHEN (Line = '@#@Start@#@') THEN
            Line = Spot
        OTHERWISE
            ;
    END
    CALL LineOut OutFile, Line
END
CALL Stream ProName, 'c', 'close'

DO WHILE (Lines(InFile) > 0)
    CALL Lineout Outfile, LineIn(InFile)
END

DO WHILE (Lines(EpiName) > 0)
    CALL Lineout Outfile, LineIn(EpiName)
END

CALL Close ProName
CALL Close EpiName
CALL Close InFile
CALL Close OutFile

EXIT

Help:
    CALL LineOut StdErr,,
        'USAGE: psnup [-n 2|4|8|16] [-r] [-s #] [-f file] [-o outfile]'
    CALL LineOut StdErr, ' '
    CALL LineOut StdErr,,
        'Requires: nup.pro and nup.epi in current directory or %PSNUP%' 
    CALL LineOut StdErr, 'directory.'
    CALL LineOut StdErr, ' '
    CALL LineOut StdErr,,
        '       -n #    Number of pages to put on one page (default 2)'
    CALL LineOut StdErr,,
        '       -r      Reverses order'
    CALL LineOut StdErr,,
        '       -s #    Spot number to print first page (default 0)'
    CALL LineOut StdErr, ' '
    EXIT

Open:
    PARSE ARG JunkFile
    OpenRet = Stream( JunkFile, 'c', 'open' )
    IF (OpenRet \= 'READY:') THEN DO
        CALL LineOut StdErr, JunkFile 'could not be opened.'
        EXIT
    END
    RETURN 

Close:
    PARSE ARG JunkFile
    CloseRet = Stream( JunkFile, 'c', 'close' )
    IF ((CloseRet \= 'READY:') & (CloseRet \= '')) THEN DO
        CALL LineOut StdErr, JunkFile 'could not be closed.'
        EXIT
    END
    RETURN
