/* STARTAPP.CMD 

      REXX Program to start KAT and STOPAPP.CMD at a particular time.
      This program can be modified to control any OS/2 PM application.
      This program requires REXXUTIL.DLL
      Press Q or q to stop this program.

      Released to Public Domain - feel free to use and modify this code to your content.

      Author: A. Schwarz 
      Date: 4-28-97
*/

IF LoadRexxUtil() THEN
  EXIT
                       /* If you want to modify this program to start any other program, then */
                       /* change the three lines below. */

StartTime = '08:00'    /* This is the start time of the application. Use military time and fill */
                       /* in a zero for single digit hour, i.e 1:00am = 01:00 */

AppName = 'KAT.EXE'    /* This is the application to be started. Must be an OS/2 PM application */
AppDir = 'kopykat'     /* Directory where the application resides. Note: STARTAPP.CMD and STOPAPP.CMD */
                       /* must be run from same drive as the AppName program. */


SAY 'Scheduler Program for ' || AppName
SAY 'Start Time: ' || StartTime
SAY ''
SAY 'Press Q to quit program.'
SAY ''

OldTime = LEFT(TIME(), 5)
SAY "Current Time: " || OldTime

Loop:

CurrTime = LEFT(TIME(), 5)        /* get current time in hh:mm format */
IF CurrTime <> OldTime THEN
   DO
     SAY "Current Time: " || CurrTime   /* display current time every minute */
     OldTime = CurrTime
   END

IF StartTime = CurrTime THEN      /* StartTime and CurrTime match, start the application and close this program */
   DO
      SAY "Kat started."
      '@echo off'
      'cd\' || AppDir
      'start ' || AppName || ' /a'    /* starts KAT.EXE with the option /a which is auto-answer */
      'cd\'
      'start stopapp'                 /* start STOPAPP.CMD which will terminate the application */
      'exit'                          /* terminate STARTAPP.CMD (this program) */
   END
ELSE                      /* StartTime does not match CurrTime */
   count = 0
   DO WHILE count < 10
      CALL SysSleep 1           /* wait 10 seconds */
      count = count + 1

      IF CHARS() <> 0 THEN   /* check if there is a keyboard entry and get key if any */
        DO
          key = SysGetKey('NOECHO')
          IF key = 'q' | key = 'Q' THEN
             EXIT
        END
   END

SIGNAL Loop

EXIT

/* Load the RexxUtil library */
LoadRexxUtil:
 IF RxFuncQuery('SysLoadFuncs') THEN
   DO
    IF RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs') THEN
       DO
         SAY "Error: Couldn't load RexxUtil library."
         RETURN 1
       END
       CALL SysLoadFuncs
   END
RETURN 0

