
FTP(1)			     UNIX Reference Manual			FTP(1)

NAME
     ftp - ARPANET file transfer program

SYNOPSIS
     ftp [-v] [-d] [-i] [-n] [-U] [-p] [-g] [host]

DESCRIPTION
     Ftp is the user interface to the ARPANET standard File Transfer Protocol.
     The program allows a user to transfer files to and from a remote network
     site.

     Options may be specified at the command line, or to the command inter-
     preter.

     -v    Verbose option forces ftp to show all responses from the remote
	   server, as well as report on data transfer statistics.

     -n    Restrains ftp from attempting ``auto-login'' upon initial connec-
	   tion.  If auto-login is enabled, ftp will check the .netrc (see be-
	   low) file in the user's home directory for an entry describing an
	   account on the remote machine.  If no entry exists, ftp will prompt
	   for the remote machine login name (default is the user identity on
	   the local machine), and, if necessary, prompt for a password and an
	   account with which to login.

     -i    Turns off interactive prompting during multiple file transfers.

     -d    Enables debugging.

     -g    Disables file name globbing.

     -U    Disable data port range restrictions.

     -p    Enable passive mode operation for use behind connection filtering
	   firewalls.

     The client host with which ftp is to communicate may be specified on the
     command line.  If this is done, ftp will immediately attempt to establish
     a connection to an FTP server on that host; otherwise, ftp will enter its
     command interpreter and await instructions from the user.	When ftp is
     awaiting commands from the user the prompt `ftp>' is provided to the us-
     er.  The following commands are recognized by ftp:

     ! [command [args]]
		 Invoke an interactive shell on the local machine.  If there
		 are arguments, the first is taken to be a command to execute
		 directly, with the rest of the arguments as its arguments.

     $ macro-name [args]
		 Execute the macro macro-name that was defined with the macdef
		 command.  Arguments are passed to the macro unglobbed.

     account [passwd]
		 Supply a supplemental password required by a remote system
		 for access to resources once a login has been successfully
		 completed.  If no argument is included, the user will be
		 prompted for an account password in a non-echoing input mode.

     append local-file [remote-file]
		 Append a local file to a file on the remote machine.  If
		 remote-file is left unspecified, the local file name is used
		 in naming the remote file after being altered by any ntrans
		 or nmap setting.  File transfer uses the current settings for
		 type, format, mode, and structure.

     ascii	 Set the file transfer type to network ASCII. This is the de-
		 fault type.

     bell	 Arrange that a bell be sounded after each file transfer com-
		 mand is completed.

     binary	 Set the file transfer type to support binary image transfer.

     bye	 Terminate the FTP session with the remote server and exit
		 ftp. An end of file will also terminate the session and exit.

     case	 Toggle remote computer file name case mapping during mget
		 commands.  When case is on (default is off), remote computer
		 file names with all letters in upper case are written in the
		 local directory with the letters mapped to lower case.

     cd remote-directory
		 Change the working directory on the remote machine to remote-
		 directory.

     cdup	 Change the remote machine working directory to the parent of
		 the current remote machine working directory.

     chmod mode file-name
		 Change the permission modes of the file file-name on the re-
		 mote sytem to mode.

     close	 Terminate the FTP session with the remote server, and return
		 to the command interpreter.  Any defined macros are erased.

     cr 	 Toggle carriage return stripping during ascii type file re-
		 trieval.  Records are denoted by a carriage return/linefeed
		 sequence during ascii type file transfer.  When cr is on (the
		 default), carriage returns are stripped from this sequence to
		 conform with the UNIX single linefeed record delimiter.
		 Records on non-UNIX remote systems may contain single line-
		 feeds; when an ascii type transfer is made, these linefeeds
		 may be distinguished from a record delimiter only when cr is
		 off.

     delete remote-file
		 Delete the file remote-file on the remote machine.

     debug [debug-value]
		 Toggle debugging mode.  If an optional debug-value is speci-
		 fied it is used to set the debugging level.  When debugging
		 is on, ftp prints each command sent to the remote machine,
		 preceded by the string `-->'

     dir [remote-directory] [local-file]
		 Print a listing of the directory contents in the directory,
		 remote-directory, and, optionally, placing the output in
		 local-file. If interactive prompting is on, ftp will prompt
		 the user to verify that the last argument is indeed the tar-
		 get local file for receiving dir output.  If no directory is
		 specified, the current working directory on the remote ma-
		 chine is used.  If no local file is specified, or local-file
		 is -, output comes to the terminal.

     disconnect  A synonym for close.

     form format
		 Set the file transfer form to format. The default format is

		 ``file''.

     get remote-file [local-file]
		 Retrieve the remote-file and store it on the local machine.
		 If the local file name is not specified, it is given the same
		 name it has on the remote machine, subject to alteration by
		 the current case, ntrans, and nmap settings.  The current
		 settings for type, form, mode, and structure are used while
		 transferring the file.

     glob	 Toggle filename expansion for mdelete, mget and mput. If
		 globbing is turned off with glob, the file name arguments are
		 taken literally and not expanded.  Globbing for mput is done
		 as in csh(1).	For mdelete and mget, each remote file name is
		 expanded separately on the remote machine and the lists are
		 not merged.  Expansion of a directory name is likely to be
		 different from expansion of the name of an ordinary file: the
		 exact result depends on the foreign operating system and ftp
		 server, and can be previewed by doing `mls remote-files -'
		 Note: mget and mput are not meant to transfer entire directo-
		 ry subtrees of files.	That can be done by transferring a
		 tar(1) archive of the subtree (in binary mode).

     hash	 Toggle hash-sign (``#'') printing for each data block trans-
		 ferred.  The size of a data block is 1024 bytes.

     help [command]
		 Print an informative message about the meaning of command. If
		 no argument is given, ftp prints a list of the known com-
		 mands.

     idle [seconds]
		 Set the inactivity timer on the remote server to seconds sec-
		 onds.	If seconds is omitted, the current inactivity timer is
		 printed.

     lcd [directory]
		 Change the working directory on the local machine.  If no
		 directory is specified, the user's home directory is used.

     ls [remote-directory] [local-file]
		 Print a listing of the contents of a directory on the remote
		 machine.  The listing includes any system-dependent informa-
		 tion that the server chooses to include; for example, most
		 UNIX systems will produce output from the command `ls -l'.
		 (See also nlist.) If remote-directory is left unspecified,
		 the current working directory is used.  If interactive
		 prompting is on, ftp will prompt the user to verify that the
		 last argument is indeed the target local file for receiving
		 ls output.  If no local file is specified, or if local-file
		 is `-', the output is sent to the terminal.

     macdefNs macro-name
		 Define a macro.  Subsequent lines are stored as the macro
		 macro-name; a null line (consecutive newline characters in a
		 file or carriage returns from the terminal) terminates macro
		 input mode.  There is a limit of 16 macros and 4096 total
		 characters in all defined macros.  Macros remain defined un-
		 til a close command is executed.  The macro processor inter-
		 prets `$' and `\' as special characters.  A `$' followed by a
		 number (or numbers) is replaced by the corresponding argument
		 on the macro invocation command line.	A `$' followed by an
		 `i' signals that macro processor that the executing macro is
		 to be looped.	On the first pass `$i' is replaced by the
		 first argument on the macro invocation command line, on the
		 second pass it is replaced by the second argument, and so on.
		 A `\' followed by any character is replaced by that charac-
		 ter.  Use the `\' to prevent special treatment of the `$'.

     mdelete [remote-files]
		 Delete the remote-files on the remote machine.

     mdir remote-files local-file
		 Like dir, except multiple remote files may be specified.  If
		 interactive prompting is on, ftp will prompt the user to ver-
		 ify that the last argument is indeed the target local file
		 for receiving mdir output.

     mget remote-files
		 Expand the remote-files on the remote machine and do a get
		 for each file name thus produced.  See glob for details on
		 the filename expansion.  Resulting file names will then be
		 processed according to case, ntrans, and nmap settings.
		 Files are transferred into the local working directory, which
		 can be changed with `lcd directory'; new local directories
		 can be created with `! mkdir directory'.

     mkdir directory-name
		 Make a directory on the remote machine.

     mls remote-files local-file
		 Like nlist, except multiple remote files may be specified,
		 and the local-file must be specified.	If interactive prompt-
		 ing is on, ftp will prompt the user to verify that the last
		 argument is indeed the target local file for receiving mls
		 output.

     mode [mode-name]
		 Set the file transfer mode to mode-name. The default mode is
		 ``stream'' mode.

     modtime file-name
		 Show the last modification time of the file on the remote ma-
		 chine.

     mput local-files
		 Expand wild cards in the list of local files given as argu-
		 ments and do a put for each file in the resulting list.  See
		 glob for details of filename expansion.  Resulting file names
		 will then be processed according to ntrans and nmap settings.

     newer file-name
		 Get the file only if the modification time of the remote file
		 is more recent that the file on the current system.  If the
		 file does not exist on the current system, the remote file is
		 considered newer. Otherwise, this command is identical to
		 get.

     nlist [remote-directory] [local-file]
		 Print a  list of the files in a directory on the remote ma-
		 chine.  If remote-directory is left unspecified, the current
		 working directory is used.  If interactive prompting is on,
		 ftp will prompt the user to verify that the last argument is
		 indeed the target local file for receiving nlist output.  If
		 no local file is specified, or if local-file is -, the output
		 is sent to the terminal.

     nmap [inpattern outpattern]
		 Set or unset the filename mapping mechanism.  If no arguments
		 are specified, the filename mapping mechanism is unset.  If
		 arguments are specified, remote filenames are mapped during
		 mput commands and put commands issued without a specified re-
		 mote target filename.	If arguments are specified, local
		 filenames are mapped during mget commands and get commands
		 issued without a specified local target filename.  This com-
		 mand is useful when connecting to a non-UNIX remote computer
		 with different file naming conventions or practices.  The
		 mapping follows the pattern set by inpattern and outpattern.
		 [Inpattern] is a template for incoming filenames (which may
		 have already been processed according to the ntrans and case
		 settings).  Variable templating is accomplished by including
		 the sequences `$1', `$2', ..., `$9' in inpattern. Use `\' to
		 prevent this special treatment of the `$' character.  All
		 other characters are treated literally, and are used to de-
		 termine the nmap [inpattern] variable values.	For example,
		 given inpattern $1.$2 and the remote file name "mydata.data",
		 $1 would have the value "mydata", and $2 would have the value
		 "data".  The outpattern determines the resulting mapped file-
		 name.	The sequences `$1', `$2', ...., `$9' are replaced by
		 any value resulting from the inpattern template.  The se-
		 quence `$0' is replace by the original filename.  Additional-
		 ly, the sequence `[seq1, seq2]' is replaced by [seq1] if seq1
		 is not a null string; otherwise it is replaced by seq2. For
		 example, the command

		       nmap $1.$2.$3 [$1,$2].[$2,file]

		 would yield the output filename "myfile.data" for input file-
		 names "myfile.data" and "myfile.data.old", "myfile.file" for
		 the input filename "myfile", and "myfile.myfile" for the in-
		 put filename ".myfile".  Spaces may be included in
		 outpattern, as in the example: `nmap $1 sed "s/  *$//" > $1'
		 .  Use the `\' character to prevent special treatment of the
		 `$','[','[', and `,' characters.

     ntrans [inchars [outchars]]
		 Set or unset the filename character translation mechanism.
		 If no arguments are specified, the filename character trans-
		 lation mechanism is unset.  If arguments are specified, char-
		 acters in remote filenames are translated during mput com-
		 mands and put commands issued without a specified remote tar-
		 get filename.	If arguments are specified, characters in lo-
		 cal filenames are translated during mget commands and get
		 commands issued without a specified local target filename.
		 This command is useful when connecting to a non-UNIX remote
		 computer with different file naming conventions or practices.
		 Characters in a filename matching a character in inchars are
		 replaced with the corresponding character in outchars. If the
		 character's position in inchars is longer than the length of
		 outchars, the character is deleted from the file name.

     open host [port]
		 Establish a connection to the specified host FTP server.  An
		 optional port number may be supplied, in which case, ftp will
		 attempt to contact an FTP server at that port.  If the auto-
		 login option is on (default), ftp will also attempt to auto-
		 matically log the user in to the FTP server (see below).

     prompt	 Toggle interactive prompting.	Interactive prompting occurs
		 during multiple file transfers to allow the user to selec-
		 tively retrieve or store files.  If prompting is turned off
		 (default is on), any mget or mput will transfer all files,
		 and any mdelete will delete all files.

     proxy ftp-command
		 Execute an ftp command on a secondary control connection.
		 This command allows simultaneous connection to two remote ftp
		 servers for transferring files between the two servers.  The
		 first proxy command should be an open, to establish the sec-
		 ondary control connection.  Enter the command "proxy ?" to
		 see other ftp commands executable on the secondary connec-
		 tion.	The following commands behave differently when pref-
		 aced by proxy: open will not define new macros during the au-
		 to-login process, close will not erase existing macro defini-
		 tions, get and mget transfer files from the host on the pri-
		 mary control connection to the host on the secondary control
		 connection, and put, mput, and append transfer files from the
		 host on the secondary control connection to the host on the
		 primary control connection.  Third party file transfers de-
		 pend upon support of the ftp protocol PASV command by the
		 server on the secondary control connection.

     put local-file [remote-file]
		 Store a local file on the remote machine.  If remote-file is
		 left unspecified, the local file name is used after process-
		 ing according to any ntrans or nmap settings in naming the
		 remote file.  File transfer uses the current settings for
		 type, format, mode, and structure.

     pwd	 Print the name of the current working directory on the remote
		 machine.

     quit	 A synonym for bye.

     quote arg1 arg2 ...
		 The arguments specified are sent, verbatim, to the remote FTP
		 server.

     recv remote-file [local-file]
		 A synonym for get.

     reget remote-file [local-file]
		 Reget acts like get, except that if local-file exists and is
		 smaller than remote-file, local-file is presumed to be a par-
		 tially transferred copy of remote-file and the transfer is
		 continued from the apparent point of failure.	This command
		 is useful when transferring very large files over networks
		 that are prone to dropping connections.

     remotehelp [command-name]
		 Request help from the remote FTP server.  If a command-name
		 is specified it is supplied to the server as well.

     remotestatus [file-name]
		 With no arguments, show status of remote machine.  If file-
		 name is specified, show status of file-name on remote ma-
		 chine.

     rename [from] [to]
		 Rename the file from on the remote machine, to the file to.

     reset	 Clear reply queue.  This command re-synchronizes com-
		 mand/reply sequencing with the remote ftp server.  Resynchro-
		 nization may be necessary following a violation of the ftp
		 protocol by the remote server.

     restart marker
		 Restart the immediately following get or put at the indicated
		 marker. On UNIX systems, marker is usually a byte offset into
		 the file.

     restrict	 Toggle data port range restrictions.  When not operating in
		 passive mode,	the ftp, client program requests that the re-
		 mote server open a connection back to the client host on a
		 separate data port.  In previous versions, that remote port
		 fell in the range 1024..4999.	However, most firewall setups
		 filter that range of TCP ports because other services reside
		 there.  The default behavior now is for the client to request
		 that the server connect back to the client using the port
		 range 40000..44999.  Firewall administrators can chose to al-
		 low TCP connections in that range, if they deem it to not be
		 a security risk.

     rmdir directory-name
		 Delete a directory on the remote machine.

     runique	 Toggle storing of files on the local system with unique file-
		 names.  If a file already exists with a name equal to the
		 target local filename for a get or mget command, a ".1" is
		 appended to the name.	If the resulting name matches another
		 existing file, a ".2" is appended to the original name.  If
		 this process continues up to ".99", an error message is
		 printed, and the transfer does not take place.  The generated
		 unique filename will be reported.  Note that runique will not
		 affect local files generated from a shell command (see be-
		 low).	The default value is off.

     send local-file [remote-file]
		 A synonym for put.

     sendport	 Toggle the use of PORT commands.  By default, ftp will at-
		 tempt to use a PORT command when establishing a connection
		 for each data transfer.  The use of PORT commands can prevent
		 delays when performing multiple file transfers.  If the PORT
		 command fails, ftp will use the default data port.  When the
		 use of PORT commands is disabled, no attempt will be made to
		 use PORT commands for each data transfer.  This is useful for
		 certain FTP implementations which do ignore PORT commands
		 but, incorrectly, indicate they've been accepted.

     site arg1 arg2 ...
		 The arguments specified are sent, verbatim, to the remote FTP
		 server as a SITE command.

     size file-name
		 Return size of file-name on remote machine.

     status	 Show the current status of ftp.

     struct [struct-name]
		 Set the file transfer structure to struct-name. By default
		 ``stream'' structure is used.

     sunique	 Toggle storing of files on remote machine under unique file
		 names.  Remote ftp server must support ftp protocol STOU com-
		 mand for successful completion.  The remote server will re-
		 port unique name.  Default value is off.

     system	 Show the type of operating system running on the remote ma-
		 chine.

     tenex	 Set the file transfer type to that needed to talk to TENEX
		 machines.

     trace	 Toggle packet tracing.

     type [type-name]
		 Set the file transfer type to type-name. If no type is speci-
		 fied, the current type is printed.  The default type is net-

		 work ASCII.

     umask [newmask]
		 Set the default umask on the remote server to newmask. If
		 newmask is omitted, the current umask is printed.

     user user-name [password] [account]
		 Identify yourself to the remote FTP server.  If the password
		 is not specified and the server requires it, ftp will prompt
		 the user for it (after disabling local echo).	If an account
		 field is not specified, and the FTP server requires it, the
		 user will be prompted for it.	If an account field is speci-
		 fied, an account command will be relayed to the remote server
		 after the login sequence is completed if the remote server
		 did not require it for logging in.  Unless ftp is invoked
		 with ``auto-login'' disabled, this process is done automati-
		 cally on initial connection to the FTP server.

     verbose	 Toggle verbose mode.  In verbose mode, all responses from the
		 FTP server are displayed to the user.	In addition, if ver-
		 bose is on, when a file transfer completes, statistics re-
		 garding the efficiency of the transfer are reported.  By de-
		 fault, verbose is on.

     ? [command]
		 A synonym for help.

     Command arguments which have embedded spaces may be quoted with quote `"'
     marks.

ABORTING A FILE TRANSFER
     To abort a file transfer, use the terminal interrupt key (usually Ctrl-
     C).  Sending transfers will be immediately halted.  Receiving transfers
     will be halted by sending a ftp protocol ABOR command to the remote serv-
     er, and discarding any further data received.  The speed at which this is
     accomplished depends upon the remote server's support for ABOR process-
     ing.  If the remote server does not support the ABOR command, an `ftp>'
     prompt will not appear until the remote server has completed sending the
     requested file.

     The terminal interrupt key sequence will be ignored when ftp has complet-
     ed any local processing and is awaiting a reply from the remote server.
     A long delay in this mode may result from the ABOR processing described
     above, or from unexpected behavior by the remote server, including viola-
     tions of the ftp protocol.  If the delay results from unexpected remote
     server behavior, the local ftp program must be killed by hand.

FILE NAMING CONVENTIONS
     Files specified as arguments to ftp commands are processed according to
     the following rules.

     1.   If the file name `-' is specified, the stdin (for reading) or stdout
	  (for writing) is used.

     2.   If the first character of the file name is `|', the remainder of the
	  argument is interpreted as a shell command.  Ftp then forks a shell,
	  using popen(3) with the argument supplied, and reads (writes) from
	  the stdout (stdin).  If the shell command includes spaces, the argu-
	  ment must be quoted; e.g.  ``" ls -lt"''.  A particularly useful ex-
	  ample of this mechanism is: ``dir more''.

     3.   Failing the above checks, if ``globbing'' is enabled, local file
	  names are expanded according to the rules used in the csh(1);  c.f.
	  the glob command.  If the ftp command expects a single local file
	  (.e.g.  put), only the first filename generated by the "globbing"

	  operation is used.

     4.   For mget commands and get commands with unspecified local file
	  names, the local filename is the remote filename, which may be al-
	  tered by a case, ntrans, or nmap setting.  The resulting filename
	  may then be altered if runique is on.

     5.   For mput commands and put commands with unspecified remote file
	  names, the remote filename is the local filename, which may be al-
	  tered by a ntrans or nmap setting.  The resulting filename may then
	  be altered by the remote server if sunique is on.

FILE TRANSFER PARAMETERS
     The FTP specification specifies many parameters which may affect a file
     transfer.	The type may be one of ``ascii'', ``image'' (binary),
     ``ebcdic'', and ``local byte size'' (for PDP-10's and PDP-20's mostly).
     Ftp supports the ascii and image types of file transfer, plus local byte
     size 8 for tenex mode transfers.

     Ftp supports only the default values for the remaining file transfer pa-
     rameters: mode, form, and struct.

THE .netrc FILE
     The .netrc file contains login and initialization information used by the
     auto-login process.  It resides in the user's home directory.  The fol-
     lowing tokens are recognized; they may be separated by spaces, tabs, or
     new-lines:

     machine name
	       Identify a remote machine name. The auto-login process searches
	       the .netrc file for a machine token that matches the remote ma-
	       chine specified on the ftp command line or as an open command
	       argument.  Once a match is made, the subsequent .netrc tokens
	       are processed, stopping when the end of file is reached or an-
	       other machine or a default token is encountered.

     default   This is the same as machine name except that default matches
	       any name.  There can be only one default token, and it must be
	       after all machine tokens.  This is normally used as:

		     default login anonymous password user@site

	       thereby giving the user automatic anonymous ftp login to ma-
	       chines not specified in .netrc. This can be overridden by using
	       the -n flag to disable auto-login.

     login name
	       Identify a user on the remote machine.  If this token is pre-
	       sent, the auto-login process will initiate a login using the
	       specified name.

     password string
	       Supply a password.  If this token is present, the auto-login
	       process will supply the specified string if the remote server
	       requires a password as part of the login process.  Note that if
	       this token is present in the .netrc file for any user other
	       than anonymous, ftp will abort the auto-login process if the
	       .netrc is readable by anyone besides the user.

     account string
	       Supply an additional account password.  If this token is pre-
	       sent, the auto-login process will supply the specified string
	       if the remote server requires an additional account password,
	       or the auto-login process will initiate an ACCT command if it

	       does not.

     macdef name
	       Define a macro.	This token functions like the ftp macdef com-
	       mand functions.	A macro is defined with the specified name;
	       its contents begin with the next .netrc line and continue until
	       a null line (consecutive new-line characters) is encountered.
	       If a macro named init is defined, it is automatically executed
	       as the last step in the auto-login process.

ENVIRONMENT
     Ftp utilizes the following environment variables.

     HOME	 For default location of a .netrc file, if one exists.

     SHELL	 For default shell.

SEE ALSO
     ftpd(8)

HISTORY
     The ftp command appeared in 4.2BSD.

BUGS
     Correct execution of many commands depends upon proper behavior by the
     remote server.

     An error in the treatment of carriage returns in the 4.2BSD ascii-mode
     transfer code has been corrected.	This correction may result in incor-
     rect transfers of binary files to and from 4.2BSD servers using the ascii
     type.  Avoid this problem by using the binary image type.

4.2 Berkeley Distribution      December 30, 1993			    10
