/*
 * Definitions for Shifty-Terminal Emulator
 */

#ifndef	_SHIFTY
#define	_SHIFTY

#define	max(x, y)	(((x) > (y)) ? (x) : (y))
#define	min(x, y)	(((x) < (y)) ? (x) : (y))

extern	UCHAR	Version[] ;
extern	UCHAR	Notice[]  ;

/*
 * Execution Control Variables
 */

extern	USHORT	ExecDone ;	/* TRUE if Program Terminate	*/
extern	UCHAR	KeyAttn  ;	/* Attention Key Code		*/
extern  FILE    *LogFP   ;

/*
 * Working Threads & Semaphores
 */

extern	TID	TidRead ;	/* thread reading com-port	*/
extern	TID	TidDisp ;	/* thread writing to display	*/

extern  HMTX    DispSem ;       /* Sem to Access Display    */
extern  HMTX    CommSem ;       /* Sem to Access Comm.      */

extern  BOOL    DispSusp ;      /* TRUE if SCREEN is suspended  */
extern	UCHAR	DispAttr[] ;	/* Display Attributes		*/

/*
 * Communication Functions for Serial and Network
 */
 
typedef struct _COM {
    UCHAR   *comName ;                          /* Name of Comm. Device */
    BOOL    (*comInit) (INT ac, CHAR *av[]) ;   /* Initialize with args */
    VOID    (*comTerm) (VOID) ;                 /* Terminates           */
    VOID    (*comStat) (VOID) ;                 /* Report Device Status */
    INT     (*comRecv) (PUCHAR buff, INT len) ; /* Read from Device     */
    INT     (*comSend) (PUCHAR buff, INT len) ; /* Send to Debvice      */
    VOID    (*comBreak) (VOID) ;                /* send BREAK           */
    VOID    (*comFlush) (VOID) ;                /* flush queue          */
} COMREC, *COMPTR ;

extern	COMPTR  comDevice ;

/*
 * Emulation Functions for each Kanji Mode
 */
 
typedef struct _EMU {
    UCHAR   *emuName ;                  /* Name of Emulation    */
    UCHAR   *emuType ;                  /* telnet terminal type */
    VOID    (*emuRst) (VOID) ;                   
    VOID    (*emuScr) (UCHAR *buff, INT len) ;  
    VOID    (*emuKey) (USHORT ch, USHORT sc, USHORT stat) ;  
} EMUREC, *EMUPTR ;

extern	EMUPTR  emuDevice ;

/*
 * Queue Manupilation binding Recv & Disp
 */

BOOL    queInit(VOID) ;
INT     quePut(UCHAR *buf, INT len) ;
INT     queGet(UCHAR *buf, INT len) ;

/*
 * Screen Informations and Controls
 */
 
extern	INT	ScrLin ;        /* Lines   on Screen        */
extern	INT	ScrCol ;        /* Columns on Screen        */
extern  BOOL    ScrSmooth ;     /* TRUE for Smooth Scroll   */

BOOL    scrInit(int ac, char *av[], char *msg) ;
VOID	scrTerm(BOOL restore) ;
VOID	scrShow(VOID) ;
BOOL	scrSave(VOID) ;
BOOL	scrRest(VOID) ;

/*
 * exported Keyboard Operations for Local Functions
 */

USHORT	getkey(VOID) ;
UCHAR   *getlin(UCHAR *lin, INT len) ;
VOID	prompt(UCHAR *msg) ;
VOID    keywait(VOID) ;
BOOL    keycheck(VOID) ;

/*
 * exported Argument Operations for Local Functions
 */

extern	USHORT	Xargc    ;
extern	UCHAR	*Xargv[] ;

VOID    arginit(VOID) ;
INT     argexpand(UCHAR *name) ;

/*
 * Local Functions
 */

USHORT	showHelp(UCHAR *title) ;
VOID	showStatus(VOID)  ;
VOID    dirChange(VOID)   ;
VOID    dirListing(VOID)  ;
VOID    execCommand(VOID) ;
VOID    execShell(VOID)   ;

VOID    upLoading(VOID) ;
VOID    dnLoading(VOID) ;
VOID    saveScreen(BOOL append) ;

#endif
