/************************************************************************\
*                                                                        *
*         Microsoft C  Language Sample Gateway HLLAPI Module             *
*                                                                        *
*       (C) Copyright Software Corporation of America, Inc. 1989.        *
*       All Rights Reserved.                                             *
*                                                                        *
\************************************************************************/
 
#include "stdio.h"
 
#include "clim.h"                     /* Include the CLIM header        */
#include "hapi.h"                     /* Include sample subs. header    */
 
void pascal hllapi();
 
 
/************************************************************************\
*                                                                        *
*        Global Variables                                                *
*                                                                        *
\************************************************************************/
 
extern int CLIMFunction;              /* API function                   */
extern int CLIMLength;                /* API string length              */
extern int CLIMReturnCode;            /* API return code                */
 
 
/************************************************************************\
*                                                                        *
*  HapiQuerySessions - Function to issue HLLAPI call #10                 *
*                                                                        *
\************************************************************************/
 
int HapiQuerySessions(pSessions, Size)
struct Session *pSessions;
int             Size;
{
 
    CLIMFunction   = PCB_QUERY_SESSIONS;         /* Set Function Code   */
    CLIMLength     = Size;                       /* Set Length          */
    CLIMReturnCode = -1;                         /* Initialize Ret. Code*/
 
    hllapi(&CLIMFunction, pSessions, &CLIMLength, &CLIMReturnCode);
 
    return(CLIMReturnCode);                      /* Return to Caller    */
}
 
