/* Written on May 21 1995 by John J. Moss */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs' 
call SysLoadFuncs

CronTabFile = 'C:\FCron.Tab'
CronLogFile = 'C:\FCron.Log'
Interval = 30

call SysCls
call SysCurState 'OFF'
rc = SysSetIcon('FCron.Cmd', 'dumb.ico')

say '+--------------------------+'
say '|   FCron for OS/2         |'
say '|   Ver 1.01 May 21 1995   |'
say '+--------------------------+'
say ''
say 'FCron Table = ' || CronTabFile
say '---------------------------------------------------------'

i = 0
do while lines(CronTabFile)
	Buf=linein(CronTabFile)
	if (left(Buf,1) = '#') | (length(Buf) = 0) then iterate 
	i = i + 1
	Rec.i.Minute = '' ; Rec.i.Hour = '' ; Rec.i.MonthDay = ''
	parse var Buf Rec.i.Minute Rec.i.Hour Rec.i.MonthDay Rec.i.Month, 
		Rec.i.WeekDay Rec.i.Command
	Rec.i.Month = translate(Rec.i.Month)	 /* convert to upper case */
	Rec.i.WeekDay = translate(Rec.i.WeekDay) /* convert to upper case */
	Rec.i.Executed = 0
	say Rec.i.Minute Rec.i.Hour Rec.i.MonthDay Rec.i.Month Rec.i.WeekDay,
		Rec.i.Command
end

do forever
	call CurrentTime		     /* get current time */
	/* for every command in the table, check time vars */
	do j=1 to i
		if DoCommandNow(j) = 1 then do
			if Rec.j.Executed = 0 then do
				say date() time() ':::' Rec.j.Command
				'@echo' date() time() ':::' Rec.j.Command '>>' CronLogFile
				'@' || Rec.j.Command
				Rec.j.Executed = 1
				Rec.j.LMinute = Now.Minute
				Rec.j.LHour = Now.Hour
				Rec.j.LMonthDay = Now.MonthDay
				Rec.j.LMonth = Now.LMonth
				Rec.j.LWeekDay = Now.WeekDay
			end
		end
	end
	call SysSleep Interval
end

/* This function loads and parses the current time into chunks which can be */
/* used by this program. */

CurrentTime:
	Now.Time = time()
	Now.Date = date()
	parse var Now.Time Now.Hour':'Now.Minute':'Now.Second
	parse var Now.Date Now.Month Now.MonthDay Now.Year
	Now.Month = translate(left(Now.Month, 3))
	Now.WeekDay = translate(left(date('W'), 3))
return

/* This function is what decides whether it is time to do a command or not. */
/* It makes calls to the Match function to determine whether the current */
/* time matches any of the times in the cron.tab file. */
/* Returns 1 if it is time to execute the command or 0 if not. */

DoCommandNow: 
	parse arg ix 
	/* As soon as one argument does not match, kick-out of this routine */
	Answer = 0
	if (Match(ix Rec.ix.Minute Now.Minute Rec.ix.LMinute) = 1 &, 
		Match(ix Rec.ix.Hour Now.Hour Rec.ix.LHour) = 1 &,
		Match(ix Rec.ix.MonthDay Now.MonthDay Rec.ix.LMonthDay) = 1 &,
		Match(ix Rec.ix.Month Now.Month Rec.ix.LMonth) = 1 &,
		Match(ix Rec.ix.WeekDay Now.WeekDay Rec.ix.LWeekDay)) then Answer = 1 
	else
		Rec.Cmd.Executed = 0
return Answer

/* This function returns 1 if the arguments supplied indicate that a command */
/* is ripe to be executed or 0 if not.  This is how we ensure that a command */
/* gets executed only once during the designated time instead of executing   */
/* every time the program wakes up during that period.                       */

Match: 
	parse arg Cmd Rec Now Last
	RetVal = 0
	if ((Rec = '*') | (Rec = Now) | (pos(Now, Rec) > 0)) then do
		if Rec.Cmd.Executed = 1 then if Last \= Now then RetVal = 1
		if Rec.Cmd.Executed = 0 then RetVal = 1
	end
return RetVal
