#define INCL_WIN
#define INCL_DOS
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include "dialog.h"
#include "program.h"
#define  szAppName      "TIMERUN"
CHAR  szKeyName[]="PARAM";
#define  szKeySys       "SYSTEM"
#define ID_TIMER 1
#define WM_USER_CHANGEFILE    (WM_USER+10)
#define MiaCheck(_hwnd,_id,_param)  WinSendMsg(_hwnd,MM_SETITEMATTR,MPFROM2SHORT(_id,TRUE),MPFROM2SHORT(MIA_CHECKED,_param*MIA_CHECKED))
MRESULT EXPENTRY dialogProc(HWND,ULONG,MPARAM,MPARAM);
MRESULT EXPENTRY startEntryProc(HWND,ULONG,MPARAM,MPARAM);
MRESULT EXPENTRY endEntryProc(HWND,ULONG,MPARAM,MPARAM);
MRESULT EXPENTRY aboutProc(HWND,ULONG,MPARAM,MPARAM);
HINI     hini;
HWND     hwndMenu;
typedef struct {
   CHAR  drive[10];
   CHAR  dir[256];
   CHAR  name[256];
   CHAR  ext[256];
   } PRGPATH;
typedef PRGPATH   *PPRGPATH;
typedef struct {
   CHAR     hour;
   CHAR     min;
   CHAR     sec;
   CHAR     prog[256];
   CHAR     dir[256];
   CHAR     ender;
   }  TIMEPROG;
typedef struct {
   TIMEPROG start;
   TIMEPROG end;
   }  TIMERUN;
typedef struct {
   CHAR     minimized;
   CHAR     resv[256];
   }  TIMESYS;
INT   pattern=0;
TIMESYS  tsys;
TIMERUN  trun[3];
ULONG    startMin[3],endMin[3],nowMin;
VOID  applyParam(TIMERUN *ptrun,HWND hwnd)                                                      
{
   CHAR     buffer[256];
   WinQueryWindowText(WinWindowFromID(hwnd,ID_STAT_PROG),sizeof ptrun->start.prog,&ptrun->start.prog);
   WinQueryWindowText(WinWindowFromID(hwnd,ID_STAT_DIR),sizeof ptrun->start.dir,&ptrun->start.dir);
   WinQueryWindowText(WinWindowFromID(hwnd,ID_END_PROG ),sizeof ptrun->end.prog,&ptrun->end.prog);
   WinQueryWindowText(WinWindowFromID(hwnd,ID_END_DIR),sizeof ptrun->end.dir,&ptrun->end.dir);
   WinQueryWindowText(WinWindowFromID(hwnd,ID_STAT_HOUR),sizeof buffer,&buffer);
   ptrun->start.hour=atoi(buffer);
   WinQueryWindowText(WinWindowFromID(hwnd,ID_STAT_MIN ),sizeof buffer,&buffer);
   ptrun->start.min=atoi(buffer);
   ptrun->start.sec=0;
   WinQueryWindowText(WinWindowFromID(hwnd,ID_END_HOUR ),sizeof buffer,&buffer);
   ptrun->end.hour=atoi(buffer);
   WinQueryWindowText(WinWindowFromID(hwnd,ID_END_MIN  ),sizeof buffer,&buffer);
   ptrun->end.min=atoi(buffer);
   ptrun->end.sec=0;
   ptrun->end.ender=WinSendMsg(WinWindowFromID(hwnd,ID_ENDER),BM_QUERYCHECK,NULL,NULL);

   startMin[pattern]=ptrun->start.hour*60+ptrun->start.min;                    
   endMin[pattern]=ptrun->end.hour*60+ptrun->end.min;
}
VOID  saveParam(TIMERUN *ptrun,HWND hwnd)                                                      
{
   TIMERUN  tr;   CHAR buffer[20];
   tsys.minimized=WinSendMsg(WinWindowFromID(hwnd,ID_MINIMIZED),BM_QUERYCHECK,NULL,NULL);
   PrfWriteProfileData(hini,szAppName,szKeySys,&tsys,sizeof tsys);
   applyParam(&tr,hwnd);
   if(pattern)    sprintf(buffer,"%s%d",szKeyName,pattern);
   else strcpy(buffer,szKeyName);
   if(PrfWriteProfileData(hini,szAppName,buffer,&tr,sizeof tr)==FALSE)  {
      WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,"ۑł܂łB","vt@Cɏ݂ł܂",0,MB_OK|MB_ICONEXCLAMATION);
      }
}
VOID  loadParam(TIMERUN *ptrun,HWND hwnd)
{
   ULONG    ulDataLength;
   CHAR     buffer[256],i;
   ulDataLength=sizeof(TIMESYS);
   if(PrfQueryProfileData(hini,szAppName,szKeySys,&tsys,&ulDataLength)==FALSE)  {
      tsys.minimized=0;
      }
   WinCheckButton(hwnd,ID_MINIMIZED,tsys.minimized);
   for(i=0;i<3;i++)  {
      WinCheckButton(hwnd,ID_PATTERN+i,FALSE);
      MiaCheck(hwndMenu,ID_PATTERN+i,FALSE);
      }
   WinCheckButton(hwnd,ID_PATTERN+pattern,TRUE);
   MiaCheck(hwndMenu,ID_PATTERN+pattern,TRUE);
   ulDataLength=sizeof(TIMERUN);
   if(pattern)    sprintf(buffer,"%s%d",szKeyName,pattern);
   else  strcpy(buffer,szKeyName);
   if(PrfQueryProfileData(hini,szAppName,buffer,ptrun,&ulDataLength)==FALSE)  {
      strcpy(ptrun->start.prog,"");
      strcpy(ptrun->end.prog,"");
      ptrun->start.hour=23;
      ptrun->start.min=10;
      ptrun->start.sec=0;
      ptrun->end.hour=7;
      ptrun->end.min=50;
      ptrun->end.sec=0;
      }
   WinSetWindowText(WinWindowFromID(hwnd,ID_STAT_PROG),ptrun->start.prog);
   WinSetWindowText(WinWindowFromID(hwnd,ID_STAT_DIR),ptrun->start.dir);
   WinSetWindowText(WinWindowFromID(hwnd,ID_END_PROG),ptrun->end.prog);
   WinSetWindowText(WinWindowFromID(hwnd,ID_END_DIR),ptrun->end.dir);
   sprintf(buffer,"%d",ptrun->start.hour);
   WinSetWindowText(WinWindowFromID(hwnd,ID_STAT_HOUR),buffer);
   sprintf(buffer,"%d",ptrun->start.min);
   WinSetWindowText(WinWindowFromID(hwnd,ID_STAT_MIN),buffer);
   sprintf(buffer,"%d",ptrun->end.hour);
   WinSetWindowText(WinWindowFromID(hwnd,ID_END_HOUR),buffer);
   sprintf(buffer,"%d",ptrun->end.min);
   WinSetWindowText(WinWindowFromID(hwnd,ID_END_MIN),buffer);

   WinCheckButton(hwnd,ID_ENDER,ptrun->end.ender);
   WinCheckButton(hwnd,ID_MINIMIZED,tsys.minimized);

   startMin[pattern]=ptrun->start.hour*60+ptrun->start.min;      
   endMin[pattern]=ptrun->end.hour*60+ptrun->end.min;
}

CHAR     filename[256];
PRGPATH  path;
HWND     hwndList,hwndClient;
PFNWP    pfnwpStartList,pfnwpEndList;
INT   TimFlag=FALSE,firstCheck=FALSE;
HAB   hab;
int main(int argc,char *argv[])
{
   HMQ   hmq;
   HWND  hwndFrame;
   QMSG  qmsg;
   INT   i;
   PPRGPATH prg;
   PCHAR    profilePath;

   hab=WinInitialize(0);
   hmq=WinCreateMsgQueue(hab,0);
   for(i=1,pattern=0;i<argc;i++)  {
      pattern=atoi(argv[i]);
      if(pattern==0||pattern>3)  pattern=1;
      pattern--;
      }

   WinRegisterClass(hab,CLIENTCLASS,dialogProc,0L,0);
   hwndFrame=WinLoadDlg(HWND_DESKTOP,HWND_DESKTOP,NULL,NULLHANDLE,ID_DIALOG,NULL);
   hwndMenu=WinLoadMenu(hwndFrame,NULL,RS_MENU);
   WinSendMsg(hwndFrame,WM_UPDATEFRAME,(MPARAM)NULL,(MPARAM)NULL);
   WinSendMsg(hwndFrame,WM_SETICON,(MPARAM)WinLoadPointer(HWND_DESKTOP,0,ID_RESOURCE),NULL);
   WinSetFocus(HWND_DESKTOP,WinWindowFromID(hwndFrame,FID_CLIENT));
   
   DosAllocMem(&prg,1,PAG_WRITE);
   DosSetMem(prg,1,PAG_DEFAULT|PAG_COMMIT);
   _splitpath(argv[0],prg->drive,prg->dir,prg->name,prg->ext);
   DosAllocMem(&profilePath,strlen(prg->drive)+strlen(prg->dir)+20,PAG_WRITE);
   DosSetMem(profilePath,strlen(prg->drive)+strlen(prg->dir)+20,PAG_DEFAULT|PAG_COMMIT);
   _makepath(profilePath,prg->drive,prg->dir,"TIMERUN","INI");
   hini=PrfOpenProfile(hab,profilePath);
   DosFreeMem(prg);

   hwndClient=WinWindowFromID(hwndFrame,FID_CLIENT);
   loadParam(&trun[pattern],hwndClient);
   WinSendDlgItemMsg(hwndClient,ID_END_PROG,EM_SETTEXTLIMIT,MPFROM2SHORT(CCHMAXPATH,0),NULL);
   WinSendDlgItemMsg(hwndClient,ID_STAT_PROG,EM_SETTEXTLIMIT,MPFROM2SHORT(CCHMAXPATH,0),NULL);
   WinSendDlgItemMsg(hwndClient,ID_STATUS,EM_SETTEXTLIMIT,MPFROM2SHORT(CCHMAXPATH,0),NULL);

   if(tsys.minimized)
      WinSetWindowPos(hwndFrame,NULLHANDLE,0,0,0,0,SWP_MINIMIZE);

   pfnwpStartList = WinSubclassWindow (WinWindowFromID(hwndClient,ID_STAT_PROG), startEntryProc);
   pfnwpEndList = WinSubclassWindow (WinWindowFromID(hwndClient,ID_END_PROG), endEntryProc);

   WinShowWindow(hwndFrame,TRUE);
   while(WinGetMsg(hab,&qmsg,NULLHANDLE,0,0))
      WinDispatchMsg(hab,&qmsg);

   PrfCloseProfile(hini);

   WinDestroyWindow(hwndFrame);
   WinDestroyMsgQueue(hmq);
   WinTerminate(hab);
   return 0;
}
/* *********************************************************************** */
/* Drop                                                                    */
/* *********************************************************************** */
MRESULT Drop(HWND hwnd, PDRAGINFO pDraginfo)
{
   CHAR  szTargetFile[CCHMAXPATHCOMP],SourceDir [CCHMAXPATH];
   PDRAGITEM     pditem;
   ULONG         i,ulBytesWritten;                                   

   if(DrgAccessDraginfo(pDraginfo)) {
      switch (pDraginfo->usOperation)   {
      case DO_MOVE:
         if (pDraginfo->hwndSource != hwnd)  {
            pditem = DrgQueryDragitemPtr (pDraginfo, 0);
            for (i=0; i<pDraginfo->cditem; i++)  {
               pditem = DrgQueryDragitemPtr (pDraginfo, i);
               ulBytesWritten = DrgQueryStrName(pditem->hstrContainerName, sizeof(SourceDir),SourceDir);
               if(ulBytesWritten == 0L)
                  return (MRESULT)NULL;
               ulBytesWritten =DrgQueryStrName(pditem->hstrTargetName, sizeof(szTargetFile),szTargetFile);
               if(ulBytesWritten == 0L)
                  return (MRESULT)NULL;
               strcpy(filename,SourceDir);
               strcat(filename,szTargetFile);

               _splitpath(filename,path.drive,path.dir,path.name,path.ext);
               WinSendMsg(hwnd,WM_USER_CHANGEFILE,(MPARAM)filename,(MPARAM)&path);
               }
            }
         break;
      default: 
         break;
      }
   }
   return (MRESULT)NULL;
}
/* *********************************************************************** */
/* Drag Over                                                               */
/* *********************************************************************** */
MRESULT DragOver(PDRAGINFO pDraginfo)
{
   USHORT        usIndicator, cItems, i ,usOperation;
   ULONG         ulBytesWritten;
   PDRAGITEM     pditem;
   CHAR          SourceDir [CCHMAXPATH];


   if(DrgAccessDraginfo(pDraginfo)) {
      usOperation = (USHORT)DO_MOVE;
      switch (pDraginfo->usOperation)   {
      case DO_UNKNOWN:
         return (MRFROM2SHORT (DOR_NODROPOP, 0));
      case DO_DEFAULT:
         pditem = DrgQueryDragitemPtr (pDraginfo, 0);
         ulBytesWritten = DrgQueryStrName(pditem->hstrContainerName,sizeof(SourceDir),SourceDir);
         if(ulBytesWritten == 0L)
            return (MRFROM2SHORT (DOR_NODROPOP, 0));
         usOperation = (USHORT)DO_MOVE;
         break;
         }
      usIndicator = DOR_DROP;
      cItems = DrgQueryDragitemCount (pDraginfo);
      for (i = 0; i < cItems; ++i)   {
         pditem = DrgQueryDragitemPtr (pDraginfo, i);
         if (((pditem->fsSupportedOps & DO_COPYABLE) && (usOperation == (USHORT)DO_COPY)) ||  ((pditem->fsSupportedOps & DO_MOVEABLE) && (usOperation == (USHORT)DO_MOVE)))         {
            if (DrgVerifyRMF(pditem, "DRM_OS2FILE", "DRF_UNKNOWN"))  {
               usIndicator = DOR_DROP;
               }
            else   {
               usIndicator = DOR_DROP;
               break;
               } 
            }
         else      {
            usIndicator = DOR_NODROPOP;
            break;
            }
         }
      return (MRFROM2SHORT(usIndicator, usOperation));
   }
}
/* *********************************************************************** */
/* startEntryProc                                                          */
/* *********************************************************************** */
MRESULT EXPENTRY startEntryProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   switch(msg)   {
   case WM_USER_CHANGEFILE:
      WinSetWindowText(WinWindowFromID(hwndClient,ID_STAT_PROG),filename);
      break;
   case DM_DROP:
      return Drop(hwnd,(PDRAGINFO) mp1);                
   case DM_DRAGOVER:
      return DragOver((PDRAGINFO) mp1);
   }
   return (pfnwpStartList (hwnd, msg, mp1, mp2));
}
/* *********************************************************************** */
/* endEntryProc                                                            */
/* *********************************************************************** */
MRESULT EXPENTRY endEntryProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   switch(msg)   {
   case WM_USER_CHANGEFILE:
      WinSetWindowText(WinWindowFromID(hwndClient,ID_END_PROG),filename);
      break;
   case DM_DROP:
      return Drop(hwnd,(PDRAGINFO) mp1);                
   case DM_DRAGOVER:
      return DragOver((PDRAGINFO) mp1);
   }
   return (pfnwpEndList (hwnd, msg, mp1, mp2));
}
/* *********************************************************************** */
/* aboutProc                                                               */
/* *********************************************************************** */
MRESULT EXPENTRY aboutProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   SHORT id;
   switch(msg) {
   case WM_COMMAND:
      id=COMMANDMSG(&msg)->cmd;
      switch(id)  {
      case DID_OK:
      case DID_CANCEL:
         WinDismissDlg(hwnd,TRUE);
      break;
      }
   }
   return WinDefDlgProc(hwnd,msg,mp1,mp2);
}
MRESULT EXPENTRY dialogProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   static DATETIME dt;
   static CHAR goStart[3]={FALSE,FALSE,FALSE},firstCheck[3]={FALSE,FALSE,FALSE};
   static PROGDETAILS   pg;
   static HWND  happStart[3]={NULL,NULL,NULL},happEnd[3]={NULL,NULL,NULL};
   CHAR  buffer[256],param[256],program[256],dir[256];
   SHORT id=0,i=0;
   TIMERUN  *ptrun;

   switch(msg) {
   case WM_CREATE:
      if(WinStartTimer(hab,hwnd,ID_TIMER,10000))   {
         }
      else  {
         WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,"łɑ̃^C}[ĂƎv܂B\nvO͋Nł܂B","vONG[",0,MB_OK|MB_ICONEXCLAMATION);
         }
      break;
   case WM_TIMER:
      ptrun=&trun[pattern];
      if(firstCheck[pattern]==FALSE)   {
         WinSetWindowText(WinWindowFromID(hwnd,ID_STATUS),"NĎł...");
         firstCheck[pattern]=TRUE;
         goStart[pattern]=FALSE;
         }
      else  {
         if(goStart[pattern]==FALSE)   {
            CHECK_START:
            ptrun=&trun[pattern];
            if(goStart[pattern]==FALSE)   {
               DosGetDateTime(&dt);
               nowMin=(dt.hours)*60+(dt.minutes);
               startMin[pattern]=(ptrun->start.hour)*60+(ptrun->start.min);      
               endMin[pattern]=(ptrun->end.hour)*60+(ptrun->end.min);
               if(startMin[pattern] <= endMin[pattern])  {
                  if((startMin[pattern]<=nowMin) && (nowMin<endMin[pattern]) )   goStart[pattern]=TRUE;
                  else  goStart[pattern]=FALSE;
                  }
               else  {
                 if((startMin[pattern] <= nowMin) || (nowMin < endMin[pattern]) )    goStart[pattern]=TRUE;
                  else  goStart[pattern]=FALSE;
                 }

                        
               if(goStart[pattern]==TRUE) {
                  GO_START:
                  goStart[pattern]=TRUE;
                  ptrun=&trun[pattern];
                  strcpy(program,ptrun->start.prog);
                  strcpy(param,"");
                  strcpy(dir,ptrun->start.dir);
                  happStart[pattern]=PrgStart(hwnd,"ԋN",program,param,dir,SWP_ACTIVATE);
                  DosBeep(200,200);
                  DosBeep(400,200);
                  DosBeep(800,200);
                  if(happStart[pattern]==(HWND)NULL) {
                     WinSetWindowText(WinWindowFromID(hwnd,ID_STATUS),"NvO͊Jn܂łAIĎł...");
                     }
                  WinSetWindowText(WinWindowFromID(hwnd,ID_STATUS),"IĎł...");
                  goStart[pattern]=TRUE;
                  }
               }
            }
         else  {
            CHECK_END:
            ptrun=&trun[pattern];
            if(goStart[pattern]==TRUE)   {
               DosGetDateTime(&dt);
               nowMin=dt.hours*60+dt.minutes;
               startMin[pattern]=(ptrun->start.hour)*60+(ptrun->start.min);
               endMin[pattern]=(ptrun->end.hour)*60+(ptrun->end.min);
               if(endMin[pattern] <= startMin[pattern])  {
                  if((endMin[pattern] <= nowMin) && (nowMin<startMin[pattern]) )   goStart[pattern]=FALSE;
                  else   goStart[pattern]=TRUE;
                  }
               else  {
                  if((endMin[pattern]<=nowMin) || (nowMin<startMin[pattern]) )   goStart[pattern]=FALSE;
                  else   goStart[pattern]=TRUE;
                  }
               if(goStart[pattern]==FALSE) {
                  GO_END:
                  goStart[pattern]=FALSE;
                  if(ptrun->end.ender)    {
                     if(happStart[pattern]!=(HWND)NULL)  {
                        PrgTerminate(happStart[pattern]);
                        }
                     }
                  ptrun=&trun[pattern];
                  strcpy(program,ptrun->end.prog);
                  strcpy(param,"");
                  strcpy(dir,ptrun->end.dir);
                  DosBeep(800,200);
                  if(strlen(program)<2)
                        break;
                  DosBeep(400,200);
                  DosBeep(200,200);
                  happEnd[pattern]=PrgStart(hwnd,"ԋN",program,param,dir,SWP_ACTIVATE);
                  if(happEnd[pattern]==(HWND)NULL) {
                     WinSetWindowText(WinWindowFromID(hwnd,ID_STATUS),"IvO͊Jn܂łAIĎł...");
                     }
                  WinSetWindowText(WinWindowFromID(hwnd,ID_STATUS),"NĎł...");
                  goStart[pattern]=FALSE;
                  }
               }
            }
         }
      break;
   case WM_COMMAND:
      id=COMMANDMSG(&msg)->cmd;
      switch(id) {
      case ID_STAT_RUN:
         ptrun=&trun[pattern];
         if(goStart[pattern]==FALSE)
            goto GO_START;
         WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,
         "N߂Ă܂ANɁuNvOvN͂ł܂B","߂͖",0,MB_OK|MB_ICONEXCLAMATION);
         break;
      case ID_END_RUN:
         ptrun=&trun[pattern];
         if(goStart[pattern]==TRUE)
            goto GO_END;
         WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,
         "I߂Ă܂AIɁuIvOvN͂ł܂B","߂͖",0,MB_OK|MB_ICONEXCLAMATION);
         break;
      case ID_APPLY:
         DosBeep(440,50);
         applyParam(&trun[pattern],hwnd);
         break;
      case ID_SAVE:
      case MN_SAVE:
         DosBeep(440,50);
         saveParam(&trun[pattern],hwnd);
         return 0;
      case MN_EXIT:
         WinSendMsg(hwnd,WM_CLOSE,(MPARAM)NULL,(MPARAM)NULL);
         break;
      case MN_PRODINFO:
         WinDlgBox(HWND_DESKTOP,hwnd,aboutProc,NULLHANDLE,IDP_DIALOG,NULL);
         break;
      case MN_PTN1:
      case MN_PTN2:
      case MN_PTN3:
         goto CHECKPTN;
      }
      return 0;
   case WM_CONTROL:
      id=SHORT1FROMMP(mp1);
      switch(id)  {
      case ID_PATTERN:
      case ID_PATTERN+1:
      case ID_PATTERN+2:
         CHECKPTN:
         DosBeep(220,50);
         DosBeep(440,50);
         for(i=0;i<3;i++)  {
            WinCheckButton(hwnd,ID_PATTERN+i,FALSE);
            MiaCheck(hwndMenu,id,FALSE);
            }
         WinCheckButton(hwnd,id,TRUE);
         MiaCheck(hwndMenu,id,TRUE);
         pattern=id-ID_PATTERN;
         loadParam(&trun[pattern],hwnd);
         return 0;
      }
      return 0;
   case WM_ERASEBACKGROUND:
      return MRFROMSHORT(1);
   case WM_CLOSE:
      WinStopTimer(hab,hwnd,ID_TIMER);
      break;
   default:
      break;
   }
   return   WinDefWindowProc(hwnd,msg,mp1,mp2);
}      
