//
//  ************************************************************************
//                          32-bit Command Interpreter
//  (c) Copyright 1988-2001 Jonathan de Boyne Pollard.
//  ************************************************************************
//

//
//  This is the interface to the command interpreter DLL.
//

//
//  CMDAPIEXPORT    This is used internally by the library for function
//                  definitions that are exported from the DLL.
//
//  CMDAPIIMPORT    This is used to declare library routines that may be
//                  imported into user code.
//
//  CMDAPICALLBACK  This is used to declare user routines that are called
//                  by library routines.
//

#if defined(__HIGHC__)

	#define CMDAPIEXPORT
	#define CMDAPICALLBACK
	#if defined(BUILDING_CMDAPI)
	#	define CMDAPIIMPORT
	#else
	#	define CMDAPIIMPORT 	__declspec(dllimport)
	#endif

#elif defined(__WATCOMC__)

	#define CMDAPIEXPORT		__declspec(__syscall)
	#define CMDAPICALLBACK		__declspec(__syscall)
	#if defined(BUILDING_CMDAPI)
	#	define CMDAPIIMPORT __declspec(__syscall)
	#else
	#	define CMDAPIIMPORT __declspec(__syscall dllimport)
	#endif

#elif defined(__IBMCPP__)

	#if __IBMCPP__ < 300 && !defined(_Import)
		#define _Import
	#endif
	#define CMDAPIEXPORT		_System
	#define CMDAPICALLBACK		_System
	#if defined(BUILDING_CMDAPI)
	#	define CMDAPIIMPORT _System
	#else
	#	define CMDAPIIMPORT _System _Import
	#endif

#elif defined(__BORLANDC__)

	#define CMDAPIEXPORT		__syscall
	#define CMDAPICALLBACK		__syscall
	#if defined(BUILDING_CMDAPI)
	#	define CMDAPIIMPORT __syscall
	#else
	#	define CMDAPIIMPORT __syscall __import
	#endif

#else

	#error "Unsupported compiler!"

#endif

#if defined(__cplusplus) || defined(__CPLUSPLUS__)
#	define CMDBYREF &
#else
#	define CMDBYREF *
#endif

#if defined(__cplusplus) || defined(__CPLUSPLUS__)
extern "C" {
#endif

CMDAPIIMPORT void		CMDPrintError0 ( unsigned int code ) ;
CMDAPIIMPORT void		CMDPrintError1 ( unsigned int code, const char * a1 ) ;
CMDAPIIMPORT void		CMDPrintError2 ( unsigned int code, const char * a1, const char * a2 ) ;
CMDAPIIMPORT void		CMDPrintMessage0 ( unsigned int code ) ;
CMDAPIIMPORT void		CMDPrintMessage1 ( unsigned int code, const char * a1 ) ;
CMDAPIIMPORT void		CMDPrintMessage2 ( unsigned int code, const char * a1, const char * a2 ) ;
CMDAPIIMPORT void		CMDPrintMessage3 ( unsigned int code, const char * a1, const char * a2, const char * a3 ) ;
CMDAPIIMPORT void		CMDPrintMessage4 ( unsigned int code, const char * a1, const char * a2, const char * a3, const char * a4 ) ;
CMDAPIIMPORT void		CMDPrintHelpMessage2 ( unsigned int code, const char * a1, const char * a2 ) ;
CMDAPIIMPORT void		CMDPrintSysError0 ( unsigned int code ) ;
CMDAPIIMPORT void		CMDPrintSysError1 ( unsigned int code, const char * a1 ) ;
CMDAPIIMPORT void		CMDPrintSysError2 ( unsigned int code, const char * a1, const char * a2 ) ;
CMDAPIIMPORT void		CMDPrintSysMessage0 ( unsigned int code ) ;
CMDAPIIMPORT void		CMDPrintSysMessage1 ( unsigned int code, const char * a1 ) ;
CMDAPIIMPORT void		CMDPrintSysMessage2 ( unsigned int code, const char * a1, const char * a2 ) ;

CMDAPIIMPORT APIRET		CMDPrintLabel ( const char * drive, ULONG DriveNum ) ;

CMDAPIIMPORT void		CMDInsertCommas ( char * buffer, unsigned int length ) ;

CMDAPIIMPORT int		CMDInitialise ( void * CMDBYREF Interpreter ) ;
CMDAPIIMPORT void		CMDTerminate ( void * Interpreter ) ;

CMDAPIIMPORT BOOL		CMDQueryANSIPromptBanner ( void * Interpreter ) ;
CMDAPIIMPORT BOOL		CMDQueryEchoFlag ( void * Interpreter ) ;
CMDAPIIMPORT int		CMDQueryErrorLevel ( void * Interpreter ) ;
CMDAPIIMPORT BOOL		CMDQueryExitFlag ( void * Interpreter ) ;
CMDAPIIMPORT BOOL		CMDQueryInteractiveFlag ( void * Interpreter ) ;
CMDAPIIMPORT BOOL		CMDQueryAutoStartVDMFlag ( void * Interpreter ) ;
CMDAPIIMPORT BOOL		CMDQueryAutoStartPMFlag ( void * Interpreter ) ;
CMDAPIIMPORT void		CMDSetANSIPromptBanner ( void * Interpreter, BOOL flag ) ;
CMDAPIIMPORT void		CMDSetEchoFlag ( void * Interpreter, BOOL flag ) ;
CMDAPIIMPORT void		CMDSetErrorLevel ( void * Interpreter, int ErrorLevel ) ;
CMDAPIIMPORT void		CMDSetExitFlag ( void * Interpreter, BOOL flag ) ;
CMDAPIIMPORT void		CMDSetInteractiveFlag ( void * Interpreter, BOOL flag ) ;
CMDAPIIMPORT void		CMDSetAutoStartVDMFlag ( void * Interpreter, BOOL flag ) ;
CMDAPIIMPORT void		CMDSetAutoStartPMFlag ( void * Interpreter, BOOL flag ) ;

CMDAPIIMPORT void		CMDSetPipeHelperVarName ( void * Interpreter, const char * variable_name ) ;

CMDAPIIMPORT void		CMDSetNameAndVersionStrings ( void * Interpreter, const char * name, const char * version ) ;

CMDAPIIMPORT void		CMDShowPrompt ( void * Interpreter, HFILE fd ) ;
CMDAPIIMPORT void		CMDPrintVersionString ( void * Interpreter, HFILE fd ) ;

CMDAPIIMPORT int		CMDProcessCommandLine ( void * Interpreter, BOOL CMDBYREF LineWasNotBlank, const char * line, BOOL show_prompt, BOOL disable_echo ) ;
CMDAPIIMPORT int		CMDProcessSingleCommand ( void * Interpreter, const char * line ) ;
CMDAPIIMPORT int		CMDExecuteCommand ( void * Interpreter, RESULTCODES CMDBYREF Result, ULONG ExecFlags, char * args, const char * tail ) ;

CMDAPIIMPORT APIRET 	CMDSetHandleInheritance ( HFILE fd, BOOL inherit ) ;

CMDAPIIMPORT BOOL		CMDPredefineStandardCommands() ;
CMDAPIIMPORT BOOL		CMDAddBuiltInCommand ( const char * name, int (* CMDAPICALLBACK function)(void *, int, char**) ) ;

CMDAPIIMPORT void		CMDPredefineStandardAliases() ;
CMDAPIIMPORT APIRET 	CMDGetAlias ( char * CMDBYREF var, const char * name ) ;
CMDAPIIMPORT APIRET 	CMDSetAlias ( const char * name , const char * value, int override ) ;
CMDAPIIMPORT APIRET 	CMDClearAlias () ;
CMDAPIIMPORT APIRET 	CMDUnsetAlias ( const char * name ) ;

CMDAPIIMPORT APIRET 	CMDGetEnv ( char * CMDBYREF var, const char * name ) ;
CMDAPIIMPORT APIRET 	CMDSetEnv ( const char * name , const char * value, int override ) ;
CMDAPIIMPORT APIRET 	CMDClearEnv () ;
CMDAPIIMPORT APIRET 	CMDUnsetEnv ( const char * name ) ;

CMDAPIIMPORT BOOL		CMDIsDir ( const char * name ) ;
CMDAPIIMPORT BOOL		CMDIsNotDotDir ( const char * name ) ;
CMDAPIIMPORT BOOL		CMDNameHasMetaChars ( const char * name ) ;

CMDAPIIMPORT int		CMDParseAttributeRule ( const char * arg, const char * CMDBYREF end, unsigned long CMDBYREF attributes, int delim ) ;
CMDAPIIMPORT int		CMDParseColour ( const char * arg, const char * CMDBYREF end, unsigned short CMDBYREF colour, int delim ) ;

CMDAPIIMPORT char * 		CMDGetWord ( char * start, char * CMDBYREF end ) ;
CMDAPIIMPORT const char *	CMDCopyWord ( const char * source, char * dest ) ;
CMDAPIIMPORT const char *	CMDCopyDelimitedWord ( const char * source, char * dest, int delim ) ;
CMDAPIIMPORT const char *	CMDSkipWord ( const char * source ) ;

CMDAPIIMPORT int 		CMDHandleNonCombiningToggleOption ( char * CMDBYREF arg, int CMDBYREF value, const char * name, size_t len, int slash ) ;
CMDAPIIMPORT void 		CMDHandleCombiningToggleOption ( char * CMDBYREF v, int CMDBYREF i ) ;

CMDAPIIMPORT extern const char CMDPackageCopyrightString[] ;
CMDAPIIMPORT extern const char CMDAPIVersionString[] ;

#if defined(__cplusplus) || defined(__CPLUSPLUS__)
}
#endif

#define ERROR_UNEXPECTED_KEYWORD	1079
#define ERROR_UNKNOWN_COMMAND		1041

