/* Don't edit this file, as it is generated by 'PPREXX' version 1.0 from the ..\src directory. */
/* Please edit the following:
    ..\src\vbcopy.cmd
    ..\src\lib.cmd
*/
/*  ͻ
      VBCOPY intelligent backup and copy tree                              
                                                                           
      17/06/02: V1.0 - Initial version (gjarvis@ieee.org)                  
      03/07/03: V1.1 - reverse copy if newer (gjarvis@ieee.org)            
    ͼ */

'@echo off'

call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
prgver = '1.1'

/* statistics */
num.0read = 0
num.0copy = 0
num.0update = 0

call getosver prgver, os.
say os.0line
parse arg from to
if to='' then do
    say "usage::vbcopy <from> <to>"
    say "from     path name"
    say "to       path name"
    exit 1
end

vdir = "vback"
log = "vbcopy.log"
address cmd
curpath = directory()
frompath = directory(from)
if lastpos('\',frompath)\=length(frompath) then frompath = frompath'\'
frompos = length(frompath)+38
call directory curpath
topath = directory(to)
if lastpos('\',topath)\=length(topath) then topath = topath'\'
topos = length(topath)+38
call directory curpath
if frompath='' then do
    say 'parameter from' from 'is bogus'
    exit 1
end /* do */
if topath='' then do
    say 'parameter to' to 'is bogus'
    exit 1
end /* do */


/* directories */

call SysFileTree frompath, 'fromdir', 'SD'


do i=1 to fromdir.0
    fromname = substr(fromdir.i,frompos)
    /* exclude vback paths */
    s1 = lastpos('\',fromname)
    if s1=0 then pd = fromname
    else pd = substr(fromname,s1+1)
/*    if pd=="vback" then say "skipping dir" fromname*/
    if pd=="vback" then iterate
    call SysFileTree topath||fromname, 'todir', 'D'
    if todir.0=0 then "md" topath||fromname '1>nul: 2>nul:'
end /* do */

/* files */

call SysFileTree frompath'*', 'froms', 'SF'
n = froms.0
if n=0 then do
    say 'nothing in from path:' from
    exit 1
end /* do */
num.0read = n

do i=1 to froms.0
   fromname = substr(froms.i,frompos)
    /* exclude vback paths */
    s1 = lastpos('\',fromname)
    if s1>0 then do
       s2 = lastpos('\',fromname,s1-1)
       pd   = substr(fromname,s2+1,s1-s2-1)
/*       if pd=="vback" then say "skipping file" fromname*/
       if pd=="vback" then iterate
    end /* do */
    
    tocopy = 1
   call SysFileTree topath||fromname, 'tos', 'F'
   if tos.0>0 then do
      todate = left(tos.1,16)
      fromdate = left(froms.i,16)
      call vback topath||fromname 'backing existing'
      if fromdate<>todate then do
         if dateGT(todate,fromdate) then do
            /* updating to: copying to from */
            call vback frompath||fromname 'backing existing'
            address cmd "copy" topath||fromname frompath||fromname '1>nul: 2>nul:'
            call vback frompath||fromname 'backing copy'
            if num.0update=0 then call lineout log, os.0line
            call lineout log, "replacing" frompath||fromname fromdate "by" topath||fromname todate
            num.0update = num.0update + 1
            tocopy = 0
         end /* do */
      end /* do */
      else tocopy = 0
   end /* do */
   if tocopy then do
        /* copying from to */
        address cmd "copy" frompath||fromname topath||fromname '1>nul: 2>nul:'
        call vback topath||fromname 'backing copy'
        num.0copy = num.0copy + 1
   end /* do */
          
end /* do */

if num.0update>0 then do
   call lineout log, ''
   call closefile log
end /* do */
say os.0prgname 'read:' num.0read 'copied:' num.0copy "update:" num.0update
exit 0



/* date compare ex: "10/22/01   6:11p" 
returns true if date1 > date 2*/
dateGT: procedure 
    parse arg fdate, tdate
    parse var fdate fmo +2 +1 fdy +2 +1 fyr +2 +2 fhh +2 +1 fmi +2 fi
    parse var tdate tmo +2 +1 tdy +2 +1 tyr +2 +2 thh +2 +1 tmi +2 ti
    select
       when fyr>tyr then gt = 1
       when fyr<tyr then gt = 0
       when fmo>tmo then gt = 1
       when fmo<tmo then gt = 0
       when fdy>tdy then gt = 1
       when fdy<tdy then gt = 0
       when fi>ti then gt = 1
       when fi<ti then gt = 0
       when fhh>thh then gt = 1
       when fhh<thh then gt = 0
       when fmi>tmi then gt = 1
    otherwise gt = 0
    end  /* select */
    return gt
    


getosver:procedure expose delimit.
   use arg prgver, os.
   call createdelimiters
   /* program invoked */
   parse upper source . . os.0prgname
   /* bootpath */
   parse value value('PATH',,'OS2ENVIRONMENT') with . ":\OS2;" -1 os.0bootPath +3
   /* datapath */
   parse var os.0prgname os.0datapath +3
   /* version - note sysos2ver() returns version of C: rather than actual bootdrive */
   /*4502.*/
   os.0ver = strip(translate("31524",c2x(charin(os.0bootpath"OS2\INSTALL\SYSLEVEL.OS2",41,2))'.',"12345"),,0)
   call stream bootpath"OS2\INSTALL\SYSLEVEL.OS2", 'c', 'close'
   curpath = directory()
   ecspath = directory(os.0bootpath'ecs')
   select
      when os.0ver<4.51 then os.0ver = 'WARP' os.0ver
      when  translate(ecspath)=os.0bootpath'ECS' then os.0ver = 'eCS' os.0ver
   otherwise os.0ver = 'SWC' os.0ver
   end  /* select */
   call directory(curpath)
   /* program name */
   i = lastpos('\', os.0prgname) + 1
   parse var os.0prgname =(i) os.0prg "."
   /* program running line */
   os.0line = os.0prg prgver 'running' '"'os.0bootpath'"' os.0ver 'on' date() time()
   return



/* wildcard match */
wildcardmatch: procedure
   parse arg wstr, str
   w = pos('*',wstr)
   if w<2 then m = str==wstr
   else m = left(str,w-1)==left(wstr,w-1)
   return m


/*  return true if file succesfully closed */
closeFile:   procedure
   ret = stream(arg(1),'C','CLOSE')
   if ret='READY:' then return 1
   say 'error closing file stream' arg(1) ret
   exit -1
   return 0


/*  return true if file exists */
fileExists:  procedure
   ret = stream(arg(1),'C','QUERY EXISTS')
   if ret='' then return 0
   return 1


/* ͸
     parse options                                                        
        stem    global  delimit.
        string  in      option string to parse (any case)
        stem    out     option stem
   ;  */
ParseOpt: procedure expose delimit.
  use arg sop, option.
  dq = '"'
  quote = translate(sop,delimit.asciiless,delimit.ascii,dq)
  option.KEY = ""
  option.0 = 0
  do forever
    if sop='' then leave
    pdq = pos(dq,quote)
    if pdq>0 then do
      parse var sop keys =(pdq) d +1  str (d) sop
      quote = right(quote,length(sop))
    end
    else do
       keys = sop
       str = ''
       sop = ''
    end
    option.KEY = option.KEY keys
    w = words(keys)
    if w>1 then
      do i  = option.0+1 to option.0+w-1
         option.i = ''
      end /* do */
    i = option.0 + w
    option.i = str
    option.0 = i
  end
  option.key = translate(strip(option.key,'L'))
   return

/* ͸
     true if name exists in option                                        
        string  in      key string to test (upper case)
        stem    in/out  option stem
        bool    ret     if string is a option
   ;  */
GetOpt: procedure
   use arg skey, gopt.
   gopt.pos = wordpos(skey, gopt.KEY)
   return gopt.pos>0
   

/* ͸
     gets option string of key from last GETOPT call, 
    which may be optional and may have a default     

string  in      default string 
        stem    in      option stem
        string  ret     option string or default string or null
   ;  */
GetStrOpt: procedure
   use arg default, gsopt.
   found = gsopt.[gsopt.pos]
   if length(found)=0 then found = default
   return found


/**
CreateDelimiters
create global dynamic delimit stem
stem global delimit.
*/
CreateDelimiters: procedure expose delimit.
delimit.STR = '"' || "'`!@#$%^&"
delimit.asciiless = ''
do i = 32 to 126
   if pos(d2c(i),delimit.Str)=0 then delimit.asciiless = delimit.asciiless || d2c(i)
end /* do */
delimit.ascii = delimit.asciiless || delimit.str
return


/**
WHENSELECTED Make and when test.
    make    in  string  make words (may be empty)
    mwhen   in  string  when words (may be '*')
    return  flag    if okay
    */
whenselected: procedure
   parse arg make, mwhen
   if mwhen='*' then return 1
   if words(make)>0 then do i=1 to words(make)
      if wordpos(word(Make,i),MWhen)>0 then return 1
   end /* do */
   return 0
   


