/* ITALIANO.CMD: Installa MEMSIZE in Italiano. */

'@Echo Off'
'CHCP 850'

/* Carica REXXUTIL. */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Inizializza. */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Si sta installando MEMSIZE...'
Say ''


/* Verifica l'esistenza dei vari file componenti il programma. */

Language = 'Italiano'

Result = SysFileTree( 'MEMSIZE2.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERRORE: MEMSIZE2.EXE non trovato!'
  Signal DONE
  End

Result = SysFileTree( "OBJECTS.OS2\"Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERRORE: 'Language'.DLL non trovato!'
  Signal DONE
  End

Result = SysFileTree( "OBJECTS.OS2\"Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERRORE: 'Language'.HLP non trovato!'
  Signal DONE
  End

/* Richiede il nome della directory di installazione. */

BootDrive = Filespec('Drive',Value('SYSTEM_INI',,'OS2ENVIRONMENT'))
Default = SysIni('USER', 'MEMSIZE', 'INIPATH' )
If Default = 'ERROR:'
  Then Default = BootDrive'\OS2\Apps'
If SUBSTR(Default,LENGTH(Default),1) <= ' '
  Then Default = SUBSTR(Default,1,LENGTH(Default)-1)

Say 'Inserire il nome completo della directory in cui '
Say 'si vuole installare MEMSIZE (default 'Default'): '
Parse Pull Directory
If Directory = "" Then Directory = Default


/* Crea la directory se necessario. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERRORE: Impossibile creare la directory di destinazione.'
    Signal DONE
    End
  End
Say ''


/* Save the target directory. */

SysIni( "USER", "MEMSIZE", "INIPATH", Directory )
SysIni( Directory"\MEMSIZE2.INI", "MEMSIZE", "INIPATH", Directory )


/* Richiede la cartella di destinazione. */

Say 'Si vuole installare il programma nella cartella di avvio? (S/N)'
Pull YesNo
If YesNo = "S" Then
  Do
  Folder = '<WP_START>'
  Say "L'oggetto sar posto nella cartella di avvio."
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say "L'oggetto sar posto sulla scrivania."
  End
Say ''


/* Distrugge il vecchio oggetto, se presente. */

Call SysDestroyObject( '<MEMSIZE>' )
Call SysSleep( 5 )


/* Completamento installazione. */

Say 'Si sta copiando MEMSIZE in 'Directory' ...'
Copy MEMSIZE2.EXE Directory                  '1>NUL'
Copy "OBJECTS.OS2\"Language".DLL" Directory"\MEMSIZE2.DLL" '1>NUL'
Copy "OBJECTS.OS2\"Language".HLP" Directory"\MEMSIZE2.HLP" '1>NUL'
Copy Language".DOC" Directory"\MEMSIZE2.DOC" '1>NUL'

Result = SysFileTree( "HLP2INF.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Result = SysFileTree( Directory"\MEMSIZE2.INF", 'Files', 'F' )
   If Files.0 > 0 Then
      Do
      "Erase" Directory"\MEMSIZE2.INF"
      End
   "HLP2INF" Directory"\MEMSIZE2.HLP"
   End

Result = SysFileTree( "SNPSHOT2.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNPSHOT2.EXE" Directory"\SNPSHOT2.EXE"  '1>NUL'
   End

Say 'Si sta creando il programma oggetto...'
Type = 'WPProgram'
Title = 'Risorse di Sistema'
Parms = 'OPEN=DEFAULT;MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MEMSIZE2.EXE;STARTUPDIR='Directory';OBJECTID=<MEMSIZE>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'Oggetto creato!  Fine.'
Else
  Say 'ERRORE: Oggetto non creato.'

Signal DONE

FAILURE:
Say 'REXX fallimento.'
Signal DONE

HALT:
Say 'REXX alt.'
Signal DONE

SYNTAX:
Say 'REXX errore di sintassi.'
Signal DONE

DONE:
Exit
