/* JAPANESE.CMD: Install MEMSIZE in Japanese. */

'@Echo Off'
'CHCP 932'

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'MEMSIZE ̃CXg[ł...'
Say ''


/* Verify the existence of the various component files. */

Language = 'JAPANESE'

Result = SysFileTree( 'MEMSIZE2.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'G[: MEMSIZE2.EXE ܂!'
  Signal DONE
  End

Result = SysFileTree( "OBJECTS.OS2\"Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'G[: 'Language'.DLL ܂!'
  Signal DONE
  End

Result = SysFileTree( "OBJECTS.OS2\"Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'G[: 'Language'.HLP ܂!'
  Signal DONE
  End

/* Ask for the target directory name. */

BootDrive = Filespec('Drive',Value('SYSTEM_INI',,'OS2ENVIRONMENT'))
Default = SysIni('USER', 'MEMSIZE', 'INIPATH' )
If Default = 'ERROR:'
  Then Default = BootDrive'\OS2\Apps'
If SUBSTR(Default,LENGTH(Default),1) <= ' '
  Then Default = SUBSTR(Default,1,LENGTH(Default)-1)

Say 'MEMSIZE CXg[fBNg'
Say 'tl[Ŏw肵ĉ (w肵Ȃ 'Default' ɂȂ܂): '
Parse Pull Directory
If Directory = "" Then Directory = Default


/* Create the target directory if necessary. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'G[: fBNg܂B'
    Signal DONE
    End
  End
Say ''


/* Save the target directory. */

SysIni( "USER", "MEMSIZE", "INIPATH", Directory )
SysIni( Directory"\MEMSIZE2.INI", "MEMSIZE", "INIPATH", Directory )


/* Ask for the target folder. */

Say 'IuWFNgntH_ɓo^܂H (Y/N)'
Pull YesNo
If YesNo = "Y" Then
  Do
  Folder = '<WP_START>'
  Say 'ntH_ɓo^܂B'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'fXNgbvɓo^܂B'
  End
Say ''


/* Destroy the old object, if present. */

Call SysDestroyObject( '<MEMSIZE>' )
Call SysSleep( 5 )


/* Perform the installation. */

Say 'MEMSIZE 'Directory' ɃRs[...'
Copy MEMSIZE2.EXE Directory                  '1>NUL'
Copy "OBJECTS.OS2\"Language".DLL" Directory"\MEMSIZE2.DLL" '1>NUL'
Copy "OBJECTS.OS2\"Language".HLP" Directory"\MEMSIZE2.HLP" '1>NUL'
Copy Language".DOC" Directory"\MEMSIZE2.DOC" "1>NUL"

Result = SysFileTree( "HLP2INF.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Result = SysFileTree( Directory"\MEMSIZE2.INF", 'Files', 'F' )
   If Files.0 > 0 Then
      Do
      "Erase" Directory"\MEMSIZE2.INF"
      End
   "HLP2INF" Directory"\MEMSIZE2.HLP"
   End

Result = SysFileTree( "SNPSHOT2.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNPSHOT2.EXE" Directory"\SNPSHOT2.EXE"  '1>NUL'
   End

Say 'IuWFNg̍쐬ł...'
Type = 'WPProgram'
Title = 'VXe\[X'
Parms = 'OPEN=DEFAULT;MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MEMSIZE2.EXE;STARTUPDIR='Directory';OBJECTID=<MEMSIZE>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'IuWFNg쐬܂BCXg[I܂B'
Else
  Say 'G[: IuWFNg쐬܂łB'

Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
