/*
The contents of this file are subject to the SciTech MGL Public
License Version 1.0 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.scitechsoft.com/mgl-license.txt

Software distributed under the License is distributed on an
"AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.

The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.

The Initial Developer of the Original Code is SciTech Software, Inc.
Portions created by Vitaliy Tymchyshyn are Copyright (C)
Vitaliy Tymchyshyn. All Rights Reserved.

Contributor(s): Vitaliy Tymchyshyn.

*/
#include "nucleus\gasdk.h"
#include "gconsole.h"

GA_initFuncs    init;
GA_devCtx       *dc;
GA_options  opt;
GA_CRTCInfo crtc;
GA_driverFuncs  driver;

int main(void)
{
    dc = GA_loadDriver(0,false);
	init.dwSize = sizeof(init);
    GA_queryFunctions(dc,GA_GET_INITFUNCS,&init);
    driver.dwSize = sizeof(driver);
    GA_queryFunctions(dc,GA_GET_DRIVERFUNCS,&driver);
    opt.dwSize = sizeof(opt);
    init.GetOptions(&opt);
    init.SetDisplayOutput((opt.outputDevice & ~gaOUTPUT_SELECTMASK) | gaOUTPUT_CRT);
    virtualX = virtualY = bytesPerLine = -1;
    init.SetVideoMode(init.GetVideoMode() | gaDontClear,&virtualX,&virtualY,&bytesPerLine,&maxMem,0,&crtc);
    init.GetOptions(&opt);
    GA_saveOptions(dc,&opt);
    GA_unloadDriver(dc);
}

