/* template for DoWarpIN
   returns 0 for success
   returns 1 for general failure code (see log)
   returns 2 for WarpIN not installed
 */

DoWarpIN:

WarpINCid = strip(arg(1))
originalDir = Directory()

wiloc = strip(SysIni("USER", "WarpIN", "Path"), 't', d2c(0))
if wiloc = 'ERROR:' then do
   call LogCdi "WarpIN was not found."
   return 2
end

if WarpINCid = '' then do
   call LogCdi "missing WarpIN response file"
   return 1
end

tempDir = value('TEMP',,'OS2ENVIRONMENT') || '\DoWarpIN'
rc = SuntanMkDir(tempDir)
if rc <> 0 & rc <> 5 then do
   call LogCdi "Error" rc "creating temporary directory" tempDir
   return 1
end

wirc = ExecWarpIN(WarpINCid)

call Directory originalDir
if originalDir = tempDir then do
   call Directory '..'
end
address cmd '@deltree /q /y' tempDir '> nul'
if rc <> 0 then do
   call LogCdi "Error" rc "deleting temporary files in" tempDir
end

do while queued() <> 0
   parse pull qline
   call LogCdi "DoWarpIN: extra queued line:" qline
end

return wirc


/* does WarpIN install */
ExecWarpIN:

WarpINCid = strip(arg(1))

call Directory originalDir
address cmd '@copy' WarpINCid tempDir '> nul'
if rc <> 0 then do
   call LogCdi "Error" rc "copying install script" WarpINCid
   return 1
end
else do
   /* these commands had better be on the queue */
   if queued() > 0 then do
      call EditFile 'nul' tempDir || '\' || WarpINCid
   end
   else do
      call LogCdi "Queue is empty; must contain at least an exit."
      return 1
   end

   errfile = tempDir || '\error.log'
   call Directory wiloc
   address cmd '@SET WARPIN_IFSAMEDATE=OVERWRITE'
   address cmd '@SET WARPIN_IFEXISTINGOLDER=OVERWRITE'
   address cmd '@SET WARPIN_IFEXISTINGNEWER=OVERWRITE'
   address cmd '@SET WARPIN_IFLOCKED=UNLOCK'
   address cmd '@' wiloc || '\wic -i -R' tempDir || '\' || WarpINCid '>' errfile '2>&1'

   wrc = rc
   do while lines(errfile)
      call LogCdi linein(errfile)
   end
   call stream errfile, 'c', 'close'
   if wrc <> 0 then do
      call LogCdi "installer returned" wrc
      return 1
   end
   else do
      call LogCdi "WarpIN reports a successful install"
   end
end

return 0
