/* Present all Settings to the user, and allow user edits
 * this program is called by the Display Monitor
 *
 * Arguments
 *   none
 *
 * Copyright (C) 2005 Blonde Guy
 * All Rights Reserved
 */

pipeName = '\pipe\suntan'
dialogName = 'Settings'
response = ''
suntanDir = strip(SysIni('User', 'Suntan Special', 'Settings'), 't', d2c(0))
if suntanDir = 'ERROR:' then suntanDir = '.'
cr = d2c(13)
instructions = "Settings Editor" || cr || cr ||,
               "Single click each line to get a description of the item",
               "on that line. Double click or press enter to select",
               "the setting for editing."

x = dialogName || d2c(10) ||,
    instructions || d2c(10) ||,
    "SetEdCB.cmd"  || d2c(10) ||,
    "SetEdCB.cmd" || d2c(10) ||,
    "~Edit"

/* should editor wait for the list panel to return OK */
if arg(1) = "Wait" then do
   x = x || d2c(10) || "Wait"
end
else do
   x = x || d2c(10) || "Continue"
end

/* get all known settings */
settingsFile = suntanDir || '\Settings.Txt'
numSettings = 0
do while lines(settingsFile)
   this = linein(settingsFile)
   if left(this, 1) = ';' then iterate
   parse var this ky '=' vl
   numSettings = numSettings + 1
   setting.numSettings = strip(ky)
end
setting.0 = numSettings
call stream settingsFile, 'c', 'close'

call BubbleSort

do sn = 1 to numSettings
   x = x || d2c(10) || setting.sn
end

call LogCdi "!listpanel" x

if arg(1) = 'Wait' then do
   qname = RxQueue('Create', 'SetEd')
   if qname <> 'SETED' then do
      say 'RxQueue(Create, SetEd) returned' qname
      call RxQueue 'Delete', qname
   end
   oldq = RxQueue('Set', 'SetEd')
   SetEdEnd = LineIn('QUEUE:')
   call RxQueue 'Set', oldq
   call RxQueue 'Delete', 'SetEd'
end

return


 /* ------------------------------------------------------------------ */
 /* function: bubble sort routine from REXX tips and tricks            */
 /*                                                                    */
 /* call:     BubbleSort                                               */
 /*                                                                    */
 /* returns:  nothing                                                  */
 /*                                                                    */
 /* notes:    You must save the elements to sort in the stem "setting."*/
 /*           setting.0 must contain the number of elements in the setting.  */
 /*                                                                    */
 /*                                                                    */
 BubbleSort: PROCEDURE expose setting.
 
   do i = setting.0 to 1 by -1 until flip_flop = 1
     flip_flop = 1
     do j = 2 to i
       m = j - 1
       mName = translate(filespec('name', setting.m))
       jName = translate(filespec('name', setting.j))
       if mName >> jName then do
         /* say "Swapping" mName "and" jName */
         xchg = setting.m
         setting.m = setting.j
         setting.j = xchg
         flip_flop = 0
       end /* if setting.m ... */
     end /* do j = 2 ... */
   end /* do i = setting.0 ... */
 return
