/* SetEdCB.cmd
 * handle Settings Editor callback from Display Monitor
 *
 * Arguments
 *   arg(1) - the name of the setting to edit
 *
 * Copyright (C) 2005 Blonde Guy
 * All Rights Reserved
 */

if arg() = 0 then do
   return SetEdCB("no argument specified")
end

x = arg(1)
cr = d2c(13)

if left(x, 1) = ';' then do
   message = "Settings Editor" || cr || cr ||,
                  "Single click each line to get a description of the item",
                  "on that line. Double click or press enter to select",
                  "the setting for editing."
   call LogCdi "!listcallback" message
   return 0
end

/* rc = beep(524,100) */

if left(x, 5) = 'ENTER' then do
   x = substr(x, 7)
   response = QuerySettings(x, 'Query')
   if response = 'syntax error' then do
      response = query('Query', QuerySettings(x, 'Value'), 'No description is available. Enter a value for' x)
   end
   call SetSetting x, response
end

message = QuerySettings(x, 'Prompt')
call LogCdi "!listcallback" message

/* rc = beep(262,100) */

return 0
