/* clean Suntan Special settings
 * This program is intended to be called from Suntan Special
 *
 * Description
 *   This command cleans the Suntan Special settings, adding
 *   any missing settings, and removing any extra settings.
 *
 *   The install is unattended.
 *
 * Copyright (C) 2016 Blonde Guy
 * All Rights Reserved
 */

productName = 'Clean Settings'
productDate = '2016-10-02 07:45:52'
productCategory = 'Operation'

suntanDir = strip(sysini("User", 'Suntan Special', 'Settings'), 'T', d2c(0))
settingsFile = suntanDir || '\settings.txt'
if stream(settingsFile, 'c', 'query exists') = '' then do
   call LogCdi "Error: settings file" settingsFile "does not exist in" suntanDir
   return 1
end

call LogCdi productName "in" settingsFile

i = 0
do while lines(settingsFile) > 0
   i = i + 1
   sf.i = linein(settingsFile)
end
sf.0 = i
call stream settingsFile, 'c', 'close'

xset = ''
response = ''
do i = 1 to sf.0
   parse var sf.i sname '=' svalue
   if QuerySettings(sname, 'Instructions') = 'syntax error' then do
      xset = xset || sname || d2c(10)
   end
   else do
      call LogCdi "Note:" sf.i
   end
end
xset = strip(xset, 'Trailing', d2c(10))

if xset <> '' then do
   response = checklist('Delete Settings', "The settings on this list are unsupported. Pick one or more settings to delete.", "Select the settings to delete.", xset)
end

all = QuerySettings('All')
last = sf.0
do while all <> ''
   parse var all aname ';' all
   found = 0
   do i = 1 to sf.0
      parse var sf.i sname '=' svalue
      if translate(aname) = translate(sname) then found = 1
   end
   if found = 0 then do
      last = last + 1
      sf.last = aname || '=' || QuerySettings(aname, 'DefaultValue')
   end
end
sf.0 = last

call SysFileDelete settingsFile
do i = 1 to sf.0
   parse var sf.i sname '=' svalue
   if pos(sname, response) = 0 then do
      call lineout settingsFile, sf.i
   end
end
call stream settingsFile, 'c', 'close'
return 0
